'use strict';

var marked = require('marked');
var highlight_js_1 = require('highlight.js');
function convertMarkedHtml(content) {
    marked.setOptions({
        highlight: function highlight(code, lang) {
            if (lang === undefined) {
                return code;
            }
            var langSplit = lang.split(':');
            try {
                return highlight_js_1.highlight(langSplit[0], code).value;
            } catch (e) {
                console.log(e.message);
                return code;
            }
        }
    });
    return marked(content);
}
exports.convertMarkedHtml = convertMarkedHtml;