'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var React = require('react');
var electron = require('electron');
var contentHolderComponent_1 = require('./contentHolderComponent');
var Thema = require('../services/thema');
var Watcher = require('../services/watcher');
var Marked = require('../services/marked');
var RemoteService = require('../services/remoteService');

var MarkdownComponent = function (_React$Component) {
    _inherits(MarkdownComponent, _React$Component);

    function MarkdownComponent() {
        _classCallCheck(this, MarkdownComponent);

        var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(MarkdownComponent).call(this));

        var currentPath = RemoteService.getArgumentInitPath();
        _this.watcher = new Watcher.Watcher(currentPath, _this.updateMarkDown.bind(_this));
        _this.state = { markdown: "" };
        return _this;
    }

    _createClass(MarkdownComponent, [{
        key: 'handleFileDrop',
        value: function handleFileDrop(path) {
            this.watcher.changeWatchPath(path);
        }
    }, {
        key: 'render',
        value: function render() {
            var html = Marked.convertMarkedHtml(this.state.markdown);
            return React.createElement(contentHolderComponent_1.ContentHolderComponent, { "html": html, "onFileDrop": this.handleFileDrop.bind(this) });
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            Thema.changeThema(RemoteService.getThema());
            this.setOpenLinkWithBrowser();
        }
    }, {
        key: 'componentDidUpdate',
        value: function componentDidUpdate() {
            this.setOpenLinkWithBrowser();
        }
    }, {
        key: 'updateMarkDown',
        value: function updateMarkDown(content) {
            this.setState({ markdown: content });
        }
    }, {
        key: 'setOpenLinkWithBrowser',
        value: function setOpenLinkWithBrowser() {
            var anchors = document.querySelectorAll('a');
            for (var i = 0; i < anchors.length; i++) {
                var anker = anchors.item(i);
                anker.onclick = function (e) {
                    event.preventDefault();
                    var target = event.target;
                    electron.shell.openExternal(target.href);
                };
            }
        }
    }]);

    return MarkdownComponent;
}(React.Component);

exports.MarkdownComponent = MarkdownComponent;