/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.jude.api.inf;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;

class SingletonFactory<T> {
    private final Set<?> instanceSet = Collections.synchronizedSet(new HashSet());
    private final WeakHashMap<ClassLoader, Reference<T>> instanceMap = new WeakHashMap();
    private final String className;

    SingletonFactory(String className) {
        this.className = className;
    }

    public static <T> SingletonFactory<T> newInstance(String className) {
        return new SingletonFactory<T>(className);
    }

    public String getClassName() {
        return this.className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T getSingleton(ClassLoader classLoader) throws ClassNotFoundException {
        while (true) {
            Reference<T> entry;
            WeakHashMap<ClassLoader, Reference<T>> weakHashMap = this.instanceMap;
            synchronized (weakHashMap) {
                entry = this.instanceMap.get(classLoader);
                if (entry != null) {
                    T instance = entry.get();
                    if (instance != null) {
                        return instance;
                    }
                    this.instanceMap.remove(classLoader);
                }
            }
            T instance = this.newInstance(classLoader);
            entry = new WeakReference<T>(instance);
            ClassLoader key = instance.getClass().getClassLoader();
            WeakHashMap<ClassLoader, Reference<T>> weakHashMap2 = this.instanceMap;
            synchronized (weakHashMap2) {
                if (!this.instanceMap.containsKey(key)) {
                    this.instanceMap.put(key, entry);
                    return instance;
                }
            }
        }
    }

    private T newInstance(ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Object[] initargs;
            Constructor<?> constructor;
            Class<?> clazz = Class.forName(this.getClassName(), true, classLoader);
            try {
                Class[] parameterTypes = new Class[]{Set.class};
                constructor = clazz.getConstructor(parameterTypes);
                initargs = new Object[]{this.instanceSet};
            }
            catch (NoSuchMethodException e) {
                Class[] parameterTypes = new Class[]{};
                constructor = clazz.getConstructor(parameterTypes);
                initargs = new Object[]{};
            }
            return (T)constructor.newInstance(initargs);
        }
        catch (InstantiationException e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            throw new ClassNotFoundException(t.getMessage(), t);
        }
    }
}

