/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.platform.connectors.wininet;

import com.change_vision.platform.connectors.exception.NativeConnectException;
import com.change_vision.platform.connectors.exception.NativeIOException;
import com.change_vision.platform.connectors.exception.NativeSSLException;
import com.change_vision.platform.connectors.exception.NativeTimeoutException;
import com.change_vision.platform.connectors.exception.NativeUnknownHostException;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WinInetUtil {
    private static final Map<String, Integer> headerMap = WinInetUtil.loadHeaderMap();

    public static boolean isWide() {
        return W32APIOptions.DEFAULT_OPTIONS == W32APIOptions.UNICODE_OPTIONS;
    }

    public static Properties loadProperties(Class<?> clazz, String name) throws IOException {
        InputStream in = clazz.getResourceAsStream(name);
        try {
            Properties properties = new Properties();
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            in.close();
        }
    }

    public static IOException getLastErrorException() {
        int errorCode = WinInetUtil.getLastError();
        String message = WinInetUtil.formatMessage(errorCode);
        switch (errorCode) {
            case 12002: {
                return new NativeTimeoutException(message, errorCode);
            }
            case 12007: {
                return new NativeUnknownHostException(message, errorCode);
            }
            case 12029: {
                return new NativeConnectException(message, errorCode);
            }
            case 12037: 
            case 12038: 
            case 12044: 
            case 12046: {
                return new NativeSSLException(message, errorCode);
            }
        }
        return new NativeIOException(message, errorCode);
    }

    public static int getLastError() {
        return Native.getLastError();
    }

    public static String formatMessage(int code) {
        WinDef.HMODULE module;
        PointerByReference buffer = new PointerByReference();
        if (Kernel32.INSTANCE.FormatMessage(4864, null, code, 0, buffer, 0, null) == 0 && ((module = Kernel32.INSTANCE.GetModuleHandle("wininet.dll")) == null || Kernel32.INSTANCE.FormatMessage(2816, module.getPointer(), code, 0, buffer, 0, null) == 0)) {
            return null;
        }
        try {
            String string = buffer.getValue().getString(0L, WinInetUtil.isWide()).trim();
            return string;
        }
        finally {
            Kernel32.INSTANCE.LocalFree(buffer.getValue());
        }
    }

    public static Integer getHeaderInfoLevel(String name) {
        return headerMap.get(name.toUpperCase());
    }

    private static Map<String, Integer> loadHeaderMap() {
        try {
            Properties properties = WinInetUtil.loadProperties(WinInetUtil.class, "headers.properties");
            HashMap<String, Integer> results = new HashMap<String, Integer>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString().toUpperCase();
                Integer value = Integer.valueOf(entry.getValue().toString());
                results.put(key, value);
            }
            return results;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

