/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.platform.connectors.impl;

import com.change_vision.platform.connectors.impl.Authenticate;
import com.change_vision.platform.connectors.impl.RequestHandle;
import com.change_vision.platform.connectors.wininet.User32;
import com.change_vision.platform.connectors.wininet.WinInetUtil;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;

public abstract class NativeAuthenticator {
    private static final NativeAuthenticator dialog = new DialogAuthenticator();
    private static final NativeAuthenticator java = new JavaAuthenticator();

    public static NativeAuthenticator getInstance(boolean allowUserInteraction) {
        return allowUserInteraction ? dialog : java;
    }

    public abstract boolean authenticate(RequestHandle var1, URL var2, Authenticator.RequestorType var3) throws IOException;

    public abstract void applyAuthorization(RequestHandle var1) throws IOException;

    public static PasswordAuthentication requestPasswordAuthentication(URL url, String field, Authenticator.RequestorType requestorType) throws IOException {
        String prompt = null;
        String scheme = null;
        if (field != null && field.length() > 0) {
            Authenticate authenticate = new Authenticate(field);
            prompt = authenticate.getParams().get("realm");
            scheme = authenticate.getScheme();
        }
        return Authenticator.requestPasswordAuthentication(url.getHost(), null, url.getPort(), url.getProtocol(), prompt, scheme, url, requestorType);
    }

    static class DialogAuthenticator
    extends NativeAuthenticator {
        DialogAuthenticator() {
        }

        public boolean authenticate(RequestHandle hRequest, URL url, Authenticator.RequestorType requestorType) throws IOException {
            return hRequest.errorDlg(User32.INSTANCE.GetDesktopWindow(), 12014, 7, null) == 12032;
        }

        public void applyAuthorization(RequestHandle hRequest) {
        }
    }

    static class JavaAuthenticator
    extends NativeAuthenticator {
        private PasswordAuthentication proxy;
        private PasswordAuthentication server;

        JavaAuthenticator() {
        }

        public boolean authenticate(RequestHandle hRequest, URL url, Authenticator.RequestorType requestorType) throws IOException {
            PasswordAuthentication authorization = this.request(hRequest, url, requestorType);
            if (authorization == null) {
                return false;
            }
            this.apply(hRequest, requestorType, authorization);
            if (requestorType.equals((Object)Authenticator.RequestorType.PROXY)) {
                this.proxy = authorization;
            } else {
                this.server = authorization;
            }
            return true;
        }

        public void applyAuthorization(RequestHandle hRequest) throws IOException {
            if (this.proxy != null) {
                this.apply(hRequest, Authenticator.RequestorType.PROXY, this.proxy);
            }
            if (this.server != null) {
                this.apply(hRequest, Authenticator.RequestorType.SERVER, this.server);
            }
        }

        private PasswordAuthentication request(RequestHandle hRequest, URL url, Authenticator.RequestorType requestorType) throws IOException {
            int dwInfoLevel = requestorType.equals((Object)Authenticator.RequestorType.PROXY) ? 41 : 40;
            String field = hRequest.httpQueryInfoString(dwInfoLevel);
            return JavaAuthenticator.requestPasswordAuthentication(url, field, requestorType);
        }

        private void apply(RequestHandle hRequest, Authenticator.RequestorType requestorType, PasswordAuthentication authorization) throws IOException {
            int password;
            int username;
            if (requestorType.equals((Object)Authenticator.RequestorType.PROXY)) {
                username = 43;
                password = 44;
            } else {
                username = 28;
                password = 29;
            }
            if (!hRequest.setOptionString(username, authorization.getUserName())) {
                throw WinInetUtil.getLastErrorException();
            }
            if (!hRequest.setOptionString(password, new String(authorization.getPassword()))) {
                throw WinInetUtil.getLastErrorException();
            }
        }
    }
}

