/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.platform.connectors.impl;

import com.change_vision.platform.connectors.impl.HeaderScanner;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Authenticate {
    private String scheme;
    private final Map<String, String> params = new LinkedHashMap<String, String>();
    private final Map<String, String> unmodifiableParams = Collections.unmodifiableMap(this.params);

    public Authenticate(CharSequence sequence) throws IOException {
        this.parse(new HeaderScanner(sequence));
    }

    public String getScheme() {
        return this.scheme;
    }

    public Map<String, String> getParams() {
        return this.unmodifiableParams;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.scheme);
        boolean first = true;
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            buffer.append(' ');
            String key = entry.getKey();
            String value = entry.getValue();
            buffer.append(key);
            if (value == null) continue;
            buffer.append('=');
            if (key.equals("algorithm") && value.indexOf(34) < 0) {
                buffer.append(value);
                continue;
            }
            buffer.append('\"');
            buffer.append(value.replaceAll("\"", "\\\""));
            buffer.append('\"');
        }
        return buffer.toString();
    }

    private void parse(HeaderScanner scanner) throws IOException {
        scanner.space();
        this.scheme = scanner.token();
        if (this.scheme == null) {
            throw new ProtocolException("auth-scheme required");
        }
        while (true) {
            scanner.space();
            String key = scanner.token();
            if (key == null) break;
            scanner.space();
            String value = null;
            if (scanner.accept(61)) {
                scanner.space();
                value = scanner.token();
                if (value == null) {
                    value = scanner.quotedString();
                }
            }
            scanner.space();
            scanner.accept(44);
            this.params.put(key.toLowerCase(), value);
        }
        scanner.space();
        if (scanner.hasRemaining()) {
            scanner.unexpectedChar();
        }
    }
}

