/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.platform.connectors;

import com.change_vision.platform.connectors.NativeHttpURLConnection;
import com.change_vision.platform.connectors.impl.InternetHandle;
import com.sun.jna.Platform;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import java.util.WeakHashMap;

public class NativeHttpURLStreamHandler
extends URLStreamHandler {
    private static final URLStreamHandler singleton = Platform.isWindows() ? new NativeHttpURLStreamHandler() : null;
    private final Map<Object, InternetHandle> handleMap = new WeakHashMap<Object, InternetHandle>();
    private String userAgent = "Java/WinInet";

    public static URLStreamHandler getInstance() {
        return singleton;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    protected URLConnection openConnection(URL u) throws IOException {
        return this.openConnection(u, null);
    }

    protected URLConnection openConnection(URL u, Proxy p) throws IOException {
        return new NativeHttpURLConnection(this, u, p, this.handleFor(p));
    }

    protected int resolveRequestFlags(URL url) {
        return this.isSecure(url) ? 0x800000 : 0;
    }

    protected int resolvePort(URL url) {
        int port = url.getPort();
        if (port < 0) {
            if (this.isSecure(url)) {
                return 443;
            }
            return 80;
        }
        return port;
    }

    protected boolean isSecure(URL url) {
        return "HTTPS".equalsIgnoreCase(url.getProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternetHandle handleFor(Proxy proxy) throws IOException {
        Object key = proxy != null ? proxy : this;
        Map<Object, InternetHandle> map = this.handleMap;
        synchronized (map) {
            InternetHandle handle = this.handleMap.get(key);
            if (handle != null) {
                return handle;
            }
            int accessType = 0;
            String proxyName = null;
            if (proxy != null) {
                switch (proxy.type()) {
                    case DIRECT: {
                        accessType = 1;
                        break;
                    }
                    case HTTP: {
                        accessType = 3;
                        proxyName = this.getProxyName(proxy.address());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            handle = InternetHandle.open(this.getUserAgent(), accessType, proxyName, null, 0);
            this.handleMap.put(key, handle);
            return handle;
        }
    }

    private String getProxyName(SocketAddress socketAddress) {
        InetSocketAddress sa = (InetSocketAddress)socketAddress;
        if (sa.isUnresolved()) {
            return String.valueOf(sa.getHostName()) + ":" + sa.getPort();
        }
        return String.valueOf(sa.getAddress().getHostAddress()) + ":" + sa.getPort();
    }
}

