/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.judebiz.model;

import JP.co.esm.caddies.golf.util.GolfProperties;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityTemplateElementProperties
extends GolfProperties {
    private static final Logger logger = LoggerFactory.getLogger(ActivityTemplateElementProperties.class);
    private static final long serialVersionUID = -1913864267097904428L;
    private String fileName = null;

    public ActivityTemplateElementProperties(String string) {
        this.fileName = string;
        try {
            this.load(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void load(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void store(String string) {
        string = string != null ? string : this.fileName;
        try {
            logger.info("file: {}", (Object)string);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.store(fileOutputStream, null);
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            logger.error("error has occurred", (Throwable)exception);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void swapElementOrder(int n2, int n3) {
        Map map = this.getElementInformation(n2, n3);
        Map map2 = this.getElementInformation(n3, n2);
        this.removeResources("element." + n2 + ".");
        this.removeResources("element." + n3 + ".");
        this.putAll((Map<?, ?>)map);
        this.putAll((Map<?, ?>)map2);
    }

    private void changeElementIndex(int n2, int n3) {
        Map map = this.getElementInformation(n2, n3);
        this.removeResources("element." + n2 + ".");
        this.removeResources("element." + n3 + ".");
        this.putAll((Map<?, ?>)map);
    }

    public void moveElement(int n2, ActivityTemplateElementProperties activityTemplateElementProperties) {
        int n3 = activityTemplateElementProperties.getElementNum() + 1;
        Map map = this.getElementInformation(n2, n3);
        activityTemplateElementProperties.putAll((Map<?, ?>)map);
        activityTemplateElementProperties.setElementNum(n3);
        String string = this.getStereotypeProfile(n2);
        Map map2 = this.getStereotypeDefinitionInformation(string);
        this.removeResources(string + ".");
        activityTemplateElementProperties.putAll((Map<?, ?>)map2);
        this.removeElement(n2);
    }

    public void setElementName(int n2) {
        String string = (String)this.get("element." + n2 + "name");
        this.put("element." + n2 + "name", string);
    }

    public void removeElement(int n2) {
        String string = this.getStereotypeProfile(n2);
        if (string != null && string.length() > 0 && this.getStereotypeProfileRefererNum(string) == 1) {
            this.removeResources(string + ".");
        }
        this.removeResources("element." + n2 + ".");
        for (int i2 = n2; i2 < this.getElementNum(); ++i2) {
            this.changeElementIndex(i2 + 1, i2);
        }
        this.setElementNum(this.getElementNum() - 1);
    }

    private int getStereotypeProfileRefererNum(String string) {
        int n2 = 0;
        int n3 = this.getElementNum();
        for (int i2 = 1; i2 <= n3; ++i2) {
            if (!string.equals(this.getStereotypeProfile(i2))) continue;
            ++n2;
        }
        return n2;
    }

    private void removeResources(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.keySet()) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        for (String string2 : arrayList) {
            this.remove(string2);
        }
    }

    private String getStereotypeProfile(int n2) {
        return (String)this.get("element." + n2 + ".stereotype_profile");
    }

    private Map getElementInformation(int n2, int n3) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : this.keySet()) {
            if (!string.startsWith("element." + n2 + ".")) continue;
            String string2 = string.replaceFirst("element." + n2, "element." + n3);
            hashMap.put(string2, this.get(string));
        }
        return hashMap;
    }

    private Map getStereotypeDefinitionInformation(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string2 : this.keySet()) {
            if (!string2.startsWith(string + ".")) continue;
            hashMap.put(string2, this.get(string2));
        }
        return hashMap;
    }

    public void reload() {
        if (this.fileName != null) {
            this.load(this.fileName);
        }
    }

    public int getElementNum() {
        return this.getInt("element_num");
    }

    public String getTemplateName() {
        return this.getString("template_name");
    }

    public void setTemplateName(String string) {
        this.put("template_name", string);
    }

    public void setElementNum(int n2) {
        this.put("element_num", String.valueOf(n2));
    }
}

