/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.jude.cmdline;

import JP.co.esm.caddies.jomt.JudeRunner;
import JP.co.esm.caddies.jomt.api.BadProjectException;
import JP.co.esm.caddies.jomt.api.JudeOpenAPI;
import JP.co.esm.caddies.jomt.api.ProjectNotFoundException;
import JP.co.esm.caddies.jomt.jsystem.e;
import JP.co.esm.caddies.jomt.jutil.O;
import JP.co.esm.caddies.jomt.jutil.k;
import com.change_vision.jude.cmdline.a;
import com.change_vision.jude.cmdline.b;
import com.change_vision.jude.cmdline.c;
import com.change_vision.jude.cmdline.d;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JudeCommandRunner
extends JudeRunner {
    public static int SUCCESS = 0;
    public static int COMMAND_EXEC_FAILED = -1;
    public static int INVALID_COMMAND_OPTIONS = -2;
    public static int FILE_NOT_FOUND = -3;
    public static int BAD_PROJECT = -4;
    public static int INVALID_JRE_VERSION = -5;
    public static int NOT_SUPPORTED_FILE = -6;
    public static int INVALID_JAVA_VENDOR = -7;
    private static final Logger logger = LoggerFactory.getLogger(JudeCommandRunner.class);
    private static final e initializer = e.a();
    public static boolean testing = false;

    public static void main(String[] stringArray) throws Exception {
        JudeCommandRunner judeCommandRunner = new JudeCommandRunner();
        if (!judeCommandRunner.isValidJavaVersion()) {
            System.err.println("This Java version is not supported in Astah. Valid Java version is " + JP.co.esm.caddies.jomt.jsystem.b.a + " or higher. Java version: " + JP.co.esm.caddies.jomt.jsystem.b.b());
            k.a();
            System.exit(INVALID_JRE_VERSION);
        }
        if (!judeCommandRunner.isValidJavaVmVendor()) {
            System.err.println("This Java vendor is not supported in Astah. Java Vendor: " + JP.co.esm.caddies.jomt.jsystem.b.e());
        }
        if (stringArray.length < 2) {
            System.err.println("invaild argument!");
            System.err.println("Usage: com.change_vision.jude.cmdline.JudeCommandRunner [-options]");
            System.err.println("where options include:");
            System.err.println("    -f,--file <target file>    target file");
            System.err.println("    -image                     export documents to image");
            System.err.println("    -o,--output <output dir>   output dir");
            System.err.println("    -t,--type <image type>     png/jpg/emf (emf is supported by uml or professional only.)");
            System.err.println("    -resized                   resized export image's font(Main purpose:Exporting at other OS)");
            System.err.println("    -diff <base astah project file> <reference astah project file>   jude/asta");
            k.a();
            System.exit(INVALID_COMMAND_OPTIONS);
        }
        int n2 = judeCommandRunner.execute(stringArray);
        k.a();
        if (testing) {
            return;
        }
        System.exit(n2);
    }

    @Override
    public void run(String[] stringArray) {
        this.execute(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String[] stringArray) {
        int n2 = SUCCESS;
        try {
            a a2 = new a(stringArray);
            boolean bl2 = a2.b();
            if (bl2) {
                this.setHeadless();
            }
            JP.co.esm.caddies.jomt.jsystem.c.v = true;
            JudeOpenAPI.getInstance().run(true, bl2);
            String string = a2.a();
            if (string != null) {
                JudeOpenAPI.getInstance().openProject(string, false, true);
            }
            List list = a2.c();
            this.executeCommands(list);
        }
        catch (BadProjectException badProjectException) {
            logger.error("error has occurred.", (Throwable)badProjectException);
            n2 = BAD_PROJECT;
        }
        catch (ProjectNotFoundException projectNotFoundException) {
            logger.error("error has occurred.", (Throwable)projectNotFoundException);
            n2 = FILE_NOT_FOUND;
        }
        catch (b b2) {
            n2 = INVALID_COMMAND_OPTIONS;
        }
        catch (d d2) {
            n2 = NOT_SUPPORTED_FILE;
        }
        catch (Exception exception) {
            logger.error("error has occurred.", (Throwable)exception);
            n2 = COMMAND_EXEC_FAILED;
        }
        finally {
            if (testing) {
                return n2;
            }
            try {
                JudeOpenAPI.getInstance().quit();
            }
            catch (Exception exception) {
                logger.error("error has occurred.", (Throwable)exception);
            }
        }
        return n2;
    }

    protected void executeCommands(List list) throws Exception {
        for (g g2 : list) {
            this.executeCommand(g2);
        }
    }

    protected void executeCommand(g g2) throws InterruptedException, InvocationTargetException {
        if (g2 == null) {
            return;
        }
        c c2 = new c(this, g2);
        O.c(c2);
    }

    protected void setHeadless() {
        if (System.getProperty("java.awt.headless") == null) {
            System.setProperty("java.awt.headless", "true");
        }
    }

    public static void resetSystemForApi() {
        initializer.c();
    }
}

