/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.astah.extension.plugin.model;

import com.change_vision.astah.extension.plugin.PluginConfigurationState;
import com.change_vision.astah.extension.plugin.exception.PluginFormatException;
import com.change_vision.astah.extension.plugin.model.PluginInformation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public class PluginFile
implements PluginInformation {
    private static String a = Locale.getDefault().toString();
    private static final Pattern b = Pattern.compile("OSGI-INF/l10n/bundle(.*)\\.properties");
    private JarFile c;
    private File d;
    private Attributes e;
    private Map f = new LinkedHashMap();

    public PluginFile(File file) throws PluginFormatException {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        try {
            this.d = file;
            this.c = new JarFile(file);
            this.e = this.c.getManifest().getMainAttributes();
        }
        catch (IOException iOException) {
            throw new PluginFormatException("The file isn't jar file.", iOException);
        }
        if (this.e == null) {
            throw new PluginFormatException("The file isn't plugin file.");
        }
        this.a();
    }

    public boolean isValid() {
        String string;
        try {
            string = this.getSymbolicName();
        }
        catch (PluginFormatException pluginFormatException) {
            return false;
        }
        return this.c.getName().endsWith(".jar") && this.a(string.isEmpty());
    }

    @Override
    public String getSymbolicName() throws PluginFormatException {
        String string = this.a("Bundle-SymbolicName");
        if (string == null || string.isEmpty()) {
            throw new PluginFormatException("Symbolic Name is null or empty.");
        }
        if (string.indexOf(";") != -1) {
            string = string.substring(0, string.indexOf(";"));
        }
        return string;
    }

    @Override
    public String getVersion() {
        return this.a("Bundle-Version");
    }

    @Override
    public String getBundleName() {
        return this.getLocalizedName(a);
    }

    public String getLocalizedName(String string) {
        return this.a(string, "Bundle-Name");
    }

    public String getDefaultBundleName() {
        return this.getLocalizedName("");
    }

    @Override
    public String getTargetAstahVersion() {
        String string = this.a("Astah-Version");
        if (string == null || string.isEmpty()) {
            return "6.6.0";
        }
        return string;
    }

    @Override
    public String getTargetAstahEdition() {
        String string = this.a("Astah-Edition");
        if (string == null || string.isEmpty()) {
            return "all";
        }
        return string;
    }

    @Override
    public String getDocURL() {
        return this.getLocalizedDocURL(a);
    }

    public String getLocalizedDocURL(String string) {
        return this.a(string, "Bundle-DocURL");
    }

    public String getDefaultURL() {
        return this.getLocalizedDocURL("");
    }

    @Override
    public URI toURI() {
        return this.d.toURI();
    }

    @Override
    public String getDescription() {
        return this.getLocalizedDescription(a);
    }

    public String getLocalizedDescription(String string) {
        return this.a(string, "Bundle-Description");
    }

    public String getDefaultDescription() {
        return this.getLocalizedDescription("");
    }

    private void a() {
        Enumeration<JarEntry> enumeration = this.c.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            Matcher matcher = b.matcher(string);
            if (!matcher.matches()) continue;
            String string2 = matcher.group(1);
            if (string2.startsWith("_")) {
                string2 = string2.substring(1);
            }
            Properties properties = this.a(jarEntry);
            this.f.put(string2, properties);
        }
    }

    private String a(String string) {
        return this.e.getValue(string);
    }

    private boolean a(boolean bl2) {
        return !bl2;
    }

    private String a(String string, String string2) {
        String string3 = this.a(string2);
        if (string3 == null) {
            return "";
        }
        if (this.a(string3.startsWith("%"))) {
            return string3;
        }
        String string4 = string.split("_")[0];
        Properties properties = (Properties)this.f.get(string4);
        if (properties == null) {
            properties = (Properties)this.f.get("");
        }
        if (properties == null) {
            return string2;
        }
        return properties.getProperty(string3.substring(1));
    }

    private Properties a(ZipEntry zipEntry) {
        Properties properties = new Properties();
        try {
            InputStream inputStream = this.c.getInputStream(zipEntry);
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return properties;
    }

    public boolean isLocalized() {
        return this.f.size() > 1;
    }

    @Override
    public String getTargetAstah() {
        String string = this.getTargetAstahVersion();
        String string2 = this.getTargetAstahEdition();
        if (!string.isEmpty() && !string2.isEmpty()) {
            return String.format("%s - %s", string, string2);
        }
        if (!string.isEmpty()) {
            return string;
        }
        if (!string2.isEmpty()) {
            return string2;
        }
        return "";
    }

    @Override
    public String getStateString() {
        return "INSTALL";
    }

    @Override
    public boolean isEnable() {
        return false;
    }

    @Override
    public String getConfiurationState() {
        return PluginConfigurationState.INSTALL.getStatus();
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isSystem() {
        return false;
    }

    @Override
    public File getFile() {
        return this.d;
    }

    public String toString() {
        return "PluginFile [getSymbolicName()=" + this.getSymbolicName() + ", getVersion()=" + this.getVersion() + "]";
    }
}

