/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.astah.extension.plugin.loader;

import com.change_vision.astah.extension.plugin.BundleUtil;
import com.change_vision.astah.extension.plugin.loader.AutoDeployPluginLoader;
import com.change_vision.astah.extension.plugin.loader.InstallFolderPluginLoader;
import com.change_vision.astah.extension.plugin.loader.PluginLoader;
import com.change_vision.astah.extension.plugin.loader.UserHomePluginLoader;
import com.change_vision.astah.extension.plugin.loader.a;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstahPluginLoader {
    private static final Logger a = LoggerFactory.getLogger(AstahPluginLoader.class);
    public static final String AUTO_DEPLOY_DIR_PROPERY = "felix.auto.deploy.dir";
    private PluginLoader[] b;
    private Properties c;

    AstahPluginLoader() {
        this(new Properties());
    }

    public AstahPluginLoader(Properties properties) {
        this.c = properties;
        if (this.b()) {
            a.debug("Enable auto deploy mode.");
            this.b = new PluginLoader[]{new AutoDeployPluginLoader(properties), new UserHomePluginLoader(), new InstallFolderPluginLoader()};
        } else {
            a.debug("Disable auto deploy mode.");
            this.b = new PluginLoader[]{new AutoDeployPluginLoader(properties)};
        }
    }

    public boolean hasPlugins() {
        for (PluginLoader pluginLoader : this.b) {
            if (!pluginLoader.hasPlugins()) continue;
            return true;
        }
        if (this.b()) {
            return this.d();
        }
        String string = this.c.getProperty("felix.auto.start.1");
        if (this.a(string)) {
            return true;
        }
        String string2 = this.c.getProperty("felix.auto.install.1");
        return this.a(string2);
    }

    public boolean isSwitchPluginFile() {
        return this.a(this.a());
    }

    private String a() {
        return System.getProperty("plugin.switch.file");
    }

    private boolean b() {
        return this.a(this.c());
    }

    private boolean a(String string) {
        return string != null && !string.isEmpty();
    }

    private String c() {
        return this.c.getProperty(AUTO_DEPLOY_DIR_PROPERY);
    }

    private boolean d() {
        File file = new File(this.c());
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list(new a(this));
        return stringArray.length > 0;
    }

    public void load(BundleContext bundleContext) {
        for (PluginLoader pluginLoader : this.b) {
            pluginLoader.load(bundleContext);
        }
    }

    public void setPluginLoaders(PluginLoader[] pluginLoaderArray) {
        this.b = pluginLoaderArray;
    }

    public void unloadCachedPlugins(BundleContext bundleContext) {
        Bundle[] bundleArray = bundleContext.getBundles();
        if (bundleArray == null) {
            return;
        }
        HashSet<Bundle> hashSet = new HashSet<Bundle>(Arrays.asList(bundleArray));
        for (PluginLoader pluginLoader : this.b) {
            for (Bundle bundle : bundleArray) {
                if (!pluginLoader.isLoaded(bundle) && !new BundleUtil().isSystemBundle(bundle)) continue;
                hashSet.remove(bundle);
            }
        }
        for (Bundle bundle : hashSet) {
            try {
                bundle.uninstall();
                a.debug("uninstall cached plugin {}", (Object)bundle.getSymbolicName());
            }
            catch (BundleException bundleException) {
                a.warn("Exception has occurred when uninstalling plugin", (Throwable)bundleException);
            }
        }
    }
}

