/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.astah.extension.plugin.description;

import com.change_vision.astah.extension.plugin.PluginLocalization;
import com.change_vision.astah.extension.plugin.description.ActionDescription;
import com.change_vision.astah.extension.plugin.description.ActionSetDescription;
import com.change_vision.astah.extension.plugin.description.MenuDescription;
import com.change_vision.astah.extension.plugin.description.ViewDescription;
import com.change_vision.astah.extension.plugin.description.localized.LocalizedActionDescription;
import com.change_vision.astah.extension.plugin.description.localized.LocalizedActionSetDescription;
import com.change_vision.astah.extension.plugin.description.localized.LocalizedMenuDescription;
import com.change_vision.astah.extension.plugin.description.localized.LocalizedViewDescription;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDescription {
    private static final Logger logger = LoggerFactory.getLogger(PluginDescription.class);
    private List actions = new ArrayList();
    private List actionSets = new ArrayList();
    private List menus = new ArrayList();
    private List views = new ArrayList();
    private Bundle bundle;
    private Properties properties;

    public PluginDescription(Bundle bundle) {
        this.bundle = bundle;
        if (bundle == null) {
            return;
        }
        try {
            this.properties = PluginLocalization.getMessageProperties(bundle);
        }
        catch (BundleException bundleException) {
            logger.error("bundle error.", (Throwable)bundleException);
        }
        catch (IOException iOException) {
            logger.error("bundle error.", (Throwable)iOException);
        }
    }

    public void addActionDescription(ActionDescription actionDescription) {
        this.actions.add(new LocalizedActionDescription(this.properties, actionDescription));
    }

    public void addMenuDescription(MenuDescription menuDescription) {
        this.menus.add(new LocalizedMenuDescription(this.properties, menuDescription));
    }

    public void addActionSetDescription(ActionSetDescription actionSetDescription) {
        this.actionSets.add(new LocalizedActionSetDescription(this.properties, actionSetDescription));
    }

    public void addViewDescription(ViewDescription viewDescription) {
        this.views.add(new LocalizedViewDescription(this.properties, viewDescription));
    }

    public List getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public List getActionSets() {
        return Collections.unmodifiableList(this.actionSets);
    }

    public List getMenus() {
        return Collections.unmodifiableList(this.menus);
    }

    public List getViews() {
        return Collections.unmodifiableList(this.views);
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }
}

