/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.astah.extension.plugin;

import com.change_vision.astah.extension.plugin.model.PluginInformation;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsConfiguration {
    public static final String PROPERTY_NAME_OF_DISABLE_BUNDLES = "disablePlugins";
    private static final Logger a = LoggerFactory.getLogger(PluginsConfiguration.class);
    private static Pattern b = Pattern.compile("plugin\\.(.*)\\.disabled$");
    private ArrayList c = new ArrayList();
    private PropertyChangeSupport d = new PropertyChangeSupport(this);

    public void disable(PluginInformation pluginInformation) {
        if (pluginInformation == null) {
            throw new IllegalArgumentException("Bundle is null.");
        }
        a.debug("disable {}", (Object)pluginInformation.getSymbolicName());
        this.c.add(pluginInformation.getSymbolicName());
        this.d.firePropertyChange(PROPERTY_NAME_OF_DISABLE_BUNDLES, null, pluginInformation);
    }

    public List getDisabledSymbolicNames() {
        return Collections.unmodifiableList(this.c);
    }

    public void enable(PluginInformation pluginInformation) {
        if (pluginInformation == null) {
            throw new IllegalArgumentException("Bundle is null.");
        }
        a.debug("enable {}", (Object)pluginInformation.getSymbolicName());
        this.c.remove(pluginInformation.getSymbolicName());
        this.d.firePropertyChange(PROPERTY_NAME_OF_DISABLE_BUNDLES, pluginInformation, null);
    }

    public boolean isEnable(Bundle bundle) {
        return !this.c.contains(bundle.getSymbolicName());
    }

    public void save(Properties properties) {
        Object object;
        if (properties == null) {
            throw new IllegalArgumentException("Properties is null.");
        }
        Set<Object> set = properties.keySet();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object2 : set) {
            object = b.matcher(object2.toString());
            if (!((Matcher)object).matches()) continue;
            hashSet.add(object2);
        }
        for (Object object2 : hashSet) {
            set.remove(object2);
        }
        for (Object object2 : this.c) {
            object = String.format("plugin.%s.disabled", object2);
            properties.put(object, "true");
        }
    }

    public void load(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties is null.");
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = enumeration.nextElement().toString();
            Matcher matcher = b.matcher(string2.toString());
            if (!matcher.matches() || !Boolean.valueOf(string = properties.getProperty(string2)).booleanValue()) continue;
            String string3 = matcher.group(1);
            this.c.add(string3);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.d.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.d.removePropertyChangeListener(propertyChangeListener);
    }
}

