/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.astah.extension.plugin;

import com.change_vision.astah.extension.plugin.AstahPluginEnvironment;
import com.change_vision.astah.extension.plugin.BundleUtil;
import com.change_vision.astah.extension.plugin.PluginConfigurationState;
import com.change_vision.astah.extension.plugin.PluginsConfiguration;
import com.change_vision.astah.extension.plugin.c;
import com.change_vision.astah.extension.plugin.model.BundleInformation;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginStateManager {
    private static final Logger a = LoggerFactory.getLogger(PluginStateManager.class);
    private static final c b = new c();
    private AstahPluginEnvironment c;
    private BundleUtil d = new BundleUtil();

    public PluginStateManager(AstahPluginEnvironment astahPluginEnvironment) {
        this.c = astahPluginEnvironment;
    }

    public void start(Bundle[] bundleArray) {
        if (bundleArray == null) {
            throw new IllegalStateException("bundles must contain system bundle.");
        }
        b.printHeader();
        for (Bundle bundle : bundleArray) {
            BundleInformation bundleInformation = this.c(bundle);
            b.printPluginInfo(bundleInformation);
            if (this.c.isForbidden(bundleInformation) || this.d.isSystemBundle(bundle)) continue;
            Dictionary dictionary = bundle.getHeaders();
            if (dictionary == null) {
                this.a(bundle);
                continue;
            }
            String string = (String)dictionary.get("Bundle-ActivationPolicy");
            if (string != null && string.startsWith("lazy")) {
                this.b(bundle);
                continue;
            }
            this.a(bundle);
        }
    }

    public void uninstall(Bundle[] bundleArray) {
        if (bundleArray == null) {
            throw new IllegalStateException("bundles must contain system bundle.");
        }
        for (Bundle bundle : bundleArray) {
            BundleInformation bundleInformation = this.c(bundle);
            if (this.c.isPermittable(bundleInformation)) continue;
            try {
                a.debug("uninstall disabled plugin {}", (Object)bundle.getSymbolicName());
                bundle.uninstall();
            }
            catch (BundleException bundleException) {
                a.warn("error has occurred.", (Throwable)bundleException);
            }
        }
    }

    private void a(Bundle bundle) {
        try {
            a.debug("start plugin {}[{}]", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
            bundle.start();
        }
        catch (BundleException bundleException) {
            a.warn("Exception has occurred.", (Throwable)bundleException);
        }
    }

    private void b(Bundle bundle) {
        try {
            a.debug("lazy start plugin {}[{}]", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
            bundle.start(2);
        }
        catch (BundleException bundleException) {
            a.warn("Exception has occurred.", (Throwable)bundleException);
        }
    }

    private BundleInformation c(Bundle bundle) {
        PluginsConfiguration pluginsConfiguration = this.c.getConfiguration();
        boolean bl2 = pluginsConfiguration.isEnable(bundle);
        PluginConfigurationState pluginConfigurationState = PluginConfigurationState.getState(bl2);
        BundleInformation bundleInformation = new BundleInformation(bundle, pluginConfigurationState);
        return bundleInformation;
    }

    public void stop(Bundle[] bundleArray) {
        for (Bundle bundle : bundleArray) {
            try {
                if (this.d.isSystemBundle(bundle)) continue;
                a.debug("stop plugin {}[{}]", (Object)bundle.getSymbolicName(), (Object)bundle.getVersion());
                bundle.stop();
            }
            catch (BundleException bundleException) {
                a.warn("Exception has occurred when plugin is stopping.", (Throwable)bundleException);
            }
        }
    }
}

