/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.uml.util;

import JP.co.esm.caddies.jomt.jmodel.f;
import JP.co.esm.caddies.jomt.jutil.JomtUtilities;
import JP.co.esm.caddies.uml.Foundation.Core.UClassifier;
import JP.co.esm.caddies.uml.Foundation.DataTypes.UMultiplicity;
import JP.co.esm.caddies.uml.Foundation.DataTypes.UMultiplicityRange;
import JP.co.esm.caddies.uml.exception.UMLSemanticsException;
import JP.co.esm.caddies.uml.java.JUPrimitive;
import java.util.ArrayList;
import java.util.List;

public class TypeExpression {
    private UClassifier classifier;
    private UMultiplicity multiplicity;

    public TypeExpression(UClassifier uClassifier, UMultiplicity uMultiplicity) {
        this.classifier = uClassifier;
        if (uClassifier == JUPrimitive.VOID && uMultiplicity != null) {
            uMultiplicity.removeAllMultiplicityRanges();
        }
        this.multiplicity = uMultiplicity;
    }

    public TypeExpression(UClassifier uClassifier, int n2) {
        if (uClassifier == JUPrimitive.VOID) {
            n2 = 0;
        }
        UMultiplicity uMultiplicity = new UMultiplicity();
        for (int i2 = 0; i2 < n2; ++i2) {
            uMultiplicity.addMultiplicityRange(new UMultiplicityRange(-100, -100));
        }
        this.classifier = uClassifier;
        this.multiplicity = uMultiplicity;
    }

    public TypeExpression(UClassifier uClassifier, int n2, int[] nArray) {
        if (uClassifier == JUPrimitive.VOID) {
            n2 = 0;
        }
        UMultiplicity uMultiplicity = new UMultiplicity();
        for (int i2 = 0; i2 < n2; ++i2) {
            uMultiplicity.addMultiplicityRange(new UMultiplicityRange(nArray[i2], nArray[i2]));
        }
        this.classifier = uClassifier;
        this.multiplicity = uMultiplicity;
    }

    public TypeExpression(UClassifier uClassifier, int n2, int[][] nArray) {
        if (uClassifier == JUPrimitive.VOID) {
            n2 = 0;
        }
        UMultiplicity uMultiplicity = new UMultiplicity();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2][0];
            int n4 = nArray[i2][nArray[i2].length == 1 ? 0 : 1];
            uMultiplicity.addMultiplicityRange(new UMultiplicityRange(n3, n4));
        }
        this.classifier = uClassifier;
        this.multiplicity = uMultiplicity;
    }

    public TypeExpression(UClassifier uClassifier, int n2, String[][] stringArray) {
        if (uClassifier == JUPrimitive.VOID) {
            n2 = 0;
        }
        UMultiplicity uMultiplicity = new UMultiplicity();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2][0];
            String string2 = stringArray[i2][stringArray[i2].length == 1 ? 0 : 1];
            uMultiplicity.addMultiplicityRange(new UMultiplicityRange(string, string2));
        }
        this.classifier = uClassifier;
        this.multiplicity = uMultiplicity;
    }

    public String toString() {
        return TypeExpression.getExpression(this.classifier, "", this.multiplicity);
    }

    public static String getExpression(UClassifier uClassifier, String string, UMultiplicity uMultiplicity) {
        String string2;
        if (uClassifier == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(uClassifier.getNameString());
        if (f.d(uClassifier) && !(string2 = JomtUtilities.getAnonymousBoundClassInfo(uClassifier)).equals("")) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(string);
        if (uClassifier == JUPrimitive.VOID && uMultiplicity != null) {
            uMultiplicity.removeAllMultiplicityRanges();
        }
        stringBuilder.append(TypeExpression.getDimention(uMultiplicity));
        return stringBuilder.toString();
    }

    public UClassifier getClassifier() {
        return this.classifier;
    }

    public UMultiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public static int getArrayDimension(String string) {
        return (Integer)TypeExpression.parseType(string)[1];
    }

    public static Object[] parseType(String string) {
        return TypeExpression.parseType(string, true);
    }

    public static Object[] parseType(String string, boolean bl2) {
        int n2;
        String string2 = string;
        int n3 = 0;
        boolean bl3 = true;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (bl3) {
            int n4 = string.lastIndexOf(91);
            if (n4 == -1) {
                bl3 = false;
            } else if (!string.endsWith("]") || string.length() <= 2) {
                bl3 = false;
            } else {
                n2 = string.length() - 1;
                if (n4 == n2 - 1) {
                    if (bl2) {
                        arrayList.add("");
                    } else {
                        bl3 = false;
                    }
                } else {
                    String string3 = string.substring(n4 + 1, n2);
                    if ((string3 = string3.trim()).equals("")) {
                        bl3 = false;
                    } else if (string3.matches("[\\d]*")) {
                        try {
                            int n5 = Integer.parseInt(string3);
                            if (string3.equals("0")) {
                                arrayList.add(new Integer(n5));
                            }
                            if (string3.startsWith("0") || n5 < 0) {
                                bl3 = false;
                            }
                            arrayList.add(new Integer(n5));
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new UMLSemanticsException("invalid_multiplicity.message");
                        }
                    } else if (string3.matches("[\\d]+[\\.][\\.][\\d]+") || string3.matches("[\\d]+[\\.][\\.][\\*]") || string3.matches("\\*")) {
                        arrayList.add(string3);
                    } else if (string3.matches("[\\D]*")) {
                        arrayList.add(string3);
                    } else if (string3.matches("[\\D]*+[\\.][\\.][\\D]*+") || string3.matches("[\\d]+[\\.][\\.][\\D]*+") || string3.matches("[\\D]*+[\\.][\\.][\\d]+")) {
                        arrayList.add(string3);
                    } else {
                        bl3 = false;
                    }
                }
            }
            if (!bl3) continue;
            string = string.substring(0, n4);
            ++n3;
            if (bl2) continue;
            bl3 = false;
        }
        if ("".equals(string)) {
            string = string2;
            n3 = 0;
            arrayList.clear();
        }
        Object[] objectArray = new Object[2 + arrayList.size()];
        objectArray[0] = string;
        objectArray[1] = new Integer(n3);
        for (n2 = 2; n2 < objectArray.length; ++n2) {
            objectArray[n2] = arrayList.get(objectArray.length - n2 - 1);
        }
        return objectArray;
    }

    public static String getTypeName(String string) {
        return (String)TypeExpression.parseType(string)[0];
    }

    public static String getDimention(UMultiplicity uMultiplicity) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (uMultiplicity == null) {
            return stringBuilder.toString();
        }
        List list = uMultiplicity.getMultiplicityRanges();
        for (UMultiplicityRange uMultiplicityRange : list) {
            stringBuilder.append("[");
            stringBuilder.append(UMultiplicityRange.toRangeString(uMultiplicityRange));
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }
}

