/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.uml.profile;

import JP.co.esm.caddies.golf.model.EntityStore;
import JP.co.esm.caddies.golf.util.B;
import JP.co.esm.caddies.golf.util.XMLWriter;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.q;
import JP.co.esm.caddies.jomt.jsystem.c;
import JP.co.esm.caddies.uml.Foundation.ExtensionMechanisms.UTaggedValue;
import JP.co.esm.caddies.uml.ModelManagement.UModel;
import JP.co.esm.caddies.uml.SimpleUML.SimpleModel;
import JP.co.esm.caddies.uml.SimpleUML.SimpleModelElement;
import JP.co.esm.caddies.uml.profile.StereotypeDefinition;
import JP.co.esm.caddies.uml.profile.UMLProfile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UMLProfileManager
implements Observer {
    private static UMLProfileManager instance;
    private Map profiles = new HashMap();
    private Observable target;
    private static final Logger logger;

    public static UMLProfileManager instance() {
        if (instance == null) {
            instance = new UMLProfileManager();
        }
        return instance;
    }

    public Map getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Map map) {
        this.profiles = map;
    }

    public UMLProfile getProfile(String string) {
        return (UMLProfile)this.profiles.get(string);
    }

    public void addProfile(String string) {
        UMLProfile uMLProfile = new UMLProfile(string);
        this.profiles.put(string, uMLProfile);
    }

    public void removeProfile(String string) {
        this.profiles.remove(string);
    }

    public void clearProfiles() {
        this.stopTargetObservation();
        this.profiles.clear();
    }

    public StereotypeDefinition getStereotypeDefinition(String string) {
        UMLProfile uMLProfile;
        StereotypeDefinition stereotypeDefinition = null;
        Iterator iterator = this.profiles.keySet().iterator();
        while (iterator.hasNext() && (stereotypeDefinition = (uMLProfile = (UMLProfile)this.profiles.get(iterator.next())).getStereotypeDefinition(string)) == null) {
        }
        return stereotypeDefinition;
    }

    public void ensureDefaultUMLProfile() {
        this.ensureDefaultUMLProfile(c.g.p().doc);
    }

    public void ensureDefaultUMLProfile(JomtEntityStore jomtEntityStore) {
        UTaggedValue uTaggedValue = this.getProfileTaggedValue(jomtEntityStore);
        if (uTaggedValue == null) {
            this.intializeDefaultUMLProfile(jomtEntityStore);
        } else {
            String string = uTaggedValue.getValue().getBody();
            this.profiles = this.decode(string);
            q.b(jomtEntityStore).setChanged();
            q.b(jomtEntityStore).notifyObservers();
        }
        this.resetTargetObservation(jomtEntityStore);
    }

    private void resetTargetObservation(EntityStore entityStore) {
        UTaggedValue uTaggedValue = this.getProfileTaggedValue(entityStore);
        if (uTaggedValue == null) {
            return;
        }
        if (this.target != null && this.target != uTaggedValue) {
            this.stopTargetObservation();
        }
        this.target = (Observable)((Object)uTaggedValue);
        this.target.addObserver(this);
    }

    private void stopTargetObservation() {
        if (this.target != null) {
            this.target.deleteObserver(this);
            this.target = null;
        }
    }

    private UTaggedValue getProfileTaggedValue(EntityStore entityStore) {
        UModel uModel = q.b(entityStore);
        UTaggedValue uTaggedValue = SimpleModelElement.getTaggedValue(uModel, "jude.profiles");
        return uTaggedValue;
    }

    private void intializeDefaultUMLProfile(JomtEntityStore jomtEntityStore) {
        UMLProfile uMLProfile = new UMLProfile("jude.profiles");
        this.profiles.put(uMLProfile.getName(), uMLProfile);
        String string = this.encode(this.profiles);
        UModel uModel = q.a(jomtEntityStore.r());
        SimpleModel simpleModel = new SimpleModel((EntityStore)jomtEntityStore, uModel);
        simpleModel.setTaggedValue(uMLProfile.getName(), string);
        jomtEntityStore.d(false);
    }

    public String encode(Map map) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            B b2 = new B(new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8")));
            b2.a(1);
            this.encodeProfiles(b2, map);
            b2.d();
        }
        catch (Exception exception) {
            logger.error("error has occurred.", (Throwable)exception);
            return null;
        }
        try {
            return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("error has occurred.", (Throwable)unsupportedEncodingException);
            return "";
        }
    }

    private void encodeProfiles(XMLWriter xMLWriter, Map map) throws SAXException {
        xMLWriter.c();
        xMLWriter.b("umlProfiles");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            UMLProfile uMLProfile = (UMLProfile)map.get(iterator.next());
            xMLWriter.b("umlProfile");
            xMLWriter.a("name", uMLProfile.getName());
            List list = uMLProfile.getAllStereotypeDefinitions();
            for (StereotypeDefinition stereotypeDefinition : list) {
                String string;
                String string2;
                String string3;
                xMLWriter.b("stereotypeDefinition");
                String string4 = stereotypeDefinition.getUuid();
                if (string4 != null) {
                    xMLWriter.a("uuid", string4);
                }
                xMLWriter.a("metaModel", String.valueOf(stereotypeDefinition.getMetaModel()));
                String string5 = stereotypeDefinition.getStereotype();
                if (string5 != null) {
                    xMLWriter.a("stereotype", string5);
                }
                if ((string3 = stereotypeDefinition.getDefinition()) != null) {
                    xMLWriter.a("definition", string3);
                }
                if ((string2 = stereotypeDefinition.getIconExtension()) != null) {
                    xMLWriter.a("iconExtension", string2);
                }
                if ((string = stereotypeDefinition.getIconContent()) != null) {
                    xMLWriter.a("iconContent", string);
                }
                xMLWriter.c("stereotypeDefinition");
            }
            xMLWriter.c("umlProfile");
        }
        xMLWriter.c("umlProfiles");
        xMLWriter.endDocument();
    }

    public Map decode(String string) {
        HashMap<String, UMLProfile> hashMap = new HashMap<String, UMLProfile>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(string.getBytes("UTF-8")), "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            Document document = documentBuilder.parse(new InputSource(bufferedReader));
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("umlProfile");
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Element element2 = (Element)nodeList.item(i2);
                NodeList nodeList2 = element2.getElementsByTagName("name");
                Node node = ((Element)nodeList2.item(0)).getFirstChild();
                String string2 = node.getNodeValue();
                UMLProfile uMLProfile = new UMLProfile(string2);
                hashMap.put(uMLProfile.getName(), uMLProfile);
                NodeList nodeList3 = element2.getElementsByTagName("stereotypeDefinition");
                for (int i3 = 0; i3 < nodeList3.getLength(); ++i3) {
                    Element element3 = (Element)nodeList3.item(i3);
                    String string3 = this.getValue(element3, "uuid");
                    String string4 = this.getValue(element3, "metaModel");
                    String string5 = this.getValue(element3, "stereotype");
                    String string6 = this.getValue(element3, "definition");
                    String string7 = this.getValue(element3, "iconExtension");
                    String string8 = this.getValue(element3, "iconContent");
                    StereotypeDefinition stereotypeDefinition = null;
                    if (stereotypeDefinition != null) {
                        stereotypeDefinition.setStereotype(string5);
                        stereotypeDefinition.setMetaModel(Integer.parseInt(string4));
                        stereotypeDefinition.setDefinition(string6);
                        stereotypeDefinition.setIconExtension(string7);
                        stereotypeDefinition.setIconContent(string8);
                        stereotypeDefinition.notifyObservers();
                    } else {
                        stereotypeDefinition = new StereotypeDefinition(string3, Integer.parseInt(string4), string5, string6, string7, string8);
                    }
                    uMLProfile.addStereotypeDefinition(stereotypeDefinition);
                }
            }
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            logger.error("error has occurred.", (Throwable)exception);
        }
        return hashMap;
    }

    private String getValue(Element element, String string) {
        Node node;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0 && (node = ((Element)nodeList.item(0)).getFirstChild()) != null) {
            return node.getNodeValue();
        }
        return "";
    }

    public void store(EntityStore entityStore) {
        this.store(entityStore, this.profiles);
    }

    public void store(EntityStore entityStore, Map map) {
        SimpleModel simpleModel = new SimpleModel(entityStore, q.a());
        simpleModel.setTaggedValue("jude.profiles", this.encode(map));
    }

    @Override
    public void update(Observable observable, Object object) {
        this.ensureDefaultUMLProfile();
    }

    static {
        logger = LoggerFactory.getLogger(UMLProfileManager.class);
    }
}

