/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.uml.profile;

import JP.co.esm.caddies.golf.util.UUID;
import JP.co.esm.caddies.golf.util.c;
import JP.co.esm.caddies.jomt.jsystem.i;
import JP.co.esm.caddies.jomt.jview.ew;
import JP.co.esm.caddies.uml.BehavioralElements.ActivityGraphs.UActionState;
import JP.co.esm.caddies.uml.BehavioralElements.ActivityGraphs.UObjectFlowState;
import JP.co.esm.caddies.uml.Foundation.Core.UClassifier;
import JP.co.esm.caddies.uml.Foundation.Core.UDiagram;
import JP.co.esm.caddies.uml.Foundation.Core.UElement;
import JP.co.esm.caddies.uml.Foundation.Core.UObject;
import JP.co.esm.caddies.uml.ModelManagement.UPackage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Observable;
import java.util.Observer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StereotypeDefinition
extends Observable {
    public static int CLASS_INT = 0;
    public static int ACTION_STATE_INT = 1;
    public static String[] typeStrings = new String[]{StereotypeDefinition.getTitle("uml.classifier.label"), StereotypeDefinition.getTitle("uml.action_state.label")};
    public static int[] typeValues = new int[]{CLASS_INT, ACTION_STATE_INT};
    private String uuid = UUID.a();
    private int metaModel = CLASS_INT;
    private String stereotype = "stereotype";
    private String definition = null;
    private String iconExtension = null;
    private String iconContent = null;
    private Image cacheImage = null;
    private ImageIcon thumbnail = null;
    private static final Logger logger = LoggerFactory.getLogger(StereotypeDefinition.class);
    private String currentCacheIcon = null;
    private static int THUMBNAIL_SIZE = 16;

    public StereotypeDefinition() {
    }

    public StereotypeDefinition(String string) {
        this();
        this.uuid = string;
    }

    public StereotypeDefinition(String string, int n2, String string2, String string3, String string4, String string5) {
        this(string);
        this.metaModel = n2;
        this.stereotype = string2;
        this.definition = string3;
        this.iconExtension = string4;
        this.iconContent = string5;
        this.setupCacheImage();
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public String getIconContent() {
        return this.iconContent;
    }

    public void setIconContent(String string) {
        this.setChanged();
        this.iconContent = string;
        this.setupCacheImage();
    }

    public String getIconExtension() {
        return this.iconExtension;
    }

    public void setIconExtension(String string) {
        this.setChanged();
        this.iconExtension = string;
    }

    public int getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(int n2) {
        this.setChanged();
        this.metaModel = n2;
    }

    public String getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(String string) {
        this.setChanged();
        this.stereotype = string;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String string) {
        this.uuid = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setIcon(String string) {
        this.setChanged();
        this.iconExtension = string.substring(string.lastIndexOf(46) + 1);
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n2;
            fileInputStream = new FileInputStream(string);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            this.iconContent = c.a(byteArrayOutputStream.toByteArray());
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error("error has occurred.", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException2) {
                logger.error("error has occurred.", (Throwable)iOException2);
            }
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException3) {
                logger.error("error has occurred.", (Throwable)iOException3);
            }
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException4) {
                logger.error("error has occurred.", (Throwable)iOException4);
            }
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    logger.error("error has occurred.", (Throwable)iOException);
                }
            }
        }
        return this.setupCacheImage();
    }

    public static BufferedImage convertType(BufferedImage bufferedImage, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, n2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawRenderedImage(bufferedImage, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setupCacheImage() {
        if (this.iconContent == null || this.iconContent.equals("")) {
            this.cacheImage = null;
            this.currentCacheIcon = null;
            this.thumbnail = null;
            return true;
        }
        if (this.currentCacheIcon != null && this.currentCacheIcon.equals(this.iconContent)) {
            return true;
        }
        this.currentCacheIcon = this.iconContent;
        byte[] byArray = c.a(this.iconContent);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
            if (bufferedImage == null) {
                boolean bl2 = false;
                return bl2;
            }
            this.cacheImage = StereotypeDefinition.convertType(bufferedImage, 2);
        }
        catch (IOException iOException) {
            ew.b("app", "tell_bad_content.message");
            logger.error("error has occurred.", (Throwable)iOException);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (byteArrayInputStream != null) {
                    ((InputStream)byteArrayInputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        this.setupThumbnail();
        return true;
    }

    public Image getIconImage() {
        if (this.cacheImage == null) {
            this.setupCacheImage();
        }
        return this.cacheImage;
    }

    public boolean isValidIcon(UElement uElement, UDiagram uDiagram, String string) {
        return this.getModelInt(uElement, uDiagram) == this.metaModel && string.equals(this.stereotype) && this.getIconImage() != null;
    }

    private int getModelInt(UElement uElement, UDiagram uDiagram) {
        int n2 = -1;
        if (!(uElement instanceof UPackage)) {
            if (uElement instanceof UObject) {
                n2 = typeValues[CLASS_INT];
            } else if (uElement instanceof UActionState) {
                n2 = typeValues[ACTION_STATE_INT];
            } else if (uElement instanceof UClassifier || uElement instanceof UObjectFlowState) {
                n2 = typeValues[CLASS_INT];
            }
        }
        return n2;
    }

    public void changeStereotypeDefinition(int n2, String string, String string2, String string3) {
        this.setMetaModel(n2);
        this.setStereotype(string);
        this.setDefinition(string2);
        this.setIcon(string3);
    }

    @Override
    public void setChanged() {
        super.setChanged();
    }

    protected static String getTitle(String string) {
        String string2 = i.h().a(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public boolean equals(Object object) {
        StereotypeDefinition stereotypeDefinition;
        return object instanceof StereotypeDefinition && this.equalsString(this.uuid, (stereotypeDefinition = (StereotypeDefinition)object).getUuid()) && this.equalsString(this.definition, stereotypeDefinition.getDefinition()) && this.metaModel == stereotypeDefinition.getMetaModel() && this.equalsString(this.iconExtension, stereotypeDefinition.getIconExtension()) && this.equalsString(this.iconContent, stereotypeDefinition.getIconContent()) && this.equalsString(this.stereotype, stereotypeDefinition.getStereotype());
    }

    private boolean equalsString(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(observer);
    }

    @Override
    public void deleteObserver(Observer observer) {
        super.deleteObserver(observer);
    }

    public ImageIcon getThumbnail() {
        return this.thumbnail;
    }

    private void setupThumbnail() {
        this.thumbnail = null;
        Image image = this.getIconImage();
        if (image != null) {
            int n2 = THUMBNAIL_SIZE;
            int n3 = THUMBNAIL_SIZE;
            float f2 = this.getHeightWidthRatio(image);
            if ((double)f2 >= 1.0) {
                n2 = Math.round((float)THUMBNAIL_SIZE / f2);
            } else {
                n3 = Math.round((float)THUMBNAIL_SIZE * f2);
            }
            Image image2 = image.getScaledInstance(n2, n3, 2);
            this.thumbnail = new ImageIcon(image2);
        }
    }

    private float getHeightWidthRatio(Image image) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        return (float)n3 / (float)n2;
    }
}

