/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.uml.mindmap;

import JP.co.esm.caddies.golf.util.c;
import JP.co.esm.caddies.jomt.jview.ew;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Observable;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserIcon
extends Observable {
    private String uuid = null;
    private String iconContent = null;
    private String iconExtension = null;
    private String iconLabel = null;
    private Image cacheImage = null;
    private ImageIcon thumbnail = null;
    private String currentCacheIcon = null;
    private static int THUMBNAIL_SIZE = 16;
    private static final Logger logger = LoggerFactory.getLogger(UserIcon.class);

    public UserIcon() {
        this.uuid = "";
        this.iconContent = "";
        this.iconExtension = "";
        this.iconLabel = "";
    }

    public UserIcon(String string, String string2, String string3, String string4) {
        this.uuid = string;
        this.iconContent = string2;
        this.iconExtension = string3;
        this.iconLabel = string4;
        this.setupCacheImage();
    }

    public UserIcon(String string) {
        this();
        this.uuid = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIcon(String string) {
        Object object;
        BufferedImage bufferedImage;
        this.setChanged();
        this.iconExtension = string.substring(string.lastIndexOf(".") + 1).toLowerCase();
        File file = new File(string);
        Image image = null;
        try {
            bufferedImage = ImageIO.read(file);
            if (bufferedImage.getWidth() != THUMBNAIL_SIZE || bufferedImage.getHeight() != THUMBNAIL_SIZE) {
                image = bufferedImage.getScaledInstance(THUMBNAIL_SIZE, THUMBNAIL_SIZE, 8);
                object = new MediaTracker(new Container());
                ((MediaTracker)object).addImage(image, 1);
                try {
                    ((MediaTracker)object).waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    logger.error("error has occurred.", (Throwable)interruptedException);
                }
            } else {
                image = bufferedImage;
            }
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
        }
        bufferedImage = new BufferedImage(THUMBNAIL_SIZE, THUMBNAIL_SIZE, 2);
        bufferedImage.createGraphics().drawImage(image, 0, 0, null);
        object = new ByteArrayOutputStream();
        try {
            if ("gif".equalsIgnoreCase(this.iconExtension)) {
                this.iconExtension = "png";
            }
            ImageIO.write((RenderedImage)bufferedImage, this.iconExtension, (OutputStream)object);
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
        }
        this.iconContent = c.a(((ByteArrayOutputStream)object).toByteArray());
        try {
            ((ByteArrayOutputStream)object).close();
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
        }
        this.cacheImage = image;
        this.thumbnail = new ImageIcon(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupCacheImage() {
        if (this.iconContent == null || this.iconContent.equals("")) {
            this.cacheImage = null;
            this.currentCacheIcon = null;
            this.thumbnail = null;
            return;
        }
        if (this.currentCacheIcon != null && this.currentCacheIcon.equals(this.iconContent)) {
            return;
        }
        this.currentCacheIcon = this.iconContent;
        byte[] byArray = c.a(this.iconContent);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
            this.cacheImage = UserIcon.convertType(bufferedImage, 2);
        }
        catch (IOException iOException) {
            ew.b("app", "tell_bad_content.message");
            logger.error("error has occurred.", (Throwable)iOException);
        }
        finally {
            try {
                if (byteArrayInputStream != null) {
                    ((InputStream)byteArrayInputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
        this.setupThumbnail();
    }

    private void setupThumbnail() {
        this.thumbnail = null;
        Image image = this.getIconImage();
        if (image != null) {
            int n2 = THUMBNAIL_SIZE;
            int n3 = THUMBNAIL_SIZE;
            float f2 = this.getHeightWidthRatio(image);
            if ((double)f2 >= 1.0) {
                n2 = Math.round((float)THUMBNAIL_SIZE / f2);
            } else {
                n3 = Math.round((float)THUMBNAIL_SIZE * f2);
            }
            Image image2 = image.getScaledInstance(n2, n3, 2);
            this.thumbnail = new ImageIcon(image2);
        }
    }

    private float getHeightWidthRatio(Image image) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        return (float)n3 / (float)n2;
    }

    private Image getIconImage() {
        if (this.cacheImage == null) {
            this.setupCacheImage();
        }
        return this.cacheImage;
    }

    private static BufferedImage convertType(BufferedImage bufferedImage, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, n2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawRenderedImage(bufferedImage, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String string) {
        this.uuid = string;
    }

    @Override
    public void setChanged() {
        super.setChanged();
    }

    public String getIconExtension() {
        return this.iconExtension;
    }

    public void setIconExtension(String string) {
        this.iconExtension = string;
    }

    public String getIconContent() {
        return this.iconContent;
    }

    public String getIconLabel() {
        return this.iconLabel;
    }

    public void setIconLabel(String string) {
        this.iconLabel = string;
    }

    public ImageIcon getThumbnail() {
        return this.thumbnail;
    }

    public void setIconContent(String string) {
        this.iconContent = string;
    }
}

