/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.uml.mindmap;

import JP.co.esm.caddies.golf.model.EntityStore;
import JP.co.esm.caddies.golf.util.B;
import JP.co.esm.caddies.golf.util.XMLWriter;
import JP.co.esm.caddies.jomt.jmodel.IMMTopicPresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.q;
import JP.co.esm.caddies.jomt.jsystem.c;
import JP.co.esm.caddies.jomt.jsystem.i;
import JP.co.esm.caddies.jomt.jview.ew;
import JP.co.esm.caddies.uml.Foundation.Core.UDiagram;
import JP.co.esm.caddies.uml.Foundation.Core.UPresentation;
import JP.co.esm.caddies.uml.Foundation.ExtensionMechanisms.UTaggedValue;
import JP.co.esm.caddies.uml.ModelManagement.UModel;
import JP.co.esm.caddies.uml.SimpleUML.SimpleModel;
import JP.co.esm.caddies.uml.SimpleUML.SimpleModelElement;
import JP.co.esm.caddies.uml.mindmap.MMUserIconInfo;
import JP.co.esm.caddies.uml.mindmap.UMindMapDiagram;
import JP.co.esm.caddies.uml.mindmap.UserIcon;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MMUserIconManager {
    private static MMUserIconManager instance;
    private Map systemUserIconInfo = new HashMap();
    private Map projectUserIconInfo = new HashMap();
    private boolean isSupportUserIcon = true;
    private static final Logger logger;

    private MMUserIconManager() {
        if (i.d().equals("J")) {
            this.isSupportUserIcon = false;
        }
    }

    public static MMUserIconManager instance() {
        if (instance == null) {
            instance = new MMUserIconManager();
        }
        return instance;
    }

    public Map getUserIconInfo() {
        return this.systemUserIconInfo;
    }

    public MMUserIconInfo getProjectUserIconInfo() {
        return (MMUserIconInfo)this.projectUserIconInfo.get("jude.usericons");
    }

    public MMUserIconInfo getSystemUserIconInfo() {
        return (MMUserIconInfo)this.systemUserIconInfo.get("jude.usericons");
    }

    public void clearUserIconInfo() {
        try {
            this.writeSystemUserIconInfo();
        }
        catch (Exception exception) {
            logger.error("error has occurred.", (Throwable)exception);
        }
        this.projectUserIconInfo.clear();
    }

    private void writeSystemUserIconInfo() throws IOException {
        if (!this.isSupportUserIcon) {
            return;
        }
        BufferedWriter bufferedWriter = null;
        try {
            String string = i.s();
            File file = new File(string + File.separator + c.m.f("jude.mmusericon"));
            logger.info("file: {}", (Object)file.getAbsolutePath());
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            bufferedWriter.write(this.encode(this.systemUserIconInfo));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bufferedWriter != null) {
            bufferedWriter.close();
        }
    }

    public void initializeMMUserIconInfo(JomtEntityStore jomtEntityStore) {
        this.initializeSystemUserIconInfo();
        this.initializeProjectUserIconInfo(jomtEntityStore);
    }

    public void initializeProjectUserIconInfo(JomtEntityStore jomtEntityStore) {
        UTaggedValue uTaggedValue = this.getUserIconInfoTaggedValue(jomtEntityStore);
        if (uTaggedValue == null) {
            this.createProjectUserIconInfo(jomtEntityStore);
        } else {
            this.readProjectUserIconInfo(jomtEntityStore, uTaggedValue);
        }
    }

    private void readProjectUserIconInfo(JomtEntityStore jomtEntityStore, UTaggedValue uTaggedValue) {
        String string = uTaggedValue.getValue().getBody();
        this.projectUserIconInfo = MMUserIconManager.decodeUserIconInfo(string);
        if (this.isSupportUserIcon) {
            this.checkAndGetNewUserIconInPrj(jomtEntityStore);
        }
    }

    private void checkAndGetNewUserIconInPrj(JomtEntityStore jomtEntityStore) {
        int n2;
        MMUserIconInfo mMUserIconInfo = this.getProjectUserIconInfo();
        List list = mMUserIconInfo.getAllUserIcons();
        if (list.isEmpty()) {
            return;
        }
        ArrayList<UserIcon> arrayList = new ArrayList<UserIcon>();
        MMUserIconInfo mMUserIconInfo2 = this.getSystemUserIconInfo();
        if (mMUserIconInfo2 == null) {
            return;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            UserIcon userIcon = (UserIcon)list.get(n2);
            if (mMUserIconInfo2.getUserIcons(userIcon.getUuid()) != null) continue;
            arrayList.add(userIcon);
        }
        if (!arrayList.isEmpty()) {
            n2 = ew.k("app", "ask_get_new_mm_user_icons.message");
            if (n2 != 0) {
                return;
            }
            for (UserIcon userIcon : arrayList) {
                mMUserIconInfo2.addUserIcon(userIcon);
            }
            this.writeProjectUserIconInfo(jomtEntityStore);
        }
    }

    private UTaggedValue getUserIconInfoTaggedValue(EntityStore entityStore) {
        UModel uModel = q.b(entityStore);
        UTaggedValue uTaggedValue = SimpleModelElement.getTaggedValue(uModel, "jude.usericons");
        return uTaggedValue;
    }

    private void initializeSystemUserIconInfo() {
        if (!this.isSupportUserIcon) {
            return;
        }
        String string = this.readSystemUserIconInfo();
        if (string != null && string.length() > 0) {
            this.systemUserIconInfo = MMUserIconManager.decodeUserIconInfo(string);
            if (!this.systemUserIconInfo.isEmpty()) {
                return;
            }
        }
        this.createSystemUserIconInfo();
    }

    private void createSystemUserIconInfo() {
        MMUserIconInfo mMUserIconInfo = new MMUserIconInfo("jude.usericons");
        this.systemUserIconInfo.put(mMUserIconInfo.getName(), mMUserIconInfo);
        try {
            this.writeSystemUserIconInfo();
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
        }
    }

    private void createProjectUserIconInfo(JomtEntityStore jomtEntityStore) {
        MMUserIconInfo mMUserIconInfo = new MMUserIconInfo("jude.usericons");
        this.projectUserIconInfo.put(mMUserIconInfo.getName(), mMUserIconInfo);
        String string = this.encode(this.projectUserIconInfo);
        UModel uModel = q.b(jomtEntityStore);
        SimpleModel simpleModel = new SimpleModel((EntityStore)jomtEntityStore, uModel);
        simpleModel.setTaggedValue(mMUserIconInfo.getName(), string);
        jomtEntityStore.d(false);
    }

    private String readSystemUserIconInfo() {
        String string = i.s();
        File file = new File(string + File.separator + c.m.f("jude.mmusericon"));
        if (!file.exists()) {
            return null;
        }
        StringWriter stringWriter = null;
        BufferedReader bufferedReader = null;
        try {
            int n2;
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            stringWriter = new StringWriter();
            while ((n2 = bufferedReader.read()) != -1) {
                stringWriter.write(n2);
            }
            stringWriter.flush();
            bufferedReader.close();
            return stringWriter.toString();
        }
        catch (Exception exception) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    logger.error("error has occurred.", (Throwable)iOException);
                }
            }
            logger.error("error has occurred.", (Throwable)exception);
            return null;
        }
    }

    private String encode(Map map) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            B b2 = new B(new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8")));
            b2.a(1);
            MMUserIconManager.encodeUserIconInfo(b2, map);
            b2.d();
        }
        catch (Exception exception) {
            logger.error("error has occurred.", (Throwable)exception);
            return null;
        }
        try {
            return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("error has occurred.", (Throwable)unsupportedEncodingException);
            return "";
        }
    }

    private static void encodeUserIconInfo(XMLWriter xMLWriter, Map map) throws SAXException {
        xMLWriter.c();
        xMLWriter.b("mmUserIcon");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            MMUserIconInfo mMUserIconInfo = (MMUserIconInfo)map.get(iterator.next());
            xMLWriter.b("mmUserIconInfo");
            xMLWriter.a("name", mMUserIconInfo.getName());
            List list = mMUserIconInfo.getUserIcons();
            for (UserIcon userIcon : list) {
                String string;
                String string2;
                String string3;
                xMLWriter.b("userIcon");
                String string4 = userIcon.getUuid();
                if (string4 != null) {
                    xMLWriter.a("uuid", string4);
                }
                if ((string3 = userIcon.getIconContent()) != null) {
                    xMLWriter.a("iconContent", string3);
                }
                if ((string2 = userIcon.getIconExtension()) != null) {
                    xMLWriter.a("iconExtension", string2);
                }
                if ((string = userIcon.getIconLabel()) != null) {
                    xMLWriter.a("iconLabel", string);
                }
                xMLWriter.c("userIcon");
            }
            xMLWriter.c("mmUserIconInfo");
        }
        xMLWriter.c("mmUserIcon");
        xMLWriter.endDocument();
    }

    public static Map decodeUserIconInfo(String string) {
        HashMap<String, MMUserIconInfo> hashMap = new HashMap<String, MMUserIconInfo>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(string.getBytes("UTF-8")), "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            Document document = documentBuilder.parse(new InputSource(bufferedReader));
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("mmUserIconInfo");
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Element element2 = (Element)nodeList.item(i2);
                NodeList nodeList2 = element2.getElementsByTagName("name");
                Node node = ((Element)nodeList2.item(0)).getFirstChild();
                String string2 = node.getNodeValue();
                MMUserIconInfo mMUserIconInfo = new MMUserIconInfo(string2);
                hashMap.put(mMUserIconInfo.getName(), mMUserIconInfo);
                NodeList nodeList3 = element2.getElementsByTagName("userIcon");
                for (int i3 = 0; i3 < nodeList3.getLength(); ++i3) {
                    Element element3 = (Element)nodeList3.item(i3);
                    String string3 = MMUserIconManager.getXmlTagValue(element3, "uuid");
                    String string4 = MMUserIconManager.getXmlTagValue(element3, "iconContent");
                    String string5 = MMUserIconManager.getXmlTagValue(element3, "iconExtension");
                    String string6 = MMUserIconManager.getXmlTagValue(element3, "iconLabel");
                    UserIcon userIcon = new UserIcon(string3, string4, string5, string6);
                    mMUserIconInfo.addUserIcon(userIcon);
                }
            }
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            logger.error("error has occurred.", (Throwable)exception);
        }
        return hashMap;
    }

    private static String getXmlTagValue(Element element, String string) {
        Node node;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 0 && (node = ((Element)nodeList.item(0)).getFirstChild()) != null) {
            return node.getNodeValue();
        }
        return "";
    }

    public void writeProjectUserIconInfo(EntityStore entityStore) {
        if (!this.isSupportUserIcon) {
            return;
        }
        SimpleModel simpleModel = new SimpleModel(entityStore, q.a());
        simpleModel.setTaggedValue("jude.usericons", this.encode(this.projectUserIconInfo));
    }

    public void checkProjectUserIconInfoToDelete(EntityStore entityStore, String string) {
        if (!this.isSupportUserIcon) {
            return;
        }
        if (!this.isUserIconUsed(entityStore, string)) {
            MMUserIconInfo mMUserIconInfo = this.getProjectUserIconInfo();
            for (int i2 = mMUserIconInfo.getAllUserIcons().size() - 1; i2 >= 0; --i2) {
                UserIcon userIcon = (UserIcon)mMUserIconInfo.getAllUserIcons().get(i2);
                if (!userIcon.getUuid().equals(string)) continue;
                mMUserIconInfo.removeUserIcon(userIcon);
                this.writeProjectUserIconInfo(entityStore);
                return;
            }
        }
    }

    private boolean isUserIconUsed(EntityStore entityStore, String string) {
        List list = q.e(entityStore);
        for (UDiagram uDiagram : list) {
            if (!(uDiagram instanceof UMindMapDiagram)) continue;
            for (UPresentation uPresentation : uDiagram.getPresentations()) {
                if (!(uPresentation instanceof IMMTopicPresentation) || ((IMMTopicPresentation)((Object)uPresentation)).getIcons() == null || !((IMMTopicPresentation)((Object)uPresentation)).getIcons().contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        logger = LoggerFactory.getLogger(MMUserIconManager.class);
    }
}

