/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.uml.SimpleUML;

import JP.co.esm.caddies.golf.model.EntityStore;
import JP.co.esm.caddies.uml.BehavioralElements.StateMachines.UState;
import JP.co.esm.caddies.uml.BehavioralElements.StateMachines.UStateChartDiagram;
import JP.co.esm.caddies.uml.BehavioralElements.StateMachines.UStateMachine;
import JP.co.esm.caddies.uml.BehavioralElements.StateMachines.UStateMachineImp;
import JP.co.esm.caddies.uml.BehavioralElements.StateMachines.USubmachineState;
import JP.co.esm.caddies.uml.BehavioralElements.StateMachines.UTransition;
import JP.co.esm.caddies.uml.Foundation.Core.UDiagram;
import JP.co.esm.caddies.uml.Foundation.Core.UElement;
import JP.co.esm.caddies.uml.Foundation.Core.UModelElement;
import JP.co.esm.caddies.uml.SimpleUML.SimpleModelElement;
import JP.co.esm.caddies.uml.SimpleUML.SimpleTransition;
import JP.co.esm.caddies.uml.SimpleUML.SimpleUml;
import JP.co.esm.caddies.uml.SimpleUML.SimpleUmlUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStateMachine
extends SimpleModelElement {
    private UStateMachine uStateMachine = null;
    private static final Logger logger = LoggerFactory.getLogger(SimpleStateMachine.class);

    public SimpleStateMachine() {
    }

    public SimpleStateMachine(EntityStore entityStore) {
        super(entityStore);
    }

    public SimpleStateMachine(EntityStore entityStore, UStateMachine uStateMachine) {
        super(entityStore);
        this.setElement(uStateMachine);
    }

    @Override
    void setElement(UElement uElement) {
        if (uElement instanceof UStateMachine) {
            this.uStateMachine = (UStateMachine)uElement;
        }
        super.setElement(uElement);
    }

    public UStateMachine createStateMachine(UModelElement uModelElement) {
        UStateMachineImp uStateMachineImp = new UStateMachineImp();
        this.entityStore.a(uStateMachineImp);
        this.setElement(uStateMachineImp);
        this.setContext(uModelElement);
        return uStateMachineImp;
    }

    public UStateMachine createStateMachine(UModelElement uModelElement, String string) {
        UStateMachine uStateMachine = this.createStateMachine(uModelElement);
        this.setName(string);
        return uStateMachine;
    }

    public void setContext(UModelElement uModelElement) {
        if (this.uStateMachine.getContext() != null) {
            UModelElement uModelElement2 = this.uStateMachine.getContext();
            EntityStore.d(uModelElement2);
            uModelElement2.removeBehavior(this.uStateMachine);
        }
        if (uModelElement != null) {
            EntityStore.d(this.uStateMachine);
            this.uStateMachine.setContext(uModelElement);
            EntityStore.d(uModelElement);
            uModelElement.addBehavior(this.uStateMachine);
        }
    }

    public void setTop(UState uState) {
        EntityStore.d(this.uStateMachine);
        this.uStateMachine.setTop(uState);
    }

    public UState getTop() {
        return this.uStateMachine.getTop();
    }

    public void removeSubmahinceInv(USubmachineState uSubmachineState) {
        if (uSubmachineState != null) {
            EntityStore.d(uSubmachineState);
            uSubmachineState.setSubmachine(null);
        }
        EntityStore.d(this.uStateMachine);
        this.uStateMachine.removeSubmahinceInv(uSubmachineState);
    }

    public void addTransition(UTransition uTransition) {
        EntityStore.d(this.uStateMachine);
        this.uStateMachine.addTransition(uTransition);
    }

    @Override
    protected void notifyObserverModels() {
        List list = this.uStateMachine.getSubmahinceInvs();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.notify((UModelElement)list.get(i2));
        }
    }

    public void removeTransition(UTransition uTransition) {
        EntityStore.d(this.uStateMachine);
        this.uStateMachine.removeTransition(uTransition);
        SimpleTransition simpleTransition = new SimpleTransition(this.entityStore, uTransition);
        simpleTransition.remove();
    }

    public void removeAllTransitions() {
        List list = this.uStateMachine.getTransitions();
        SimpleTransition simpleTransition = new SimpleTransition(this.entityStore);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            UTransition uTransition = (UTransition)list.get(i2);
            simpleTransition.setElement(uTransition);
            simpleTransition.remove();
        }
        EntityStore.d(this.uStateMachine);
        this.uStateMachine.removeAllTransitions();
    }

    @Override
    public void remove() {
        if (this.uStateMachine == null) {
            return;
        }
        SimpleUmlUtil.setEntityStore(this.entityStore);
        EntityStore.d(this.uStateMachine);
        this.removeTop();
        this.removeTransitions();
        this.removeDiagram();
        this.removeSubmachieState();
        this.removeContext();
        this.uStateMachine = null;
        super.remove();
    }

    private void removeSubmachieState() {
        List list = this.uStateMachine.getSubmahinceInvs();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            USubmachineState uSubmachineState = (USubmachineState)list.get(i2);
            EntityStore.d(uSubmachineState);
            uSubmachineState.setSubmachine(null);
        }
    }

    private void removeContext() {
        UModelElement uModelElement = this.uStateMachine.getContext();
        if (uModelElement != null) {
            this.uStateMachine.setContext(null);
            EntityStore.d(uModelElement);
            uModelElement.removeBehavior(this.uStateMachine);
        }
    }

    private void removeDiagram() {
        UStateChartDiagram uStateChartDiagram = (UStateChartDiagram)this.uStateMachine.getDiagram();
        if (uStateChartDiagram != null) {
            EntityStore.d(uStateChartDiagram);
            uStateChartDiagram.setStateMachine(null);
            this.uStateMachine.setDiagram(null);
            SimpleUml simpleUml = SimpleUmlUtil.getSimpleUml((UElement)uStateChartDiagram);
            if (simpleUml != null) {
                simpleUml.remove();
            }
        }
    }

    private void removeTransitions() {
        List list = this.uStateMachine.getTransitions();
        Object[] objectArray = list.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            SimpleUml simpleUml = SimpleUmlUtil.getSimpleUml((UTransition)objectArray[i2]);
            if (simpleUml == null) continue;
            simpleUml.remove();
        }
    }

    private void removeTop() {
        SimpleUml simpleUml;
        UState uState = this.uStateMachine.getTop();
        if (uState != null && (simpleUml = SimpleUmlUtil.getSimpleUml(uState)) != null) {
            simpleUml.remove();
        }
    }

    @Override
    public void setParameters(Map map) {
        String string = (String)map.get("s16");
        if (this.uStateMachine != null) {
            if (string.equals("")) {
                return;
            }
            SimpleUml simpleUml = SimpleUmlUtil.getSimpleUml(this.uStateMachine);
            simpleUml.setName(string);
        }
        super.setParameters(map);
    }

    @Override
    public Map getParameters() {
        Map map = super.getParameters();
        if (this.uStateMachine == null) {
            map.put("s9", "");
        } else {
            map.put("s9", this.uStateMachine.getNameString());
        }
        return map;
    }

    @Override
    public void validate() {
        this.validateContext();
        this.validateTop();
        this.validateTransition();
        this.validateSubmachineInv();
        this.validateDiagram();
        super.validate();
    }

    private void validateContext() {
        UModelElement uModelElement = this.uStateMachine.getContext();
        if (uModelElement == null) {
            this.nullErrorMsg(this.uStateMachine, "context");
        } else {
            List list;
            if (!this.entityStore.e(uModelElement)) {
                this.entityStoreErrorMsg(uModelElement, "context");
            }
            if (!(list = uModelElement.getBehavior()).contains(this.uStateMachine)) {
                this.inverseErrorMsg(uModelElement, "context");
            }
        }
    }

    private void validateTop() {
        UState uState = this.uStateMachine.getTop();
        if (uState != null && !this.entityStore.e(uState)) {
            this.entityStoreErrorMsg(uState, "top");
        }
    }

    private void validateTransition() {
        List list = this.uStateMachine.getTransitions();
        for (UTransition uTransition : list) {
            UStateMachine uStateMachine;
            if (!this.entityStore.e(uTransition)) {
                this.entityStoreErrorMsg(uTransition, "transition");
            }
            if (this.uStateMachine == (uStateMachine = uTransition.getTransitionsInv())) continue;
            this.inverseErrorMsg(uTransition, "transition");
        }
    }

    private void validateSubmachineInv() {
        List list = this.uStateMachine.getSubmahinceInvs();
        for (USubmachineState uSubmachineState : list) {
            UStateMachine uStateMachine;
            if (!this.entityStore.e(uSubmachineState)) {
                this.entityStoreErrorMsg(uSubmachineState, "submachineInv");
            }
            if (this.uStateMachine == (uStateMachine = uSubmachineState.getSubmachine())) continue;
            this.inverseErrorMsg(uSubmachineState, "submachineInv");
        }
    }

    private void validateDiagram() {
        UDiagram uDiagram = this.uStateMachine.getDiagram();
        if (uDiagram == null) {
            this.nullErrorMsg(this.uStateMachine, "diagram");
        } else {
            if (!this.entityStore.e(uDiagram)) {
                this.entityStoreErrorMsg(uDiagram, "diagram");
            }
            if (uDiagram instanceof UStateChartDiagram) {
                UStateMachine uStateMachine = ((UStateChartDiagram)uDiagram).getStateMachine();
                if (this.uStateMachine != uStateMachine) {
                    this.inverseErrorMsg(uDiagram, "diagram");
                }
            } else {
                logger.warn("ERROR : The diagram is not UStateChartDiagram");
            }
        }
    }
}

