/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.uml.SimpleUML;

import JP.co.esm.caddies.golf.model.EntityStore;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UCollaboration;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UGate;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UInteraction;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UInteractionFragment;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UInteractionImp;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UInteractionUse;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UMessage;
import JP.co.esm.caddies.uml.Foundation.Core.UElement;
import JP.co.esm.caddies.uml.SimpleUML.SimpleModelElement;
import JP.co.esm.caddies.uml.SimpleUML.SimpleUml;
import JP.co.esm.caddies.uml.SimpleUML.SimpleUmlUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleInteraction
extends SimpleModelElement {
    private UInteraction uInteraction = null;
    private static final Logger logger = LoggerFactory.getLogger(SimpleInteraction.class);

    SimpleInteraction() {
    }

    public SimpleInteraction(EntityStore entityStore) {
        super(entityStore);
    }

    public SimpleInteraction(EntityStore entityStore, UInteraction uInteraction) {
        super(entityStore);
        this.setElement(uInteraction);
    }

    public UInteraction createInteraction(UCollaboration uCollaboration) {
        UInteractionImp uInteractionImp = new UInteractionImp();
        this.entityStore.a(uInteractionImp);
        this.setElement(uInteractionImp);
        this.setContext(uCollaboration);
        return uInteractionImp;
    }

    @Override
    public void setElement(UElement uElement) {
        if (uElement instanceof UInteraction || uElement == null) {
            this.uInteraction = (UInteraction)uElement;
        }
        super.setElement(uElement);
    }

    public void setContext(UCollaboration uCollaboration) {
        EntityStore.d(this.uInteraction);
        this.uInteraction.setContext(uCollaboration);
        EntityStore.d(uCollaboration);
        uCollaboration.addInteraction(this.uInteraction);
    }

    public void addMessage(UMessage uMessage) {
        EntityStore.d(this.uInteraction);
        this.uInteraction.addMessage(uMessage);
    }

    public void removeMessage(UMessage uMessage) {
        EntityStore.d(this.uInteraction);
        this.uInteraction.removeMessage(uMessage);
    }

    public void removeAllMessages() {
        EntityStore.d(this.uInteraction);
        this.uInteraction.removeAllMessages();
    }

    @Override
    public void remove() {
        SimpleUmlUtil.setEntityStore(this.entityStore);
        EntityStore.d(this.uInteraction);
        this.removeAllRefersToInvs();
        UCollaboration uCollaboration = this.uInteraction.getContext();
        if (uCollaboration != null) {
            EntityStore.d(uCollaboration);
            this.uInteraction.setContext(null);
            uCollaboration.removeInteraction(this.uInteraction);
        }
        List list = this.uInteraction.getMessages();
        Object[] objectArray = list.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            SimpleUml simpleUml = SimpleUmlUtil.getSimpleUml((UMessage)objectArray[i2]);
            if (simpleUml == null) continue;
            simpleUml.remove();
        }
        super.remove();
    }

    private void removeAllRefersToInvs() {
        if (this.uInteraction.getRefersToInv() != null) {
            Object[] objectArray = this.uInteraction.getRefersToInv().toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                UInteractionUse uInteractionUse = (UInteractionUse)objectArray[i2];
                this.removeRefersToInv(uInteractionUse);
            }
        }
    }

    private void removeRefersToInv(UInteractionUse uInteractionUse) {
        EntityStore.d(uInteractionUse);
        uInteractionUse.removeRefersTo();
        EntityStore.d(this.uInteraction);
        this.uInteraction.removeRefersToInv(uInteractionUse);
    }

    @Override
    public void changeMergeParent(UElement uElement) {
    }

    @Override
    public void validate() {
        this.validateMessage();
        this.validateContext();
        this.validateFragments();
        this.validateFormalGates();
        this.validateReferstoInv();
        super.validate();
    }

    private void validateReferstoInv() {
        List list = this.uInteraction.getRefersToInv();
        if (list == null) {
            this.nullErrorMsg(this.uInteraction, "ReferstoInv");
        } else {
            for (UInteractionUse uInteractionUse : list) {
                if (!this.entityStore.e(uInteractionUse)) {
                    this.entityStoreErrorMsg(uInteractionUse, "interactionUse");
                }
                if (this.uInteraction == uInteractionUse.getRefersTo()) continue;
                this.inverseErrorMsg(uInteractionUse, "interactionUse");
            }
        }
    }

    private void validateFragments() {
        List list = this.uInteraction.getFragments();
        for (UInteractionFragment uInteractionFragment : list) {
            if (!this.entityStore.e(uInteractionFragment)) {
                this.entityStoreErrorMsg(uInteractionFragment, "fragment");
            }
            if (this.uInteraction == uInteractionFragment.getEnclosingInteraction()) continue;
            this.inverseErrorMsg(uInteractionFragment, "fragment");
        }
    }

    private void validateFormalGates() {
        List list = this.uInteraction.getAllFormalGates();
        for (UGate uGate : list) {
            if (!this.entityStore.e(uGate)) {
                this.entityStoreErrorMsg(uGate, "formalGate");
            }
            if (this.uInteraction == uGate.getInteraction()) continue;
            this.inverseErrorMsg(uGate, "formalGate");
        }
    }

    private void validateMessage() {
        List list = this.uInteraction.getMessages();
        for (UMessage uMessage : list) {
            UInteraction uInteraction;
            if (!this.entityStore.e(uMessage)) {
                this.entityStoreErrorMsg(uMessage, "message");
            }
            if ((uInteraction = uMessage.getInteraction()) == null) {
                logger.warn("ERROR: interaction is null.");
                continue;
            }
            if (this.uInteraction == uInteraction) continue;
            this.inverseErrorMsg(uMessage, "message");
        }
    }

    private void validateContext() {
        UCollaboration uCollaboration = this.uInteraction.getContext();
        if (uCollaboration == null) {
            logger.warn("ERROR: context is null.");
        } else {
            List list;
            if (!this.entityStore.e(uCollaboration)) {
                this.entityStoreErrorMsg(uCollaboration, "context");
            }
            if (!(list = uCollaboration.getInteractions()).contains(this.uInteraction)) {
                this.inverseErrorMsg(uCollaboration, "context");
            }
        }
    }
}

