/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.uml.SimpleUML;

import JP.co.esm.caddies.golf.model.EntityStore;
import JP.co.esm.caddies.jomt.jutil.JomtUtilities;
import JP.co.esm.caddies.uml.Foundation.Core.UArtifact;
import JP.co.esm.caddies.uml.Foundation.Core.UComponent;
import JP.co.esm.caddies.uml.Foundation.Core.UComponentImp;
import JP.co.esm.caddies.uml.Foundation.Core.UElement;
import JP.co.esm.caddies.uml.Foundation.Core.UElementResidence;
import JP.co.esm.caddies.uml.Foundation.Core.UNamespace;
import JP.co.esm.caddies.uml.Foundation.Core.UNode;
import JP.co.esm.caddies.uml.SimpleUML.SimpleClassifier;
import JP.co.esm.caddies.uml.SimpleUML.SimpleElementResidence;
import JP.co.esm.caddies.uml.SimpleUML.SimpleUmlUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SimpleComponent
extends SimpleClassifier {
    private UComponent uComponent;

    public SimpleComponent() {
    }

    public SimpleComponent(EntityStore entityStore) {
        super(entityStore);
    }

    public SimpleComponent(EntityStore entityStore, UComponent uComponent) {
        super(entityStore);
        this.setElement(uComponent);
    }

    @Override
    public void setElement(UElement uElement) {
        if (uElement instanceof UComponent || uElement == null) {
            this.uComponent = (UComponent)uElement;
        }
        super.setElement(uElement);
    }

    public UComponent createComponent(UNamespace uNamespace) {
        UComponentImp uComponentImp = new UComponentImp();
        this.entityStore.a(uComponentImp);
        this.setElement(uComponentImp);
        this.setNamespace(uNamespace, uComponentImp);
        return uComponentImp;
    }

    public UComponent createComponent(UNamespace uNamespace, String string) {
        UComponent uComponent = this.createComponent(uNamespace);
        this.setName(string);
        return uComponent;
    }

    @Override
    public void remove() {
        SimpleUmlUtil.setEntityStore(this.entityStore);
        EntityStore.d(this.uComponent);
        this.removeImplementation();
        this.removeDeploymentLocation();
        this.removeResidentElement();
        super.remove();
    }

    protected void removeResidentElement() {
        List list = this.uComponent.getAllResidentElements();
        if (list != null) {
            Object[] objectArray = list.toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                UElementResidence uElementResidence = (UElementResidence)objectArray[i2];
                SimpleElementResidence simpleElementResidence = new SimpleElementResidence(this.entityStore, uElementResidence);
                simpleElementResidence.remove();
            }
        }
    }

    protected void removeDeploymentLocation() {
        List list = this.uComponent.getAllDeploymentLocations();
        if (list != null) {
            Object[] objectArray = list.toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                UNode uNode = (UNode)objectArray[i2];
                this.removeDeploymentLocation(uNode);
            }
        }
    }

    protected void removeImplementation() {
        List list = this.uComponent.getAllImplementations();
        if (list != null) {
            Object[] objectArray = list.toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                UArtifact uArtifact = (UArtifact)objectArray[i2];
                this.removeImplementation(uArtifact);
            }
        }
    }

    @Override
    public Map getParameters() {
        List list;
        List list2;
        Map map = super.getParameters();
        List list3 = this.uComponent.getAllImplementations();
        if (list3 != null) {
            map.put("i45", list3);
        }
        if ((list2 = this.uComponent.getAllDeploymentLocations()) != null) {
            map.put("d17", list2);
        }
        if ((list = this.uComponent.getAllResidentElements()) != null) {
            map.put("r21", list);
        }
        return map;
    }

    @Override
    public void setParameters(Map map) {
        List list = (List)map.get("d17");
        this.setParamDeploymentLocations(list);
        List list2 = (List)map.get("i45");
        this.setParamImplementations(list2);
        List list3 = (List)map.get("r21");
        this.setParamResidentElements(list3);
        super.setParameters(map);
    }

    private void setParamResidentElements(List list) {
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                UElementResidence uElementResidence = (UElementResidence)list.get(i2);
                this.addResidentElement(uElementResidence);
            }
        }
    }

    private void setParamImplementations(List list) {
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                UArtifact uArtifact = (UArtifact)list.get(i2);
                this.addImplementation(uArtifact);
            }
        }
    }

    private void setParamDeploymentLocations(List list) {
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                UNode uNode = (UNode)list.get(i2);
                this.addDeploymentLocation(uNode);
            }
        }
    }

    public void addResidentElement(UElementResidence uElementResidence) {
        EntityStore.d(this.uComponent);
        this.uComponent.addResidentElement(uElementResidence);
        EntityStore.d(uElementResidence);
        uElementResidence.setContainer(this.uComponent);
    }

    public void removeResidentElement(UElementResidence uElementResidence) {
        EntityStore.d(this.uComponent);
        this.uComponent.removeResidentElement(uElementResidence);
        EntityStore.d(uElementResidence);
        uElementResidence.setContainer(this.uComponent);
    }

    public void addImplementation(UArtifact uArtifact) {
        EntityStore.d(this.uComponent);
        this.uComponent.addImplementation(uArtifact);
        EntityStore.d(uArtifact);
        uArtifact.addImplementationLocation(this.uComponent);
    }

    public void removeImplementation(UArtifact uArtifact) {
        EntityStore.d(this.uComponent);
        this.uComponent.removeImplementation(uArtifact);
        EntityStore.d(uArtifact);
        uArtifact.removeImplementationLocation(this.uComponent);
    }

    public void addDeploymentLocation(UNode uNode) {
        EntityStore.d(this.uComponent);
        this.uComponent.addDeploymentLocation(uNode);
        EntityStore.d(uNode);
        uNode.addDeployedComponent(this.uComponent);
    }

    public void removeDeploymentLocation(UNode uNode) {
        EntityStore.d(this.uComponent);
        this.uComponent.removeDeploymentLocation(uNode);
        EntityStore.d(uNode);
        uNode.removeDeployedComponent(this.uComponent);
    }

    @Override
    public void resetMergeRelation(UElement uElement, boolean bl2, boolean bl3) {
        super.resetMergeRelation(uElement, bl2, bl3);
        if (uElement instanceof UComponent) {
            Object[] objectArray;
            UComponent uComponent = (UComponent)uElement;
            Object[] objectArray2 = uComponent.getAllImplementations().toArray();
            for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                UArtifact uArtifact = (UArtifact)objectArray2[i2];
                if (JomtUtilities.contains(this.uComponent.getAllImplementations(), uArtifact, bl2)) continue;
                objectArray = this.uComponent;
                this.setElement(uComponent);
                this.removeImplementation(uArtifact);
                this.setElement((UElement)objectArray);
                this.addImplementation(uArtifact);
            }
            Object[] objectArray3 = uComponent.getAllResidentElements().toArray();
            for (int i3 = 0; i3 < objectArray3.length; ++i3) {
                objectArray = (UElementResidence)objectArray3[i3];
                if (JomtUtilities.contains(this.uComponent.getAllResidentElements(), objectArray, bl2)) continue;
                SimpleElementResidence simpleElementResidence = (SimpleElementResidence)SimpleUmlUtil.getSimpleUml((UElement)objectArray);
                simpleElementResidence.setContainer(this.uComponent);
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.uComponent.getAllDeploymentLocations());
            objectArray = uComponent.getAllDeploymentLocations().toArray();
            for (int i4 = 0; i4 < objectArray.length; ++i4) {
                UNode uNode = (UNode)objectArray[i4];
                if (JomtUtilities.contains(arrayList, uNode, bl2)) continue;
                UComponent uComponent2 = this.uComponent;
                this.setElement(uComponent);
                this.removeDeploymentLocation(uNode);
                this.setElement(uComponent2);
                this.addDeploymentLocation(uNode);
            }
        }
    }

    @Override
    public void validate() {
        this.residentElementValidator();
        this.implementationValidator();
        this.deploymentLocationValidator();
        super.validate();
    }

    private void residentElementValidator() {
        List list = this.uComponent.getAllResidentElements();
        for (UElementResidence uElementResidence : list) {
            if (!this.entityStore.e(uElementResidence)) {
                this.entityStoreErrorMsg(uElementResidence, "residentElement");
            }
            if (this.uComponent == uElementResidence.getContainer()) continue;
            this.inverseErrorMsg(uElementResidence, "residentElement");
        }
    }

    private void implementationValidator() {
        List list = this.uComponent.getAllImplementations();
        for (UArtifact uArtifact : list) {
            if (!this.entityStore.e(uArtifact)) {
                this.entityStoreErrorMsg(uArtifact, "implementation");
            }
            if (uArtifact.getAllImplementationLocations().contains(this.uComponent)) continue;
            this.inverseErrorMsg(uArtifact, "implementation");
        }
    }

    private void deploymentLocationValidator() {
        List list = this.uComponent.getAllDeploymentLocations();
        for (UNode uNode : list) {
            if (!this.entityStore.e(uNode)) {
                this.entityStoreErrorMsg(uNode, "deploymentLocation");
            }
            if (uNode.getAllDeployedComponents().contains(this.uComponent)) continue;
            this.inverseErrorMsg(uNode, "deploymentLocation");
        }
    }
}

