/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.uml.Foundation.DataTypes;

import JP.co.esm.caddies.golf.util.UUID;
import JP.co.esm.caddies.golf.util.h;
import JP.co.esm.caddies.uml.Foundation.Core.UAssociationEnd;
import JP.co.esm.caddies.uml.Foundation.Core.UModelElement;
import JP.co.esm.caddies.uml.exception.UMLSemanticsException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class UMultiplicityRange
implements Serializable {
    static final long serialVersionUID = -7034479319225695075L;
    private String uid = null;
    private String id = UUID.a();
    private int lower = -100;
    private int upper = -100;
    private String lowerValue = "";
    private String upperValue = "";
    public static final int UNDEFINED = -100;
    public static final int UNLIMITED = -1;

    public UMultiplicityRange() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setUid(String string) {
        this.uid = string;
    }

    public String getUid() {
        return this.uid;
    }

    public UMultiplicityRange(int n2, int n3) {
        this.setRange(n2, n3);
    }

    public UMultiplicityRange(String string, String string2) {
        this.setRange(string, string2);
    }

    public UMultiplicityRange(String string, int n2) {
        this.setRange(string, n2);
    }

    public UMultiplicityRange(int n2, String string) {
        this.setRange(n2, string);
    }

    public void setRange(int n2, int n3) {
        if (n2 == -100 || n3 == -100) {
            this.setUnknown();
            return;
        }
        if (n2 == -1) {
            this.lower = -1;
            this.upper = -1;
            return;
        }
        this.setUpAndLow(n2, n3);
    }

    public void setRange(String string, String string2) {
        if (string.equals("") || string2.equals("")) {
            this.setUnknown();
            return;
        }
        this.setUpAndLow(string, string2);
    }

    public void setRange(String string, int n2) {
        if (string.equals("") || n2 == -100 || n2 < 0) {
            this.setUnknown();
            return;
        }
        this.setUpAndLow(string, n2);
    }

    public void setRange(int n2, String string) {
        if (n2 == -100 || string.equals("") || n2 == -1) {
            this.setUnknown();
            return;
        }
        this.setUpAndLow(n2, string);
    }

    public void setUpAndLow(int n2, int n3) {
        if (n3 == -1) {
            this.lower = n2;
            this.upper = n3;
            this.lowerValue = "";
            this.upperValue = "";
        } else if (n2 <= n3 && n3 >= 0) {
            this.lower = n2;
            this.upper = n3;
            this.lowerValue = "";
            this.upperValue = "";
        }
    }

    public void setUpAndLow(String string, String string2) {
        if (String.valueOf(-1).equals(string)) {
            this.setUpAndLow(-1, string2);
        } else if (String.valueOf(-1).equals(string2)) {
            this.setUpAndLow(string, -1);
        } else {
            this.lowerValue = string;
            this.upperValue = string2;
            this.lower = -100;
            this.upper = -100;
        }
    }

    public void setUpAndLow(String string, int n2) {
        if (String.valueOf(-1).equals(string)) {
            this.setUpAndLow(-1, n2);
        } else if (n2 == -1) {
            this.lowerValue = string;
            this.upper = n2;
            this.lower = -100;
            this.upperValue = "";
        } else if (n2 >= 0) {
            this.lowerValue = string;
            this.upper = n2;
            this.lower = -100;
            this.upperValue = "";
        }
    }

    public void setUpAndLow(int n2, String string) {
        if (String.valueOf(-1).equals(string)) {
            this.setUpAndLow(n2, -1);
        } else {
            this.lower = n2;
            this.upperValue = string;
            this.lowerValue = "";
            this.upper = -100;
        }
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public void setUnknown() {
        this.lower = -100;
        this.upper = -100;
        this.lowerValue = "";
        this.upperValue = "";
    }

    public boolean isUnknown() {
        return this.lower == -100 && this.upper == -100 && this.lowerValue.equals("") && this.upperValue.equals("");
    }

    public static boolean checkMultiplicityRange(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int[] nArray = UMultiplicityRange.toMultiplicityRange(string2);
            if (UMultiplicityRange.checkMultiplicityRange(nArray)) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    public static boolean isLegalIntMultiplicity(String string) {
        if ("".equals(string)) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        if (stringTokenizer.countTokens() == 0) {
            return false;
        }
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String[] stringArray = UMultiplicityRange.toStringMultiplicityRange(string2);
            if (stringArray == null) continue;
            if (stringArray.length > 0 && !UMultiplicityRange.isInteger(stringArray[0])) {
                bl2 = false;
                break;
            }
            if (stringArray.length != 2 || UMultiplicityRange.isInteger(stringArray[1])) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    private static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean checkCardinalityRange(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int[] nArray = UMultiplicityRange.toMultiplicityRange(string2);
            if (UMultiplicityRange.checkMultiplicityRange(nArray)) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    public static boolean checkMultiplicityRange(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        if (nArray.length == 1) {
            if (nArray[0] < 0) {
                return nArray[0] == -100 || nArray[0] == -1;
            }
            return true;
        }
        if (nArray.length == 2) {
            if (nArray[0] < 0) {
                return false;
            }
            if (nArray[1] == -1) {
                return true;
            }
            if (nArray[1] < 0) {
                return false;
            }
            return nArray[0] <= nArray[1];
        }
        return false;
    }

    public static boolean checkCardinalityRange(int[] nArray) {
        if (nArray == null) {
            return false;
        }
        if (nArray.length == 1) {
            if (nArray[0] < 0) {
                return nArray[0] == -100 || nArray[0] == -1;
            }
            return true;
        }
        if (nArray.length == 2) {
            if (nArray[0] < 0) {
                return false;
            }
            if (nArray[1] == -1) {
                return true;
            }
            if (nArray[1] < 1) {
                return false;
            }
            return nArray[0] <= nArray[1];
        }
        return false;
    }

    public static int[][] toMultiplicityRanges(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        int n2 = arrayList.size();
        int[][] nArray = new int[n2][2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = (String)arrayList.get(i2);
            int[] nArray2 = UMultiplicityRange.toMultiplicityRange(string3);
            nArray[i2][0] = nArray2[0];
            if (nArray2.length == 1) {
                nArray[i2][1] = nArray2[0];
                continue;
            }
            if (nArray2.length != 2) continue;
            nArray[i2][1] = nArray2[1];
        }
        return nArray;
    }

    public static String[][] toStringMultiplicityRanges(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        int n2 = arrayList.size();
        String[][] stringArray = new String[n2][2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = (String)arrayList.get(i2);
            String[] stringArray2 = UMultiplicityRange.toStringMultiplicityRange(string3);
            stringArray[i2][0] = stringArray2[0];
            if (stringArray2.length == 1) {
                stringArray[i2][1] = stringArray2[0];
                continue;
            }
            if (stringArray2.length != 2) continue;
            stringArray[i2][1] = stringArray2[1];
        }
        return stringArray;
    }

    public static int[] toMultiplicityRange(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            int[] nArray = new int[]{-100};
            return nArray;
        }
        int n3 = string.indexOf(46);
        if (n3 == -1) {
            int[] nArray = new int[1];
            if (string.equals("*")) {
                nArray[0] = -1;
                return nArray;
            }
            try {
                nArray[0] = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return nArray;
        }
        int n4 = string.lastIndexOf(46);
        if (n4 != n3 + 1) {
            return null;
        }
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n4 + 1, n2);
        int[] nArray = new int[2];
        try {
            nArray[0] = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        try {
            nArray[1] = string3.equals("*") ? -1 : Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return nArray;
    }

    public static String[] toStringMultiplicityRange(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            String[] stringArray = new String[]{""};
            return stringArray;
        }
        int n3 = string.indexOf(46);
        if (n3 == -1) {
            String[] stringArray = new String[1];
            if (string.equals("*")) {
                stringArray[0] = String.valueOf(-1);
                return stringArray;
            }
            stringArray[0] = string;
            return stringArray;
        }
        int n4 = string.lastIndexOf(46);
        if (n4 != n3 + 1) {
            String[] stringArray = new String[]{string};
            return stringArray;
        }
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n4 + 1, n2);
        String[] stringArray = new String[]{string2, string3.equals("*") ? String.valueOf(-1) : string3};
        return stringArray;
    }

    public static String toRangeString(UMultiplicityRange[] uMultiplicityRangeArray) {
        String string = "";
        for (int i2 = 0; i2 < uMultiplicityRangeArray.length; ++i2) {
            if (uMultiplicityRangeArray[i2].isUnknown()) {
                string = "";
                continue;
            }
            string = string + UMultiplicityRange.toRangeString(uMultiplicityRangeArray[i2]);
            if (i2 >= uMultiplicityRangeArray.length - 1) continue;
            string = string + " , ";
        }
        return string;
    }

    public static String toRangeString(UMultiplicityRange uMultiplicityRange) {
        if (uMultiplicityRange == null || uMultiplicityRange.isUnknown()) {
            return "";
        }
        int n2 = uMultiplicityRange.getLower();
        int n3 = uMultiplicityRange.getUpper();
        String string = uMultiplicityRange.getLowerValue();
        String string2 = uMultiplicityRange.getUpperValue();
        if (n2 == n3 && n2 != -100) {
            return UMultiplicityRange.toRangeEndString(n2);
        }
        if (string.equals(string2) && !string.equals("")) {
            return string;
        }
        String string3 = null;
        String string4 = null;
        string3 = n2 != -100 || string.equals("") ? UMultiplicityRange.toRangeEndString(n2) : string;
        string4 = n3 != -100 || string2.equals("") ? UMultiplicityRange.toRangeEndString(n3) : string2;
        return string3 + ".." + string4;
    }

    public static String toRangeEndString(int n2) {
        if (n2 == -1) {
            return "*";
        }
        return Integer.toString(n2);
    }

    public void setLowerString(String string) {
        if (string == null) {
            this.lower = -100;
        } else if (string.equals("*")) {
            this.lower = -1;
        } else if (string.equals("")) {
            this.lower = -100;
        } else {
            Integer n2 = Integer.valueOf(string);
            this.lower = n2;
        }
    }

    public void setLowerValueString(String string) {
        this.lowerValue = string == null ? "" : string;
    }

    public void setUpperString(String string) {
        if (string == null) {
            this.upper = -100;
        } else if (string.equals("*")) {
            this.upper = -1;
        } else if (string.equals("")) {
            this.upper = -100;
        } else {
            Integer n2 = Integer.valueOf(string);
            this.upper = n2;
        }
    }

    public void setUpperValueString(String string) {
        this.upperValue = string == null ? "" : string;
    }

    public boolean equals(Object object) {
        if (h.a(this).equals(h.a(object)) && object instanceof UMultiplicityRange) {
            UMultiplicityRange uMultiplicityRange = (UMultiplicityRange)object;
            return this.lower == uMultiplicityRange.getLower() && this.upper == uMultiplicityRange.getUpper() && this.lowerValue.equals(uMultiplicityRange.getLowerValue()) && this.upperValue.equals(uMultiplicityRange.getUpperValue());
        }
        return false;
    }

    public static int[][] getMultiplicityRanges(UModelElement uModelElement, Object[] objectArray) {
        int[][] nArray;
        if (uModelElement instanceof UAssociationEnd) {
            nArray = new int[1][2];
            if (objectArray.length > 2 && objectArray[2] != null) {
                nArray[0] = UMultiplicityRange.buildMultiplicityRange(objectArray[2]);
            }
        } else {
            nArray = new int[objectArray.length - 2][2];
            for (int i2 = 2; i2 < objectArray.length; ++i2) {
                nArray[i2 - 2] = UMultiplicityRange.buildMultiplicityRange(objectArray[i2]);
            }
        }
        return nArray;
    }

    public static String[][] getStringMultiplicityRanges(UModelElement uModelElement, Object[] objectArray) {
        String[][] stringArray;
        if (uModelElement instanceof UAssociationEnd) {
            stringArray = new String[1][2];
            if (objectArray.length > 2 && objectArray[2] != null) {
                stringArray[0] = UMultiplicityRange.toStringMultiplicityRange(String.valueOf(objectArray[2]));
            }
        } else {
            stringArray = new String[objectArray.length - 2][2];
            for (int i2 = 2; i2 < objectArray.length; ++i2) {
                stringArray[i2 - 2] = UMultiplicityRange.toStringMultiplicityRange(String.valueOf(objectArray[i2]));
            }
        }
        return stringArray;
    }

    public static boolean isContentsAfterParseContainsString(Object[] objectArray) {
        for (int i2 = 2; i2 < objectArray.length; ++i2) {
            if (UMultiplicityRange.isLegalIntMultiplicity(objectArray[i2].toString())) continue;
            return true;
        }
        return false;
    }

    private static int[] buildMultiplicityRange(Object object) {
        int[] nArray = new int[2];
        if (object instanceof Integer) {
            nArray[0] = (Integer)object;
            nArray[1] = (Integer)object;
        } else if (object instanceof String) {
            nArray = UMultiplicityRange.toMultiplicityRange((String)object);
        }
        return nArray;
    }

    private static void checkMultiplicityRanges(int[][] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (UMultiplicityRange.checkMultiplicityRange(nArray[i2])) continue;
            throw new UMLSemanticsException("invalid_multiplicity.message");
        }
    }

    public String getLowerValue() {
        return this.lowerValue;
    }

    public String getUpperValue() {
        return this.upperValue;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.id == null) {
            this.id = UUID.a();
        }
        if (this.lowerValue == null) {
            this.lowerValue = "";
        } else if (this.lowerValue.equals(String.valueOf(-1))) {
            this.lower = -1;
            this.lowerValue = "";
        } else if (this.lowerValue.equals(String.valueOf(-100))) {
            this.lower = -100;
            this.lowerValue = "";
        }
        if (this.upperValue == null) {
            this.upperValue = "";
        } else if (this.upperValue.equals(String.valueOf(-1))) {
            this.upper = -1;
            this.upperValue = "";
        } else if (this.upperValue.equals(String.valueOf(-100))) {
            this.upper = -100;
            this.upperValue = "";
        }
    }
}

