/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.uml.Foundation.Core;

import JP.co.esm.caddies.golf.util.h;
import JP.co.esm.caddies.uml.Foundation.Core.UElement;
import JP.co.esm.caddies.uml.Foundation.Core.UGeneralizableElement;
import JP.co.esm.caddies.uml.Foundation.Core.UGeneralization;
import JP.co.esm.caddies.uml.Foundation.Core.UModelElement;
import JP.co.esm.caddies.uml.Foundation.Core.UModelElementImp;
import JP.co.esm.caddies.uml.Foundation.Core.UNamespace;
import JP.co.esm.caddies.uml.Foundation.ExtensionMechanisms.UStereotype;
import JP.co.esm.caddies.uml.exception.UMLSemanticsException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class UGeneralizableElementImp
extends UModelElementImp
implements UGeneralizableElement {
    static final long serialVersionUID = -8478109097398358714L;
    protected boolean root = false;
    protected boolean leaf = false;
    protected boolean abst = false;
    protected List generalization = new ArrayList(0);
    protected List specialization = new ArrayList(0);

    @Override
    public boolean isRoot() {
        return this.root;
    }

    @Override
    public void setRoot(boolean bl2) {
        this.root = bl2;
        this.setChanged();
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    @Override
    public void setLeaf(boolean bl2) {
        this.leaf = bl2;
        this.setChanged();
    }

    @Override
    public boolean isAbstract() {
        return this.abst;
    }

    @Override
    public void setAbstract(boolean bl2) {
        this.abst = bl2;
        this.setChanged();
    }

    @Override
    public List getGeneralizations() {
        return this.generalization;
    }

    @Override
    public void addGeneralization(UGeneralization uGeneralization) {
        this.generalization.add(uGeneralization);
        this.setChanged();
    }

    @Override
    public void removeGeneralization(UGeneralization uGeneralization) {
        this.generalization.remove(uGeneralization);
        this.setChanged();
    }

    @Override
    public void removeAllGeneralizations() {
        this.generalization.clear();
        this.setChanged();
    }

    @Override
    public List getSpecializations() {
        return this.specialization;
    }

    @Override
    public void addSpecialization(UGeneralization uGeneralization) {
        this.specialization.add(uGeneralization);
        this.setChanged();
    }

    @Override
    public void removeSpecialization(UGeneralization uGeneralization) {
        this.specialization.remove(uGeneralization);
        this.setChanged();
    }

    @Override
    public void removeAllSpecializations() {
        this.specialization.clear();
        this.setChanged();
    }

    @Override
    public List getXMISubset() {
        List list = super.getXMISubset();
        list.addAll(this.generalization);
        list.addAll(this.specialization);
        List list2 = this.getGeneralizationConstraints(this.generalization);
        list.addAll(list2);
        List list3 = this.getGeneralizationConstraints(this.specialization);
        list.addAll(list3);
        return list;
    }

    private List getGeneralizationConstraints(List list) {
        ArrayList arrayList = new ArrayList();
        for (UGeneralization uGeneralization : list) {
            List list2 = uGeneralization.getConstraints();
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    @Override
    public void ensureWellFormed() {
        this.ensureRoot();
        this.ensureLeaf();
        this.ensureNotRoop();
        this.ensurehasMultiGeneralizations();
        super.ensureWellFormed();
    }

    public void ensureRoot() {
        String string = "GeneralizableElement:RootError";
        if (this.root && this.generalization.size() != 0) {
            throw new UMLSemanticsException(string);
        }
    }

    public void ensureLeaf() {
        String string = "GeneralizableElement:LeafError";
        if (this.leaf && this.specialization.size() != 0) {
            throw new UMLSemanticsException(string);
        }
    }

    protected void ensureNotRoop() {
        String string = "GeneralizableElement:RoopError";
        if (this.isLoop(this)) {
            throw new UMLSemanticsException(string);
        }
    }

    public void ensurehasMultiGeneralizations() {
        ArrayList<UGeneralizableElement> arrayList = new ArrayList<UGeneralizableElement>();
        if (this.generalization.size() >= 2) {
            for (int i2 = 0; i2 < this.generalization.size(); ++i2) {
                UGeneralization uGeneralization = (UGeneralization)this.generalization.get(i2);
                UGeneralizableElement uGeneralizableElement = uGeneralization.getSupertype();
                List list = uGeneralizableElement.getStereotypes();
                boolean bl2 = false;
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    UStereotype uStereotype = (UStereotype)list.get(i3);
                    String string = uStereotype.getName().getName();
                    if (!string.equals("interface")) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    arrayList.add(uGeneralizableElement);
                }
                if (arrayList.size() < 2) continue;
                String string = "GeneralizableElement:MultiInheritance";
                throw new UMLSemanticsException(string);
            }
        }
    }

    @Override
    public boolean isLoop(UGeneralizableElement uGeneralizableElement) {
        for (int i2 = 0; i2 < this.generalization.size(); ++i2) {
            UGeneralization uGeneralization = (UGeneralization)this.generalization.get(i2);
            UGeneralizableElement uGeneralizableElement2 = uGeneralization.getSupertype();
            if (uGeneralizableElement2.equals(uGeneralizableElement)) {
                return true;
            }
            if (!uGeneralizableElement2.isLoop(uGeneralizableElement)) continue;
            return true;
        }
        return false;
    }

    protected void ensureGeneralizationNamespace() {
        UNamespace uNamespace = this.getNamespaceOwnership().getNamespace();
        for (int i2 = 0; i2 < this.generalization.size(); ++i2) {
            UGeneralization uGeneralization = (UGeneralization)this.generalization.get(i2);
            UNamespace uNamespace2 = uGeneralization.getNamespaceOwnership().getNamespace();
            String string = "semantics_error.message";
            if (uNamespace.equals(uNamespace2)) continue;
            throw new UMLSemanticsException(string);
        }
    }

    @Override
    public void storeState(Hashtable hashtable) {
        super.storeState(hashtable);
        hashtable.put("r2", this.root);
        hashtable.put("l0", this.leaf);
        hashtable.put("a0", this.abst);
        if (this.generalization != null) {
            hashtable.put("g0", h.a(this.generalization));
        }
        if (this.specialization != null) {
            hashtable.put("s0", h.a(this.specialization));
        }
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        List list;
        List list2;
        Boolean bl2;
        Boolean bl3;
        Boolean bl4 = (Boolean)hashtable.get("r2");
        if (bl4 != null) {
            this.root = bl4;
        }
        if ((bl3 = (Boolean)hashtable.get("l0")) != null) {
            this.leaf = bl3;
        }
        if ((bl2 = (Boolean)hashtable.get("a0")) != null) {
            this.abst = bl2;
        }
        if ((list2 = (List)hashtable.get("g0")) != null) {
            this.generalization = h.a(list2);
        }
        if ((list = (List)hashtable.get("s0")) != null) {
            this.specialization = h.a(list);
        }
        super.restoreState(hashtable);
    }

    @Override
    public Object clone() {
        UGeneralizableElementImp uGeneralizableElementImp = (UGeneralizableElementImp)super.clone();
        uGeneralizableElementImp.abst = this.abst;
        uGeneralizableElementImp.root = this.root;
        uGeneralizableElementImp.leaf = this.leaf;
        uGeneralizableElementImp.generalization = h.a(this.generalization);
        uGeneralizableElementImp.specialization = h.a(this.specialization);
        return uGeneralizableElementImp;
    }

    @Override
    public boolean attributesEqual(UElement uElement) {
        if (super.attributesEqual(uElement)) {
            if (!this.visibilityEqual((UModelElement)uElement)) {
                return false;
            }
            UGeneralizableElement uGeneralizableElement = (UGeneralizableElement)uElement;
            return this.abst == uGeneralizableElement.isAbstract() && this.leaf == uGeneralizableElement.isLeaf() && this.root == uGeneralizableElement.isRoot();
        }
        return false;
    }

    @Override
    public List getSurviveTogetherElements(boolean bl2, List list) {
        super.getSurviveTogetherElements(bl2, list);
        ArrayList<List> arrayList = new ArrayList<List>();
        if (!bl2) {
            arrayList.add(this.specialization);
            arrayList.add(this.generalization);
        }
        this.addSubElementsIntoSurviveTogetherElements(bl2, list, arrayList);
        return list;
    }

    @Override
    public void copyAttributes(UElement uElement) {
        super.copyAttributes(uElement);
        UGeneralizableElement uGeneralizableElement = (UGeneralizableElement)uElement;
        this.root = uGeneralizableElement.isRoot();
        this.abst = uGeneralizableElement.isAbstract();
        this.leaf = uGeneralizableElement.isLeaf();
    }

    @Override
    public List getMergeSubset() {
        List list = super.getMergeSubset();
        list.addAll(this.specialization);
        return list;
    }
}

