/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jview.initialOperation.javafx;

import JP.co.esm.caddies.jomt.jview.initialOperation.javafx.InitialOperationController;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialOperationApplication
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(InitialOperationApplication.class);
    private ClassLoader classLoader;
    private InitialOperationController controller;
    private String initialOperationPath;

    public InitialOperationApplication() {
        this.initialOperationPath = "JP/co/esm/caddies/jomt/jview/initialOperation/javafx/initialOperation_P.fxml";
    }

    public InitialOperationApplication(String string) {
        this.initialOperationPath = string;
    }

    public void start(Stage stage) throws Exception {
        logger.debug(String.format("JavaFX version : %s", System.getProperty("javafx.version")));
        stage.setScene(this.createScene());
        stage.show();
    }

    public Scene createScene() {
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        if (null != this.classLoader) {
            classLoader = this.classLoader;
        }
        URL uRL = classLoader.getResource(this.initialOperationPath);
        FXMLLoader fXMLLoader = new FXMLLoader(uRL, ResourceBundle.getBundle("JP/co/esm/caddies/jomt/jview/initialOperation/javafx/fx_init_operation"));
        fXMLLoader.setClassLoader(classLoader);
        fXMLLoader.setLocation(uRL);
        InputStream inputStream = null;
        try {
            fXMLLoader.load();
            this.controller = (InitialOperationController)fXMLLoader.getController();
            this.controller.updateProjectImages();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
        Parent parent = (Parent)fXMLLoader.getRoot();
        Scene scene = new Scene(parent);
        return scene;
    }

    public InitialOperationController getController() {
        return this.controller;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

