/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jutil;

import JP.co.esm.caddies.golf.model.EntityStore;
import JP.co.esm.caddies.golf.model.l;
import JP.co.esm.caddies.golf.util.h;
import JP.co.esm.caddies.jomt.jcontrol.R;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.JomtReadOnlyElementRule;
import JP.co.esm.caddies.jomt.jmodel.ModelManageInfo;
import JP.co.esm.caddies.jomt.jmodel.Project;
import JP.co.esm.caddies.jomt.jmodel.q;
import JP.co.esm.caddies.jomt.jsystem.a;
import JP.co.esm.caddies.jomt.jsystem.c;
import JP.co.esm.caddies.jomt.jsystem.i;
import JP.co.esm.caddies.jomt.jutil.JomtUtilities;
import JP.co.esm.caddies.uml.Foundation.ExtensionMechanisms.UTaggedValue;
import JP.co.esm.caddies.uml.ModelManagement.UModel;
import JP.co.esm.caddies.uml.SimpleUML.SimpleModelElement;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferModelUtil {
    public static final String RELATIVE_PRJ_DIR = "0";
    public static final String RELATIVE_WORK_DIR = "1";
    private static final Logger logger = LoggerFactory.getLogger(ReferModelUtil.class);
    private static final String STATE_LATEST = ReferModelUtil.getTitle("ui.table.header.refered_models_state.latest.label");
    private static final String STATE_NEED_UPDATE = ReferModelUtil.getTitle("ui.table.header.refered_models_state.update.label");
    private static final String STATE_NOT_FOUND = ReferModelUtil.getTitle("ui.table.header.refered_models_state.delete.label");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    public static boolean isAbsoluteFilePath(String string) {
        return new File(string).isAbsolute();
    }

    public static boolean isRelativeFilePath(String string) {
        return !new File(string).isAbsolute();
    }

    public static boolean isValidFilePath(String string) {
        if (!ReferModelUtil.isAbsoluteFilePath(string)) {
            string = ReferModelUtil.convertRelativeToAbsolute(string);
        }
        return new File(string).isFile();
    }

    public static String convertAbsoluteToRelative(String string) {
        String string2 = ReferModelUtil.getCurrentRelativeDir();
        if (string2 == null) {
            return string;
        }
        if (string.charAt(0) != string2.charAt(0)) {
            return string;
        }
        String string3 = ReferModelUtil.getRelativePath(new File(string2), new File(string));
        string3 = JomtUtilities.convertForAllOsString(string3);
        return string3;
    }

    public static String convertRelativeToAbsolute(String string) {
        if (ReferModelUtil.isAbsoluteFilePath(string)) {
            return string;
        }
        String string2 = ReferModelUtil.getCurrentRelativeDir();
        if (string2 == null) {
            return string;
        }
        String string3 = ReferModelUtil.getAbsolutePath(new File(string2), string);
        string3 = JomtUtilities.convertForAllOsString(string3);
        return string3;
    }

    public static String getCurrentRelativeDir() {
        if (c.m.k("readonly_merge.relative_path_type.selected").equals(RELATIVE_PRJ_DIR)) {
            Project project = c.g.p();
            if ("no_title".equals(project.doc.n())) {
                return i.s();
            }
            return new File(project.doc.n()).getParent();
        }
        return ReferModelUtil.getCurrentWorkDir();
    }

    public static String getDetailedCurrentRelativeDir() {
        if (c.m.k("readonly_merge.relative_path_type.selected").equals(RELATIVE_PRJ_DIR)) {
            Project project = c.g.p();
            if ("no_title".equals(project.doc.n())) {
                return ReferModelUtil.getTitle("ui.add_file_dialog.text.relative_path_unusable.label");
            }
            return new File(project.doc.n()).getParent();
        }
        return ReferModelUtil.getCurrentWorkDir();
    }

    public static String getCurrentWorkDir() {
        String string = c.m.k("readonly_merge.user_work_dir");
        if (string.equals("")) {
            string = i.s();
        }
        return string;
    }

    public static String getRelativePath(File file, File file2) {
        List list = ReferModelUtil.getPathList(file);
        List list2 = ReferModelUtil.getPathList(file2);
        String string = ReferModelUtil.matchPathLists(list, list2);
        return string;
    }

    public static File checkAbsolutePath(String string) {
        String string2 = string;
        if (ReferModelUtil.isRelativeFilePath(string)) {
            string2 = ReferModelUtil.convertRelativeToAbsolute(string);
        }
        File file = new File(string2);
        return file;
    }

    public static String getAbsolutePath(File file, String string) {
        int n2;
        int n3 = 0;
        String[] stringArray = string.split("/");
        for (n2 = 0; n2 < stringArray.length && stringArray[n2].equals(".."); ++n2) {
            ++n3;
        }
        for (n2 = n3; n2 > 0; --n2) {
            if ((file = file.getParentFile()) != null) continue;
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(file.getAbsolutePath());
        if (stringBuilder.charAt(stringBuilder.length() - 1) == '\\') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        for (int i2 = n3; i2 < stringArray.length; ++i2) {
            stringBuilder.append(File.separator);
            stringBuilder.append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }

    private static List getPathList(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (File file2 = file.getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
                arrayList.add(file2.getName());
            }
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
            arrayList = null;
        }
        return arrayList;
    }

    private static String matchPathLists(List list, List list2) {
        int n2;
        String string = "";
        int n3 = list.size() - 1;
        for (n2 = list2.size() - 1; n3 >= 0 && n2 >= 0 && list.get(n3).equals(list2.get(n2)); --n3, --n2) {
        }
        while (n3 >= 0) {
            string = string + ".." + File.separator;
            --n3;
        }
        while (n2 >= 1) {
            string = string + list2.get(n2) + File.separator;
            --n2;
        }
        string = string + list2.get(n2);
        return string;
    }

    private static String getTitle(String string) {
        String string2 = i.h().a(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static int getReferFileNumber() {
        UModel uModel = q.a();
        return ReferModelUtil.getReferFileNumber(uModel);
    }

    public static int getRefprojectReferFileNumber(EntityStore entityStore) {
        UModel uModel = q.b(entityStore);
        return ReferModelUtil.getReferFileNumber(uModel);
    }

    public static int getReferFileNumber(UModel uModel) {
        UTaggedValue uTaggedValue = SimpleModelElement.getTaggedValue(uModel, "jude.ref_prj.num");
        if (uTaggedValue != null && uTaggedValue.getValue() != null) {
            String string = uTaggedValue.getValue().getBody();
            return Integer.parseInt(string);
        }
        return 0;
    }

    public static String[] getAllReferedFilePaths() {
        return ReferModelUtil.getAllReferedFilePaths(q.a());
    }

    public static String[] getAllReferedAbsoluteFilePaths() {
        String[] stringArray = ReferModelUtil.getAllReferedFilePaths(q.a());
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = ReferModelUtil.convertRelativeToAbsolute(stringArray[i2]);
        }
        return stringArray;
    }

    public static String[] getAllReferedFilePaths(UModel uModel) {
        String[] stringArray = new String[ReferModelUtil.getReferFileNumber(uModel)];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string;
            UTaggedValue uTaggedValue = SimpleModelElement.getTaggedValue(uModel, "jude.ref_prj.path." + i2);
            stringArray[i2] = string = uTaggedValue.getValue().getBody();
        }
        return stringArray;
    }

    public static boolean isOldVersionReadOnlyData(EntityStore entityStore) {
        UTaggedValue uTaggedValue = SimpleModelElement.getTaggedValue(q.b(entityStore), "jude.referenceModels");
        return uTaggedValue != null;
    }

    public static boolean isNewVersionReadOnlyData(EntityStore entityStore) {
        UTaggedValue uTaggedValue = SimpleModelElement.getTaggedValue(q.b(entityStore), "jude.ref_prj.num");
        if (uTaggedValue == null) {
            return false;
        }
        String string = uTaggedValue.getValue().getBody();
        int n2 = Integer.valueOf(string);
        return n2 > 0;
    }

    public static String getMergedTimeStamp(int n2) {
        String string = ReferModelUtil.getMergedTime(n2);
        if (string == null || string.equals(RELATIVE_PRJ_DIR)) {
            return "-";
        }
        return ReferModelUtil.getTimeStamp(Long.parseLong(string));
    }

    public static long getMergedTimeStampValue(int n2) {
        String string = ReferModelUtil.getMergedTime(n2);
        if (string == null || string.equals(RELATIVE_PRJ_DIR)) {
            return 0L;
        }
        return Long.parseLong(string);
    }

    private static String getMergedTime(int n2) {
        UModel uModel = q.a();
        UTaggedValue uTaggedValue = SimpleModelElement.getTaggedValue(uModel, "jude.ref_prj.timestamp." + n2);
        if (uTaggedValue == null || uTaggedValue.getValue() == null) {
            return null;
        }
        return uTaggedValue.getValue().getBody();
    }

    public static String getFileTimeStamp(String string) {
        File file = ReferModelUtil.checkAbsolutePath(string);
        long l2 = file.lastModified();
        return ReferModelUtil.getTimeStamp(l2);
    }

    public static String getProjectTimeStamp(String string, boolean bl2) {
        return ReferModelUtil.getTimeStamp(ReferModelUtil.getProjectTimeStampValue(string, bl2));
    }

    public static long getProjectTimeStampValue(String string, boolean bl2) {
        Object object;
        String string2 = ReferModelUtil.convertRelativeToAbsolute(string);
        long l2 = 0L;
        if (bl2) {
            object = new JomtEntityStore();
            ((EntityStore)object).a(false);
            try {
                Object object2 = ((EntityStore)object).g(string2);
                if (object2 instanceof ModelManageInfo) {
                    l2 = ((ModelManageInfo)object2).getLastModifiedTime();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (l2 == 0L) {
            object = ReferModelUtil.checkAbsolutePath(string);
            l2 = ((File)object).lastModified();
        }
        return l2;
    }

    public static String getTimeStamp(long l2) {
        String string = "";
        if (l2 == 0L) {
            string = "-";
        } else {
            Date date = new Date(l2);
            string = DATE_FORMAT.format(date);
        }
        return string;
    }

    public static String getFileState(String string, String string2) {
        String string3 = STATE_LATEST;
        string3 = string2.equals("-") ? STATE_NOT_FOUND : (!string.equals(string2) ? STATE_NEED_UPDATE : STATE_LATEST);
        return string3;
    }

    public static int getFileStateForAPI(String string, String string2) {
        int n2 = 0;
        n2 = string2.equals("-") ? -1 : (!string.equals(string2) ? 1 : 0);
        return n2;
    }

    public static int getReferedFilePathIndex(String string) {
        String string2 = JomtUtilities.convertForAllOsString(ReferModelUtil.convertRelativeToAbsolute(string));
        for (int i2 = 0; i2 < ReferModelUtil.getReferFileNumber(); ++i2) {
            String string3;
            String string4;
            UModel uModel = q.a();
            UTaggedValue uTaggedValue = SimpleModelElement.getTaggedValue(uModel, "jude.ref_prj.path." + i2);
            if (uTaggedValue == null || !(string4 = JomtUtilities.convertForAllOsString(ReferModelUtil.convertRelativeToAbsolute(string3 = uTaggedValue.getValue().getBody()))).equals(string2)) continue;
            return i2;
        }
        return -1;
    }

    public static String findRefPrjPathByElement(String string) {
        UModel uModel = q.a();
        for (int i2 = 0; i2 < ReferModelUtil.getReferFileNumber(); ++i2) {
            UTaggedValue uTaggedValue = SimpleModelElement.getTaggedValue(uModel, "jude.ref_prj.models." + i2);
            if (uTaggedValue == null || uTaggedValue.getValue() == null || uTaggedValue.getValue().getBody() == null) {
                return null;
            }
            Set set = h.b(uTaggedValue.getValue().getBody(), ",");
            if (!set.contains(string)) continue;
            UTaggedValue uTaggedValue2 = SimpleModelElement.getTaggedValue(uModel, "jude.ref_prj.path." + i2);
            return uTaggedValue2.getValue().getBody();
        }
        return null;
    }

    public static boolean canSetReadOnly(EntityStore entityStore, l l2) {
        return !(l2 instanceof UTaggedValue) || ((UTaggedValue)l2).getInvTaggedValue() != q.b(entityStore);
    }

    public static boolean canCleartReadOnly(l l2) {
        return l2.isReadOnly();
    }

    public static void setupReadOnlyFrameworkIfNeed() {
        if (ReferModelUtil.getReferFileNumber() > 0 && a.a() && EntityStore.u() == null) {
            EntityStore.a(new JomtReadOnlyElementRule());
            EntityStore.a(new R());
        }
    }
}

