/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.geom2D.Rectangle2d;
import JP.co.esm.caddies.golf.geom2D.Vec2d;
import JP.co.esm.caddies.jomt.jmodel.ILabelPresentation;
import JP.co.esm.caddies.jomt.jmodel.IMessagePresentation;
import JP.co.esm.caddies.jomt.jmodel.ITimeConstraintPresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.JomtPresentation;
import JP.co.esm.caddies.jomt.jmodel.LabelPresentation;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UTimeConstraint;
import JP.co.esm.caddies.uml.Foundation.Core.IUPresentation;
import JP.co.esm.caddies.uml.Foundation.Core.UConstraint;
import JP.co.esm.caddies.uml.Foundation.Core.UPresentation;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;

public class TimeConstraintPresentation
extends JomtPresentation
implements ITimeConstraintPresentation {
    private static final long serialVersionUID = -4784507608311155492L;
    private Pnt2d[] points = new Pnt2d[2];
    private ILabelPresentation namePresentation = new LabelPresentation();

    public TimeConstraintPresentation() {
        this.namePresentation.setCompositeParent(this);
        this.updateNamePresentation();
    }

    @Override
    public Pnt2d[] getPoints() {
        return this.points;
    }

    @Override
    public void setPoints(Pnt2d[] pnt2dArray) {
        this.points = pnt2dArray;
    }

    @Override
    public void update(Observable observable, Object object) {
        this.updateLinePoints();
        this.updateNamePresentation();
        super.update(observable, null);
    }

    private void updateLinePoints() {
        IMessagePresentation iMessagePresentation = this.getMessagePresentation();
        if (iMessagePresentation != null) {
            Pnt2d pnt2d;
            this.setChanged();
            this.points[0] = pnt2d = iMessagePresentation.getTargetEndPnt();
            double d2 = pnt2d.getX() + (double)(this.isMessageFromLeftToRight() ? 30 : -30);
            this.points[1] = new Pnt2d(d2, pnt2d.getY());
        }
    }

    private boolean isMessageFromLeftToRight() {
        IMessagePresentation iMessagePresentation = this.getMessagePresentation();
        if (iMessagePresentation != null) {
            this.setChanged();
            Pnt2d pnt2d = iMessagePresentation.getSourceEndPnt();
            Pnt2d pnt2d2 = iMessagePresentation.getTargetEndPnt();
            return pnt2d.getX() < pnt2d2.getX();
        }
        return true;
    }

    private IMessagePresentation getMessagePresentation() {
        IUPresentation iUPresentation = this.getServer(0);
        if (iUPresentation instanceof IMessagePresentation) {
            return (IMessagePresentation)iUPresentation;
        }
        return null;
    }

    @Override
    public void move(Vec2d vec2d) {
        super.move(vec2d);
        this.updateNamePresentation();
    }

    @Override
    public ILabelPresentation getNamePresentation() {
        return this.namePresentation;
    }

    @Override
    public void setNamePresentation(ILabelPresentation iLabelPresentation) {
        this.setChanged();
        if (this.namePresentation != null) {
            this.namePresentation.setCompositeParent(null);
        }
        this.namePresentation = iLabelPresentation;
        this.namePresentation.setCompositeParent(this);
    }

    public void updateNamePresentation() {
        Cloneable cloneable;
        if (this.namePresentation == null) {
            return;
        }
        this.setChanged();
        String string = "";
        if (this.model instanceof UTimeConstraint) {
            cloneable = (UTimeConstraint)this.model;
            string = cloneable.getBody().getBody().getBody();
        }
        this.namePresentation.setLabel(String.format("{%s}", string));
        this.namePresentation.resize();
        cloneable = this.getDefaultNamePnt();
        if (cloneable != null) {
            this.namePresentation.setLocation((Pnt2d)cloneable);
        }
    }

    public Pnt2d getDefaultNamePnt() {
        Pnt2d pnt2d = this.points[1];
        if (pnt2d != null) {
            double d2 = pnt2d.getX();
            if (!this.isMessageFromLeftToRight()) {
                d2 -= this.namePresentation.getWidth();
            }
            return new Pnt2d(d2, pnt2d.getY() - this.namePresentation.getHeight() / 2.0);
        }
        return null;
    }

    @Override
    public void storeState(Hashtable hashtable) {
        if (this.points != null) {
            Pnt2d[] pnt2dArray = new Pnt2d[this.points.length];
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                if (this.points[i2] == null) continue;
                pnt2dArray[i2] = new Pnt2d(this.points[i2]);
            }
            hashtable.put("points", pnt2dArray);
        }
        if (this.namePresentation != null) {
            hashtable.put("namePresentation", ((LabelPresentation)this.namePresentation).clone());
        }
        super.storeState(hashtable);
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        this.setChanged();
        Object v2 = hashtable.get("points");
        if (v2 != null) {
            Pnt2d[] pnt2dArray = (Pnt2d[])v2;
            this.points = new Pnt2d[pnt2dArray.length];
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                if (pnt2dArray[i2] == null) continue;
                this.points[i2] = new Pnt2d(pnt2dArray[i2]);
            }
        }
        if ((v2 = hashtable.get("namePresentation")) != null) {
            this.namePresentation = (ILabelPresentation)v2;
            this.namePresentation.setCompositeParent(this);
        }
        super.restoreState(hashtable);
    }

    @Override
    public boolean attributesEqual(UPresentation uPresentation) {
        LabelPresentation labelPresentation;
        if (!(uPresentation instanceof TimeConstraintPresentation)) {
            return false;
        }
        TimeConstraintPresentation timeConstraintPresentation = (TimeConstraintPresentation)uPresentation;
        if (timeConstraintPresentation.points.length == this.points.length) {
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                if (timeConstraintPresentation.points[i2].equals(this.points[i2])) continue;
                return false;
            }
        } else {
            return false;
        }
        LabelPresentation labelPresentation2 = (LabelPresentation)this.getNamePresentation();
        if (!this.attributeEquals(labelPresentation2, labelPresentation = (LabelPresentation)timeConstraintPresentation.getNamePresentation())) {
            return false;
        }
        return super.attributesEqual(timeConstraintPresentation);
    }

    private boolean attributeEquals(LabelPresentation labelPresentation, LabelPresentation labelPresentation2) {
        if (labelPresentation == null && labelPresentation2 != null) {
            return false;
        }
        return labelPresentation.attributesEqual(labelPresentation2);
    }

    @Override
    public Object clone() {
        TimeConstraintPresentation timeConstraintPresentation = (TimeConstraintPresentation)super.clone();
        if (this.namePresentation != null) {
            timeConstraintPresentation.namePresentation = null;
            timeConstraintPresentation.setNamePresentation((ILabelPresentation)((LabelPresentation)this.namePresentation).clone());
            timeConstraintPresentation.namePresentation.removeAllClients();
        }
        Pnt2d[] pnt2dArray = new Pnt2d[this.points.length];
        for (int i2 = 0; i2 < this.points.length; ++i2) {
            pnt2dArray[i2] = new Pnt2d(this.points[i2]);
        }
        timeConstraintPresentation.setPoints(pnt2dArray);
        return timeConstraintPresentation;
    }

    @Override
    public Rectangle2d getBoundsRect() {
        Rectangle2d rectangle2d = super.getBoundsRect();
        if (this.points != null) {
            for (Pnt2d pnt2d : this.points) {
                rectangle2d.add(pnt2d);
            }
        }
        if (this.namePresentation != null) {
            if (rectangle2d.isEmpty()) {
                rectangle2d.setRect(this.namePresentation.getBoundsRect());
            } else {
                rectangle2d.add(this.namePresentation.getBoundsRect());
            }
        }
        return rectangle2d;
    }

    @Override
    public void validate(JomtEntityStore jomtEntityStore) {
        if (this.getServerNum() != 1) {
            this.sizeErrorMsg(this.getServers(), "servers should be one");
        } else if (!(this.getServer(0) instanceof IMessagePresentation)) {
            this.errorMsg(this, "servers should be Messages");
        } else {
            IMessagePresentation iMessagePresentation = (IMessagePresentation)this.getServer(0);
            List list = ((UConstraint)this.getModel()).getConstrainedElements();
            if (list.size() != 1 || iMessagePresentation.getMessage() != list.get(0)) {
                this.errorMsg(this, "server presentation's model is NG");
            }
        }
        super.validate(jomtEntityStore);
    }
}

