/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Vec2d;
import JP.co.esm.caddies.jomt.jmodel.IActivationPresentation;
import JP.co.esm.caddies.jomt.jmodel.IClassifierRolePresentation;
import JP.co.esm.caddies.jomt.jmodel.ITerminationPresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.RectPresentation;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UMessage;
import JP.co.esm.caddies.uml.Foundation.Core.UDiagram;
import JP.co.esm.caddies.uml.Foundation.Core.UModelElement;
import JP.co.esm.caddies.uml.Foundation.Core.UPresentation;
import java.util.Hashtable;
import java.util.List;

public class TerminationPresentation
extends RectPresentation
implements ITerminationPresentation {
    static final long serialVersionUID = 6563353271834085938L;
    public static final double WIDTH = 20.0;
    public static final double HEIGHT = 20.0;
    private IActivationPresentation relatedAp = null;

    @Override
    public IActivationPresentation getRelatedAp() {
        return this.relatedAp;
    }

    @Override
    public void setRelatedAp(IActivationPresentation iActivationPresentation) {
        this.relatedAp = iActivationPresentation;
    }

    @Override
    public boolean isValidModel(UModelElement uModelElement) {
        return uModelElement instanceof UMessage && super.isValidModel(uModelElement);
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public double getMinWidth() {
        return 20.0;
    }

    @Override
    public double getMinHeight() {
        return 20.0;
    }

    @Override
    public double getDefaultWidth() {
        return 20.0;
    }

    @Override
    public double getDefaultHeight() {
        return 20.0;
    }

    @Override
    public IClassifierRolePresentation getFather() {
        return (IClassifierRolePresentation)this.getServer(0);
    }

    @Override
    public void move(Vec2d vec2d) {
        Vec2d vec2d2 = new Vec2d(vec2d);
        if (this.relatedAp != null) {
            vec2d2.y = 0.0;
        }
        super.move(this.adjustMoveVector(vec2d2));
        this.adjustLifeline();
    }

    private Vec2d adjustMoveVector(Vec2d vec2d) {
        IClassifierRolePresentation iClassifierRolePresentation = this.getFather();
        double d2 = iClassifierRolePresentation.getLifelineLocY() + iClassifierRolePresentation.getLifelineMinLength() - (this.getMinY() + this.getHeight() / 2.0);
        if (this.relatedAp != null) {
            d2 = 0.0;
        }
        double d3 = iClassifierRolePresentation.getLifelineLocX() - this.getLocation().x - this.getWidth() / 2.0;
        double d4 = Math.max(d2, vec2d.y);
        Vec2d vec2d2 = new Vec2d(d3, d4);
        return vec2d2;
    }

    @Override
    public void adjustLifeline() {
        IClassifierRolePresentation iClassifierRolePresentation = this.getFather();
        double d2 = this.getMinY() + this.getHeight() / 2.0 - iClassifierRolePresentation.getLifelineLocY();
        iClassifierRolePresentation.setLifelineLength(d2);
    }

    @Override
    public void storeState(Hashtable hashtable) {
        if (this.relatedAp != null) {
            hashtable.put("relatedAp", this.relatedAp);
            hashtable.put("IS_relatedAp_EXISTS", Boolean.TRUE);
        } else {
            hashtable.put("IS_relatedAp_EXISTS", Boolean.FALSE);
        }
        super.storeState(hashtable);
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        super.restoreState(hashtable);
        IActivationPresentation iActivationPresentation = (IActivationPresentation)hashtable.get("relatedAp");
        if (iActivationPresentation != null) {
            this.relatedAp = iActivationPresentation;
        }
        if (hashtable.get("IS_relatedAp_EXISTS") != null && !((Boolean)hashtable.get("IS_relatedAp_EXISTS")).booleanValue()) {
            this.relatedAp = null;
        }
    }

    @Override
    public Object clone() {
        ITerminationPresentation iTerminationPresentation = (ITerminationPresentation)super.clone();
        return iTerminationPresentation;
    }

    @Override
    public void validate(JomtEntityStore jomtEntityStore) {
        this.validateDiagram(jomtEntityStore);
        this.validateServer(jomtEntityStore);
        this.validateRelatedAp(jomtEntityStore);
        super.validate(jomtEntityStore);
    }

    private void validateDiagram(JomtEntityStore jomtEntityStore) {
        UDiagram uDiagram = this.getDiagram();
        if (uDiagram == null) {
            this.nullErrorMsg(this, "diagram");
            return;
        }
        if (uDiagram != null) {
            List list;
            if (!jomtEntityStore.e(uDiagram)) {
                this.entityErrorMsg(this, "diagram");
            }
            if (!(list = uDiagram.getPresentations()).contains(this)) {
                this.inverseErrorMsg(this, "diagram");
            }
        }
    }

    private void validateServer(JomtEntityStore jomtEntityStore) {
        List list = this.getServers();
        for (UPresentation uPresentation : list) {
            if (jomtEntityStore.e(uPresentation)) continue;
            this.entityErrorMsg(this, "server");
        }
    }

    private void validateRelatedAp(JomtEntityStore jomtEntityStore) {
        IActivationPresentation iActivationPresentation = this.getRelatedAp();
        if (iActivationPresentation != null) {
            UMessage uMessage;
            if (!jomtEntityStore.e(iActivationPresentation)) {
                this.entityErrorMsg(this, "relatedAp");
            }
            if ((uMessage = iActivationPresentation.getActivator()) == null) {
                this.nullErrorMsg(this, "terminationActivator");
                return;
            }
            List list = uMessage.getPresentations();
            if (!list.contains(this)) {
                this.inverseErrorMsg(this, "relatedAp");
            }
        }
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        return false;
    }
}

