/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.geom2D.Rectangle2d;
import JP.co.esm.caddies.golf.geom2D.Vec2d;
import JP.co.esm.caddies.golf.model.EntityStore;
import JP.co.esm.caddies.jomt.jmodel.H;
import JP.co.esm.caddies.jomt.jmodel.IJomtPresentation;
import JP.co.esm.caddies.jomt.jmodel.IObjectFlowStatePresentation;
import JP.co.esm.caddies.jomt.jmodel.IPinPresentation;
import JP.co.esm.caddies.jomt.jmodel.IRectPresentation;
import JP.co.esm.caddies.jomt.jmodel.ISwimlanePresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.JomtPresentation;
import JP.co.esm.caddies.jomt.jmodel.LabelPresentation;
import JP.co.esm.caddies.jomt.jmodel.PresentationUtil;
import JP.co.esm.caddies.jomt.jmodel.RectPresentation;
import JP.co.esm.caddies.jomt.jutil.y;
import JP.co.esm.caddies.uml.BehavioralElements.ActivityGraphs.UActivityDiagram;
import JP.co.esm.caddies.uml.BehavioralElements.ActivityGraphs.UObjectFlowState;
import JP.co.esm.caddies.uml.BehavioralElements.ActivityGraphs.UPartition;
import JP.co.esm.caddies.uml.BehavioralElements.StateMachines.UStateVertex;
import JP.co.esm.caddies.uml.BehavioralElements.StateMachines.UTransition;
import JP.co.esm.caddies.uml.Foundation.Core.UDiagram;
import JP.co.esm.caddies.uml.Foundation.Core.UModelElement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwimlanePresentation
extends LabelPresentation
implements ISwimlanePresentation {
    public static final double DEFAULT_SIZE = 175.0;
    public static final double MIN_SIZE = 100.0;
    static final long serialVersionUID = 6563353271834085937L;
    public static final double NAME_TOP_OFFSET = 10.0;
    public static final double NAME_BOTTOM_OFFSET = 10.0;
    public static final double INTERNAL_BODYBLOCK_VERTICAL_OFFSET = 10.0;
    public static final double INTERNAL_BODYBLOCK_HORIZON_OFFSET = 10.0;
    public static final double LINE_OFFSET = 10.0;
    private ISwimlanePresentation rightLane = null;
    private ISwimlanePresentation leftLane = null;
    private boolean isHorizontal = false;
    private double nameBlockHeight = 0.0;
    public static final String UPDATE_TO_SUPER = "update to supper";
    public static final String UPDATE_TO_SUB = "update to sub";
    public static final String UPDATE_TO_BOTH = "update to both";
    private static final Logger logger = LoggerFactory.getLogger(SwimlanePresentation.class);

    @Override
    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    @Override
    public void setHorizontal(boolean bl2) {
        this.isHorizontal = bl2;
    }

    @Override
    public boolean isValidModel(UModelElement uModelElement) {
        return uModelElement instanceof UPartition && super.isValidModel(uModelElement);
    }

    @Override
    public UPartition getPartition() {
        return (UPartition)this.getModel();
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public String getLabelForDBTest() {
        return this.label;
    }

    @Override
    public boolean hasContents() {
        return !this.getPartition().getContents().isEmpty();
    }

    @Override
    public void move(Vec2d vec2d) {
        if (!this.isHorizontal) {
            vec2d.y = 0.0;
            if (Math.abs(vec2d.x) < 1.0E-6) {
                return;
            }
        } else {
            vec2d.x = 0.0;
            if (Math.abs(vec2d.y) < 1.0E-6) {
                return;
            }
        }
        this.move(vec2d, false, true, false);
    }

    @Override
    public void move(Vec2d vec2d, boolean bl2, boolean bl3, boolean bl4) {
        super.move(vec2d);
        if (this.getNextLane() != null) {
            if (bl2) {
                this.getNextLane().move(vec2d);
            } else {
                this.getNextLane().move(vec2d, bl2, bl3, bl4);
            }
        }
        this.moveSubPartitions(vec2d, bl2, bl3);
        if (bl3) {
            this.moveContents(vec2d);
        }
        if (bl4) {
            H.a((ISwimlanePresentation)this, vec2d);
        }
    }

    private void moveSubPartitions(Vec2d vec2d, boolean bl2, boolean bl3) {
        ISwimlanePresentation iSwimlanePresentation = this.getFirstSubSwimlane();
        if (iSwimlanePresentation != null) {
            if (bl2) {
                iSwimlanePresentation.move(vec2d);
            } else {
                iSwimlanePresentation.move(vec2d, bl2, bl3, false);
            }
        }
    }

    @Override
    public ISwimlanePresentation getFirstSubSwimlane() {
        List list = this.getPartition().getSubGroup();
        for (UPartition uPartition : list) {
            ISwimlanePresentation iSwimlanePresentation;
            List list2 = uPartition.getPresentations();
            if (list2.size() <= 0 || (iSwimlanePresentation = (ISwimlanePresentation)list2.get(0)).getPreviousLane() != null) continue;
            return iSwimlanePresentation;
        }
        return null;
    }

    @Override
    public void moveContents(Vec2d vec2d) {
        List list = this.getPartition().getContents();
        for (UModelElement uModelElement : list) {
            if (!(uModelElement instanceof UStateVertex)) continue;
            UStateVertex uStateVertex = (UStateVertex)uModelElement;
            this.movePresentation(uStateVertex, vec2d);
            this.moveIncoming(uStateVertex, vec2d);
            this.moveOutgoing(uStateVertex, vec2d);
        }
    }

    private void moveIncoming(UStateVertex uStateVertex, Vec2d vec2d) {
        for (UTransition uTransition : uStateVertex.getIncomings()) {
            UStateVertex uStateVertex2 = uTransition.getSource();
            if (!this.isMovableTarget(uStateVertex2)) continue;
            this.movePresentation(uTransition, vec2d);
        }
    }

    private void moveOutgoing(UStateVertex uStateVertex, Vec2d vec2d) {
        if (this.getNextLane() == null) {
            return;
        }
        for (UTransition uTransition : uStateVertex.getOutgoings()) {
            UStateVertex uStateVertex2 = uTransition.getTarget();
            if (!this.getNextLane().isMovableTarget(uStateVertex2)) continue;
            this.movePresentation(uTransition, vec2d);
        }
    }

    @Override
    public boolean isMovableTarget(UStateVertex uStateVertex) {
        List list = this.getPartition().getContents();
        if (list.contains(uStateVertex)) {
            return true;
        }
        if (this.getNextLane() == null) {
            return false;
        }
        return this.getNextLane().isMovableTarget(uStateVertex);
    }

    private void movePresentation(UModelElement uModelElement, Vec2d vec2d) {
        IJomtPresentation iJomtPresentation;
        List list = uModelElement.getPresentations();
        if (list.size() != 0 && !((iJomtPresentation = (IJomtPresentation)list.get(0)) instanceof IPinPresentation)) {
            iJomtPresentation.move(vec2d);
        }
    }

    @Override
    public List getContents() {
        List list = this.getPartition().getContents();
        ArrayList<IRectPresentation> arrayList = new ArrayList<IRectPresentation>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = ((UModelElement)iterator.next()).getPresentations();
            if (list2 == null || list2.size() < 1) continue;
            IRectPresentation iRectPresentation = (IRectPresentation)list2.get(0);
            arrayList.add(iRectPresentation);
        }
        return arrayList;
    }

    @Override
    public void resize() {
        this.resize(UPDATE_TO_BOTH);
    }

    @Override
    public void resize(String string) {
        if (this.model == null) {
            return;
        }
        if (H.a()) {
            H.a(this.getDiagram());
            H.a(false);
            return;
        }
        if (suppressResize) {
            return;
        }
        double d2 = y.a(this.getFont(), this.getName());
        double d3 = 20.0 + d2;
        double d4 = 0.0;
        double d5 = this.getResizeSpan(string);
        if (this.getPartition().getContents().isEmpty()) {
            d4 = Math.max(d3, this.getMinSpan());
            if (d5 == 0.0 || d4 > this.getSpan()) {
                d4 = Math.max(d4, this.getSpan());
            }
            d4 = Math.max(d4, d5);
            this.setSpan(d4);
        } else {
            Rectangle2d rectangle2d = this.getBodyBlockRect();
            this.updateSpan(d3, d5, rectangle2d);
            this.updateLength(rectangle2d);
        }
        if (this.getNextLane() != null) {
            this.moveNextLane();
        }
        if (this.isCompleteModel()) {
            this.changeNameBlockHeight();
            if (string.equals(UPDATE_TO_BOTH)) {
                this.resizeAllSubPartitions((UPartition)this.getModel());
                this.resizeAllSuperPartitions((UPartition)this.getModel());
            } else if (string.equals(UPDATE_TO_SUPER)) {
                this.resizeAllSuperPartitions((UPartition)this.getModel());
            } else if (string.equals(UPDATE_TO_SUB)) {
                this.resizeAllSubPartitions((UPartition)this.getModel());
            }
            H.c(this.getPartition());
            H.g(this);
            H.a(this.getDiagram());
        }
    }

    private void updateLength(Rectangle2d rectangle2d) {
        double d2 = 0.0;
        double d3 = 0.0;
        if (!this.isHorizontal) {
            d3 = rectangle2d.height;
            d2 = this.getLocation().y - rectangle2d.getMinY();
        } else {
            d3 = rectangle2d.width;
            d2 = this.getLocation().x - rectangle2d.getMinX();
        }
        double d4 = Math.max(this.getLength(), d3);
        d4 = Math.max(d4, this.getMinLength());
        double d5 = this.getLength();
        if (d5 != d4) {
            List list = H.f((UActivityDiagram)this.getDiagram(), this.isHorizontal);
            H.a(list, this.isHorizontal);
            if (list.size() > 0) {
                ISwimlanePresentation iSwimlanePresentation = (ISwimlanePresentation)list.get(list.size() - 1);
                iSwimlanePresentation.setLength(iSwimlanePresentation.getLength() + (d4 - d2 - d5));
                H.a(this.getDiagram());
            }
        }
    }

    private void updateSpan(double d2, double d3, Rectangle2d rectangle2d) {
        double d4 = 0.0;
        double d5 = 0.0;
        if (!this.isHorizontal) {
            d4 = this.getLocation().x - rectangle2d.getMinX();
            d5 = rectangle2d.width;
        } else {
            d4 = this.getLocation().y - rectangle2d.getMinY();
            d5 = rectangle2d.height;
        }
        double d6 = Math.max(d2, d5);
        d6 = Math.max(d6, this.getMinSpan());
        d6 = Math.max(d6, d3);
        double d7 = this.getSpan();
        if (d7 != d6) {
            this.setSpan(d6 - d4);
            this.resizeOtherDirectionalPartition(d6, d7);
        }
    }

    private void resizeOtherDirectionalPartition(double d2, double d3) {
        UActivityDiagram uActivityDiagram = (UActivityDiagram)this.getDiagram();
        List list = H.i(uActivityDiagram, !this.isHorizontal);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SwimlanePresentation swimlanePresentation = (SwimlanePresentation)list.get(i2);
            double d4 = swimlanePresentation.getLength();
            if (((UPartition)swimlanePresentation.getModel()).getSuperPartition() == null) continue;
            swimlanePresentation.setLength(d4 + (d2 - d3));
        }
    }

    private double getResizeSpan(String string) {
        double d2 = 0.0;
        if (string.equals(UPDATE_TO_SUPER) || string.equals(UPDATE_TO_BOTH)) {
            d2 = H.a(this);
        } else if (string.equals(UPDATE_TO_SUB)) {
            d2 = H.a((ISwimlanePresentation)this, false);
            List list = H.e(this);
            for (ISwimlanePresentation iSwimlanePresentation : list) {
                if (iSwimlanePresentation == this) continue;
                d2 -= iSwimlanePresentation.getSpan();
            }
        }
        return d2;
    }

    private void resizeAllSubPartitions(UPartition uPartition) {
        if (!this.isDimension() && uPartition.getSuperPartition() == null) {
            return;
        }
        ISwimlanePresentation iSwimlanePresentation = H.f(this);
        if (iSwimlanePresentation != null) {
            iSwimlanePresentation.resize(UPDATE_TO_SUB);
        }
    }

    private boolean isCompleteModel() {
        UPartition uPartition = (UPartition)this.getModel();
        UActivityDiagram uActivityDiagram = (UActivityDiagram)this.getDiagram();
        if (uPartition == null) {
            return false;
        }
        if (uPartition != null && uPartition.getName().getName().equals("")) {
            return false;
        }
        if (uActivityDiagram == null) {
            return false;
        }
        return uActivityDiagram.getPresentations().contains(this);
    }

    private void changeNameBlockHeight() {
        UPartition uPartition = (UPartition)this.getModel();
        if (uPartition == null) {
            return;
        }
        if (uPartition.getSuperPartition() == null) {
            this.changeTopNameBlockHeight();
            return;
        }
        if (uPartition.getSubGroup().size() == 0) {
            UActivityDiagram uActivityDiagram = (UActivityDiagram)this.getDiagram();
            int n2 = this.getDgmMaxLevel(uActivityDiagram);
            int n3 = uPartition.getLevel();
            if (n3 > n2) {
                this.setDgmMaxLevel(uActivityDiagram, n3);
                this.changeAllDeepestPartitionNameBlockHeight(uActivityDiagram);
            } else if (n3 < n2 || n3 == n2) {
                int n4 = n2 - n3;
                this.setNameBlockHeight(this.getMyNameBlockHeight() * (double)(n4 + 1));
                this.changeSuperPartitionNameBlockHeight();
            }
        }
    }

    private void changeTopNameBlockHeight() {
        this.setLength(H.b((UActivityDiagram)this.getDiagram(), (ISwimlanePresentation)this));
    }

    private void resizeAllSuperPartitions(UPartition uPartition) {
        ISwimlanePresentation iSwimlanePresentation;
        UPartition uPartition2 = uPartition.getSuperPartition();
        if (uPartition2 != null && (iSwimlanePresentation = H.b(uPartition2)) != null) {
            iSwimlanePresentation.resize(UPDATE_TO_SUPER);
        }
    }

    @Override
    public void changeSuperPartitionNameBlockHeight() {
        UPartition uPartition = ((UPartition)this.getModel()).getSuperPartition();
        if (uPartition == null) {
            return;
        }
        ISwimlanePresentation iSwimlanePresentation = H.b(uPartition);
        if (iSwimlanePresentation != null) {
            String string = iSwimlanePresentation.getName();
            iSwimlanePresentation.setNameBlockHeight(this.getNameBlockHeight(string));
            iSwimlanePresentation.changeSuperPartitionNameBlockHeight();
        }
    }

    private void setDgmMaxLevel(UActivityDiagram uActivityDiagram, int n2) {
        EntityStore.d(uActivityDiagram);
        if (this.isHorizontal()) {
            uActivityDiagram.setHorizontalMaxLevel(n2);
        } else {
            uActivityDiagram.setVerticalMaxLevel(n2);
        }
    }

    private int getDgmMaxLevel(UActivityDiagram uActivityDiagram) {
        int n2 = this.isHorizontal() ? uActivityDiagram.getHorizontalMaxLevel() : uActivityDiagram.getVerticalMaxLevel();
        return n2;
    }

    private void changeAllDeepestPartitionNameBlockHeight(UActivityDiagram uActivityDiagram) {
        UPartition uPartition = H.b(uActivityDiagram, this.isHorizontal());
        if (uPartition != null) {
            List list = uPartition.getSubGroup();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                UPartition uPartition2 = (UPartition)list.get(i2);
                ArrayList arrayList = new ArrayList();
                H.a(uPartition2, arrayList);
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    UPartition uPartition3 = (UPartition)arrayList.get(i3);
                    ISwimlanePresentation iSwimlanePresentation = H.b(uPartition3);
                    iSwimlanePresentation.resize();
                }
            }
        }
    }

    private double getTotalSpan() {
        return H.g((UActivityDiagram)this.getDiagram(), this.isHorizontal);
    }

    @Override
    public void setSpan(double d2) {
        if (this.isHorizontal) {
            this.setHeight(d2);
        } else {
            this.setWidth(d2);
        }
    }

    @Override
    public void setLength(double d2) {
        if (this.isHorizontal) {
            this.setWidth(d2);
        } else {
            this.setHeight(d2);
        }
    }

    @Override
    public void setSize(double d2, double d3) {
        double d4;
        double d5 = this.getTotalSpan();
        double d6 = this.getLength();
        super.setSize(d2, d3);
        double d7 = this.getTotalSpan();
        if (d5 != d7) {
            UActivityDiagram uActivityDiagram = (UActivityDiagram)this.getDiagram();
            ISwimlanePresentation iSwimlanePresentation = H.b(this);
            H.d(uActivityDiagram, iSwimlanePresentation);
        }
        if (d6 != (d4 = this.getLength())) {
            UActivityDiagram uActivityDiagram = (UActivityDiagram)this.getDiagram();
            H.a(uActivityDiagram, this);
        }
    }

    private void moveNextLane() {
        ISwimlanePresentation iSwimlanePresentation = this.getNextLane();
        ISwimlanePresentation iSwimlanePresentation2 = iSwimlanePresentation.getPreviousLane();
        Vec2d vec2d = null;
        if (iSwimlanePresentation2 == null) {
            Pnt2d pnt2d = iSwimlanePresentation.getLocation();
            if (this.isHorizontal) {
                vec2d = new Vec2d(0.0, -pnt2d.y);
                H.a(iSwimlanePresentation, vec2d, true);
                iSwimlanePresentation.move(vec2d, false, true, false);
            } else {
                vec2d = new Vec2d(-pnt2d.x, 0.0);
                H.a(iSwimlanePresentation, vec2d, true);
                iSwimlanePresentation.move(vec2d, false, true, false);
            }
        } else if (this.isHorizontal) {
            double d2 = iSwimlanePresentation2.getLocation().y + iSwimlanePresentation2.getSpan();
            double d3 = d2 - iSwimlanePresentation.getLocation().y;
            vec2d = new Vec2d(0.0, d3);
            H.a(iSwimlanePresentation, vec2d, true);
            iSwimlanePresentation.move(vec2d, false, true, false);
        } else {
            double d4 = iSwimlanePresentation2.getLocation().x + iSwimlanePresentation2.getSpan();
            double d5 = d4 - iSwimlanePresentation.getLocation().x;
            vec2d = new Vec2d(d5, 0.0);
            H.a(iSwimlanePresentation, vec2d, true);
            iSwimlanePresentation.move(vec2d, false, true, false);
        }
    }

    @Override
    public double getSpan() {
        if (this.isHorizontal) {
            return this.getHeight();
        }
        return this.getWidth();
    }

    @Override
    public double getLength() {
        if (this.isHorizontal) {
            return this.getWidth();
        }
        return this.getHeight();
    }

    @Override
    public double getMinSpan() {
        return 100.0;
    }

    @Override
    public double getMinLength() {
        return this.getLabelHeight() + 100.0;
    }

    @Override
    public double getMinWidth() {
        return 100.0;
    }

    @Override
    public double getMinHeight() {
        return 100.0;
    }

    @Override
    public double getDefaultWidth() {
        if (this.isHorizontal) {
            return this.getDefaultLength();
        }
        return this.getDefaultSpan();
    }

    @Override
    public double getDefaultSpan() {
        double d2 = y.a(this.getFont(), this.getName());
        double d3 = 10.0 + d2 + 10.0;
        Rectangle2d rectangle2d = this.getInternalBodyBlockRect();
        double d4 = 0.0;
        double d5 = 0.0;
        if (!this.isHorizontal) {
            d4 = rectangle2d.getWidth();
            d5 = this.getLocation().x - rectangle2d.getMinX();
        } else {
            d4 = rectangle2d.getHeight();
            d5 = this.getLocation().y - rectangle2d.getMinY();
        }
        double d6 = Math.max(d3, d4 -= d5);
        return Math.max(d6, this.getMinSpan());
    }

    @Override
    public double getDefaultHeight() {
        if (this.isHorizontal) {
            return this.getDefaultSpan();
        }
        return this.getDefaultLength();
    }

    @Override
    public double getDefaultLength() {
        double d2;
        double d3 = d2 = H.b((UActivityDiagram)this.getDiagram(), (ISwimlanePresentation)this);
        Rectangle2d rectangle2d = this.getInternalBodyBlockRect();
        if (rectangle2d.isEmpty()) {
            return this.getMinLength();
        }
        rectangle2d.add(this.getLocation());
        double d4 = 0.0;
        d4 = !this.isHorizontal ? rectangle2d.getHeight() : rectangle2d.getWidth();
        double d5 = Math.max(d3, d4);
        return Math.max(d5, this.getMinLength());
    }

    @Override
    public double getMyNameBlockHeight() {
        String string = this.getName();
        if (string == null) {
            string = "m";
        }
        double d2 = y.b(this.getFont(), "m");
        double d3 = 10.0 + d2 + 10.0;
        return d3;
    }

    public double getNameBlockHeight(String string) {
        if (string == null) {
            string = "m";
        }
        double d2 = y.b(this.getFont(), "m");
        double d3 = 10.0 + d2 + 10.0;
        return d3;
    }

    private Rectangle2d getInternalBodyBlockRect() {
        List list = this.getPartition().getContents();
        ArrayList<RectPresentation> arrayList = new ArrayList<RectPresentation>(list.size());
        for (UModelElement uModelElement : list) {
            if (!(uModelElement instanceof UObjectFlowState)) {
                arrayList.addAll(uModelElement.getPresentations());
                continue;
            }
            if (uModelElement.getPresentations().size() <= 0) continue;
            IObjectFlowStatePresentation iObjectFlowStatePresentation = (IObjectFlowStatePresentation)uModelElement.getPresentations().get(0);
            RectPresentation rectPresentation = new RectPresentation();
            rectPresentation.setLocation(iObjectFlowStatePresentation.getLocation());
            if (this.isHorizontal) {
                rectPresentation.setSize(iObjectFlowStatePresentation.getWidth(), iObjectFlowStatePresentation.getHeight() / 2.0);
            } else {
                rectPresentation.setSize(iObjectFlowStatePresentation.getWidth() / 2.0, iObjectFlowStatePresentation.getHeight());
            }
            arrayList.add(rectPresentation);
        }
        Rectangle2d rectangle2d = PresentationUtil.getBoundsRect(arrayList, true);
        return rectangle2d;
    }

    private Rectangle2d getBodyBlockRect() {
        Rectangle2d rectangle2d = this.getInternalBodyBlockRect();
        rectangle2d.add(this.getBoundsRect());
        return rectangle2d;
    }

    @Override
    public ISwimlanePresentation getPreviousLane() {
        return this.leftLane;
    }

    @Override
    public ISwimlanePresentation getNextLane() {
        return this.rightLane;
    }

    @Override
    public void setPreviousLane(ISwimlanePresentation iSwimlanePresentation) {
        this.setChanged();
        this.leftLane = iSwimlanePresentation;
    }

    @Override
    public void setNextLane(ISwimlanePresentation iSwimlanePresentation) {
        this.setChanged();
        this.rightLane = iSwimlanePresentation;
    }

    @Override
    public void insertPreviousLane(ISwimlanePresentation iSwimlanePresentation) {
        if (this.leftLane != null) {
            this.leftLane.setNextLane(iSwimlanePresentation);
        }
        iSwimlanePresentation.setPreviousLane(this.leftLane);
        iSwimlanePresentation.setNextLane(this);
        this.setPreviousLane(iSwimlanePresentation);
    }

    @Override
    public void insertNextLane(ISwimlanePresentation iSwimlanePresentation) {
        if (this.rightLane != null) {
            this.rightLane.setPreviousLane(iSwimlanePresentation);
        }
        iSwimlanePresentation.setNextLane(this.rightLane);
        iSwimlanePresentation.setPreviousLane(this);
        this.setNextLane(iSwimlanePresentation);
    }

    @Override
    public void preRemove() {
        ISwimlanePresentation iSwimlanePresentation = this.getNextLane();
        ISwimlanePresentation iSwimlanePresentation2 = this.getPreviousLane();
        if (iSwimlanePresentation != null) {
            Vec2d vec2d = null;
            if (this.isHorizontal) {
                vec2d = new Vec2d(0.0, -this.getSpan());
                H.a(iSwimlanePresentation, vec2d, true);
                iSwimlanePresentation.move(vec2d, false, true, false);
            } else {
                vec2d = new Vec2d(-this.getSpan(), 0.0);
                H.a(iSwimlanePresentation, vec2d, true);
                iSwimlanePresentation.move(vec2d, false, true, false);
            }
            iSwimlanePresentation.setPreviousLane(iSwimlanePresentation2);
            this.setNextLane(null);
        }
        if (iSwimlanePresentation2 != null) {
            iSwimlanePresentation2.setNextLane(iSwimlanePresentation);
            this.setPreviousLane(null);
        }
    }

    public void changeDgmMaxLevel() {
        UActivityDiagram uActivityDiagram = (UActivityDiagram)this.getDiagram();
        if (uActivityDiagram != null) {
            UPartition uPartition = H.b(uActivityDiagram, this.isHorizontal());
            ArrayList arrayList = new ArrayList();
            if (uPartition != null) {
                H.a(uPartition, arrayList);
            }
            int n2 = -1;
            for (UPartition uPartition2 : arrayList) {
                int n3 = uPartition2.getLevel();
                if (n3 <= n2) continue;
                n2 = n3;
            }
            int n4 = this.getDgmMaxLevel(uActivityDiagram);
            if (n2 != n4) {
                if (this.isHorizontal()) {
                    uActivityDiagram.setHorizontalMaxLevel(n2);
                } else {
                    uActivityDiagram.setVerticalMaxLevel(n2);
                }
            }
        }
    }

    @Override
    public void setDepth(int n2) {
        UPartition uPartition = this.getPartition();
        if (!this.isValidModel(uPartition)) {
            super.setDepth(n2);
            return;
        }
        List list = this.resetArray(uPartition);
        Object[] objectArray = list.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            UModelElement uModelElement = (UModelElement)objectArray[i2];
            if (uModelElement.getPresentations() == null || uModelElement.getPresentations().isEmpty()) continue;
            IJomtPresentation iJomtPresentation = (IJomtPresentation)uModelElement.getPresentations().get(0);
            iJomtPresentation.setDepth(iJomtPresentation.getDepth() + n2 - this.getDepth());
            iJomtPresentation.notifyObservers(null);
        }
        super.setDepth(n2);
    }

    @Override
    public List resetArray(UPartition uPartition) {
        ArrayList arrayList = new ArrayList();
        List list = uPartition.getContents();
        arrayList.addAll(list);
        Object[] objectArray = list.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            List list2;
            UStateVertex uStateVertex = (UStateVertex)objectArray[i2];
            List list3 = uStateVertex.getOutgoings();
            if (!list3.isEmpty()) {
                arrayList.addAll(list3);
            }
            if ((list2 = uStateVertex.getIncomings()).isEmpty()) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    @Override
    public void storeState(Hashtable hashtable) {
        if (this.rightLane != null) {
            hashtable.put("rightLane", this.rightLane);
            hashtable.put("isRightLaneExist", Boolean.TRUE);
        } else {
            hashtable.put("isRightLaneExist", Boolean.FALSE);
        }
        if (this.leftLane != null) {
            hashtable.put("leftLane", this.leftLane);
            hashtable.put("isLeftLaneExist", Boolean.TRUE);
        } else {
            hashtable.put("isLeftLaneExist", Boolean.FALSE);
        }
        hashtable.put("isHorizontal", this.isHorizontal);
        hashtable.put("nameBlockHeight", new Double(this.nameBlockHeight));
        super.storeState(hashtable);
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        this.setChanged();
        Object var2_2 = null;
        var2_2 = hashtable.get("rightLane");
        if (var2_2 != null) {
            this.rightLane = var2_2;
        }
        if ((var2_2 = hashtable.get("isRightLaneExist")) != null && !((Boolean)var2_2).booleanValue()) {
            this.rightLane = null;
        }
        if ((var2_2 = hashtable.get("leftLane")) != null) {
            this.leftLane = var2_2;
        }
        if ((var2_2 = hashtable.get("isLeftLaneExist")) != null && !((Boolean)var2_2).booleanValue()) {
            this.leftLane = null;
        }
        if ((var2_2 = hashtable.get("isHorizontal")) != null) {
            this.isHorizontal = var2_2;
        }
        if ((var2_2 = hashtable.get("nameBlockHeight")) != null) {
            this.nameBlockHeight = var2_2;
        }
        super.restoreState(hashtable);
        logger.debug("{}: loc = {}", (Object)this.getLabel(), (Object)this.location);
    }

    @Override
    public void remove() {
        this.changeDgmMaxLevel();
        this.preRemove();
        super.remove();
    }

    @Override
    public Object clone() {
        SwimlanePresentation swimlanePresentation = (SwimlanePresentation)super.clone();
        swimlanePresentation.leftLane = null;
        swimlanePresentation.rightLane = null;
        return swimlanePresentation;
    }

    @Override
    public void validate(JomtEntityStore jomtEntityStore) {
        this.validateDiagram(jomtEntityStore);
        this.validateModel();
        super.validate(jomtEntityStore);
    }

    private void validateModel() {
        if (this.isTop()) {
            List list = ((UPartition)this.model).getSubGroup();
            ArrayList<ISwimlanePresentation> arrayList = new ArrayList<ISwimlanePresentation>();
            int n2 = 0;
            for (UPartition iExObservable : list) {
                ISwimlanePresentation iSwimlanePresentation = H.b(iExObservable);
                if (iSwimlanePresentation != null) {
                    arrayList.add(iSwimlanePresentation);
                } else {
                    this.errorMsg(this, "model's SubGroup[" + n2 + "]'s presentation is NULL");
                }
                ++n2;
            }
            H.a(arrayList, this.isHorizontal());
            for (SwimlanePresentation swimlanePresentation : arrayList) {
                int n3 = arrayList.indexOf(swimlanePresentation);
                if (swimlanePresentation.getPreviousLane() != null && n3 == 0) {
                    this.entityErrorMsg(this, "Swimlane");
                }
                if (swimlanePresentation.getPreviousLane() == null && n3 != 0) {
                    this.entityErrorMsg(this, "Swimlane");
                }
                if (swimlanePresentation.getNextLane() == null && n3 != arrayList.size() - 1) {
                    this.entityErrorMsg(this, "Swimlane");
                }
                if (swimlanePresentation.getNextLane() == null || n3 != arrayList.size() - 1) continue;
                this.entityErrorMsg(this, "Swimlane");
            }
        }
    }

    private void validateDiagram(JomtEntityStore jomtEntityStore) {
        UDiagram uDiagram = this.getDiagram();
        if (uDiagram != null) {
            List list;
            if (!jomtEntityStore.e(uDiagram)) {
                this.entityErrorMsg(this, "diagram");
            }
            if (!(list = uDiagram.getPresentations()).contains(this)) {
                this.inverseErrorMsg(this, "diagram");
            }
        }
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        return string.equals("fill.color") || string.equals("font") || string.equals("font.color");
    }

    @Override
    public double getNameBlockHeight() {
        if (this.nameBlockHeight == 0.0) {
            return this.getMyNameBlockHeight();
        }
        return this.nameBlockHeight;
    }

    public Pnt2d getLabelEditerLocation() {
        if (this.isHorizontal) {
            Pnt2d pnt2d = super.getLocation();
            pnt2d.x = pnt2d.x - this.getDefaultLabelWidth() + this.getDefaultLabelHeight() / 2.0;
            pnt2d.y = pnt2d.y + this.getDefaultLabelWidth() / 2.0 - this.getDefaultLabelHeight() / 2.0;
            return pnt2d;
        }
        return super.getLocation();
    }

    @Override
    public void setNameBlockHeight(double d2) {
        if (this.nameBlockHeight != d2) {
            this.setChanged();
            this.nameBlockHeight = d2;
        }
    }

    @Override
    public boolean isDimension() {
        if (this.model != null) {
            UPartition uPartition = H.b((UActivityDiagram)this.getDiagram(), this.isHorizontal);
            if (uPartition != null) {
                return uPartition.isDimension();
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isTop() {
        if (this.model != null) {
            UPartition uPartition = (UPartition)this.model;
            UPartition uPartition2 = H.b((UActivityDiagram)this.getDiagram(), this.isHorizontal);
            return uPartition.equals(uPartition2);
        }
        return false;
    }

    @Override
    public void setLocationWithoutMoveSub(Pnt2d pnt2d) {
        super.setLocation(pnt2d);
    }

    @Override
    public void setLocation(Pnt2d pnt2d) {
        this.moveSubsWithPartion((UPartition)this.getModel(), pnt2d.x - this.getLocation().x, pnt2d.y - this.getLocation().y);
        super.setLocation(pnt2d);
    }

    private void moveSubsWithPartion(UPartition uPartition, double d2, double d3) {
        if (uPartition == null) {
            return;
        }
        List list = uPartition.getContents();
        for (UModelElement uModelElement : list) {
            if (uModelElement.getPresentations().isEmpty()) continue;
            JomtPresentation jomtPresentation = (JomtPresentation)uModelElement.getPresentations().get(0);
            if (this.isHorizontal()) {
                jomtPresentation.setLocation(new Pnt2d(jomtPresentation.getLocation().x + d2, jomtPresentation.getLocation().y));
                continue;
            }
            jomtPresentation.setLocation(new Pnt2d(jomtPresentation.getLocation().x, jomtPresentation.getLocation().y + d3));
        }
    }

    @Override
    public void setHeight(double d2) {
        super.setHeight(d2);
        this.resetNameBlockHeight();
    }

    @Override
    public void setWidth(double d2) {
        super.setWidth(d2);
        this.resetNameBlockHeight();
    }

    @Override
    public void resetNameBlockHeight() {
        UPartition uPartition = (UPartition)this.getModel();
        if (uPartition == null) {
            return;
        }
        if (uPartition.getSubGroup().size() == 0) {
            UActivityDiagram uActivityDiagram = (UActivityDiagram)this.getDiagram();
            int n2 = this.getDgmMaxLevel(uActivityDiagram);
            int n3 = uPartition.getLevel();
            int n4 = n2 - n3;
            double d2 = this.getMyNameBlockHeight() * (double)n4;
            if (n3 < n2) {
                if (this.nameBlockHeight != this.getMyNameBlockHeight() + d2) {
                    this.setNameBlockHeight(this.getMyNameBlockHeight() + d2);
                }
            } else {
                this.setNameBlockHeight(this.getMyNameBlockHeight());
            }
        }
    }

    @Override
    public Rectangle2d getTextScrollRect() {
        Rectangle2d rectangle2d = this.getBoundsRect();
        double d2 = rectangle2d.x;
        double d3 = rectangle2d.y;
        Rectangle2d rectangle2d2 = new Rectangle2d(d2, d3, 0.0, 0.0);
        double d4 = y.a(this.getFont(), this.getLabel());
        if (!this.isHorizontal) {
            double d5 = this.getCenterX() - d4 / 2.0;
            double d6 = d5 + d4;
            double d7 = this.getLabelHeight();
            double d8 = this.getMinY();
            double d9 = d8 + d7;
            rectangle2d2.add(d5, d8);
            rectangle2d2.add(d6, d9);
            return rectangle2d2;
        }
        double d10 = this.getCenterY() - d4 / 2.0;
        double d11 = d10 + d4;
        double d12 = this.getLabelHeight();
        double d13 = this.getMinX();
        double d14 = d13 + d12;
        rectangle2d2.add(d13, d10);
        rectangle2d2.add(d14, d11);
        return rectangle2d2;
    }
}

