/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.geom2D.Rectangle2d;
import JP.co.esm.caddies.golf.geom2D.Vec2d;
import JP.co.esm.caddies.jomt.jmodel.BinaryRelationPresentation;
import JP.co.esm.caddies.jomt.jmodel.ClassifierPresentation;
import JP.co.esm.caddies.jomt.jmodel.IConnectorPresentation;
import JP.co.esm.caddies.jomt.jmodel.IDependencyPresentation;
import JP.co.esm.caddies.jomt.jmodel.ILabelPresentation;
import JP.co.esm.caddies.jomt.jmodel.IPortPresentation;
import JP.co.esm.caddies.jomt.jmodel.IUsagePresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.LabelPresentation;
import JP.co.esm.caddies.jomt.jmodel.N;
import JP.co.esm.caddies.jomt.jmodel.ad;
import JP.co.esm.caddies.jomt.jmodel.f;
import JP.co.esm.caddies.uml.Foundation.Core.IUPresentation;
import JP.co.esm.caddies.uml.Foundation.Core.UClassifier;
import JP.co.esm.caddies.uml.Foundation.Core.UPort;
import JP.co.esm.caddies.uml.Foundation.Core.UPresentation;
import JP.co.esm.caddies.uml.Foundation.DataTypes.UMultiplicityRange;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortPresentation
extends LabelPresentation
implements IPortPresentation {
    static final long serialVersionUID = 3185739253173992200L;
    public static final double DEFAULT_HEIGHT = 14.0;
    public static final double DEFAULT_WIDTH = 14.0;
    private ILabelPresentation namePresentation;
    private boolean typeVisibility = true;
    private boolean nameVisibility = true;
    private boolean multiplicityVisibility = true;
    private static final Logger logger = LoggerFactory.getLogger(PortPresentation.class);

    @Override
    public void update(Observable observable, Object object) {
        if ((ILabelPresentation)this.getServer(0) != null) {
            this.setDepth(((ILabelPresentation)this.getServer(0)).getDepth() - 1);
        }
        super.update(observable, null);
        this.updateNamePresentation();
    }

    @Override
    public void resize() {
        this.setSize(14.0, 14.0);
    }

    @Override
    public void move(Vec2d vec2d) {
        super.move(vec2d);
        this.updateNamePresentation();
    }

    public List getAllMoveTogether() {
        ArrayList<IUPresentation> arrayList = new ArrayList<IUPresentation>();
        if (this.getClients() != null) {
            for (UPresentation uPresentation : this.getClients()) {
                IUPresentation iUPresentation;
                if (!(uPresentation instanceof IDependencyPresentation) && !(uPresentation instanceof IUsagePresentation) || (iUPresentation = uPresentation.getServer(0)) == null || !(iUPresentation.getModel() instanceof UClassifier) || !((ClassifierPresentation)iUPresentation).canMoveTogether(this) || !f.b((UClassifier)iUPresentation.getModel()) || !ad.c(iUPresentation.getModel())) continue;
                if (!arrayList.contains(uPresentation)) {
                    arrayList.add(uPresentation);
                }
                if (arrayList.contains(iUPresentation)) continue;
                arrayList.add(iUPresentation);
            }
        }
        return arrayList;
    }

    @Override
    public String getLabel() {
        UClassifier uClassifier;
        UPort uPort;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getNameVisibility()) {
            stringBuilder.append(fa.a((Object)this.getModel()));
        }
        if ((uPort = (UPort)this.getModel()) != null && (uClassifier = uPort.getType()) != null && this.getTypeVisibility()) {
            stringBuilder.append(" : " + fa.a((Object)uClassifier) + this.getTypeModifier());
        }
        if (this.getMultiplicityVisibility() && uPort != null && !this.getMultiplicity().equals("")) {
            stringBuilder.append("[" + this.getMultiplicity() + "]");
        }
        return stringBuilder.toString();
    }

    private String getMultiplicity() {
        UPort uPort = (UPort)this.getModel();
        List list = uPort.getMultiplicity().getMultiplicityRanges();
        UMultiplicityRange[] uMultiplicityRangeArray = new UMultiplicityRange[list.size()];
        list.toArray(uMultiplicityRangeArray);
        return UMultiplicityRange.toRangeString(uMultiplicityRangeArray);
    }

    @Override
    public ILabelPresentation getNamePresentation() {
        if (this.namePresentation == null) {
            this.setChanged();
            this.setNamePresentation(new LabelPresentation());
            Pnt2d pnt2d = this.getDefaultNamePnt();
            if (pnt2d != null) {
                pnt2d.setLocation(pnt2d.x - this.namePresentation.getWidth() / 2.0, pnt2d.y);
                this.namePresentation.setLocation(pnt2d);
            }
            this.updateNamePresentation();
        }
        return this.namePresentation;
    }

    public void setNamePresentation(ILabelPresentation iLabelPresentation) {
        this.setChanged();
        if (this.namePresentation != null) {
            this.namePresentation.setCompositeParent(null);
        }
        this.namePresentation = iLabelPresentation;
        this.namePresentation.setCompositeParent(this);
    }

    public void updateNamePresentation() {
        if (this.namePresentation == null) {
            return;
        }
        this.setChanged();
        if (this.model == null) {
            this.namePresentation.setLabel("");
        } else {
            this.namePresentation.setLabel(this.getLabel());
        }
        this.namePresentation.resize();
        Pnt2d pnt2d = this.getDefaultNamePnt();
        if (pnt2d != null) {
            pnt2d.setLocation(pnt2d.x - this.namePresentation.getWidth() / 2.0, pnt2d.y);
            this.namePresentation.setLocation(pnt2d);
        }
        if (this.namePresentation.getName() == null || this.namePresentation.getName().equals("")) {
            return;
        }
    }

    public Pnt2d getDefaultNamePnt() {
        return new Pnt2d(this.getCenterX(), this.getMaxY());
    }

    @Override
    public void storeState(Hashtable hashtable) {
        if (this.namePresentation != null) {
            hashtable.put("namePresentation", ((LabelPresentation)this.namePresentation).clone());
        }
        hashtable.put("nameVisibility", this.nameVisibility);
        hashtable.put("typeVisibility", this.typeVisibility);
        hashtable.put("multiplicityVisibility", this.multiplicityVisibility);
        super.storeState(hashtable);
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        Object v2 = hashtable.get("namePresentation");
        if (v2 != null) {
            this.namePresentation = (ILabelPresentation)v2;
            this.namePresentation.setCompositeParent(this);
        }
        if ((v2 = hashtable.get("nameVisibility")) != null) {
            this.nameVisibility = (Boolean)v2;
        }
        if ((v2 = hashtable.get("typeVisibility")) != null) {
            this.typeVisibility = (Boolean)v2;
        }
        if ((v2 = hashtable.get("multiplicityVisibility")) != null) {
            this.multiplicityVisibility = (Boolean)v2;
        }
        super.restoreState(hashtable);
    }

    @Override
    public double getMaxResizeRightWidth() {
        return this.getDefaultWidth();
    }

    @Override
    public double getMaxResizeDownHeight() {
        return this.getDefaultHeight();
    }

    @Override
    public double getMaxResizeLeftWidth() {
        return this.getDefaultWidth();
    }

    @Override
    public double getMaxResizeUpHeight() {
        return this.getDefaultHeight();
    }

    @Override
    public double getDefaultHeight() {
        return 14.0;
    }

    @Override
    public double getDefaultWidth() {
        return 14.0;
    }

    @Override
    public boolean getTypeVisibility() {
        return this.typeVisibility;
    }

    @Override
    public void setTypeVisibility(boolean bl2) {
        this.setChanged();
        this.typeVisibility = bl2;
        this.updateNamePresentation();
    }

    @Override
    public boolean getNameVisibility() {
        return this.nameVisibility;
    }

    @Override
    public void setNameVisibility(boolean bl2) {
        this.setChanged();
        this.nameVisibility = bl2;
        this.updateNamePresentation();
    }

    @Override
    public boolean getMultiplicityVisibility() {
        return this.multiplicityVisibility;
    }

    @Override
    public void setMultiplicityVisibility(boolean bl2) {
        this.setChanged();
        this.multiplicityVisibility = bl2;
        this.updateNamePresentation();
    }

    @Override
    public Object clone() {
        PortPresentation portPresentation = (PortPresentation)super.clone();
        if (this.namePresentation != null) {
            portPresentation.namePresentation = null;
            portPresentation.setNamePresentation((ILabelPresentation)((LabelPresentation)this.namePresentation).clone());
            portPresentation.namePresentation.removeAllClients();
        }
        return portPresentation;
    }

    @Override
    public void validateServers(JomtEntityStore jomtEntityStore) {
        List list = this.getServers();
        if (list.size() != 1) {
            this.sizeErrorMsg(list, "size of port.server is not equals 1");
        } else {
            ILabelPresentation iLabelPresentation = (ILabelPresentation)list.get(0);
            Pnt2d pnt2d = this.getLocation();
            Pnt2d pnt2d2 = N.a(new Pnt2d(pnt2d.x, pnt2d.y), iLabelPresentation, 14.0, 14.0);
            if (14.0 < Math.abs(pnt2d.x - pnt2d2.x) || 14.0 < Math.abs(pnt2d.y - pnt2d2.y)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("serverP={} loc={} dgm={} dgm.isReadOnly(){}", new Object[]{iLabelPresentation, iLabelPresentation.getLocation(), iLabelPresentation.getDiagram(), iLabelPresentation.getDiagram().isReadOnly()});
                    logger.debug("this={} loc={} dgm={} dgm.isReadOnly(){}", new Object[]{this, pnt2d, this.getDiagram(), this.getDiagram().isReadOnly()});
                    logger.debug("temploc={}", (Object)pnt2d2);
                }
                this.isValidErrorMsg(this, "port position");
            }
        }
        super.validateServers(jomtEntityStore);
    }

    @Override
    public void setVisibility(boolean bl2) {
        super.setVisibility(bl2);
        block0: for (int i2 = 0; i2 < this.getClients().size(); ++i2) {
            if (!(this.getClients().get(i2) instanceof IConnectorPresentation)) continue;
            IConnectorPresentation iConnectorPresentation = (IConnectorPresentation)this.getClients().get(i2);
            iConnectorPresentation.setConnectorVisibility(bl2);
            for (int i3 = 0; i3 < iConnectorPresentation.getServers().size(); ++i3) {
                if (((ILabelPresentation)iConnectorPresentation.getServer(i3)).getVisibility()) continue;
                iConnectorPresentation.setVisibility(false);
                continue block0;
            }
        }
    }

    @Override
    public void adjustLocation(Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        double d2 = rectangle2d2.getWidth() / rectangle2d.getWidth();
        double d3 = rectangle2d2.getHeight() / rectangle2d.getHeight();
        double d4 = this.getCenterX() - rectangle2d.x;
        double d5 = this.getCenterY() - rectangle2d.y;
        double d6 = d4 * d2;
        double d7 = d5 * d3;
        double d8 = rectangle2d2.x + d6 - this.getWidth() / 2.0;
        double d9 = rectangle2d2.y + d7 - this.getHeight() / 2.0;
        this.setLocation(new Pnt2d(d8, d9));
    }

    @Override
    public boolean attributesEqual(UPresentation uPresentation) {
        if (!(uPresentation instanceof IPortPresentation)) {
            return false;
        }
        PortPresentation portPresentation = (PortPresentation)uPresentation;
        if (portPresentation.typeVisibility != this.typeVisibility || portPresentation.nameVisibility != this.nameVisibility || portPresentation.multiplicityVisibility != this.multiplicityVisibility) {
            return false;
        }
        LabelPresentation labelPresentation = (LabelPresentation)this.getNamePresentation();
        LabelPresentation labelPresentation2 = (LabelPresentation)portPresentation.getNamePresentation();
        if (labelPresentation == null && labelPresentation2 != null || !labelPresentation.attributesEqual(labelPresentation2)) {
            return false;
        }
        return super.attributesEqual(portPresentation);
    }

    @Override
    public void attributesCopy(UPresentation uPresentation) {
        super.attributesCopy(uPresentation);
        if (!(uPresentation instanceof PortPresentation)) {
            return;
        }
        PortPresentation portPresentation = (PortPresentation)uPresentation;
        this.typeVisibility = portPresentation.typeVisibility;
        this.nameVisibility = portPresentation.nameVisibility;
        this.multiplicityVisibility = portPresentation.multiplicityVisibility;
        LabelPresentation labelPresentation = (LabelPresentation)this.getNamePresentation();
        LabelPresentation labelPresentation2 = (LabelPresentation)portPresentation.getNamePresentation();
        if (labelPresentation != null && labelPresentation2 != null) {
            labelPresentation.attributesCopy(labelPresentation2);
        }
    }

    @Override
    public void setDepth(int n2) {
        super.setDepth(n2);
        for (Object e2 : this.getClients()) {
            ((BinaryRelationPresentation)e2).setDepth(n2 - 1);
            ((BinaryRelationPresentation)e2).notifyObservers();
        }
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        return string.equals("fill.color") || string.equals("font.color");
    }

    @Override
    public void remove() {
        super.remove();
    }

    @Override
    public Rectangle2d getBoundsRect() {
        Rectangle2d rectangle2d = super.getBoundsRect();
        if (!this.getLabel().isEmpty()) {
            if (rectangle2d.isEmpty()) {
                rectangle2d.setRect(this.getNamePresentation().getBoundsRect());
            } else {
                rectangle2d.add(this.getNamePresentation().getBoundsRect());
            }
        }
        return rectangle2d;
    }
}

