/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.geom2D.Rectangle2d;
import JP.co.esm.caddies.golf.geom2D.Vec2d;
import JP.co.esm.caddies.jomt.jmodel.ILabelPresentation;
import JP.co.esm.caddies.jomt.jmodel.IPinPresentation;
import JP.co.esm.caddies.jomt.jmodel.IRectPresentation;
import JP.co.esm.caddies.jomt.jmodel.LabelPresentation;
import JP.co.esm.caddies.jomt.jmodel.ObjectFlowStatePresentation;
import JP.co.esm.caddies.jomt.jutil.y;
import java.awt.Font;
import java.awt.geom.Line2D;
import java.util.Hashtable;
import java.util.Observable;

public abstract class PinPresentation
extends ObjectFlowStatePresentation
implements IPinPresentation {
    private static final long serialVersionUID = 7684617437111329967L;
    public static final double DEFAULT_SIZE = 15.0;
    private ILabelPresentation namePresentation;
    private ILabelPresentation statePresentation;

    @Override
    public void update(Observable observable, Object object) {
        if ((ILabelPresentation)this.getServer(0) != null) {
            this.setDepth(((ILabelPresentation)this.getServer(0)).getDepth() - 1);
        }
        super.update(observable, null);
        this.updateNamePresentation();
        this.updateStatePresentation();
    }

    @Override
    public void move(Vec2d vec2d) {
        super.move(vec2d);
        this.updateNamePresentation();
        this.updateStatePresentation();
    }

    @Override
    public ILabelPresentation getNamePresentation() {
        if (this.namePresentation == null) {
            this.setChanged();
            this.setNamePresentation(new LabelPresentation());
            Pnt2d pnt2d = this.getDefaultNamePnt();
            if (pnt2d != null) {
                pnt2d.setLocation(pnt2d.x - this.namePresentation.getWidth() / 2.0, pnt2d.y);
                this.namePresentation.setLocation(pnt2d);
            }
            this.updateNamePresentation();
        }
        return this.namePresentation;
    }

    public void setNamePresentation(ILabelPresentation iLabelPresentation) {
        this.setChanged();
        if (this.namePresentation != null) {
            this.namePresentation.setCompositeParent(null);
        }
        this.namePresentation = iLabelPresentation;
        this.namePresentation.setCompositeParent(this);
    }

    public void updateNamePresentation() {
        if (this.namePresentation == null) {
            return;
        }
        this.setChanged();
        if (this.model == null) {
            this.namePresentation.setLabel("");
        } else {
            this.namePresentation.setLabel(this.getLabel());
        }
        this.namePresentation.resize();
        Pnt2d pnt2d = this.getDefaultNamePnt();
        if (pnt2d != null) {
            pnt2d.setLocation(pnt2d.x - this.namePresentation.getWidth() / 2.0, pnt2d.y);
            this.namePresentation.setLocation(pnt2d);
        }
        if (this.namePresentation.getName() == null || this.namePresentation.getName().equals("")) {
            return;
        }
    }

    public Pnt2d getDefaultNamePnt() {
        Pnt2d pnt2d = new Pnt2d(this.getCenterX(), this.getMaxY());
        ILabelPresentation iLabelPresentation = this.getParentPresentation();
        if (iLabelPresentation == null || this.namePresentation == null) {
            return pnt2d;
        }
        if (!(this.getMinX() < iLabelPresentation.getMinX()) && !(this.getMaxX() > iLabelPresentation.getMaxX())) {
            if (this.getMinY() < iLabelPresentation.getMinY()) {
                pnt2d.x = this.getMaxX() + 5.0 + this.namePresentation.getWidth() / 2.0;
                pnt2d.y = this.getMinY() - 5.0 - this.namePresentation.getHeight();
            } else {
                pnt2d.x = this.getMaxX() + 5.0 + this.namePresentation.getWidth() / 2.0;
                pnt2d.y = this.getMinY() + 5.0;
            }
        }
        return pnt2d;
    }

    @Override
    public ILabelPresentation getStatePresentation() {
        if (this.statePresentation == null) {
            this.setChanged();
            this.setStatePresentation(new LabelPresentation());
            Pnt2d pnt2d = this.getDefaultStatePnt();
            if (pnt2d != null) {
                pnt2d.setLocation(pnt2d.x - this.statePresentation.getWidth() / 2.0, pnt2d.y);
                this.statePresentation.setLocation(pnt2d);
            }
            this.updateStatePresentation();
        }
        return this.statePresentation;
    }

    @Override
    public ILabelPresentation getParentPresentation() {
        if (this.servers != null && !this.servers.isEmpty()) {
            return (ILabelPresentation)this.servers.get(0);
        }
        return null;
    }

    public void setStatePresentation(ILabelPresentation iLabelPresentation) {
        this.setChanged();
        if (this.statePresentation != null) {
            this.statePresentation.setCompositeParent(null);
        }
        this.statePresentation = iLabelPresentation;
        this.statePresentation.setCompositeParent(this);
    }

    public void updateStatePresentation() {
        if (this.statePresentation == null) {
            return;
        }
        this.setChanged();
        if (this.model == null) {
            this.statePresentation.setLabel("");
        } else {
            this.statePresentation.setLabel(this.getStateLabel());
        }
        this.statePresentation.resize();
        Font font = this.statePresentation.getFont();
        String string = this.statePresentation.getLabel();
        this.statePresentation.setWidth(y.a(font, string));
        this.statePresentation.setHeight(y.b(font, string));
        Pnt2d pnt2d = this.getDefaultStatePnt();
        if (pnt2d != null) {
            pnt2d.setLocation(pnt2d.x - this.statePresentation.getWidth() / 2.0, pnt2d.y);
            this.statePresentation.setLocation(pnt2d);
        }
    }

    public Pnt2d getDefaultStatePnt() {
        Pnt2d pnt2d = new Pnt2d(this.getCenterX(), this.getMaxY() + 15.0);
        ILabelPresentation iLabelPresentation = this.getParentPresentation();
        if (iLabelPresentation == null || this.statePresentation == null) {
            return pnt2d;
        }
        if (!(this.getMinX() < iLabelPresentation.getMinX()) && !(this.getMaxX() > iLabelPresentation.getMaxX())) {
            if (this.getMinY() < iLabelPresentation.getMinY()) {
                pnt2d.x = this.getMaxX() + 5.0 + this.statePresentation.getWidth() / 2.0;
                pnt2d.y = this.getMinY() - 5.0;
            } else {
                pnt2d.x = this.getMaxX() + 5.0 + this.statePresentation.getWidth() / 2.0;
                pnt2d.y = this.getMinY() + 5.0 + this.statePresentation.getHeight();
            }
        }
        return pnt2d;
    }

    @Override
    public Pnt2d getDefaultPropertyPnt() {
        ILabelPresentation iLabelPresentation;
        Pnt2d pnt2d = this.getDefaultNamePnt();
        ILabelPresentation iLabelPresentation2 = this.getNamePresentation();
        if (iLabelPresentation2.getLabel() != null && iLabelPresentation2.getLabel().length() > 0) {
            pnt2d.y += iLabelPresentation2.getHeight();
        }
        if ((iLabelPresentation = this.getStatePresentation()).getLabel() != null && iLabelPresentation.getLabel().length() > 0) {
            pnt2d.y += iLabelPresentation.getHeight();
        }
        return pnt2d;
    }

    @Override
    public void storeState(Hashtable hashtable) {
        if (this.namePresentation != null) {
            hashtable.put("namePresentation", this.namePresentation.clone());
        }
        if (this.statePresentation != null) {
            hashtable.put("statePresentation", this.statePresentation.clone());
        }
        super.storeState(hashtable);
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        Object v2;
        Object v3 = hashtable.get("namePresentation");
        if (v3 instanceof ILabelPresentation) {
            this.namePresentation = (ILabelPresentation)v3;
            this.namePresentation.setCompositeParent(this);
        }
        if ((v2 = hashtable.get("statePresentation")) instanceof ILabelPresentation) {
            this.statePresentation = (ILabelPresentation)v2;
            this.statePresentation.setCompositeParent(this);
        }
        super.restoreState(hashtable);
    }

    @Override
    public Object clone() {
        PinPresentation pinPresentation = (PinPresentation)super.clone();
        if (this.namePresentation != null) {
            pinPresentation.namePresentation = null;
            pinPresentation.setNamePresentation((ILabelPresentation)this.namePresentation.clone());
            pinPresentation.namePresentation.removeAllClients();
        }
        if (this.statePresentation != null) {
            pinPresentation.statePresentation = null;
            pinPresentation.setStatePresentation((ILabelPresentation)this.statePresentation.clone());
            pinPresentation.statePresentation.removeAllClients();
        }
        return pinPresentation;
    }

    @Override
    public double getMinWidth() {
        return this.getDefaultSize();
    }

    @Override
    public double getMinHeight() {
        return this.getDefaultSize();
    }

    @Override
    public double getDefaultWidth() {
        return this.getDefaultSize();
    }

    @Override
    public double getDefaultHeight() {
        return this.getDefaultSize();
    }

    private double getDefaultSize() {
        return 15.0;
    }

    @Override
    public Pnt2d getNearestPinLocation(Pnt2d pnt2d) {
        return this.getNearestPinLocation(pnt2d, this.getParentPresentation());
    }

    @Override
    public Pnt2d getNearestPinLocation(Pnt2d pnt2d, IRectPresentation iRectPresentation) {
        Pnt2d pnt2d2 = new Pnt2d(pnt2d);
        Pnt2d pnt2d3 = iRectPresentation.getLocation();
        double d2 = Line2D.ptLineDist(pnt2d3.x, pnt2d3.y, pnt2d3.x, iRectPresentation.getMaxY(), pnt2d.x, pnt2d.y);
        double d3 = Line2D.ptLineDist(pnt2d3.x, pnt2d3.y, iRectPresentation.getMaxX(), pnt2d3.y, pnt2d.x, pnt2d.y);
        double d4 = Line2D.ptLineDist(iRectPresentation.getMaxX(), pnt2d3.y, iRectPresentation.getMaxX(), iRectPresentation.getMaxY(), pnt2d.x, pnt2d.y);
        double d5 = Line2D.ptLineDist(pnt2d3.x, iRectPresentation.getMaxY(), iRectPresentation.getMaxX(), iRectPresentation.getMaxY(), pnt2d.x, pnt2d.y);
        boolean bl2 = false;
        if (Math.min(d2, d4) < Math.min(d3, d5)) {
            bl2 = true;
        }
        if (bl2) {
            pnt2d2.x = d2 < d4 ? pnt2d3.x - 15.0 : iRectPresentation.getMaxX();
            if (pnt2d.y < iRectPresentation.getMinY()) {
                pnt2d2.y = iRectPresentation.getMinY();
            } else if (pnt2d.y > iRectPresentation.getMaxY() - 15.0) {
                pnt2d2.y = iRectPresentation.getMaxY() - 15.0;
            }
        } else {
            pnt2d2.y = d3 < d5 ? pnt2d3.y - 15.0 : iRectPresentation.getMaxY();
            if (pnt2d.x < iRectPresentation.getMinX()) {
                pnt2d2.x = iRectPresentation.getMinX();
            } else if (pnt2d.x > iRectPresentation.getMaxX() - 15.0) {
                pnt2d2.x = iRectPresentation.getMaxX() - 15.0;
            }
        }
        return pnt2d2;
    }

    @Override
    public void adjustLocation(Rectangle2d rectangle2d, Rectangle2d rectangle2d2) {
        double d2;
        double d3 = rectangle2d2.getWidth() / rectangle2d.getWidth();
        double d4 = rectangle2d2.getHeight() / rectangle2d.getHeight();
        double d5 = this.getMinX() - rectangle2d.x;
        double d6 = this.getMinY() - rectangle2d.y;
        double d7 = d5 * d3;
        if (d7 >= rectangle2d2.getWidth() - this.getWidth()) {
            d7 = rectangle2d2.getWidth() - this.getWidth();
        }
        if ((d2 = d6 * d4) >= rectangle2d2.getHeight() - this.getHeight()) {
            d2 = rectangle2d2.getHeight() - this.getHeight();
        }
        double d8 = rectangle2d2.x + d7;
        double d9 = rectangle2d2.y + d2;
        if (this.getMinX() < rectangle2d.getMinX()) {
            d8 = rectangle2d2.getMinX() - this.getWidth();
        } else if (this.getMaxX() > rectangle2d.getMaxX()) {
            d8 = rectangle2d2.getMaxX();
        } else if (this.getMinY() < rectangle2d.getMinY()) {
            d9 = rectangle2d2.getMinY() - this.getHeight();
        } else if (this.getMaxY() > rectangle2d.getMaxY()) {
            d9 = rectangle2d2.getMaxY();
        }
        if (this.getMinY() < rectangle2d.getMinY() || this.getMaxY() > rectangle2d.getMaxY()) {
            d8 = this.getMinX();
        }
        if (this.getMinX() < rectangle2d.getMinX() || this.getMaxX() > rectangle2d.getMaxX()) {
            d9 = this.getMinY();
        }
        this.setLocation(new Pnt2d(d8, d9));
    }

    @Override
    public double getMaxResizeRightWidth() {
        return this.getDefaultWidth();
    }

    @Override
    public double getMaxResizeDownHeight() {
        return this.getDefaultHeight();
    }

    @Override
    public double getMaxResizeLeftWidth() {
        return this.getDefaultWidth();
    }

    @Override
    public double getMaxResizeUpHeight() {
        return this.getDefaultHeight();
    }

    @Override
    public double getMinResizeLeftWidth() {
        return this.getDefaultWidth();
    }

    @Override
    public double getMinResizeRightWidth() {
        return this.getDefaultWidth();
    }

    @Override
    public double getMinResizeUpHeight() {
        return this.getDefaultHeight();
    }

    @Override
    public double getMinResizeDownHeight() {
        return this.getDefaultHeight();
    }

    @Override
    public void resize() {
        this.setSize(15.0, 15.0);
    }

    @Override
    protected void updateExceptionPresentationPoint(Pnt2d pnt2d) {
        this.exceptionPresentation.setWidth(15.0);
        this.exceptionPresentation.setHeight(7.5 * Math.sqrt(2.0));
        ILabelPresentation iLabelPresentation = this.getParentPresentation();
        if (iLabelPresentation == null) {
            return;
        }
        if (this.getMinX() < iLabelPresentation.getMinX()) {
            pnt2d.x -= 12.5 + this.exceptionPresentation.getWidth();
            pnt2d.y -= this.exceptionPresentation.getHeight();
        } else if (this.getMaxX() > iLabelPresentation.getMaxX()) {
            pnt2d.x += 12.5;
            pnt2d.y -= this.exceptionPresentation.getHeight();
        } else if (this.getMinY() < iLabelPresentation.getMinY()) {
            pnt2d.x -= 12.5 + this.exceptionPresentation.getWidth();
            pnt2d.y -= this.exceptionPresentation.getHeight();
        } else {
            pnt2d.x -= 12.5 + this.exceptionPresentation.getWidth();
            pnt2d.y += this.exceptionPresentation.getHeight();
        }
        this.exceptionPresentation.setLocation(pnt2d);
    }

    @Override
    public boolean isValid() {
        return this.getServerNum() == 1 && super.isValid();
    }
}

