/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.geom2D.Rectangle2d;
import JP.co.esm.caddies.golf.geom2D.Vec2d;
import JP.co.esm.caddies.golf.util.e;
import JP.co.esm.caddies.jomt.jmodel.ILabelPresentation;
import JP.co.esm.caddies.jomt.jmodel.IPathPresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.JomtPresentation;
import JP.co.esm.caddies.jomt.jmodel.LabelPresentation;
import JP.co.esm.caddies.jomt.jutil.y;
import JP.co.esm.caddies.uml.Foundation.Core.IUPresentation;
import JP.co.esm.caddies.uml.Foundation.Core.UPresentation;
import JP.co.esm.caddies.uml.Foundation.Core.UUsageImp;
import JP.co.esm.caddies.uml.Foundation.ExtensionMechanisms.UStereotype;
import java.awt.Font;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPresentation
extends JomtPresentation
implements IPathPresentation {
    private static final Logger logger = LoggerFactory.getLogger(PathPresentation.class);
    static final long serialVersionUID = -3921316546713049945L;
    protected ILabelPresentation namePresentation;
    protected List stereotypePresentations = new ArrayList(0);
    protected List constraintPresentations;
    protected ILabelPresentation stereotypePresentation;
    protected Pnt2d[] points = new Pnt2d[0];
    protected Pnt2d[] allPoints;
    protected Pnt2d[] outerPoints;
    protected static final double shiftUnit = 4.5;

    @Override
    public void setPoints(Pnt2d[] pnt2dArray) {
        this.setChanged();
        this.points = pnt2dArray;
        this.updatePoints();
    }

    @Override
    public Pnt2d[] getPoints() {
        return this.points;
    }

    @Override
    public void move(Vec2d vec2d) {
        super.move(vec2d);
        for (int i2 = 0; i2 < this.points.length; ++i2) {
            this.points[i2].add(vec2d);
        }
        this.updatePoints();
    }

    @Override
    public Rectangle2d getBoundsRect() {
        int n2;
        int n3;
        Rectangle2d rectangle2d = new Rectangle2d();
        boolean bl2 = true;
        if (this.allPoints != null) {
            for (n3 = 0; n3 < this.allPoints.length; ++n3) {
                Pnt2d pnt2d = this.allPoints[n3];
                if (bl2) {
                    rectangle2d.setRect(pnt2d.x, pnt2d.y, 0.0, 0.0);
                    bl2 = false;
                    continue;
                }
                rectangle2d.add(pnt2d);
            }
        }
        if (this.allPoints != null) {
            if (bl2) {
                rectangle2d.setRect(this.getNamePresentation().getBoundsRect());
            } else {
                rectangle2d.add(this.getNamePresentation().getBoundsRect());
            }
        }
        n3 = this.stereotypePresentations.size();
        for (n2 = 0; n2 < n3; ++n2) {
            ILabelPresentation iLabelPresentation = (ILabelPresentation)this.stereotypePresentations.get(n2);
            rectangle2d.add(iLabelPresentation.getBoundsRect());
        }
        if (this.constraintPresentations != null) {
            n2 = this.constraintPresentations.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ILabelPresentation iLabelPresentation = (ILabelPresentation)this.constraintPresentations.get(i2);
                rectangle2d.add(iLabelPresentation.getBoundsRect());
            }
        }
        return rectangle2d;
    }

    @Override
    public Pnt2d getDefaultStereotypePnt() {
        Pnt2d pnt2d = this.getDefaultNamePnt();
        if (pnt2d == null) {
            return null;
        }
        pnt2d.y -= 9.0;
        return pnt2d;
    }

    @Override
    public ILabelPresentation getNamePresentation() {
        if (this.namePresentation == null) {
            this.setChanged();
            this.setNamePresentation(new LabelPresentation());
            Pnt2d pnt2d = this.getDefaultNamePnt();
            if (pnt2d != null) {
                pnt2d.setLocation(pnt2d.x - this.namePresentation.getWidth() / 2.0, pnt2d.y - this.namePresentation.getHeight() / 2.0);
                this.namePresentation.setLocation(pnt2d);
            }
            this.updateNamePresentation();
        }
        return this.namePresentation;
    }

    @Override
    public void setNamePresentation(ILabelPresentation iLabelPresentation) {
        this.setChanged();
        if (this.namePresentation != null) {
            this.namePresentation.setCompositeParent(null);
        }
        this.namePresentation = iLabelPresentation;
        this.namePresentation.setCompositeParent(this);
    }

    @Override
    public void updateNamePresentation() {
        if (this.namePresentation == null) {
            return;
        }
        this.setChanged();
        if (this.model == null) {
            this.namePresentation.setLabel("");
        } else {
            this.namePresentation.setLabel(this.getIndicatoryName());
        }
        this.namePresentation.resize();
        this.updateNamePsLocation();
        if (this.namePresentation.getName() == null || this.namePresentation.getName().equals("")) {
            return;
        }
    }

    protected void updateNamePsLocation() {
        Pnt2d pnt2d = this.getDefaultNamePnt();
        if (pnt2d != null) {
            pnt2d.setLocation(pnt2d.x - this.namePresentation.getWidth() / 2.0, pnt2d.y - this.namePresentation.getHeight() / 2.0);
            this.namePresentation.setLocation(pnt2d);
        }
    }

    protected String getIndicatoryName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return fa.a((Object)this.model);
    }

    @Override
    public Pnt2d getDefaultNamePnt() {
        Pnt2d pnt2d = this.getMiddlePnt();
        if (pnt2d == null) {
            return null;
        }
        pnt2d.y += 9.0;
        return pnt2d;
    }

    @Override
    public Pnt2d[] getAllPoints() {
        if (this.allPoints == null) {
            this.updateAllPoints();
        }
        return this.allPoints;
    }

    @Override
    public Pnt2d[] getOuterPoints() {
        return this.outerPoints;
    }

    @Override
    public void updateAllPoints() {
    }

    @Override
    public void updateOuterPoints() {
    }

    @Override
    public void updatePoints() {
        this.updateAllPoints();
        this.updateOuterPoints();
        if (!suppressResize) {
            this.updateNamePresentation();
            this.updateStereotypePresentation();
            this.updateConstraintPresentation();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        super.update(observable, null);
        this.updatePoints();
        this.notifyObservers(null);
    }

    @Override
    public void storeState(Hashtable hashtable) {
        LabelPresentation labelPresentation;
        int n2;
        Pnt2d[] pnt2dArray;
        if (this.namePresentation != null) {
            hashtable.put("namePresentation", ((LabelPresentation)this.namePresentation).clone());
        }
        if (this.stereotypePresentations != null) {
            pnt2dArray = new ArrayList(this.stereotypePresentations.size());
            for (n2 = 0; n2 < this.stereotypePresentations.size(); ++n2) {
                labelPresentation = (LabelPresentation)this.stereotypePresentations.get(n2);
                pnt2dArray.add(labelPresentation.clone());
            }
            hashtable.put("stereotypePresentations", pnt2dArray);
        }
        if (this.constraintPresentations != null) {
            pnt2dArray = new ArrayList(this.constraintPresentations.size());
            for (n2 = 0; n2 < this.constraintPresentations.size(); ++n2) {
                labelPresentation = (LabelPresentation)this.constraintPresentations.get(n2);
                pnt2dArray.add(labelPresentation.clone());
            }
            hashtable.put("constraintPresentations", pnt2dArray);
        }
        if (this.points != null) {
            pnt2dArray = new Pnt2d[this.points.length];
            for (n2 = 0; n2 < this.points.length; ++n2) {
                pnt2dArray[n2] = new Pnt2d(this.points[n2]);
            }
            hashtable.put("points", pnt2dArray);
        }
        super.storeState(hashtable);
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        ILabelPresentation iLabelPresentation;
        int n2;
        Object var2_2 = null;
        var2_2 = hashtable.get("namePresentation");
        if (var2_2 != null) {
            this.namePresentation = var2_2;
            this.namePresentation.setCompositeParent(this);
        }
        if ((var2_2 = hashtable.get("stereotypePresentations")) != null) {
            this.stereotypePresentations = var2_2;
            for (n2 = 0; n2 < this.stereotypePresentations.size(); ++n2) {
                iLabelPresentation = (ILabelPresentation)this.stereotypePresentations.get(n2);
                iLabelPresentation.setCompositeParent(this);
            }
        }
        if ((var2_2 = hashtable.get("constraintPresentations")) != null) {
            this.constraintPresentations = var2_2;
            for (n2 = 0; n2 < this.constraintPresentations.size(); ++n2) {
                iLabelPresentation = (ILabelPresentation)this.constraintPresentations.get(n2);
                iLabelPresentation.setCompositeParent(this);
                iLabelPresentation.removeAllClients();
            }
        }
        if ((var2_2 = hashtable.get("points")) != null) {
            Pnt2d[] pnt2dArray = var2_2;
            this.points = new Pnt2d[pnt2dArray.length];
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                this.points[i2] = new Pnt2d(pnt2dArray[i2]);
            }
        }
        this.addClient();
        super.restoreState(hashtable);
        this.updatePoints();
    }

    protected void addClient() {
        if (this.constraintPresentations == null) {
            return;
        }
        for (int i2 = 0; i2 < this.constraintPresentations.size(); ++i2) {
            ILabelPresentation iLabelPresentation = (ILabelPresentation)this.constraintPresentations.get(i2);
            for (int i3 = 0; i3 < this.constraintPresentations.size(); ++i3) {
                if (i3 == i2) continue;
                ILabelPresentation iLabelPresentation2 = (ILabelPresentation)this.constraintPresentations.get(i3);
                iLabelPresentation.addClient(iLabelPresentation2);
                iLabelPresentation2.addClient(iLabelPresentation);
            }
        }
    }

    @Override
    public Object clone() {
        LabelPresentation labelPresentation;
        LabelPresentation labelPresentation2;
        int n2;
        Pnt2d[] pnt2dArray;
        PathPresentation pathPresentation = (PathPresentation)super.clone();
        if (this.namePresentation != null) {
            pathPresentation.namePresentation = null;
            pathPresentation.setNamePresentation((ILabelPresentation)((LabelPresentation)this.namePresentation).clone());
            pathPresentation.namePresentation.removeAllClients();
        }
        if (this.stereotypePresentations != null) {
            pnt2dArray = new ArrayList(this.stereotypePresentations.size());
            for (n2 = 0; n2 < this.stereotypePresentations.size(); ++n2) {
                labelPresentation2 = (LabelPresentation)this.stereotypePresentations.get(n2);
                labelPresentation = (LabelPresentation)labelPresentation2.clone();
                pnt2dArray.add(labelPresentation);
            }
            pathPresentation.setStereotypePresentations((List)pnt2dArray);
        }
        if (this.constraintPresentations != null) {
            pnt2dArray = new ArrayList(this.constraintPresentations.size());
            for (n2 = 0; n2 < this.constraintPresentations.size(); ++n2) {
                labelPresentation2 = (LabelPresentation)this.constraintPresentations.get(n2);
                labelPresentation = (LabelPresentation)labelPresentation2.clone();
                labelPresentation.removeAllClients();
                pnt2dArray.add(labelPresentation);
            }
            pathPresentation.setConstraintPresentations((List)pnt2dArray);
        }
        pathPresentation.allPoints = null;
        pathPresentation.outerPoints = null;
        pnt2dArray = new Pnt2d[this.points.length];
        for (n2 = 0; n2 < this.points.length; ++n2) {
            pnt2dArray[n2] = new Pnt2d(this.points[n2]);
        }
        pathPresentation.setPoints(pnt2dArray);
        return pathPresentation;
    }

    @Override
    public Pnt2d getMiddlePnt() {
        Pnt2d[] pnt2dArray = this.getOuterPoints();
        if (pnt2dArray == null) {
            pnt2dArray = this.getAllPoints();
        }
        if (pnt2dArray == null) {
            return null;
        }
        return PathPresentation.getMiddlePnt(pnt2dArray);
    }

    public static Pnt2d getMiddlePnt(Pnt2d[] pnt2dArray) {
        Pnt2d pnt2d = new Pnt2d();
        double d2 = 0.0;
        double[] dArray = new double[pnt2dArray.length];
        for (int i2 = 0; i2 < pnt2dArray.length - 1; ++i2) {
            dArray[i2] = pnt2dArray[i2].distance(pnt2dArray[i2 + 1]);
            d2 += dArray[i2];
        }
        if (d2 < 1.0E-5) {
            pnt2d.setLocation(pnt2dArray[0]);
            return pnt2d;
        }
        double d3 = d2 / 2.0;
        for (int i3 = 0; i3 < pnt2dArray.length - 1; ++i3) {
            if (d3 > dArray[i3]) {
                d3 -= dArray[i3];
                continue;
            }
            double d4 = d3 / dArray[i3];
            pnt2d.interpolate(pnt2dArray[i3], pnt2dArray[i3 + 1], d4);
            break;
        }
        return pnt2d;
    }

    @Override
    public void remove() {
        ILabelPresentation iLabelPresentation;
        int n2;
        super.remove();
        if (this.namePresentation != null) {
            this.namePresentation.setCompositeParent(null);
            this.namePresentation = null;
        }
        if (this.stereotypePresentation != null) {
            this.stereotypePresentation.setCompositeParent(null);
            this.stereotypePresentation = null;
        }
        if (this.stereotypePresentations != null) {
            for (n2 = 0; n2 < this.stereotypePresentations.size(); ++n2) {
                iLabelPresentation = (ILabelPresentation)this.stereotypePresentations.get(n2);
                iLabelPresentation.setCompositeParent(null);
                iLabelPresentation = null;
            }
        }
        if (this.constraintPresentations != null) {
            for (n2 = 0; n2 < this.constraintPresentations.size(); ++n2) {
                iLabelPresentation = (ILabelPresentation)this.constraintPresentations.get(n2);
                iLabelPresentation.setCompositeParent(null);
                iLabelPresentation = null;
            }
        }
    }

    private void updateStereotypePresentation() {
        this.removeUnexistedStereotypePresentation();
        for (int i2 = 0; i2 < this.stereotypePresentations.size(); ++i2) {
            this.updateStereotypePresentation(i2);
        }
    }

    protected void removeUnexistedStereotypePresentation() {
        List list = this.getVisibleStereotypes();
        int n2 = this.stereotypePresentations.size();
        if (list.size() < n2) {
            for (int i2 = 0; i2 < n2 - list.size(); ++i2) {
                ILabelPresentation iLabelPresentation = (ILabelPresentation)this.stereotypePresentations.get(n2 - 1 - i2);
                for (int i3 = 0; i3 < n2 - 1 - i2; ++i3) {
                    ILabelPresentation iLabelPresentation2 = (ILabelPresentation)this.stereotypePresentations.get(i3);
                    iLabelPresentation2.removeClient(iLabelPresentation);
                    iLabelPresentation.removeClient(iLabelPresentation2);
                }
                this.stereotypePresentations.remove(n2 - 1 - i2);
            }
        }
    }

    @Override
    public ILabelPresentation getStereotypePresentation(int n2) {
        if (this.stereotypePresentations.size() == n2) {
            this.setChanged();
            this.setStereotypePresentation(n2, new LabelPresentation());
            this.updateStereotypePresentation();
        }
        return (ILabelPresentation)this.stereotypePresentations.get(n2);
    }

    @Override
    public void addStereotypePresentation(ILabelPresentation iLabelPresentation) {
        this.setChanged();
        iLabelPresentation.setCompositeParent(this);
        this.stereotypePresentations.add(iLabelPresentation);
    }

    @Override
    public void setStereotypePresentation(int n2, ILabelPresentation iLabelPresentation) {
        this.setChanged();
        iLabelPresentation.setCompositeParent(this);
        if (n2 > 0 && n2 < this.stereotypePresentations.size()) {
            this.stereotypePresentations.set(n2, iLabelPresentation);
        } else if (n2 == this.stereotypePresentations.size()) {
            this.stereotypePresentations.add(iLabelPresentation);
        } else {
            e.b();
        }
    }

    @Override
    public void updateStereotypePresentation(int n2) {
        if (n2 < 0 || n2 >= this.stereotypePresentations.size()) {
            return;
        }
        this.setChanged();
        ILabelPresentation iLabelPresentation = (ILabelPresentation)this.stereotypePresentations.get(n2);
        iLabelPresentation.setLabel(this.getStereotypeString(n2));
        iLabelPresentation.resize();
        Pnt2d pnt2d = this.getDefaultStereotypePnt();
        if (pnt2d != null) {
            double d2 = y.b(iLabelPresentation.getFont(), iLabelPresentation.getLabel());
            double d3 = this.model == null ? 0.0 : (double)(this.getStereotypeCount() - n2 - 1) * d2;
            pnt2d.setLocation(pnt2d.x - iLabelPresentation.getWidth() / 2.0, pnt2d.y - iLabelPresentation.getHeight() - d3);
            iLabelPresentation.setLocation(pnt2d);
        }
    }

    @Override
    public List getStereotypePresentations() {
        return this.stereotypePresentations;
    }

    @Override
    public void setStereotypePresentations(List list) {
        this.setChanged();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ((ILabelPresentation)list.get(i2)).setCompositeParent(this);
        }
        this.stereotypePresentations = list;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.stereotypePresentations == null) {
            this.stereotypePresentations = new ArrayList(0);
            if (this.stereotypePresentation != null) {
                this.stereotypePresentations.add(this.stereotypePresentation);
                this.stereotypePresentation = null;
            }
        }
        if (this.constraintPresentations == null) {
            this.constraintPresentations = new ArrayList(0);
        }
    }

    @Override
    public void validate(JomtEntityStore jomtEntityStore) {
        this.validateNamePresentation();
        this.validateStereotypePresentation();
        this.validatePoint();
        this.validateAllPoints();
        this.validateOuterPoints();
        super.validate(jomtEntityStore);
    }

    private void validateNamePresentation() {
        ILabelPresentation iLabelPresentation = this.getNamePresentation();
        if (iLabelPresentation == null) {
            this.nullErrorMsg(this, "namePresentation");
        } else {
            IUPresentation iUPresentation = iLabelPresentation.getCompositeParent();
            if (iUPresentation != this) {
                this.inverseErrorMsg(this, "namePresentation");
            }
        }
    }

    private void validateStereotypePresentation() {
        List list = this.getStereotypePresentations();
        for (ILabelPresentation iLabelPresentation : list) {
            IUPresentation iUPresentation = iLabelPresentation.getCompositeParent();
            if (iUPresentation == this) continue;
            this.inverseErrorMsg(this, "stereotypePs");
        }
    }

    private void validatePoint() {
    }

    private void validateAllPoints() {
    }

    private void validateOuterPoints() {
    }

    @Override
    public boolean attributesEqual(UPresentation uPresentation) {
        LabelPresentation labelPresentation;
        if (!(uPresentation instanceof PathPresentation)) {
            return false;
        }
        PathPresentation pathPresentation = (PathPresentation)uPresentation;
        if (pathPresentation.points.length == this.points.length) {
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                if (pathPresentation.points[i2].equals(this.points[i2])) continue;
                return false;
            }
        } else {
            return false;
        }
        LabelPresentation labelPresentation2 = (LabelPresentation)this.getNamePresentation();
        if (!this.attributeEquals(labelPresentation2, labelPresentation = (LabelPresentation)pathPresentation.getNamePresentation())) {
            return false;
        }
        return super.attributesEqual(pathPresentation);
    }

    private boolean attributeEquals(LabelPresentation labelPresentation, LabelPresentation labelPresentation2) {
        if (labelPresentation == null && labelPresentation2 != null) {
            return false;
        }
        return labelPresentation.attributesEqual(labelPresentation2);
    }

    @Override
    public void attributesCopy(UPresentation uPresentation) {
        super.attributesCopy(uPresentation);
        if (!(uPresentation instanceof PathPresentation)) {
            return;
        }
        PathPresentation pathPresentation = (PathPresentation)uPresentation;
        this.points = pathPresentation.getPoints();
        LabelPresentation labelPresentation = (LabelPresentation)this.getNamePresentation();
        LabelPresentation labelPresentation2 = (LabelPresentation)pathPresentation.getNamePresentation();
        if (labelPresentation != null && labelPresentation2 != null) {
            labelPresentation.attributesCopy(labelPresentation2);
        }
    }

    private void updateConstraintPresentation() {
        if (this.constraintPresentations == null) {
            return;
        }
        if (this.model != null) {
            this.removeUnexistedConstraintPresentation();
        }
        for (int i2 = 0; i2 < this.constraintPresentations.size(); ++i2) {
            this.updateConstraintPresentation(i2);
        }
    }

    protected void removeUnexistedConstraintPresentation() {
        List list = this.getConstraintModels();
        int n2 = this.constraintPresentations.size();
        if (list.size() < n2) {
            for (int i2 = 0; i2 < n2 - list.size(); ++i2) {
                ILabelPresentation iLabelPresentation = (ILabelPresentation)this.constraintPresentations.get(n2 - 1 - i2);
                for (int i3 = 0; i3 < n2 - 1 - i2; ++i3) {
                    ILabelPresentation iLabelPresentation2 = (ILabelPresentation)this.constraintPresentations.get(i3);
                    iLabelPresentation2.removeClient(iLabelPresentation);
                    iLabelPresentation.removeClient(iLabelPresentation2);
                }
                this.constraintPresentations.remove(n2 - 1 - i2);
            }
        }
    }

    @Override
    public void updateConstraintPresentation(int n2) {
        if (n2 < 0 || n2 >= this.constraintPresentations.size()) {
            return;
        }
        this.setChanged();
        ILabelPresentation iLabelPresentation = (ILabelPresentation)this.constraintPresentations.get(n2);
        Pnt2d pnt2d = this.getDefaultConstraintPnt();
        String string = this.getConstraintString(n2);
        iLabelPresentation.setLabel(string);
        iLabelPresentation.resize();
        if (pnt2d != null) {
            double d2 = y.b(iLabelPresentation.getFont(), iLabelPresentation.getLabel());
            double d3 = this.model == null ? 0.0 : (double)this.computeRowsOfConstraints(n2) * d2;
            iLabelPresentation.setHeight(this.getConstraintHeight(iLabelPresentation));
            iLabelPresentation.setWidth(this.getConstraintWidth(iLabelPresentation));
            double d4 = pnt2d.x - iLabelPresentation.getWidth() / 2.0;
            double d5 = pnt2d.y + d3;
            iLabelPresentation.setLocation(new Pnt2d(d4, d5));
        }
    }

    private Pnt2d getTailConstraintPnt() {
        if (this.constraintPresentations.size() < 1) {
            return this.getDefaultConstraintPnt();
        }
        ILabelPresentation iLabelPresentation = (ILabelPresentation)this.constraintPresentations.get(this.constraintPresentations.size() - 1);
        double d2 = iLabelPresentation.getLocation().getX() + iLabelPresentation.getWidth() / 2.0;
        double d3 = iLabelPresentation.getLocation().getY() + iLabelPresentation.getHeight();
        Pnt2d pnt2d = new Pnt2d(d2, d3);
        return pnt2d;
    }

    @Override
    public Pnt2d getDefaultConstraintPnt() {
        Pnt2d pnt2d = this.getDefaultNamePnt();
        if (pnt2d == null) {
            return null;
        }
        String string = this.getName();
        if (string != null && !this.getName().equals("")) {
            pnt2d.y += this.getNamePresentation().getLabelHeight();
        }
        return pnt2d;
    }

    protected int computeRowsOfConstraints(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += this.getConstraintRows(this.getConstraintStringWithBracket(i2));
        }
        return n3;
    }

    protected double getConstraintHeight(ILabelPresentation iLabelPresentation) {
        return (double)this.getConstraintRows(iLabelPresentation.getLabel()) * y.b(iLabelPresentation.getFont(), iLabelPresentation.getLabel());
    }

    protected int getConstraintRows(String string) {
        int n2 = 1;
        int n3 = 0;
        while (string.indexOf("\n", n3) != -1) {
            n3 = string.indexOf("\n", n3) + 1;
            ++n2;
        }
        return n2;
    }

    protected double getConstraintWidth(ILabelPresentation iLabelPresentation) {
        String[] stringArray = iLabelPresentation.getLabel().split("\n");
        double d2 = 0.0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            double d3 = this.getWidthOfString(iLabelPresentation.getFont(), "{" + stringArray[i2] + "}");
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    protected double getConstraintWidth(ILabelPresentation iLabelPresentation, String string) {
        String[] stringArray = string.split("\n");
        double d2 = 0.0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            double d3 = this.getWidthOfString(iLabelPresentation.getFont(), stringArray[i2]);
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    private double getWidthOfString(Font font, String string) {
        return y.a(font, string);
    }

    @Override
    public void addConstraintPresentation(ILabelPresentation iLabelPresentation) {
        this.setChanged();
        iLabelPresentation.setCompositeParent(this);
        for (int i2 = 0; i2 < this.constraintPresentations.size(); ++i2) {
            ILabelPresentation iLabelPresentation2 = (ILabelPresentation)this.constraintPresentations.get(i2);
            iLabelPresentation2.addClient(iLabelPresentation);
            iLabelPresentation.addClient(iLabelPresentation2);
        }
        this.constraintPresentations.add(iLabelPresentation);
    }

    public void addConstraintPresentationXMI(ILabelPresentation iLabelPresentation) {
        this.setChanged();
        iLabelPresentation.setCompositeParent(this);
        if (this.constraintPresentations == null) {
            this.constraintPresentations = new ArrayList();
        }
        this.constraintPresentations.add(iLabelPresentation);
    }

    @Override
    public void setConstraintPresentation(int n2, ILabelPresentation iLabelPresentation) {
        if (this.constraintPresentations == null) {
            return;
        }
        this.setChanged();
        iLabelPresentation.setCompositeParent(this);
        if (n2 > 0 && n2 < this.constraintPresentations.size()) {
            this.constraintPresentations.set(n2, iLabelPresentation);
        } else if (n2 == this.constraintPresentations.size()) {
            if (this.isCalculateConstraintLocation()) {
                for (int i2 = 0; i2 < this.constraintPresentations.size(); ++i2) {
                    ILabelPresentation iLabelPresentation2 = (ILabelPresentation)this.constraintPresentations.get(i2);
                    iLabelPresentation2.addClient(iLabelPresentation);
                    iLabelPresentation.addClient(iLabelPresentation2);
                }
                Pnt2d pnt2d = this.getTailConstraintPnt();
                iLabelPresentation.setWidth(this.getConstraintWidth(iLabelPresentation, this.getConstraintStringWithBracket(this.constraintPresentations.size())));
                double d2 = pnt2d.x - iLabelPresentation.getWidth() / 2.0;
                double d3 = pnt2d.y;
                iLabelPresentation.setLocation(new Pnt2d(d2, d3));
                if (this.constraintPresentations.size() > 0) {
                    ILabelPresentation iLabelPresentation3 = (ILabelPresentation)this.constraintPresentations.get(0);
                    Vec2d vec2d = iLabelPresentation3.getLocalMovement();
                    iLabelPresentation.setLocalMovement(new Vec2d(vec2d));
                }
            }
            this.constraintPresentations.add(iLabelPresentation);
        } else {
            e.b();
        }
    }

    @Override
    public List getConstraintPresentations() {
        return this.constraintPresentations;
    }

    @Override
    public void setConstraintPresentations(List list) {
        this.setChanged();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ILabelPresentation iLabelPresentation = (ILabelPresentation)list.get(i2);
            iLabelPresentation.setCompositeParent(this);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                if (i3 == i2) continue;
                ILabelPresentation iLabelPresentation2 = (ILabelPresentation)list.get(i3);
                iLabelPresentation.addClient(iLabelPresentation2);
                iLabelPresentation2.addClient(iLabelPresentation);
            }
        }
        this.constraintPresentations = list;
    }

    @Override
    public ILabelPresentation getConstraintPresentation(int n2) {
        if (this.constraintPresentations == null) {
            this.constraintPresentations = new ArrayList(0);
        }
        if (this.constraintPresentations.size() == n2) {
            this.setConstraintPresentation(n2, new LabelPresentation());
            this.updateConstraintPresentation();
        }
        return (ILabelPresentation)this.constraintPresentations.get(n2);
    }

    private int getStereotypeCount() {
        List list = this.getVisibleStereotypes();
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        return string.equals("font") || string.equals("font.color");
    }

    @Override
    public String getDefaultStyleFromSystem(String string) {
        if (string.equals("font.color")) {
            return "#000000";
        }
        return super.getDefaultStyleFromSystem(string);
    }

    @Override
    public List getVisibleStereotypes() {
        ArrayList<UStereotype> arrayList = new ArrayList<UStereotype>();
        List list = super.getVisibleStereotypes();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            UStereotype uStereotype = (UStereotype)list.get(i2);
            if (this.model instanceof UUsageImp && i2 == 0 && ("use".equals(uStereotype.getNameString()) || "realize".equals(uStereotype.getNameString()))) continue;
            arrayList.add(uStereotype);
        }
        return arrayList;
    }

    protected boolean isCalculateConstraintLocation() {
        return true;
    }
}

