/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.jomt.jmodel.MindMapProperty;
import JP.co.esm.caddies.jomt.jmodel.MindmapStyleTemplateItem;
import JP.co.esm.caddies.jomt.jmodel.Template;
import JP.co.esm.caddies.jomt.jmodel.TemplateItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MindmapStyleTemplate
extends Template {
    private static final long serialVersionUID = -5767817859421744995L;
    private static final String MINDMAP_STYLE_BUILD_IN_TEMPLATE = "mindmap_style.built_in.template";
    private static List builtInTemplates = null;
    private static MindMapProperty prop = MindMapProperty.getInstance();
    private String key;
    private Map itemMap = new HashMap();

    private MindmapStyleTemplate(String string) {
        super(string);
        this.itemMap = new HashMap();
    }

    public MindmapStyleTemplate(String string, MindmapStyleTemplate mindmapStyleTemplate) {
        super(string, mindmapStyleTemplate);
        this.key = MindmapStyleTemplate.getDifferentKey();
        this.itemMap = new HashMap();
        Iterator iterator = this.getAllTemplateItems();
        while (iterator.hasNext()) {
            MindmapStyleTemplateItem mindmapStyleTemplateItem = (MindmapStyleTemplateItem)iterator.next();
            this.itemMap.put(mindmapStyleTemplateItem.getKey(), mindmapStyleTemplateItem);
        }
    }

    public static List getAllTemplates() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(MindmapStyleTemplate.getBuiltInTemplates());
        arrayList.addAll(MindmapStyleTemplate.getCustomizedTemplates());
        return arrayList;
    }

    private static List getCustomizedTemplates() {
        return MindmapStyleTemplate.getTemplates("mindmap_style.customized", false);
    }

    private static List getTemplates(String string, boolean bl2) {
        ArrayList<MindmapStyleTemplate> arrayList = new ArrayList<MindmapStyleTemplate>();
        String[] stringArray = prop.getSubKeys(string);
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                MindmapStyleTemplate mindmapStyleTemplate;
                if (MindmapStyleTemplate.isSameWithPrevious(stringArray, i2) || (mindmapStyleTemplate = MindmapStyleTemplate.createTemplate(stringArray[i2], bl2)) == null) continue;
                arrayList.add(mindmapStyleTemplate);
            }
        }
        return arrayList;
    }

    private static MindmapStyleTemplate createTemplate(String string, boolean bl2) {
        String string2 = prop.getTemplateName(string);
        String string3 = prop.getTemlateLabel(string);
        if (string2 == null || string2.equals("")) {
            return null;
        }
        if (bl2) {
            string = string2;
        }
        MindmapStyleTemplate mindmapStyleTemplate = new MindmapStyleTemplate(string2);
        mindmapStyleTemplate.setKey(string);
        mindmapStyleTemplate.setName(string3);
        String[] stringArray = prop.getTemplateItems(MINDMAP_STYLE_BUILD_IN_TEMPLATE);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            MindmapStyleTemplateItem mindmapStyleTemplateItem = MindmapStyleTemplateItem.createItem(prop, string, stringArray[i2]);
            if (mindmapStyleTemplateItem == null) continue;
            mindmapStyleTemplate.addTemplateItem(mindmapStyleTemplateItem);
        }
        return mindmapStyleTemplate;
    }

    private void setKey(String string) {
        this.key = string;
    }

    private static boolean isSameWithPrevious(String[] stringArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!stringArray[i2].equals(stringArray[n2])) continue;
            return true;
        }
        return false;
    }

    private static List getBuiltInTemplates() {
        if (builtInTemplates == null) {
            builtInTemplates = MindmapStyleTemplate.getTemplates("mindmap_style.built_in", true);
        }
        return builtInTemplates;
    }

    public static MindmapStyleTemplate getAppliedTemplate() {
        String string = prop.getDefaultString("mindmap_style.applied");
        if (string != null && !string.equals("")) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(MindmapStyleTemplate.getCustomizedTemplates());
            arrayList.addAll(MindmapStyleTemplate.getBuiltInTemplates());
            for (MindmapStyleTemplate mindmapStyleTemplate : arrayList) {
                if (mindmapStyleTemplate.getKey() == null || !mindmapStyleTemplate.getKey().equals(string)) continue;
                return mindmapStyleTemplate;
            }
        }
        return MindmapStyleTemplate.getDefaultTemplate();
    }

    public static MindmapStyleTemplate getDefaultTemplate() {
        return (MindmapStyleTemplate)MindmapStyleTemplate.getBuiltInTemplates().get(0);
    }

    public String getKey() {
        return this.key;
    }

    private static String getDifferentKey() {
        List list = MindmapStyleTemplate.getAllKeys();
        int n2 = 0;
        String string;
        while (list.contains(string = "mindmap_style.customized.customized" + n2)) {
            ++n2;
        }
        return string;
    }

    private static List getAllKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MindmapStyleTemplate mindmapStyleTemplate : MindmapStyleTemplate.getCustomizedTemplates()) {
            arrayList.add(mindmapStyleTemplate.getKey());
        }
        return arrayList;
    }

    public void store() {
        this.store(null);
    }

    private void store(String string) {
        Object object;
        Object object2;
        if (this.isBuiltInTemplate()) {
            prop.setValue("mindmap_style.customized", this.key);
        } else if (this.isNewKey()) {
            object2 = prop.getDefaultString("mindmap_style.customized");
            object = this.key;
            if (object2 != null) {
                object = (String)object2 + " " + this.key;
            }
            prop.setValue("mindmap_style.customized", object);
            prop.setValue(this.key + ".name", this.getName());
        }
        prop.setValue(this.key + ".name.label", this.getName());
        object2 = new ArrayList();
        object = this.getAllTemplateItems();
        while (object.hasNext()) {
            MindmapStyleTemplateItem mindmapStyleTemplateItem = (MindmapStyleTemplateItem)object.next();
            String string2 = this.key + "." + mindmapStyleTemplateItem.getKey();
            object2.add(string2);
            prop.setValue(string2, mindmapStyleTemplateItem.getItemValue());
        }
        prop.setValue(this.key + ".items", this.getString((List)object2));
        prop.store(string);
    }

    public void storeModifiedValues(Map map, String string) {
        for (String string2 : map.keySet()) {
            String string3 = (String)map.get(string2);
            prop.setValue(string2, string3);
        }
        prop.store(string);
    }

    public boolean isBuiltInTemplate() {
        return !this.key.startsWith("mindmap_style.customized");
    }

    private boolean isNewKey() {
        String[] stringArray = prop.getSubKeys("mindmap_style.customized");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals(this.key)) continue;
            return false;
        }
        return true;
    }

    private String getString(List list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    @Override
    public void addTemplateItem(TemplateItem templateItem) {
        super.addTemplateItem(templateItem);
        this.itemMap.put(((MindmapStyleTemplateItem)templateItem).getKey(), templateItem);
    }

    public String getItemValue(String string) {
        MindmapStyleTemplateItem mindmapStyleTemplateItem = (MindmapStyleTemplateItem)this.itemMap.get(string);
        if (mindmapStyleTemplateItem == null) {
            return null;
        }
        return mindmapStyleTemplateItem.getItemValue();
    }

    public void remove() {
        String[] stringArray = prop.getSubKeys("mindmap_style.customized");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].equals(this.key)) continue;
            arrayList.add(stringArray[i2]);
        }
        prop.setValue("mindmap_style.customized", this.getString(arrayList));
        prop.remove(this.key + ".name.label");
        prop.remove(this.key + ".name");
        prop.remove(this.key + ".items");
        Iterator iterator = this.getAllTemplateItems();
        while (iterator.hasNext()) {
            MindmapStyleTemplateItem mindmapStyleTemplateItem = (MindmapStyleTemplateItem)iterator.next();
            this.removeItem(mindmapStyleTemplateItem.getKey());
        }
        prop.store(null);
    }

    private void removeItem(String string) {
        String string2 = this.key + "." + string;
        prop.remove(string2);
    }

    public boolean isApplied() {
        String string = prop.getDefaultString("mindmap_style.applied");
        if (string == null) {
            return this.isBuiltInTemplate();
        }
        return string.equals(this.getKey());
    }

    public void apply() {
        prop.setValue("mindmap_style.applied", this.getKey());
        prop.store(null);
    }

    public void export(String string) {
        MindMapProperty mindMapProperty = (MindMapProperty)prop.clone();
        prop.clear();
        this.store(string);
        prop.putAll((Map<?, ?>)mindMapProperty);
        prop.store(null);
    }

    public static MindmapStyleTemplate importTemplate(String string) {
        MindMapProperty mindMapProperty = (MindMapProperty)prop.clone();
        String string2 = MindmapStyleTemplate.getDifferentKey();
        List list = MindmapStyleTemplate.getAllNames();
        prop.clear();
        prop.load(string);
        String string3 = prop.getDefaultString("mindmap_style.customized");
        MindmapStyleTemplate mindmapStyleTemplate = MindmapStyleTemplate.createTemplate(string3, false);
        String string4 = MindmapStyleTemplate.getDifferentName(mindmapStyleTemplate.getName(), list);
        if (!string4.equals(mindmapStyleTemplate.getName())) {
            mindmapStyleTemplate.setName(string4);
        }
        if (!string2.equals(mindmapStyleTemplate.getKey())) {
            mindmapStyleTemplate.setKey(string2);
            Object[] objectArray = prop.keySet().toArray();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                String string5 = (String)objectArray[i2];
                String string6 = string5.replaceFirst(string3, string2);
                prop.put(string6, prop.get(string5));
                prop.remove(string5);
            }
        }
        prop.putAll((Map<?, ?>)mindMapProperty);
        mindmapStyleTemplate.store();
        return mindmapStyleTemplate;
    }

    private static String getDifferentName(String string, List list) {
        if (!list.contains(string)) {
            return string;
        }
        int n2 = 0;
        String string2;
        while (list.contains(string2 = string + "(" + n2 + ")")) {
            ++n2;
        }
        return string2;
    }

    private static List getAllNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MindmapStyleTemplate mindmapStyleTemplate : MindmapStyleTemplate.getAllTemplates()) {
            arrayList.add(mindmapStyleTemplate.getName());
        }
        return arrayList;
    }
}

