/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.geom2D.Rectangle2d;
import JP.co.esm.caddies.golf.geom2D.Vec2d;
import JP.co.esm.caddies.golf.util.h;
import JP.co.esm.caddies.jomt.jmodel.IImagePresentation;
import JP.co.esm.caddies.jomt.jmodel.IJomtPresentation;
import JP.co.esm.caddies.jomt.jmodel.IMMBoundaryPresentation;
import JP.co.esm.caddies.jomt.jmodel.IMMEdgePresentation;
import JP.co.esm.caddies.jomt.jmodel.IMMLinkPresentation;
import JP.co.esm.caddies.jomt.jmodel.IMMTopicPresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.TextPresentation;
import JP.co.esm.caddies.jomt.jmodel.w;
import JP.co.esm.caddies.jomt.jsystem.i;
import JP.co.esm.caddies.jomt.jutil.I;
import JP.co.esm.caddies.jomt.jutil.JomtUtilities;
import JP.co.esm.caddies.jomt.jutil.JomtUtilities2;
import JP.co.esm.caddies.jomt.jutil.y;
import JP.co.esm.caddies.uml.Foundation.Core.IUPresentation;
import JP.co.esm.caddies.uml.Foundation.Core.UPresentation;
import JP.co.esm.caddies.uml.mindmap.MMUserIconInfo;
import JP.co.esm.caddies.uml.mindmap.MMUserIconManager;
import JP.co.esm.caddies.uml.mindmap.UMindMapDiagram;
import JP.co.esm.caddies.uml.mindmap.UserIcon;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MMTopicPresentation
extends TextPresentation
implements IMMTopicPresentation {
    static final long serialVersionUID = -7157015426138780164L;
    private IMMTopicPresentation parent;
    private List children = new ArrayList();
    private String position = "right";
    private transient double rightBranchHeight = 0.0;
    private transient double leftBranchHeight = 0.0;
    private boolean isFolded = false;
    private Map customStyleMap = null;
    private boolean fixHorizontalPosition = false;
    private String note;
    private IMMEdgePresentation edge;
    private IMMBoundaryPresentation boundary;
    private List icons;
    private IImagePresentation imagePresentation;
    private int index;
    private static final Logger logger = LoggerFactory.getLogger(MMTopicPresentation.class);

    @Override
    public void move(Vec2d vec2d) {
        super.move(vec2d);
        this.setFixHorizontalPosition(true);
    }

    @Override
    public void update(Observable observable, Object object) {
        super.update(observable, null);
    }

    @Override
    public void storeState(Hashtable hashtable) {
        if (this.parent != null) {
            hashtable.put("parent", this.parent);
        }
        hashtable.put("hasParent", this.parent != null);
        if (this.children != null) {
            hashtable.put("children", h.a(this.children));
        }
        hashtable.put("position", this.position);
        hashtable.put("topicIndex", this.index);
        hashtable.put("isFolded", this.isFolded);
        hashtable.put("fixHorizontalPosition", this.fixHorizontalPosition);
        if (this.note != null) {
            hashtable.put("note", this.note);
        }
        if (this.edge != null) {
            hashtable.put("edge", this.edge);
        }
        hashtable.put("hasEdge", this.edge != null);
        if (this.boundary != null) {
            hashtable.put("boundary", this.boundary);
            hashtable.put("is_boundary_exist", Boolean.TRUE);
        } else {
            hashtable.put("is_boundary_exist", Boolean.FALSE);
        }
        if (this.icons != null) {
            hashtable.put("icons", h.a(this.icons));
            hashtable.put("is_icons_exists", Boolean.TRUE);
        } else {
            hashtable.put("is_icons_exists", Boolean.FALSE);
        }
        if (this.imagePresentation != null) {
            IImagePresentation iImagePresentation = (IImagePresentation)this.imagePresentation.clone();
            iImagePresentation.setCompositeParent(this.imagePresentation.getCompositeParent());
            hashtable.put("imagePresentation", iImagePresentation);
            hashtable.put("is_imagePresentation_exists", Boolean.TRUE);
        } else {
            hashtable.put("is_imagePresentation_exists", Boolean.FALSE);
        }
        super.storeState(hashtable);
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        Object v2;
        this.setChanged();
        if (hashtable.get("parent") != null) {
            this.parent = (IMMTopicPresentation)hashtable.get("parent");
        }
        if (hashtable.get("hasParent") instanceof Boolean && !((Boolean)hashtable.get("hasParent")).booleanValue()) {
            this.parent = null;
        }
        if ((List)hashtable.get("children") != null) {
            this.children = h.a((List)hashtable.get("children"));
        }
        if ((String)hashtable.get("position") != null) {
            this.position = (String)hashtable.get("position");
        }
        if (hashtable.get("topicIndex") instanceof Integer) {
            this.index = (Integer)hashtable.get("topicIndex");
        }
        if ((Boolean)hashtable.get("isFolded") != null) {
            this.isFolded = (Boolean)hashtable.get("isFolded");
        }
        if ((Boolean)hashtable.get("fixHorizontalPosition") != null) {
            this.fixHorizontalPosition = (Boolean)hashtable.get("fixHorizontalPosition");
        }
        if ((String)hashtable.get("note") != null) {
            this.note = (String)hashtable.get("note");
        }
        if ((IMMEdgePresentation)hashtable.get("edge") != null) {
            this.edge = (IMMEdgePresentation)hashtable.get("edge");
        }
        if (hashtable.get("hasEdge") instanceof Boolean && !((Boolean)hashtable.get("hasEdge")).booleanValue()) {
            this.edge = null;
        }
        if ((IMMBoundaryPresentation)hashtable.get("boundary") != null) {
            this.boundary = (IMMBoundaryPresentation)hashtable.get("boundary");
        }
        if (hashtable.get("is_boundary_exist") != null && !((Boolean)hashtable.get("is_boundary_exist")).booleanValue()) {
            this.boundary = null;
        }
        if (hashtable.get("icons") != null) {
            this.icons = h.a((List)hashtable.get("icons"));
        }
        if (hashtable.get("is_icons_exists") != null && !((Boolean)hashtable.get("is_icons_exists")).booleanValue()) {
            this.icons = null;
        }
        if ((v2 = hashtable.get("imagePresentation")) instanceof IImagePresentation) {
            IImagePresentation iImagePresentation = (IImagePresentation)hashtable.get("imagePresentation");
            IImagePresentation iImagePresentation2 = (IImagePresentation)iImagePresentation.clone();
            iImagePresentation2.setCompositeParent(iImagePresentation.getCompositeParent());
            this.imagePresentation = iImagePresentation2;
        }
        if (hashtable.get("is_imagePresentation_exists") != null && !((Boolean)hashtable.get("is_imagePresentation_exists")).booleanValue()) {
            this.imagePresentation = null;
        }
        super.restoreState(hashtable);
    }

    @Override
    public Object clone() {
        MMTopicPresentation mMTopicPresentation = (MMTopicPresentation)super.clone();
        if (this.parent != null) {
            mMTopicPresentation.setParent(this.parent);
        }
        if (this.children != null) {
            mMTopicPresentation.setChildren(h.a(this.children));
        }
        mMTopicPresentation.setPosition(this.position);
        mMTopicPresentation.setTopicIndex(this.getTopicIndex());
        mMTopicPresentation.setFolded(this.isFolded);
        mMTopicPresentation.setFixHorizontalPosition(this.fixHorizontalPosition);
        if (this.note != null) {
            mMTopicPresentation.setNote(this.note);
        }
        if (this.edge != null) {
            mMTopicPresentation.setEdge(this.edge);
        }
        if (this.boundary != null) {
            mMTopicPresentation.setBoundary(this.boundary);
        }
        if (this.icons != null) {
            mMTopicPresentation.setIcons(h.a(this.icons));
        }
        if (this.imagePresentation != null) {
            mMTopicPresentation.imagePresentation = (IImagePresentation)this.imagePresentation.clone();
            if (this.imagePresentation.getCompositeParent() != null) {
                mMTopicPresentation.imagePresentation.setCompositeParent(mMTopicPresentation);
            }
        }
        return mMTopicPresentation;
    }

    @Override
    public void remove() {
        UMindMapDiagram uMindMapDiagram = (UMindMapDiagram)this.getDiagram();
        uMindMapDiagram.removeFloatingTopic(this);
        super.remove();
        if (this.children != null) {
            this.children = null;
        }
        if (this.parent != null) {
            this.parent.removeChildren(this);
            this.parent = null;
        }
        if (this.edge != null) {
            this.edge = null;
        }
        if (this.boundary != null) {
            this.boundary = null;
        }
        if (this.icons != null) {
            this.icons = null;
        }
        if (this.imagePresentation != null) {
            this.imagePresentation.remove();
            this.imagePresentation.setCompositeParent(null);
            this.imagePresentation = null;
        }
    }

    @Override
    public void validate(JomtEntityStore jomtEntityStore) {
        super.validate(jomtEntityStore);
        this.validatePosition();
        this.validateNull();
        this.validateChildren(jomtEntityStore);
        this.validateEdge();
        this.validateIcons();
    }

    private void validatePosition() {
        String string;
        if (this.isTop() && (string = this.getPosition()) != null && !string.equals("center")) {
            this.errorMsg(this, "this root topic's position should be center.");
        }
    }

    private void validateNull() {
        if (!this.isTop() && this.edge == null) {
            this.nullErrorMsg(this, "edge");
        }
    }

    private void validateChildren(JomtEntityStore jomtEntityStore) {
        for (IMMTopicPresentation iMMTopicPresentation : this.children) {
            if (!iMMTopicPresentation.isValid()) {
                this.isValidErrorMsg(this, "children");
            }
            if (!jomtEntityStore.e(iMMTopicPresentation)) {
                this.entityErrorMsg(this, "children");
            }
            if (iMMTopicPresentation.getParent() == null) {
                this.nullErrorMsg(this, "children's parent topic");
            }
            if (iMMTopicPresentation.getParent() == null || iMMTopicPresentation.getParent().equals(this)) continue;
            this.errorMsg(this, "child parent topic of this is different from this");
        }
    }

    private void validateEdge() {
        if (!this.isTop() && this.edge.getParentTopic() != null && !this.edge.getParentTopic().equals(this.getParent())) {
            this.errorMsg(this, "edge's parent topic of this is different from parent topic of this");
        }
    }

    private void validateIcons() {
        if (this.icons != null) {
            for (Object e2 : this.icons) {
                if (e2 instanceof String) continue;
                this.isValidErrorMsg(this, "icons is not String");
            }
        }
    }

    @Override
    public boolean isRoot() {
        UMindMapDiagram uMindMapDiagram;
        if (this.getDiagram() != null && (uMindMapDiagram = (UMindMapDiagram)this.getDiagram()).getRoot() == this) {
            return true;
        }
        return this.isTop() && !this.isFloatingTopic();
    }

    @Override
    public boolean isFloatingTopic() {
        UMindMapDiagram uMindMapDiagram;
        if (this.isTop() && this.getDiagram() != null && (uMindMapDiagram = (UMindMapDiagram)this.getDiagram()).getFloatingTopics() != null) {
            return uMindMapDiagram.getFloatingTopics().contains(this);
        }
        return false;
    }

    @Override
    public boolean isTop() {
        return this.parent == null;
    }

    @Override
    public int getAllChildrenTopicNumber() {
        return this.children.size();
    }

    @Override
    public int getLeftChildrenTopicNumber() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            IMMTopicPresentation iMMTopicPresentation = (IMMTopicPresentation)this.children.get(i2);
            if (!iMMTopicPresentation.getPosition().equals("left")) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public List getLeftChildrenTopics() {
        ArrayList<IMMTopicPresentation> arrayList = new ArrayList<IMMTopicPresentation>();
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            IMMTopicPresentation iMMTopicPresentation = (IMMTopicPresentation)this.children.get(i2);
            if (!iMMTopicPresentation.getPosition().equals("left")) continue;
            arrayList.add(iMMTopicPresentation);
        }
        return arrayList;
    }

    @Override
    public int getRightChildrenTopicNumber() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            IMMTopicPresentation iMMTopicPresentation = (IMMTopicPresentation)this.children.get(i2);
            if (!iMMTopicPresentation.getPosition().equals("right")) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public List getRightChildrenTopics() {
        ArrayList<IMMTopicPresentation> arrayList = new ArrayList<IMMTopicPresentation>();
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            IMMTopicPresentation iMMTopicPresentation = (IMMTopicPresentation)this.children.get(i2);
            if (!iMMTopicPresentation.getPosition().equals("right")) continue;
            arrayList.add(iMMTopicPresentation);
        }
        return arrayList;
    }

    @Override
    public IMMTopicPresentation getRightFirstChild() {
        List list = this.getRightChildrenTopics();
        IMMTopicPresentation iMMTopicPresentation = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            iMMTopicPresentation = (IMMTopicPresentation)list.get(i2);
            if (iMMTopicPresentation.getPreChildTopic() != null) continue;
            return iMMTopicPresentation;
        }
        return iMMTopicPresentation;
    }

    @Override
    public IMMTopicPresentation getRightLastChild() {
        List list = this.getRightChildrenTopics();
        IMMTopicPresentation iMMTopicPresentation = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            iMMTopicPresentation = (IMMTopicPresentation)list.get(i2);
            if (iMMTopicPresentation.getNextChildTopic() != null) continue;
            return iMMTopicPresentation;
        }
        return iMMTopicPresentation;
    }

    @Override
    public IMMTopicPresentation getLeftFirstChild() {
        List list = this.getLeftChildrenTopics();
        IMMTopicPresentation iMMTopicPresentation = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            iMMTopicPresentation = (IMMTopicPresentation)list.get(i2);
            if (iMMTopicPresentation.getPreChildTopic() != null) continue;
            return iMMTopicPresentation;
        }
        return iMMTopicPresentation;
    }

    @Override
    public IMMTopicPresentation getLeftLastChild() {
        List list = this.getLeftChildrenTopics();
        IMMTopicPresentation iMMTopicPresentation = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            iMMTopicPresentation = (IMMTopicPresentation)list.get(i2);
            if (iMMTopicPresentation.getNextChildTopic() != null) continue;
            return iMMTopicPresentation;
        }
        return iMMTopicPresentation;
    }

    @Override
    public int getTopicIndex() {
        if (this.isTop()) {
            return this.index;
        }
        if (this.isRoot()) {
            return 0;
        }
        return this.getParent().getTopicIndex() + 1;
    }

    @Override
    public void setTopicIndex(int n2) {
        this.setChanged();
        this.index = n2;
    }

    @Override
    public IMMTopicPresentation getLastChildWithSameHierarchy(int n2) {
        if (this.isShowWithFolded()) {
            List list = this.getChildren();
            if (list.size() > 0) {
                IMMTopicPresentation iMMTopicPresentation = (IMMTopicPresentation)list.get(list.size() - 1);
                if (n2 == iMMTopicPresentation.getTopicIndex()) {
                    return iMMTopicPresentation;
                }
                return iMMTopicPresentation.getLastChildWithSameHierarchy(n2);
            }
            return this;
        }
        return this.getParent().getLastChildWithSameHierarchy(n2);
    }

    @Override
    public IMMTopicPresentation getFirstChildWithSameHierarchy(int n2) {
        if (this.isShowWithFolded()) {
            List list = this.getChildren();
            if (list.size() > 0) {
                IMMTopicPresentation iMMTopicPresentation = (IMMTopicPresentation)list.get(0);
                if (n2 == iMMTopicPresentation.getTopicIndex()) {
                    return iMMTopicPresentation;
                }
                return iMMTopicPresentation.getFirstChildWithSameHierarchy(n2);
            }
            return this;
        }
        return this.getParent().getFirstChildWithSameHierarchy(n2);
    }

    @Override
    public IMMTopicPresentation getPreChildTopic() {
        if (this.isTop()) {
            return null;
        }
        List list = this.getParent().getChildren(this.getPosition());
        int n2 = 0;
        if (list.size() > 1) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                IMMTopicPresentation iMMTopicPresentation = (IMMTopicPresentation)list.get(i2);
                if (!iMMTopicPresentation.equals(this)) continue;
                n2 = i2;
                break;
            }
            if (n2 - 1 >= 0) {
                return (IMMTopicPresentation)list.get(n2 - 1);
            }
            return null;
        }
        return null;
    }

    @Override
    public IMMTopicPresentation getNextChildTopic() {
        if (this.isTop()) {
            return null;
        }
        List list = this.getParent().getChildren(this.getPosition());
        int n2 = 0;
        if (list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                IMMTopicPresentation iMMTopicPresentation = (IMMTopicPresentation)list.get(i2);
                if (!iMMTopicPresentation.equals(this)) continue;
                n2 = i2;
                break;
            }
            if (n2 + 1 < list.size()) {
                return (IMMTopicPresentation)list.get(n2 + 1);
            }
            return null;
        }
        return null;
    }

    @Override
    public IMMTopicPresentation getNextRootChildTopic() {
        if (this.isTop()) {
            return null;
        }
        if (this.getParent().isTop()) {
            List list = this.getParent().getChildren(this.getPosition());
            int n2 = 0;
            if (list.size() > 0) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    IMMTopicPresentation iMMTopicPresentation = (IMMTopicPresentation)list.get(i2);
                    if (!iMMTopicPresentation.equals(this)) continue;
                    n2 = i2;
                    break;
                }
                if (n2 + 1 < list.size()) {
                    return (IMMTopicPresentation)list.get(n2 + 1);
                }
                return null;
            }
            return null;
        }
        return this.getParent().getNextRootChildTopic();
    }

    @Override
    public double getAllIconsHeight() {
        if (this.icons == null || this.icons.size() == 0) {
            return 0.0;
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.icons.size(); ++i2) {
            String string = (String)this.icons.get(i2);
            ImageIcon imageIcon = UPresentation.getImageIcon(string);
            if (!(d2 < (double)imageIcon.getIconHeight())) continue;
            d2 = imageIcon.getIconHeight();
        }
        return d2;
    }

    @Override
    public double getAllIconsWidth() {
        if (this.icons == null || this.icons.size() == 0) {
            return 0.0;
        }
        double d2 = 0.0;
        for (int i2 = 0; i2 < this.icons.size(); ++i2) {
            String string = (String)this.icons.get(i2);
            ImageIcon imageIcon = UPresentation.getImageIcon(string);
            d2 += (double)imageIcon.getIconWidth();
        }
        return d2;
    }

    @Override
    public double getImageHeight() {
        if (this.imagePresentation != null) {
            return this.imagePresentation.getHeight();
        }
        return 0.0;
    }

    @Override
    public double getImageWidth() {
        if (this.imagePresentation != null) {
            return this.imagePresentation.getWidth();
        }
        return 0.0;
    }

    @Override
    public void setParent(IMMTopicPresentation iMMTopicPresentation) {
        this.setChanged();
        if (this.parent == iMMTopicPresentation) {
            return;
        }
        this.parent = iMMTopicPresentation;
        if (iMMTopicPresentation == null) {
            this.setFolded(false);
        }
    }

    @Override
    public IMMTopicPresentation getParent() {
        return this.parent;
    }

    @Override
    public void setChildren(List list) {
        this.setChanged();
        this.children = list;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public List getChildren(String string) {
        ArrayList<IMMTopicPresentation> arrayList = new ArrayList<IMMTopicPresentation>();
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            IMMTopicPresentation iMMTopicPresentation = (IMMTopicPresentation)this.children.get(i2);
            if (!iMMTopicPresentation.getPosition().equals(string)) continue;
            arrayList.add(iMMTopicPresentation);
        }
        return arrayList;
    }

    @Override
    public void addChildren(IMMTopicPresentation iMMTopicPresentation) {
        this.setChanged();
        this.children.add(iMMTopicPresentation);
    }

    @Override
    public void addChildren(IMMTopicPresentation iMMTopicPresentation, int n2) {
        this.setChanged();
        n2 = Math.max(0, n2);
        n2 = Math.min(this.getChildren().size(), n2);
        logger.debug("index={}", (Object)n2);
        this.children.add(n2, iMMTopicPresentation);
    }

    @Override
    public void addChildren(IMMTopicPresentation iMMTopicPresentation, int n2, String string) {
        Object object;
        this.setChanged();
        n2 = Math.max(0, n2);
        n2 = Math.min(this.getChildren(string).size(), n2);
        iMMTopicPresentation.setPosition(string);
        if (logger.isDebugEnabled()) {
            int n3 = this.getRightChildrenTopicNumber();
            logger.debug("position={} index={} rightSize={}" + string, (Object)n2, (Object)n3);
            for (IMMTopicPresentation iMMTopicPresentation2 : this.children) {
                if (!(iMMTopicPresentation2 instanceof IMMTopicPresentation)) continue;
                object = iMMTopicPresentation2;
                String string2 = object.getLabel();
                logger.debug("children before:{}", (Object)string2);
            }
        }
        this.addTopicWithPosition(iMMTopicPresentation, n2, string);
        if (logger.isDebugEnabled()) {
            for (Object object2 : this.children) {
                IMMTopicPresentation iMMTopicPresentation2;
                if (!(object2 instanceof IMMTopicPresentation)) continue;
                iMMTopicPresentation2 = (IMMTopicPresentation)object2;
                object = iMMTopicPresentation2.getLabel();
                logger.debug("children after:{}", object);
            }
        }
    }

    private void addTopicWithPosition(IMMTopicPresentation iMMTopicPresentation, int n2, String string) {
        int n3 = n2;
        ArrayList<IMMTopicPresentation> arrayList = new ArrayList<IMMTopicPresentation>();
        ArrayList<IMMTopicPresentation> arrayList2 = new ArrayList<IMMTopicPresentation>();
        for (Object e2 : this.children) {
            if (!(e2 instanceof IMMTopicPresentation)) continue;
            IMMTopicPresentation iMMTopicPresentation2 = (IMMTopicPresentation)e2;
            if (iMMTopicPresentation2.getPosition().equalsIgnoreCase("right")) {
                arrayList.add(iMMTopicPresentation2);
                continue;
            }
            arrayList2.add(iMMTopicPresentation2);
        }
        Object object = null;
        object = string.equalsIgnoreCase("right") ? (arrayList.size() > n2 ? (IMMTopicPresentation)arrayList.get(n2) : null) : (arrayList2.size() > n2 ? (IMMTopicPresentation)arrayList2.get(n2) : null);
        if (object != null) {
            int n4 = this.children.indexOf(object);
            if (n4 != -1) {
                n3 = n4;
            }
            this.children.add(n3, iMMTopicPresentation);
        } else {
            this.children.add(iMMTopicPresentation);
        }
    }

    @Override
    public void removeChildren(IMMTopicPresentation iMMTopicPresentation) {
        if (this.children != null) {
            this.setChanged();
            this.children.remove(iMMTopicPresentation);
        }
    }

    @Override
    public void setPosition(String string) {
        this.setChanged();
        this.position = string;
    }

    @Override
    public void setPositionRecursively(String string) {
        this.setPosition(string);
        List list = this.getAllChildren();
        for (IMMTopicPresentation iMMTopicPresentation : list) {
            iMMTopicPresentation.setPosition(string);
        }
    }

    @Override
    public String getPosition() {
        return this.position;
    }

    @Override
    public boolean isPositionCenter() {
        return this.getPosition().equals("center");
    }

    @Override
    public boolean isPositionLeft() {
        return this.getPosition().equals("left");
    }

    @Override
    public boolean isPositionRight() {
        return this.getPosition().equals("right");
    }

    @Override
    public double getRightBranchHeight() {
        return this.rightBranchHeight;
    }

    @Override
    public double getLeftBranchHeight() {
        return this.leftBranchHeight;
    }

    @Override
    public void setLeftBranchHeight(double d2) {
        this.setChanged();
        this.leftBranchHeight = d2;
    }

    @Override
    public void setRightBranchHeight(double d2) {
        this.setChanged();
        this.rightBranchHeight = d2;
    }

    @Override
    public void setFolded(boolean bl2) {
        this.setChanged();
        this.isFolded = bl2;
    }

    @Override
    public boolean isFolded() {
        return this.isFolded;
    }

    @Override
    public boolean isParentFolded() {
        if (this.isFolded) {
            return true;
        }
        if (this.parent != null) {
            if (this.parent.isTop()) {
                return this.isFolded;
            }
            return this.parent.isParentFolded();
        }
        return this.isFolded;
    }

    @Override
    public boolean isAllParentFolded() {
        if (this.parent != null && !this.parent.isTop()) {
            return this.parent.isParentFolded();
        }
        return false;
    }

    @Override
    public boolean isShowWithFolded() {
        if (this.isFolded()) {
            return this.getParent() == null || !this.getParent().isParentFolded();
        }
        return !this.isParentFolded();
    }

    @Override
    public void setFixHorizontalPosition(boolean bl2) {
        this.setChanged();
        this.fixHorizontalPosition = bl2;
    }

    public void setFoldedStr(String string) {
        this.isFolded = Boolean.valueOf(string);
    }

    public void setFixHorizontalPositionStr(String string) {
        this.fixHorizontalPosition = Boolean.valueOf(string);
    }

    public void setEncodeNote(String string) {
        String string2 = "";
        string2 = h.b(string);
        if (string2 == null) {
            string2 = "";
        }
        this.setNote(string2);
    }

    @Override
    public boolean getFixHorizontalPosition() {
        return this.fixHorizontalPosition;
    }

    @Override
    public void setNote(String string) {
        this.setChanged();
        this.note = string;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public void setEdge(IMMEdgePresentation iMMEdgePresentation) {
        this.setChanged();
        this.edge = iMMEdgePresentation;
    }

    @Override
    public IMMEdgePresentation getEdge() {
        return this.edge;
    }

    @Override
    public void setIcons(List list) {
        this.setChanged();
        this.icons = list;
    }

    @Override
    public List getIcons() {
        return this.icons;
    }

    public static ImageIcon getImageIcon(String string) {
        String string2 = i.i().a("diagramview.popupmenu.mm_" + string + ".image");
        if (string2 == null) {
            MMUserIconInfo mMUserIconInfo = MMUserIconManager.instance().getProjectUserIconInfo();
            UserIcon userIcon = mMUserIconInfo.getUserIcon(string);
            if (userIcon != null) {
                return userIcon.getThumbnail();
            }
            string2 = "mm_image_astah.png";
        }
        return JomtUtilities2.getIcon(string2);
    }

    public static String getImageIconLabel(String string) {
        String string2 = i.i().a("diagramview.popupmenu.mm_" + string + ".label");
        if (string2 == null) {
            MMUserIconInfo mMUserIconInfo = MMUserIconManager.instance().getProjectUserIconInfo();
            UserIcon userIcon = mMUserIconInfo.getUserIcon(string);
            string2 = userIcon != null ? userIcon.getIconLabel() : "JUDE";
        }
        return string2;
    }

    @Override
    public void addIcon(String string) {
        this.setChanged();
        if (this.icons == null) {
            this.icons = new ArrayList();
        }
        double d2 = 0.0;
        if (this.icons.isEmpty()) {
            d2 = w.g(this);
        }
        this.icons.add(string);
        ImageIcon imageIcon = UPresentation.getImageIcon(string);
        this.setSize(this.getWidth() + (double)imageIcon.getIconWidth() + d2, this.getHeight());
        if (this.getPosition().equals("left")) {
            this.setLocation(new Pnt2d(this.location.x - (double)imageIcon.getIconWidth() - d2, this.location.y));
        }
        if (this.getDiagram() != null) {
            ((UMindMapDiagram)this.getDiagram()).startLayout(this.getPosition());
        }
    }

    @Override
    public void setIcon(String string) {
        if (this.icons == null) {
            this.icons = new ArrayList();
        }
        this.icons.add(string);
    }

    @Override
    public void removeAllIcons() {
        if (this.icons == null || this.icons.isEmpty()) {
            return;
        }
        this.setChanged();
        this.icons.clear();
        this.resize();
        if (this.getDiagram() != null) {
            ((UMindMapDiagram)this.getDiagram()).startLayout(this.getPosition());
        }
    }

    @Override
    public void removeIcon(String string) {
        this.setChanged();
        double d2 = 0.0;
        if (this.icons.size() == 1) {
            d2 = w.g(this);
        }
        ImageIcon imageIcon = UPresentation.getImageIcon(string);
        this.icons.remove(string);
        this.setSize(this.getWidth() - (double)imageIcon.getIconWidth() - d2, this.getHeight());
        if (this.getPosition().equals("left")) {
            this.setLocation(new Pnt2d(this.location.x + (double)imageIcon.getIconWidth() + d2, this.location.y));
        }
        if (this.getDiagram() != null) {
            ((UMindMapDiagram)this.getDiagram()).startLayout(this.getPosition());
        }
    }

    @Override
    public void removeIconFromIndex(int n2) {
        this.setChanged();
        double d2 = 0.0;
        if (this.icons.size() == 1) {
            d2 = w.g(this);
        }
        ImageIcon imageIcon = UPresentation.getImageIcon((String)this.icons.get(n2));
        this.icons.remove(n2);
        this.setSize(this.getWidth() - (double)imageIcon.getIconWidth() - d2, this.getHeight());
        if (this.getPosition().equals("left")) {
            this.setLocation(new Pnt2d(this.location.x + (double)imageIcon.getIconWidth() + d2, this.location.y));
        }
        if (this.getDiagram() != null) {
            ((UMindMapDiagram)this.getDiagram()).startLayout(this.getPosition());
        }
    }

    public void setImagePresentationForXMI(IImagePresentation iImagePresentation) {
        this.imagePresentation = iImagePresentation;
    }

    @Override
    public void setImagePresentation(IImagePresentation iImagePresentation) {
        double d2 = 0.0;
        if (this.imagePresentation == null) {
            this.setChanged();
        } else {
            this.removeImagePresentation();
        }
        d2 = w.g(this);
        this.imagePresentation = iImagePresentation;
        String string = w.l(this);
        if ("left".equals(string) || "right".equals(string)) {
            this.setWidth(this.getWidth() + iImagePresentation.getWidth() + d2);
            double d3 = 4.0 + this.imagePresentation.getHeight() + 4.0;
            double d4 = this.getDefaultHeight();
            double d5 = 0.0;
            d5 = d3 < d4 ? d4 : d3;
            this.setHeight(d5);
            if (this.getPosition().equals("left")) {
                this.setLocation(new Pnt2d(this.location.x - this.imagePresentation.getWidth() - d2, this.location.y));
            }
        } else if ("top".equals(string) || "bottom".equals(string)) {
            double d6 = this.getHeight();
            double d7 = d6 - 4.0 - 4.0;
            double d8 = 4.0 + this.imagePresentation.getHeight() + d2 + d7 + 4.0;
            double d9 = this.getDefaultHeight();
            double d10 = 0.0;
            d10 = d8 < d9 ? d9 : d8;
            double d11 = this.getWidth();
            double d12 = this.imagePresentation.getWidth();
            double d13 = 10.0 + d12 + 10.0;
            if (this.icons != null && this.icons.size() > 0) {
                d13 += d2 + this.getAllIconsWidth();
            }
            double d14 = 0.0;
            d14 = d11 < d13 ? d13 : d11;
            this.setSize(d14, d10);
            if (this.getPosition().equals("left")) {
                this.setLocation(new Pnt2d(this.location.x - this.imagePresentation.getWidth() - d2, this.location.y));
            }
        }
        if (this.getDiagram() != null) {
            ((UMindMapDiagram)this.getDiagram()).startLayout();
        }
    }

    @Override
    public void removeImagePresentation() {
        if (this.imagePresentation == null) {
            return;
        }
        this.setChanged();
        double d2 = w.g(this);
        IImagePresentation iImagePresentation = this.imagePresentation;
        this.imagePresentation = null;
        String string = w.l(this);
        if ("left".equals(string) || "right".equals(string)) {
            double d3 = this.getHeight();
            double d4 = iImagePresentation.getHeight();
            double d5 = d4 + 4.0;
            double d6 = this.getDefaultHeight();
            double d7 = 0.0;
            d7 = d3 - d5 < d6 ? d6 : d3 - d5;
            this.setSize(this.getWidth() - iImagePresentation.getWidth() - d2, d7);
            if (this.getPosition().equals("left")) {
                this.setLocation(new Pnt2d(this.location.x + iImagePresentation.getWidth() + d2, this.location.y));
            }
        } else if ("top".equals(string) || "bottom".equals(string)) {
            double d8 = this.getHeight();
            double d9 = 10.0 + this.getDefaultHeight() + 10.0;
            double d10 = this.getDefaultHeight();
            double d11 = 0.0;
            d11 = d8 - d9 < d10 ? d10 : d10;
            double d12 = this.getDefaultWidth() + this.getAllIconsWidth();
            if (iImagePresentation.getWidth() != 0.0) {
                d12 += d2;
            }
            double d13 = this.getWidth() - iImagePresentation.getWidth();
            double d14 = 0.0;
            d14 = d13 < d12 ? d12 : d13;
            this.setSize(d14, d11);
            if (this.getPosition().equals("left")) {
                this.setLocation(new Pnt2d(this.location.x + iImagePresentation.getWidth() + d2, this.location.y));
            }
        }
        if (this.getDiagram() != null) {
            ((UMindMapDiagram)this.getDiagram()).startLayout();
        }
    }

    @Override
    public IImagePresentation getImagePresentation() {
        return this.imagePresentation;
    }

    @Override
    public Rectangle2d getBoundsRect() {
        if (this.isShowWithFolded()) {
            return super.getBoundsRect();
        }
        return new Rectangle2d(this.location.x + this.localMovement.x, this.location.y + this.localMovement.y, 0.0, 0.0);
    }

    @Override
    public void setText(String string) {
        if (string.equals("")) {
            return;
        }
        super.setText(string);
        if (!this.getAutoResize()) {
            this.resizeWithAutoHeight();
        }
        if (this.getDiagram() != null) {
            ((UMindMapDiagram)this.getDiagram()).startLayout(this.getPosition());
        }
    }

    @Override
    protected void setAliasToLabel() {
        this.setLabel(this.getText());
    }

    @Override
    public double getDefaultHeight() {
        double d2 = this.getWidth() - 18.0;
        d2 -= this.getWidthForIcons();
        d2 -= this.getWidthForImage();
        double d3 = 0.0;
        if (this.getAutoResize()) {
            double d4 = y.b(this.getFont(), "m");
            String[] stringArray = JomtUtilities.splitMultiLineString(this.getLabel());
            d3 = d4 * (double)stringArray.length;
        } else {
            double d5 = 0.0;
            d3 = y.a(this.getFont(), this.getLabel(), d2, d5);
        }
        return 4.0 + d3 + 4.0;
    }

    @Override
    public void setWidth(double d2) {
        double d3 = this.getWidth();
        if (d3 == d2) {
            return;
        }
        super.setWidth(d2);
        UMindMapDiagram uMindMapDiagram = (UMindMapDiagram)this.getDiagram();
        if (this.isPositionLeft()) {
            boolean bl2 = this.getFixHorizontalPosition();
            uMindMapDiagram.move(this, new Vec2d(d3 - d2, 0.0));
            this.setFixHorizontalPosition(bl2);
        } else {
            Vec2d vec2d = new Vec2d(d2 - d3, 0.0);
            List list = this.getRightChildrenTopics();
            for (IMMTopicPresentation iMMTopicPresentation : list) {
                boolean bl3 = iMMTopicPresentation.getFixHorizontalPosition();
                uMindMapDiagram.move(iMMTopicPresentation, vec2d);
                iMMTopicPresentation.setFixHorizontalPosition(bl3);
            }
        }
    }

    @Override
    public void resize() {
        if (suppressResize) {
            return;
        }
        if (this.isValid() && this.doAutoResize) {
            double d2;
            double d3 = this.getDefaultWidth();
            d3 += this.getWidthForIcons();
            this.setWidth(d3 += this.getWidthForImage());
            double d4 = this.getDefaultHeight();
            if (this.icons != null && this.icons.size() > 0 && d4 < (d2 = 4.0 + this.getAllIconsHeight() + 4.0)) {
                d4 = d2;
            }
            if (this.imagePresentation != null) {
                String string = w.l(this);
                if ("top".equals(string) || "bottom".equals(string)) {
                    d4 += this.getImageHeight() + w.g(this);
                } else {
                    double d5 = 4.0 + this.getImageHeight() + 4.0;
                    if (d4 < d5) {
                        d4 = d5;
                    }
                }
            }
            this.setHeight(d4);
        } else if (this.isValid()) {
            logger.debug("resize: wrap line");
            this.resizeWithAutoHeight();
        }
    }

    private double getWidthForImage() {
        String string;
        if (this.imagePresentation != null && ("left".equals(string = w.l(this)) || "right".equals(string))) {
            return this.getImageWidth() + w.g(this);
        }
        return 0.0;
    }

    private double getWidthForIcons() {
        if (this.icons == null || this.icons.isEmpty()) {
            return 0.0;
        }
        return this.getAllIconsWidth() + w.g(this);
    }

    @Override
    public List getAllChildren() {
        ArrayList<IMMTopicPresentation> arrayList = new ArrayList<IMMTopicPresentation>();
        if (this.children != null) {
            for (IMMTopicPresentation iMMTopicPresentation : this.children) {
                arrayList.add(iMMTopicPresentation);
                arrayList.addAll(iMMTopicPresentation.getAllChildren());
            }
        }
        return arrayList;
    }

    @Override
    public List getAllParents() {
        ArrayList<IMMTopicPresentation> arrayList = new ArrayList<IMMTopicPresentation>();
        for (IMMTopicPresentation iMMTopicPresentation = this.getParent(); iMMTopicPresentation != null; iMMTopicPresentation = iMMTopicPresentation.getParent()) {
            arrayList.add(iMMTopicPresentation);
        }
        return arrayList;
    }

    @Override
    public boolean isLegalParent(IJomtPresentation iJomtPresentation) {
        return iJomtPresentation instanceof IMMTopicPresentation;
    }

    @Override
    public void resizeWithAutoHeight() {
        if (suppressResize) {
            return;
        }
        if (this.isValid()) {
            double d2;
            double d3 = this.getDefaultHeight();
            if (this.icons != null && this.icons.size() > 0 && d3 < (d2 = 4.0 + this.getAllIconsHeight() + 4.0)) {
                d3 = d2;
            }
            if (this.imagePresentation != null) {
                String string = w.l(this);
                if ("top".equals(string) || "bottom".equals(string)) {
                    d3 += this.getImageHeight() + w.g(this);
                } else {
                    double d4 = 4.0 + this.getImageHeight() + 4.0;
                    if (d3 < d4) {
                        d3 = d4;
                    }
                }
            }
            if (d3 > this.getHeight()) {
                this.setHeight(d3);
            }
        }
        if (this.getDiagram() != null) {
            ((UMindMapDiagram)this.getDiagram()).startLayout(this.getPosition());
        }
    }

    public void addChildren(MMTopicPresentation mMTopicPresentation) {
        this.setChanged();
        this.children.add(mMTopicPresentation);
    }

    @Override
    public void setDepth(int n2) {
        super.setDepth(n2);
        this.notifyObservers();
        if (this.edge != null) {
            this.edge.setDepth(n2 + 1);
        }
        if (this.children != null) {
            for (IMMTopicPresentation iMMTopicPresentation : this.children) {
                iMMTopicPresentation.setDepth(n2);
            }
        }
        this.setBoundaryDepth();
        this.setLinkDepth();
    }

    private void setLinkDepth() {
        List list = this.getClients();
        for (IUPresentation iUPresentation : list) {
            IMMLinkPresentation iMMLinkPresentation;
            if (!(iUPresentation instanceof IMMLinkPresentation) || (iMMLinkPresentation = (IMMLinkPresentation)iUPresentation).getSourceTopic() == null || iMMLinkPresentation.getTargetTopic() == null) continue;
            int n2 = Math.min(iMMLinkPresentation.getSourceTopic().getDepth(), iMMLinkPresentation.getTargetTopic().getDepth()) - 1;
            iMMLinkPresentation.setDepth(n2);
        }
    }

    private void setBoundaryDepth() {
        if (this.boundary == null) {
            return;
        }
        this.boundary.setDepth(this.getDepth() + this.getDeepestDescendantLevel() + 2);
    }

    @Override
    public int getDeepestDescendantLevel() {
        return this.getDeepestDescendantLevel(this, 0);
    }

    private int getDeepestDescendantLevel(IMMTopicPresentation iMMTopicPresentation, int n2) {
        int n3 = n2;
        for (IMMTopicPresentation iMMTopicPresentation2 : iMMTopicPresentation.getChildren()) {
            int n4 = this.getDeepestDescendantLevel(iMMTopicPresentation2, n3 + 1);
            if (n2 >= n4) continue;
            n2 = n4;
        }
        return n2;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @Override
    public String getSearchableTypeString() {
        return "Topic";
    }

    @Override
    public void setBoundary(IMMBoundaryPresentation iMMBoundaryPresentation) {
        this.setChanged();
        this.boundary = iMMBoundaryPresentation;
        if (iMMBoundaryPresentation != null) {
            IMMTopicPresentation iMMTopicPresentation;
            this.addObserver(iMMBoundaryPresentation);
            for (iMMTopicPresentation = this; iMMTopicPresentation != null && !iMMTopicPresentation.isTop(); iMMTopicPresentation = iMMTopicPresentation.getParent()) {
            }
            iMMTopicPresentation.setDepth(iMMTopicPresentation.getDepth());
        }
    }

    @Override
    public IMMBoundaryPresentation getBoundary() {
        return this.boundary;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.customStyleMap != null) {
            this.setStyleMap(this.customStyleMap);
            this.customStyleMap = null;
        }
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        return string.equals("line.width") || string.equals("shape") || string.equals("font.name") || string.equals("font.size") || string.equals("font.color") || string.equals("font.struckthrough") || string.equals("font.style") || string.equals("font.underlined") || string.equals("font") || string.equals("fill.color") || string.equals("line.color");
    }

    @Override
    public String getStyleKeyForDiagram(String string) {
        int n2 = I.a((IUPresentation)this);
        StringBuilder stringBuilder = new StringBuilder("topic.").append(string).append(".").append(Math.min(this.getTopicIndex(), n2));
        return stringBuilder.toString();
    }

    @Override
    public String getStyleKeyForSystem(String string) {
        return I.a().getSelectedTemplate() + "." + this.getStyleKeyForDiagram(string);
    }

    @Override
    public String getDefaultStyleFromSystem(String string) {
        return I.a().getDefaultString(this.getStyleKeyForSystem(string));
    }

    @Override
    public void setStyles(Map map) {
        super.setStyles(map);
        if (!this.getAutoResize()) {
            this.setChanged();
            this.resizeWithAutoHeight();
        }
    }

    @Override
    protected boolean isSupportedStyle(String string, String string2) {
        if (string.equals("shape")) {
            String[] stringArray = new String[]{"line", "rounded_rectangle"};
            if (this.isTop()) {
                stringArray = new String[]{"rounded_rectangle"};
            }
            return Arrays.asList(stringArray).contains(string2);
        }
        return this.isSupportedStyleKey(string);
    }

    @Override
    protected String getStyleForCopy(String string) {
        if (string.equals("line.color")) {
            Color color = w.b(this).a();
            return h.b(color);
        }
        return super.getStyleForCopy(string);
    }

    @Override
    public void addStyleMap(String string, String string2) {
        super.addStyleMap(string, string2);
        if (this.getEdge() != null) {
            this.addObserver(this.getEdge());
        }
    }

    @Override
    public boolean isValid() {
        if (this.diagram == null) {
            return false;
        }
        if (this.edge != null && !this.edge.isValid()) {
            return false;
        }
        return super.isValid();
    }

    @Override
    public String getIconIDFromIndex(int n2) {
        return (String)this.icons.get(n2);
    }

    @Override
    public boolean attributesEqual(UPresentation uPresentation) {
        if (!(uPresentation instanceof MMTopicPresentation)) {
            return false;
        }
        MMTopicPresentation mMTopicPresentation = (MMTopicPresentation)uPresentation;
        if (mMTopicPresentation.isFolded != this.isFolded || mMTopicPresentation.fixHorizontalPosition != this.fixHorizontalPosition) {
            return false;
        }
        if (this.icons == null && mMTopicPresentation.icons != null || this.icons != null && !this.icons.equals(mMTopicPresentation.icons)) {
            return false;
        }
        if (this.index != mMTopicPresentation.index) {
            return false;
        }
        return super.attributesEqual(mMTopicPresentation);
    }
}

