/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.geom2D.Rectangle2d;
import JP.co.esm.caddies.jomt.jmodel.BinaryRelationPresentation;
import JP.co.esm.caddies.jomt.jmodel.ILabelPresentation;
import JP.co.esm.caddies.jomt.jmodel.IMMLinkPresentation;
import JP.co.esm.caddies.jomt.jmodel.IMMTopicPresentation;
import JP.co.esm.caddies.jomt.jmodel.LabelPresentation;
import JP.co.esm.caddies.jomt.jutil.I;
import JP.co.esm.caddies.jomt.jutil.y;
import JP.co.esm.caddies.uml.mindmap.UMindMapDiagram;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Map;

public class MMLinkPresentation
extends BinaryRelationPresentation
implements IMMLinkPresentation {
    static final long serialVersionUID = -4918933158159657009L;
    private Pnt2d startInclination;
    private Pnt2d endInclination;
    private Map customStyleMap = null;

    @Override
    public IMMTopicPresentation getSourceTopic() {
        return (IMMTopicPresentation)this.getSourcePresentation();
    }

    @Override
    public IMMTopicPresentation getTargetTopic() {
        return (IMMTopicPresentation)this.getTargetPresentation();
    }

    @Override
    public void setRightAngleConstraint(boolean bl2) {
    }

    @Override
    public void updateAllPoints() {
        super.updateAllPoints();
        Pnt2d[] pnt2dArray = this.allPoints;
        if (pnt2dArray != null && pnt2dArray.length == 2) {
            Pnt2d pnt2d;
            if (this.getStartInclination() == null) {
                pnt2d = this.calcInclination(this.getSourceTopic());
                this.setStartInclination(pnt2d);
            }
            if (this.getEndInclination() == null) {
                pnt2d = this.calcInclination(this.getTargetTopic());
                this.setEndInclination(pnt2d);
            }
            this.allPoints = new Pnt2d[4];
            this.allPoints[0] = pnt2dArray[0];
            this.allPoints[3] = pnt2dArray[1];
            this.allPoints[1] = new Pnt2d(pnt2dArray[0]);
            this.allPoints[1].add(this.getStartInclination());
            this.allPoints[2] = new Pnt2d(pnt2dArray[1]);
            this.allPoints[2].add(this.getEndInclination());
        }
        this.notifyObservers();
    }

    @Override
    public void updateOuterPoints() {
    }

    private Pnt2d calcInclination(IMMTopicPresentation iMMTopicPresentation) {
        double d2 = iMMTopicPresentation.getWidth();
        double d3 = iMMTopicPresentation.getHeight();
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = this.getSourceTopic().getCenterX();
        double d6 = this.getSourceTopic().getCenterY();
        double d7 = this.getTargetTopic().getCenterX();
        double d8 = this.getTargetTopic().getCenterY();
        double d9 = new Pnt2d(d5, d6).distance(d7, d8);
        double d10 = d9 * d2 / d4;
        double d11 = d9 * d3 / d4;
        if (this.getSourceTopic().getPosition().equals(this.getTargetTopic().getPosition())) {
            return new Pnt2d((double)this.getInclinationQuotietyX(iMMTopicPresentation) * d10, MMLinkPresentation.getDeltaValue(d6 - d8));
        }
        return new Pnt2d(MMLinkPresentation.getDeltaValue(d5 - d7), (double)this.getInclinationQuotietyY(iMMTopicPresentation) * d11);
    }

    private int getInclinationQuotietyX(IMMTopicPresentation iMMTopicPresentation) {
        double d2 = iMMTopicPresentation == this.getSourceTopic() ? this.getSourceEndX() : this.getTargetEndX();
        return MMLinkPresentation.getInclinationQuotiety(d2);
    }

    private int getInclinationQuotietyY(IMMTopicPresentation iMMTopicPresentation) {
        double d2 = iMMTopicPresentation == this.getSourceTopic() ? this.getSourceEndY() : this.getTargetEndY();
        return MMLinkPresentation.getInclinationQuotiety(d2);
    }

    private static int getInclinationQuotiety(double d2) {
        return d2 <= 0.01 ? -1 : 1;
    }

    private static double getDeltaValue(double d2) {
        if (Math.abs(d2) < 10.0) {
            return -20.0;
        }
        return 0.0;
    }

    @Override
    public Pnt2d getEndInclination() {
        return this.endInclination;
    }

    @Override
    public void setEndInclination(Pnt2d pnt2d) {
        this.setChanged();
        this.endInclination = pnt2d;
        this.updatePoints();
    }

    @Override
    public Pnt2d getStartInclination() {
        return this.startInclination;
    }

    @Override
    public void setStartInclination(Pnt2d pnt2d) {
        this.setChanged();
        this.startInclination = pnt2d;
        this.updatePoints();
    }

    @Override
    public void changeInclination(String string, Pnt2d pnt2d) {
        if ("start".equals(string)) {
            this.setSourceEnd(MMLinkPresentation.getNewEndPnt(pnt2d, this.getSourceTopic()));
            Pnt2d pnt2d2 = MMLinkPresentation.getNewInclination(pnt2d, this.getSourceEndPnt());
            this.setStartInclination(pnt2d2);
        } else if ("end".equals(string)) {
            this.setTargetEnd(MMLinkPresentation.getNewEndPnt(pnt2d, this.getTargetTopic()));
            Pnt2d pnt2d3 = MMLinkPresentation.getNewInclination(pnt2d, this.getTargetEndPnt());
            this.setEndInclination(pnt2d3);
        }
    }

    private static Pnt2d getNewEndPnt(Pnt2d pnt2d, IMMTopicPresentation iMMTopicPresentation) {
        double d2;
        double d3 = iMMTopicPresentation.getHeight();
        double d4 = iMMTopicPresentation.getWidth();
        double d5 = pnt2d.x - iMMTopicPresentation.getCenterX();
        double d6 = pnt2d.y - iMMTopicPresentation.getCenterY();
        double d7 = Math.abs(d3 / d4);
        double d8 = Math.abs(d4 / d3);
        double d9 = Math.abs(d6 / d5);
        double d10 = Math.abs(d5 / d6);
        double d11 = 0.0;
        if (d9 <= d7) {
            d11 = d5 <= 0.0 ? 0.0 : 1.0;
        } else {
            d2 = 0.5 * d7 * d10;
            d11 = d5 > 0.0 ? 0.5 + d2 : 0.5 - d2;
        }
        d2 = 0.0;
        if (d9 < d7) {
            double d12 = 0.5 * d8 * d9;
            d2 = d6 > 0.0 ? 0.5 + d12 : 0.5 - d12;
        } else {
            d2 = d6 <= 0.0 ? 0.0 : 1.0;
        }
        return new Pnt2d(d11, d2);
    }

    private static Pnt2d getNewInclination(Pnt2d pnt2d, Pnt2d pnt2d2) {
        return new Pnt2d(pnt2d.x - pnt2d2.x, pnt2d.y - pnt2d2.y);
    }

    @Override
    public void storeState(Hashtable hashtable) {
        if (this.startInclination != null) {
            hashtable.put("startInclination", this.startInclination.clone());
        }
        if (this.endInclination != null) {
            hashtable.put("endInclination", this.endInclination.clone());
        }
        super.storeState(hashtable);
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        this.setChanged();
        if (hashtable.get("startInclination") instanceof Pnt2d) {
            this.startInclination = (Pnt2d)hashtable.get("startInclination");
        }
        if (hashtable.get("endInclination") instanceof Pnt2d) {
            this.endInclination = (Pnt2d)hashtable.get("endInclination");
        }
        super.restoreState(hashtable);
    }

    @Override
    public Object clone() {
        MMLinkPresentation mMLinkPresentation = (MMLinkPresentation)super.clone();
        mMLinkPresentation.startInclination = (Pnt2d)this.startInclination.clone();
        mMLinkPresentation.endInclination = (Pnt2d)this.endInclination.clone();
        return mMLinkPresentation;
    }

    @Override
    public Pnt2d getNewTargetEndPoint(IMMTopicPresentation iMMTopicPresentation, IMMTopicPresentation iMMTopicPresentation2) {
        return MMLinkPresentation.getEndPnt(iMMTopicPresentation, iMMTopicPresentation2, iMMTopicPresentation2);
    }

    @Override
    public Pnt2d getNewSourceEndPoint(IMMTopicPresentation iMMTopicPresentation, IMMTopicPresentation iMMTopicPresentation2) {
        return MMLinkPresentation.getEndPnt(iMMTopicPresentation, iMMTopicPresentation2, iMMTopicPresentation);
    }

    private static Pnt2d getEndPnt(IMMTopicPresentation iMMTopicPresentation, IMMTopicPresentation iMMTopicPresentation2, IMMTopicPresentation iMMTopicPresentation3) {
        if (iMMTopicPresentation.getPosition().equals(iMMTopicPresentation2.getPosition())) {
            double d2 = iMMTopicPresentation.getPosition().equals("left") ? 0.0 : 1.0;
            return new Pnt2d(d2, 0.5);
        }
        IMMTopicPresentation iMMTopicPresentation4 = ((UMindMapDiagram)iMMTopicPresentation.getDiagram()).getRoot();
        double d3 = iMMTopicPresentation.getCenterY();
        double d4 = iMMTopicPresentation2.getCenterY();
        double d5 = 0.0;
        d5 = d3 >= iMMTopicPresentation4.getCenterY() && d4 >= iMMTopicPresentation4.getCenterY() ? 1.0 : (d3 <= iMMTopicPresentation4.getCenterY() && d4 <= iMMTopicPresentation4.getCenterY() ? 0.0 : (iMMTopicPresentation3.getCenterY() > iMMTopicPresentation4.getCenterY() ? 0.0 : 1.0));
        return new Pnt2d(0.5, d5);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.customStyleMap != null) {
            this.setStyleMap(this.customStyleMap);
            this.customStyleMap = null;
        }
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        return string.equals("line.width") || string.equals("line.type") || string.equals("line.arrow.type") || string.equals("line.color");
    }

    @Override
    public String getStyleKeyForDiagram(String string) {
        return "link." + string;
    }

    @Override
    public String getStyleKeyForSystem(String string) {
        return I.a().getSelectedTemplate() + "." + this.getStyleKeyForDiagram(string);
    }

    @Override
    public String getDefaultStyleFromSystem(String string) {
        return I.a().getDefaultString(this.getStyleKeyForSystem(string));
    }

    @Override
    public void updateNamePresentation() {
        if (this.namePresentation != null) {
            this.namePresentation.resize();
            if (this.namePresentation.getAutoResize()) {
                this.namePresentation.resize();
            } else {
                double d2 = this.getMultiLineStringHeight(this.namePresentation.getLabel());
                if (d2 > this.namePresentation.getHeight()) {
                    this.namePresentation.setHeight(d2);
                }
            }
            if (this.namePresentation.getName() == null || this.namePresentation.getName().equals("")) {
                return;
            }
        }
    }

    @Override
    public double getMultiLineStringHeight(String string) {
        double d2 = this.namePresentation.getWidth();
        double d3 = 0.0;
        return y.a(this.namePresentation.getFont(), string, d2, d3);
    }

    @Override
    public int getLineCount(String string) {
        if (string != null && !string.equals("")) {
            double d2 = y.a(this.namePresentation.getFont(), string);
            double d3 = this.namePresentation.getWidth();
            return (int)(d2 / d3) + 1;
        }
        return 0;
    }

    @Override
    public ILabelPresentation getNamePresentation() {
        Pnt2d pnt2d;
        if (this.namePresentation == null) {
            this.setChanged();
            this.setNamePresentation(new LabelPresentation());
        }
        if ((pnt2d = this.getDefaultNamePnt()) != null) {
            this.namePresentation.setLocation(pnt2d);
        }
        this.updateNamePresentation();
        return this.namePresentation;
    }

    @Override
    public Rectangle2d getBoundsRect() {
        Cloneable cloneable;
        Rectangle2d rectangle2d = new Rectangle2d();
        if (this.allPoints != null) {
            rectangle2d.setRect(this.allPoints[3].x, this.allPoints[3].y, 0.0, 0.0);
            cloneable = new Pnt2d();
            ((Pnt2d)cloneable).x = (this.allPoints[1].x + this.allPoints[2].x) / 2.0;
            ((Pnt2d)cloneable).y = (this.allPoints[1].y + this.allPoints[2].y) / 2.0;
            rectangle2d.add((Point2D)cloneable);
            Pnt2d pnt2d = new Pnt2d();
            pnt2d.x = (this.allPoints[1].x + this.allPoints[3].x) / 2.0;
            pnt2d.y = (this.allPoints[1].y + this.allPoints[3].y) / 2.0;
            rectangle2d.add(pnt2d);
            Pnt2d pnt2d2 = new Pnt2d();
            pnt2d2.x = (this.allPoints[2].x + this.allPoints[0].x) / 2.0;
            pnt2d2.y = (this.allPoints[2].y + this.allPoints[0].y) / 2.0;
            rectangle2d.add(pnt2d2);
            rectangle2d.add(this.allPoints[0]);
        }
        if (this.allPoints != null && !"".equals((cloneable = this.getNamePresentation()).getLabel()) && cloneable.getVisibility()) {
            rectangle2d.add(this.getNamePresentation().getBoundsRect());
        }
        return rectangle2d;
    }
}

