/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.geom2D.Rectangle2d;
import JP.co.esm.caddies.jomt.jmodel.IMMBoundaryPresentation;
import JP.co.esm.caddies.jomt.jmodel.IMMTopicPresentation;
import JP.co.esm.caddies.jomt.jmodel.RectPresentation;
import JP.co.esm.caddies.jomt.jmodel.w;
import JP.co.esm.caddies.jomt.jutil.I;
import JP.co.esm.caddies.uml.Foundation.Core.UModelElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Observable;

public class MMBoundaryPresentation
extends RectPresentation
implements IMMBoundaryPresentation {
    static final long serialVersionUID = 6912717794223356990L;
    private static final double BOUNDARY_OFFSET_X = 12.0;
    private static final double BOUNDARY_OFFSET_Y = 8.0;
    private static final double OUT_BOUND_OFFSET = 8.0;
    private IMMTopicPresentation topic;
    private Map customStyleMap = null;
    private boolean visible;

    @Override
    public void update(Observable observable, Object object) {
        if (this.isValid()) {
            super.update(observable, null);
            this.notifyObservers(object);
        }
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.topic != null;
    }

    @Override
    public void setTopic(IMMTopicPresentation iMMTopicPresentation) {
        this.setChanged();
        this.topic = iMMTopicPresentation;
    }

    @Override
    public IMMTopicPresentation getTopic() {
        return this.topic;
    }

    @Override
    public void setVisible(boolean bl2) {
        this.setChanged();
        this.visible = bl2;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isValidModel(UModelElement uModelElement) {
        return true;
    }

    @Override
    public Pnt2d[] getPoints() {
        List list = this.getTopPoints();
        List list2 = this.getLowPoints();
        ArrayList arrayList = new ArrayList();
        if (this.getTopic().getPosition().equals("right")) {
            arrayList.addAll(list);
            for (int i2 = list2.size() - 1; i2 >= 0; --i2) {
                arrayList.add(list2.get(i2));
            }
        } else {
            arrayList.addAll(list2);
            for (int i3 = list.size() - 1; i3 >= 0; --i3) {
                arrayList.add(list.get(i3));
            }
        }
        return arrayList.toArray(new Pnt2d[0]);
    }

    private List getTopPoints() {
        ArrayList<Pnt2d> arrayList = new ArrayList<Pnt2d>();
        IMMTopicPresentation iMMTopicPresentation = this.getTopic();
        while (iMMTopicPresentation != null) {
            double d2 = iMMTopicPresentation.getMinY() - (double)this.countBoundary(iMMTopicPresentation) * 8.0;
            if (this.isHigherPoint(d2, arrayList)) {
                arrayList.add(new Pnt2d(this.getBoundaryX(iMMTopicPresentation), d2));
            }
            List list = iMMTopicPresentation.getChildren();
            if (iMMTopicPresentation.isFolded() || list.isEmpty()) {
                arrayList.add(new Pnt2d(this.getEndBoundaryX(), d2));
                break;
            }
            iMMTopicPresentation = (IMMTopicPresentation)list.get(0);
        }
        return arrayList;
    }

    private int countBoundary(IMMTopicPresentation iMMTopicPresentation) {
        int n2 = 0;
        for (IMMTopicPresentation iMMTopicPresentation2 = iMMTopicPresentation; iMMTopicPresentation2 != null; iMMTopicPresentation2 = iMMTopicPresentation2.getParent()) {
            if (w.a(iMMTopicPresentation2)) {
                ++n2;
            }
            if (iMMTopicPresentation2.isTop() || iMMTopicPresentation2 == this.getTopic()) break;
        }
        return n2;
    }

    private double getEndBoundaryX() {
        if (this.getTopic().getPosition().equals("left")) {
            double d2 = this.getTopic().getMinX() - (double)this.countBoundary(this.getTopic()) * 12.0;
            for (IMMTopicPresentation iMMTopicPresentation : this.getAllLeafChildren()) {
                d2 = Math.min(d2, iMMTopicPresentation.getMinX() - (double)this.countBoundary(iMMTopicPresentation) * 12.0);
            }
            return d2;
        }
        double d3 = this.getTopic().getMaxX() + (double)this.countBoundary(this.getTopic()) * 12.0;
        for (IMMTopicPresentation iMMTopicPresentation : this.getAllLeafChildren()) {
            d3 = Math.max(d3, iMMTopicPresentation.getMaxX() + (double)this.countBoundary(iMMTopicPresentation) * 12.0);
        }
        return d3;
    }

    private List getAllLeafChildren() {
        ArrayList<IMMTopicPresentation> arrayList = new ArrayList<IMMTopicPresentation>();
        for (IMMTopicPresentation iMMTopicPresentation : this.getTopic().getAllChildren()) {
            if (!iMMTopicPresentation.isShowWithFolded()) continue;
            arrayList.add(iMMTopicPresentation);
        }
        return arrayList;
    }

    private double getBoundaryX(IMMTopicPresentation iMMTopicPresentation) {
        if (iMMTopicPresentation.getPosition().equals("left")) {
            return iMMTopicPresentation.getMaxX() + (double)this.countBoundary(iMMTopicPresentation) * 12.0;
        }
        return iMMTopicPresentation.getMinX() - (double)this.countBoundary(iMMTopicPresentation) * 12.0;
    }

    private List getLowPoints() {
        ArrayList<Pnt2d> arrayList = new ArrayList<Pnt2d>();
        IMMTopicPresentation iMMTopicPresentation = this.getTopic();
        while (iMMTopicPresentation != null) {
            double d2 = iMMTopicPresentation.getMaxY() + (double)this.countBoundary(iMMTopicPresentation) * 8.0;
            if (this.isLowerPoint(d2, arrayList)) {
                arrayList.add(new Pnt2d(this.getBoundaryX(iMMTopicPresentation), d2));
            }
            List list = iMMTopicPresentation.getChildren();
            if (iMMTopicPresentation.isFolded() || list.isEmpty()) {
                arrayList.add(new Pnt2d(this.getEndBoundaryX(), ((Pnt2d)arrayList.get((int)(arrayList.size() - 1))).y));
                break;
            }
            iMMTopicPresentation = (IMMTopicPresentation)list.get(list.size() - 1);
        }
        return arrayList;
    }

    private boolean isHigherPoint(double d2, List list) {
        if (list.isEmpty()) {
            return true;
        }
        Pnt2d pnt2d = (Pnt2d)list.get(list.size() - 1);
        return d2 < pnt2d.y;
    }

    private boolean isLowerPoint(double d2, List list) {
        if (list.isEmpty()) {
            return true;
        }
        Pnt2d pnt2d = (Pnt2d)list.get(list.size() - 1);
        return d2 > pnt2d.y;
    }

    @Override
    public void storeState(Hashtable hashtable) {
        if (this.topic != null) {
            hashtable.put("topic", this.topic);
        }
        hashtable.put("visible", this.visible);
        super.storeState(hashtable);
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        this.setChanged();
        if (hashtable.get("topic") != null) {
            this.topic = (IMMTopicPresentation)hashtable.get("topic");
        }
        if (hashtable.get("visible") != null) {
            this.visible = (Boolean)hashtable.get("visible");
        }
        super.restoreState(hashtable);
    }

    @Override
    public Object clone() {
        MMBoundaryPresentation mMBoundaryPresentation = (MMBoundaryPresentation)super.clone();
        if (this.topic != null) {
            mMBoundaryPresentation.setTopic(this.topic);
        }
        mMBoundaryPresentation.setVisible(this.visible);
        return mMBoundaryPresentation;
    }

    @Override
    public void setDepth(int n2) {
        super.setDepth(n2);
        this.notifyObservers();
    }

    @Override
    public void remove() {
        super.remove();
        if (this.topic != null) {
            this.topic.setBoundary(null);
            this.topic = null;
        }
    }

    @Override
    public Rectangle2d getBoundsRect() {
        Rectangle2d rectangle2d = null;
        Pnt2d[] pnt2dArray = this.getPoints();
        if (pnt2dArray != null) {
            rectangle2d = new Rectangle2d(pnt2dArray[0].x, pnt2dArray[0].y, 10.0, 10.0);
            for (int i2 = 0; i2 < pnt2dArray.length; ++i2) {
                rectangle2d.add(pnt2dArray[i2]);
            }
        }
        return new Rectangle2d(rectangle2d.x - 8.0, rectangle2d.y - 8.0, rectangle2d.width + 16.0, rectangle2d.height + 16.0);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.customStyleMap != null) {
            this.setStyleMap(this.customStyleMap);
            this.customStyleMap = null;
        }
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        return string.equals("line.width") || string.equals("shape") || string.equals("line.color") || string.equals("fill.color");
    }

    @Override
    public String getStyleKeyForDiagram(String string) {
        return "boundary." + string;
    }

    @Override
    public String getStyleKeyForSystem(String string) {
        return I.a().getSelectedTemplate() + "." + this.getStyleKeyForDiagram(string);
    }

    @Override
    public String getDefaultStyleFromSystem(String string) {
        return I.a().getDefaultString(this.getStyleKeyForSystem(string));
    }

    @Override
    protected boolean isSupportedStyle(String string, String string2) {
        if (string.equals("shape")) {
            String[] stringArray = new String[]{"cloud", "straightLine", "roundedLine"};
            return Arrays.asList(stringArray).contains(string2);
        }
        return this.isSupportedStyleKey(string);
    }
}

