/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.geom2D.Rectangle2d;
import JP.co.esm.caddies.golf.geom2D.Vec2d;
import JP.co.esm.caddies.jomt.jmodel.ILinePresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtPresentation;
import JP.co.esm.caddies.jomt.jmodel.ae;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Observable;

public class LinePresentation
extends JomtPresentation
implements ILinePresentation {
    static final long serialVersionUID = -582497952433499079L;
    protected int bodyColor = 0;
    private Color baseColor = Color.WHITE;
    private int lineType = -1;
    private int lineStartArrow = -1;
    private int lineEndArrow = -1;

    @Override
    public void update(Observable observable, Object object) {
        super.update(observable, null);
    }

    @Override
    public void storeState(Hashtable hashtable) {
        if (this.baseColor != null) {
            hashtable.put("baseColor", this.baseColor);
        }
        super.storeState(hashtable);
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        this.setChanged();
        if (hashtable.get("baseColor") != null) {
            this.baseColor = (Color)hashtable.get("baseColor");
        }
        super.restoreState(hashtable);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public void setBodyColor(bj bj2) {
        if (bj2 == null) {
            return;
        }
        this.setChanged();
        this.baseColor = bj2.a();
    }

    @Override
    public bj getBodyColor() {
        return bP.a().a(this.baseColor);
    }

    @Override
    public void setStartLocation(Pnt2d pnt2d) {
        super.setLocation(pnt2d);
    }

    @Override
    public Rectangle2d getBoundsRect() {
        Pnt2d pnt2d = this.getStartLocation();
        Pnt2d pnt2d2 = this.getEndLocation();
        double d2 = Math.min(pnt2d.x, pnt2d2.x);
        double d3 = Math.min(pnt2d.y, pnt2d2.y);
        double d4 = Math.max(pnt2d.x, pnt2d2.x);
        double d5 = Math.max(pnt2d.y, pnt2d2.y);
        return new Rectangle2d(d2, d3, Math.max(0.01, d4 - d2), Math.max(0.01, d5 - d3));
    }

    @Override
    public void setEndLocation(Pnt2d pnt2d) {
        Vec2d vec2d = new Vec2d(pnt2d.getX() - this.location.getX(), pnt2d.getY() - this.location.getY());
        super.setLocalMovement(vec2d);
    }

    @Override
    public void reSize(Pnt2d pnt2d, Pnt2d pnt2d2) {
        this.setStartLocation(pnt2d);
        this.setEndLocation(pnt2d2);
    }

    @Override
    public Pnt2d getStartLocation() {
        return super.getLocation();
    }

    @Override
    public Pnt2d getEndLocation() {
        return super.getMovedLocation();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.lineType != -1) {
            ae.l(this, this.getLineTypeInNewFormat());
            this.lineType = -1;
        }
        if (ae.q(this) == null && this.lineStartArrow != -1 && this.lineEndArrow != -1) {
            ae.k(this, this.getLineArrowTypeInNewFormat());
            this.lineStartArrow = -1;
            this.lineEndArrow = -1;
        }
    }

    private String getLineArrowTypeInNewFormat() {
        if (this.lineStartArrow == 0 && this.lineEndArrow == 0) {
            return "noarrow";
        }
        if (this.lineStartArrow == 1 && this.lineEndArrow == 1) {
            return "botharrow";
        }
        if (this.lineStartArrow == 0 && this.lineEndArrow == 1) {
            return "endarrow";
        }
        if (this.lineStartArrow == 1 && this.lineEndArrow == 0) {
            return "startarrow";
        }
        return "line";
    }

    private String getLineTypeInNewFormat() {
        if (this.lineType == 0) {
            return "line";
        }
        if (this.lineType == 1) {
            return "dash1";
        }
        if (this.lineType == 2) {
            return "dash2";
        }
        return "line";
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        return string.equals("line.width") || string.equals("line.type") || string.equals("line.arrow.type") || string.equals("line.color");
    }

    @Override
    public String getStyleKeyForDiagram(String string) {
        return "line." + string;
    }

    @Override
    public String getStyleKeyForSystem(String string) {
        return this.getStyleKeyForDiagram(string);
    }

    @Override
    public String getDefaultStyleFromSystem(String string) {
        if (string.equals("line.width")) {
            return "1";
        }
        if (string.equals("line.type")) {
            return "line";
        }
        if (string.equals("line.arrow.type")) {
            return "noarrow";
        }
        if (string.equals("line.color")) {
            return "#000000";
        }
        return null;
    }

    public void setLineType(String string) {
        int n2 = Integer.parseInt(string);
        this.setLineType(n2);
    }

    @Override
    public void setLineType(int n2) {
        this.lineType = n2;
        if (n2 == 0) {
            this.addStyleMap("line.type", "line");
        } else if (n2 == 1) {
            this.addStyleMap("line.type", "dash1");
        } else if (n2 == 2) {
            this.addStyleMap("line.type", "dash2");
        }
    }

    public void setStartArrow(String string) {
        int n2 = Integer.parseInt(string);
        this.setStartArrow(n2);
    }

    @Override
    public void setStartArrow(int n2) {
        this.lineStartArrow = n2;
        if (this.getStyleMap() == null || this.getStyleMapFromKey("line.arrow.type") == null) {
            if (n2 == 1) {
                this.addStyleMap("line.arrow.type", "startarrow");
            } else {
                this.addStyleMap("line.arrow.type", "noarrow");
            }
        } else if (n2 == 1) {
            if (this.getStyleMapFromKey("line.arrow.type").equals("endarrow")) {
                this.addStyleMap("line.arrow.type", "botharrow");
            } else if (this.getStyleMapFromKey("line.arrow.type").equals("noarrow")) {
                this.addStyleMap("line.arrow.type", "startarrow");
            }
        } else if (this.getStyleMapFromKey("line.arrow.type").equals("botharrow")) {
            this.addStyleMap("line.arrow.type", "endarrow");
        } else if (this.getStyleMapFromKey("line.arrow.type").equals("startarrow")) {
            this.addStyleMap("line.arrow.type", "noarrow");
        }
    }

    public void setEndArrow(String string) {
        int n2 = Integer.parseInt(string);
        this.setEndArrow(n2);
    }

    @Override
    public void setEndArrow(int n2) {
        this.lineEndArrow = n2;
        if (this.getStyleMap() == null || this.getStyleMapFromKey("line.arrow.type") == null) {
            if (n2 == 1) {
                this.addStyleMap("line.arrow.type", "endarrow");
            } else {
                this.addStyleMap("line.arrow.type", "noarrow");
            }
        } else if (n2 == 1) {
            if (this.getStyleMapFromKey("line.arrow.type").equals("startarrow")) {
                this.addStyleMap("line.arrow.type", "botharrow");
            } else if (this.getStyleMapFromKey("line.arrow.type").equals("noarrow")) {
                this.addStyleMap("line.arrow.type", "endarrow");
            }
        } else if (this.getStyleMapFromKey("line.arrow.type").equals("botharrow")) {
            this.addStyleMap("line.arrow.type", "startarrow");
        } else if (this.getStyleMapFromKey("line.arrow.type").equals("endarrow")) {
            this.addStyleMap("line.arrow.type", "noarrow");
        }
    }

    @Override
    public int getLineType() {
        return this.lineType;
    }

    @Override
    public int getStartArrow() {
        return this.lineStartArrow;
    }

    @Override
    public int getEndArrow() {
        return this.lineEndArrow;
    }

    @Override
    public void addStyleMap(String string, String string2) {
        super.addStyleMap(string, string2);
        if ("line".equals(string2)) {
            this.lineType = 0;
        } else if ("dash1".equals(string2)) {
            this.lineType = 1;
        } else if ("dash2".equals(string2)) {
            this.lineType = 2;
        }
    }
}

