/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.geom2D.Vec2d;
import JP.co.esm.caddies.jomt.jmodel.IActivationPresentation;
import JP.co.esm.caddies.jomt.jmodel.IClassifierRolePresentation;
import JP.co.esm.caddies.jomt.jmodel.ICombinedFragmentPresentation;
import JP.co.esm.caddies.jomt.jmodel.IInteractionUsePresentation;
import JP.co.esm.caddies.jomt.jmodel.IMessagePresentation;
import JP.co.esm.caddies.jomt.jmodel.LabelPresentation;
import JP.co.esm.caddies.jomt.jmodel.PresentationUtil;
import JP.co.esm.caddies.jomt.jsystem.c;
import JP.co.esm.caddies.jomt.jutil.y;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UClassifierRole;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UInteractionDiagram;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UInteractionFragment;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UInteractionOperand;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UInteractionUse;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;

public class InteractionUsePresentation
extends LabelPresentation
implements IInteractionUsePresentation {
    static final long serialVersionUID = 1411274787217657828L;
    public static final double MIN_WIDTH = 80.0;
    public static final double MIN_HEIGHT = 60.0;
    public static final double NAME_TOP_OFFSET = 5.0;
    public static final double NAME_BOTTOM_OFFSET = 5.0;

    @Override
    public String getLabel() {
        if (this.getInteractionUse() == null) {
            return "";
        }
        if (!this.getInteractionUse().getArgument().equals("")) {
            return this.getModel().getNameString() + "(" + this.getInteractionUse().getArgument() + ")";
        }
        return this.getModel().getNameString();
    }

    @Override
    public double getMinWidth() {
        return 80.0;
    }

    @Override
    public double getMinHeight() {
        return 60.0;
    }

    @Override
    public double getDefaultHeight() {
        return Math.max(10.0 + this.getHeadNameHeight() + this.getNameHeight() + 10.0, this.getMinHeight());
    }

    @Override
    public double getDefaultWidth() {
        return Math.max(10.0 + this.getNameWidth() + 10.0, this.getMinWidth());
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.isValid()) {
            super.update(observable, null);
            this.updateBody();
        }
    }

    @Override
    public void updateBody() {
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        for (IActivationPresentation iActivationPresentation : this.getActivationClients()) {
            Pnt2d pnt2d = iActivationPresentation.getLocation();
            d2 = Math.min(d2, pnt2d.y);
            d3 = Math.max(d3, pnt2d.y);
        }
        if (d2 < this.getLocation().y && d2 != Double.MAX_VALUE) {
            this.setHeight(this.getLocation().y + this.getHeight() - d2);
            this.setLocation(new Pnt2d(this.getLocation().x, d2));
        }
        if (d3 > this.getLocation().y + this.getHeight() && d3 != Double.MIN_VALUE) {
            this.setHeight(d3 - this.getLocation().y);
        }
    }

    @Override
    public double getNameWidth() {
        return y.a(this.getFont(), this.getLabel());
    }

    @Override
    public double getNameHeight() {
        return y.b(this.getFont(), this.getLabel());
    }

    @Override
    public UInteractionUse getInteractionUse() {
        return (UInteractionUse)this.getModel();
    }

    @Override
    public double getHeadNameWidth() {
        return y.a(this.getFont(), UInteractionUse.OPERATOR.toString());
    }

    @Override
    public double getHeadNameHeight() {
        return y.b(this.getFont(), UInteractionUse.OPERATOR.toString());
    }

    @Override
    public void resize() {
        if (suppressResize) {
            return;
        }
        if (this.isValid()) {
            double d2;
            double d3 = this.getDefaultWidth();
            if (d3 > this.getWidth()) {
                d2 = d3 - this.getWidth();
                this.setWidth(d3);
                this.updateGatesHorizontally(d2);
            }
            if ((d2 = this.getDefaultHeight()) > this.getHeight()) {
                this.setHeight(d2);
            }
            UInteractionFragment uInteractionFragment = (UInteractionFragment)this.getModel();
            for (UClassifierRole uClassifierRole : uInteractionFragment.getCovereds()) {
                for (IClassifierRolePresentation iClassifierRolePresentation : uClassifierRole.getPresentations()) {
                    iClassifierRolePresentation.updateLifeline();
                }
            }
        }
    }

    @Override
    public IActivationPresentation getTopGatePs() {
        double d2 = Double.MAX_VALUE;
        IActivationPresentation iActivationPresentation = null;
        for (IActivationPresentation iActivationPresentation2 : this.getActivationClients()) {
            if (!(iActivationPresentation2.getLocation().y < d2)) continue;
            d2 = iActivationPresentation2.getLocation().y;
            iActivationPresentation = iActivationPresentation2;
        }
        return iActivationPresentation;
    }

    @Override
    public IActivationPresentation getBottomGatePs() {
        double d2 = Double.MIN_VALUE;
        IActivationPresentation iActivationPresentation = null;
        for (IActivationPresentation iActivationPresentation2 : this.getActivationClients()) {
            if (!(iActivationPresentation2.getLocation().y > d2)) continue;
            d2 = iActivationPresentation2.getLocation().y;
            iActivationPresentation = iActivationPresentation2;
        }
        return iActivationPresentation;
    }

    @Override
    public List getAllRelatedMessages() {
        ArrayList arrayList = new ArrayList(0);
        for (IActivationPresentation iActivationPresentation : this.getActivationClients()) {
            arrayList.addAll(iActivationPresentation.getAllMessages());
        }
        return arrayList;
    }

    @Override
    public List getAllOutgoingMessages() {
        ArrayList arrayList = new ArrayList(0);
        for (IActivationPresentation iActivationPresentation : this.getActivationClients()) {
            arrayList.addAll(iActivationPresentation.getAllOutMessages());
        }
        return arrayList;
    }

    @Override
    public List getAllIncomingMessages() {
        ArrayList arrayList = new ArrayList(0);
        for (IActivationPresentation iActivationPresentation : this.getActivationClients()) {
            arrayList.addAll(iActivationPresentation.getAllIncomeMessages());
        }
        return arrayList;
    }

    @Override
    public void updateGatesHorizontally(double d2) {
        for (IActivationPresentation iActivationPresentation : this.getActivationClients()) {
            IActivationPresentation iActivationPresentation2 = iActivationPresentation.getOppositeAp();
            double d3 = this.getLocation().x - d2 - iActivationPresentation.getLocation().x;
            double d4 = this.getLocation().x + this.getWidth() - d2 - iActivationPresentation.getLocation().x;
            if (d3 >= -0.5 && d3 <= 0.5) {
                if (iActivationPresentation2.getLocation().x > this.getLocation().x + this.getWidth()) {
                    iActivationPresentation.setLocation(new Pnt2d(this.getLocation().x + this.getWidth(), iActivationPresentation.getLocation().y));
                    continue;
                }
                iActivationPresentation.move(new Vec2d(d2, 0.0));
                continue;
            }
            if (!(d4 >= -0.5) || !(d4 <= 0.5)) continue;
            if (iActivationPresentation2.getLocation().x < this.getLocation().x) {
                iActivationPresentation.setLocation(new Pnt2d(this.getLocation().x, iActivationPresentation.getLocation().y));
                continue;
            }
            iActivationPresentation.move(new Vec2d(d2, 0.0));
        }
    }

    @Override
    public ICombinedFragmentPresentation getParentCombinedFragment() {
        UInteractionOperand uInteractionOperand = ((UInteractionUse)this.getModel()).getEnclosingOperand();
        if (uInteractionOperand != null) {
            return (ICombinedFragmentPresentation)uInteractionOperand.getEnclosingFragment().getPresentations().get(0);
        }
        return null;
    }

    @Override
    public void setDepth(int n2) {
        super.setDepth(n2);
        if (c.c != null) {
            if (this.getDiagram() == null || !(this.getDiagram() instanceof UInteractionDiagram)) {
                return;
            }
            int n3 = PresentationUtil.getMinDepth(this.getDiagram());
            List list = this.getDiagram().getPresentations();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object e2 = list.get(i2);
                if (!(e2 instanceof IMessagePresentation)) continue;
                IMessagePresentation iMessagePresentation = (IMessagePresentation)e2;
                iMessagePresentation.setDepth(n3 - 1);
                iMessagePresentation.notifyObservers(null);
            }
        }
    }

    private List getActivationClients() {
        ArrayList arrayList = new ArrayList();
        for (Object e2 : this.getClients()) {
            if (!(e2 instanceof IActivationPresentation)) continue;
            arrayList.add(e2);
        }
        return arrayList;
    }

    @Override
    public double getMaxResizeRightWidth() {
        double d2 = Double.MAX_VALUE;
        if (this.container != null) {
            double d3 = this.container.getMinX() + this.container.getWidth();
            d2 = d3 - this.getMinX() - 10.0;
        }
        return d2;
    }

    @Override
    public double getMaxResizeDownHeight() {
        double d2 = Double.MAX_VALUE;
        if (this.container != null) {
            Pnt2d pnt2d = this.container.getLocation();
            double d3 = pnt2d.getY() + this.container.getHeight();
            d2 = d3 - this.getLocation().getY() - 2.0;
        }
        return d2;
    }

    @Override
    public double getMaxResizeLeftWidth() {
        double d2 = Double.MAX_VALUE;
        if (this.container != null) {
            double d3 = this.container.getMinX();
            d2 = this.getMaxX() - d3 - 10.0;
        }
        return d2;
    }

    @Override
    public double getMaxResizeUpHeight() {
        double d2 = Double.MAX_VALUE;
        if (this.container != null) {
            double d3 = this.container.getMinY();
            d2 = this.getMaxY() - d3 - 2.0;
        }
        return d2;
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        return string.equals("fill.color") || string.equals("font") || string.equals("font.color");
    }
}

