/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.util.c;
import JP.co.esm.caddies.golf.util.h;
import JP.co.esm.caddies.golf.util.u;
import JP.co.esm.caddies.jomt.jmodel.IImagePresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.LabelPresentation;
import JP.co.esm.caddies.uml.Foundation.Core.UPresentation;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagePresentation
extends LabelPresentation
implements IImagePresentation {
    static final long serialVersionUID = -5206549763581777740L;
    private ImageIcon image;
    private int[] imagePixels;
    private int imageWidth;
    private int imageHeight;
    private static final double DEFAULT_MAX_HEIGHT = 100.0;
    private static final double DEFAULT_MAX_WIDTH = 100.0;
    private static final Logger logger = LoggerFactory.getLogger(ImagePresentation.class);

    public ImagePresentation() {
        this.doAutoResize = false;
    }

    @Override
    public void setAutoResize(boolean bl2) {
    }

    @Override
    public void storeState(Hashtable hashtable) {
        if (this.image != null) {
            hashtable.put("image", new ImageIcon(this.image.getImage()));
        }
        super.storeState(hashtable);
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        this.setChanged();
        Object v2 = hashtable.get("image");
        if (v2 != null) {
            this.image = (ImageIcon)v2;
        }
        super.restoreState(hashtable);
    }

    @Override
    public void setImage(bv bv2) {
        double d2;
        double d3;
        this.setChanged();
        this.image = bv2.e();
        double d4 = bv2.a(null);
        double d5 = bv2.b(null);
        boolean bl2 = JP.co.esm.caddies.jomt.jsystem.c.m.o("default_size.max_image.default_use");
        if (bl2) {
            d3 = this.getRatio(d4, "default_size.max_image.default_width", 100.0);
            d2 = this.getRatio(d5, "default_size.max_image.default_height", 100.0);
        } else {
            d3 = 1.0;
            d2 = 1.0;
        }
        double d6 = this.getValue(d4, d3, d2);
        double d7 = this.getValue(d5, d3, d2);
        this.setWidth(d6);
        this.setHeight(d7);
    }

    private double getRatio(double d2, String string, double d3) {
        double d4 = JP.co.esm.caddies.jomt.jsystem.c.m.getIntWithDefault(string);
        if (d4 == -1.0) {
            d4 = d3;
        }
        return d4 / d2;
    }

    private double getValue(double d2, double d3, double d4) {
        if (d3 >= 1.0 && d4 >= 1.0) {
            return d2;
        }
        return d2 * Math.min(d3, d4);
    }

    @Override
    public bv getImage() {
        return new ch(this.image);
    }

    @Override
    public void validate(JomtEntityStore jomtEntityStore) {
        super.validate(jomtEntityStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImageData() {
        Object object;
        if (this.image == null) {
            return "";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeObject(this.image);
            ((ObjectOutputStream)object).close();
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
            String string = "";
            return string;
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                logger.error("error has occurred.", (Throwable)iOException);
                return "";
            }
        }
        object = c.a(byteArrayOutputStream.toByteArray());
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImageData(String string) {
        if (string == null || string.equals("")) {
            this.image = null;
            return;
        }
        byte[] byArray = c.a(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        u u2 = null;
        try {
            u2 = new u(byteArrayInputStream);
            Object object = u2.readObject();
            u2.close();
            u2 = null;
            if (object instanceof ImageIcon) {
                this.image = (ImageIcon)object;
            }
        }
        catch (IOException iOException) {
            logger.error("error has occurred.", (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error("error has occurred.", (Throwable)classNotFoundException);
        }
        finally {
            try {
                if (u2 != null) {
                    u2.close();
                } else {
                    byteArrayInputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.error("error has occurred.", (Throwable)iOException);
            }
        }
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        return false;
    }

    @Override
    public boolean attributesEqual(UPresentation uPresentation) {
        if (!h.a(uPresentation, LabelPresentation.class)) {
            return false;
        }
        LabelPresentation labelPresentation = (LabelPresentation)uPresentation;
        if (labelPresentation.doAutoResize != this.doAutoResize) {
            return false;
        }
        return super.attributesEqual(labelPresentation);
    }

    @Override
    public void attributesCopy(UPresentation uPresentation) {
        super.attributesCopy(uPresentation);
        if (!(uPresentation instanceof ImagePresentation)) {
            return;
        }
        ImagePresentation imagePresentation = (ImagePresentation)uPresentation;
        this.image = imagePresentation.getImage().e();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.imagePixels != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            ColorModel colorModel = ColorModel.getRGBdefault();
            this.image = new ImageIcon(toolkit.createImage(new MemoryImageSource(this.imageWidth, this.imageHeight, colorModel, this.imagePixels, 0, this.imageWidth)));
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ImageIcon imageIcon = null;
        if (this.image != null) {
            this.imageWidth = this.image.getIconWidth();
            this.imageHeight = this.image.getIconHeight();
            this.imagePixels = this.image != null ? new int[this.imageWidth * this.imageHeight] : null;
            try {
                PixelGrabber pixelGrabber = new PixelGrabber(this.image.getImage(), 0, 0, this.imageWidth, this.imageHeight, this.imagePixels, 0, this.imageWidth);
                pixelGrabber.grabPixels();
                if ((pixelGrabber.getStatus() & 0x80) != 0) {
                    throw new IOException("failed to load image contents");
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("image load interrupted");
            }
            imageIcon = this.image;
            this.image = null;
        }
        objectOutputStream.defaultWriteObject();
        this.image = imageIcon;
    }
}

