/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.er.ERAttribute;
import JP.co.esm.caddies.er.EREntity;
import JP.co.esm.caddies.er.ERRelationshipEnd;
import JP.co.esm.caddies.er.UERDiagram;
import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.model.EntityRoot;
import JP.co.esm.caddies.golf.util.h;
import JP.co.esm.caddies.jomt.jmodel.EREntityPresentation;
import JP.co.esm.caddies.jomt.jmodel.IImagePresentation;
import JP.co.esm.caddies.jomt.jmodel.IMMTopicPresentation;
import JP.co.esm.caddies.jomt.jmodel.IObjectPresentation;
import JP.co.esm.caddies.jomt.jmodel.ITextPresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.UCDescriptionTemplate;
import JP.co.esm.caddies.jomt.jmodel.ah;
import JP.co.esm.caddies.jomt.jmodel.f;
import JP.co.esm.caddies.jomt.jmodel.q;
import JP.co.esm.caddies.jomt.jsystem.c;
import JP.co.esm.caddies.jomt.jsystem.i;
import JP.co.esm.caddies.jomt.jutil.JomtUtilities;
import JP.co.esm.caddies.jomt.jview.db;
import JP.co.esm.caddies.uml.BehavioralElements.ActivityGraphs.UClassifierInState;
import JP.co.esm.caddies.uml.BehavioralElements.ActivityGraphs.UObjectFlowState;
import JP.co.esm.caddies.uml.BehavioralElements.UseCases.UUseCase;
import JP.co.esm.caddies.uml.Foundation.Core.IUPresentation;
import JP.co.esm.caddies.uml.Foundation.Core.UClassifier;
import JP.co.esm.caddies.uml.Foundation.Core.UModelElement;
import JP.co.esm.caddies.uml.Foundation.Core.UNamespace;
import JP.co.esm.caddies.uml.Foundation.ExtensionMechanisms.UTaggedValue;
import JP.co.esm.caddies.uml.ModelManagement.UModel;
import JP.co.esm.caddies.uml.ModelManagement.UPackage;
import JP.co.esm.caddies.uml.util.IExObservable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hyperlink
implements Serializable {
    private static final long serialVersionUID = 7686931783625932084L;
    private String type;
    private String name;
    private String path;
    private String comment;
    private transient IExObservable owner;
    public static final String SEPARATOR = ",";
    public static final String FILE = "file";
    public static final String URL = "url";
    public static final String MODEL = "model";
    private static final Logger logger = LoggerFactory.getLogger(Hyperlink.class);

    public Hyperlink() {
        this.type = "";
        this.name = "";
        this.path = "";
        this.comment = "";
    }

    public Hyperlink(Hyperlink hyperlink) {
        this.type = hyperlink.getType();
        this.name = hyperlink.getName();
        this.path = hyperlink.getPath();
        this.comment = hyperlink.getComment();
    }

    public String getTaggedValueString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type=" + this.type);
        stringBuilder.append(SEPARATOR);
        stringBuilder.append("name=" + this.name);
        stringBuilder.append(SEPARATOR);
        stringBuilder.append("path=" + this.path);
        stringBuilder.append(SEPARATOR);
        stringBuilder.append("comment=" + this.comment);
        return stringBuilder.toString();
    }

    public IExObservable getExObservable() {
        JomtEntityStore jomtEntityStore = c.g.p().doc;
        EntityRoot entityRoot = jomtEntityStore.r();
        IExObservable iExObservable = q.b(entityRoot, this.name);
        if (iExObservable instanceof UTaggedValue && ((UTaggedValue)iExObservable).getInvTaggedValue() instanceof UUseCase && UCDescriptionTemplate.getBuiltInTemplates().size() == 0) {
            return null;
        }
        return iExObservable;
    }

    public String toString() {
        return this.getTaggedValueString();
    }

    public void setValue(Hyperlink hyperlink) {
        this.type = hyperlink.getType();
        this.owner = hyperlink.getOwner();
        this.name = hyperlink.getName();
        this.path = hyperlink.getPath();
        this.comment = hyperlink.getComment();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = h.b(string);
        if (this.comment == null) {
            this.comment = "";
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        if (this.name == null) {
            this.name = "";
        }
    }

    public void setEncodeName(String string) {
        this.setName(h.b(string));
    }

    public IExObservable getOwner() {
        return this.owner;
    }

    public void setOwner(IExObservable iExObservable) {
        this.owner = iExObservable;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        string = JomtUtilities.checkPlusForFilePath(string);
        this.path = h.b(string);
        if (this.path == null) {
            this.path = "";
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
        if (this.type == null) {
            this.type = "";
        }
    }

    public String getHyperlinkName() {
        String string = "";
        if (!this.getType().equals(MODEL)) {
            string = this.getName();
        } else {
            IExObservable iExObservable = this.getExObservable();
            if (iExObservable == null) {
                string = Hyperlink.getTitle("projectview.item.no_reference.label");
            } else if (iExObservable instanceof IUPresentation) {
                if (iExObservable instanceof IMMTopicPresentation || iExObservable instanceof ITextPresentation) {
                    string = ((ITextPresentation)iExObservable).getLabel();
                } else if (iExObservable instanceof IImagePresentation) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Pnt2d pnt2d = ((IImagePresentation)iExObservable).getLocation();
                    bv bv2 = ((IImagePresentation)iExObservable).getImage();
                    stringBuilder.append(Hyperlink.getTitle("uml.image_presentation.label"));
                    stringBuilder.append("(");
                    stringBuilder.append(pnt2d.getX());
                    stringBuilder.append(" ");
                    stringBuilder.append(pnt2d.getY());
                    stringBuilder.append(" ");
                    stringBuilder.append(bv2.a());
                    stringBuilder.append(" ");
                    stringBuilder.append(bv2.b());
                    stringBuilder.append(")");
                    string = stringBuilder.toString();
                } else {
                    UClassifier uClassifier;
                    UClassifier uClassifier2;
                    UModelElement uModelElement = ((IUPresentation)iExObservable).getModel();
                    string = uModelElement instanceof UClassifier && f.d((UClassifier)((IUPresentation)iExObservable).getModel()) ? JomtUtilities.getAnonymousBoundClassInfo((UClassifier)((IUPresentation)iExObservable).getModel()) : (uModelElement instanceof UObjectFlowState ? ((uClassifier2 = ((UObjectFlowState)uModelElement).getType()) instanceof UClassifierInState ? ((uClassifier = ((UClassifierInState)uClassifier2).getType()) != null ? uClassifier.getNameString() : ((IUPresentation)iExObservable).getName()) : ((IUPresentation)iExObservable).getName()) : ((IUPresentation)iExObservable).getName());
                }
            } else if (iExObservable instanceof UModelElement) {
                string = iExObservable instanceof UClassifier && f.d((UClassifier)iExObservable) ? JomtUtilities.getAnonymousBoundClassInfo((UClassifier)iExObservable) : ((UModelElement)iExObservable).getNameString();
            } else if (iExObservable instanceof UTaggedValue) {
                string = Hyperlink.getTitle("uml.usecase_description.label");
            }
            string = string.replaceAll("\n", " ");
        }
        return string;
    }

    public String getHyperlinkPath() {
        String string = "";
        if (!this.getType().equals(MODEL)) {
            string = this.getPath();
        } else {
            IExObservable iExObservable = this.getExObservable();
            if (iExObservable == null) {
                string = "";
            } else {
                Object object;
                UNamespace uNamespace = null;
                if (iExObservable instanceof IUPresentation) {
                    uNamespace = ((IUPresentation)iExObservable).getDiagram().getNamespace();
                } else if (iExObservable instanceof UModelElement) {
                    uNamespace = ((UModelElement)iExObservable).getNamespace();
                }
                if (uNamespace != null) {
                    object = "";
                    object = this.isERRelated(iExObservable) ? this.createFullPathNameWithoutScheam(uNamespace) : uNamespace.getFullName();
                    int n2 = ((String)object).indexOf("::");
                    if (n2 != -1) {
                        string = ((String)object).substring(n2 + 2);
                    }
                }
                if (iExObservable instanceof IUPresentation) {
                    object = ((IUPresentation)iExObservable).getDiagram().getNameString();
                    string = string.equals("") ? string + (String)object : string + "::" + (String)object;
                } else if (iExObservable instanceof UTaggedValue) {
                    object = (UTaggedValue)iExObservable;
                    string = object.getInvTaggedValue().getNameString();
                }
            }
        }
        return string;
    }

    private boolean isERRelated(IExObservable iExObservable) {
        return iExObservable instanceof EREntity || iExObservable instanceof ERAttribute || iExObservable instanceof ERRelationshipEnd || iExObservable instanceof EREntityPresentation || iExObservable instanceof UERDiagram;
    }

    private String createFullPathNameWithoutScheam(UNamespace uNamespace) {
        StringBuilder stringBuilder = new StringBuilder();
        UNamespace uNamespace2 = uNamespace;
        while (!this.isERScheam(uNamespace2) && !this.isERModel(uNamespace2)) {
            stringBuilder.insert(0, uNamespace2.getNameString());
            stringBuilder.insert(0, "::");
            uNamespace2 = uNamespace2.getNamespace();
        }
        if (this.isERModel(uNamespace2)) {
            stringBuilder.insert(0, uNamespace2.getNameString());
        }
        if (this.isERScheam(uNamespace2)) {
            stringBuilder.insert(0, uNamespace2.getNamespace().getFullName());
        }
        return stringBuilder.toString();
    }

    private boolean isERModel(UNamespace uNamespace) {
        if (!(uNamespace instanceof UModel)) {
            return false;
        }
        return ah.a((UModel)uNamespace);
    }

    private boolean isERScheam(UNamespace uNamespace) {
        if (!(uNamespace instanceof UPackage)) {
            return false;
        }
        return ah.a((UPackage)uNamespace);
    }

    public String getHyperlinkComment() {
        return this.getComment();
    }

    private static String getTitle(String string) {
        String string2 = i.h().a(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public Icon getDisplayIcon() {
        Icon icon = null;
        String string = this.getType();
        if (string.equals(FILE)) {
            String string2 = this.getPath() + System.getProperty("file.separator") + this.getName();
            File file = new File(string2);
            File file2 = null;
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                logger.error("error has occurred.", (Throwable)iOException);
            }
            if (file2 != null && file2.canRead()) {
                icon = FileSystemView.getFileSystemView().getSystemIcon(file2);
            }
        } else if (string.equals(URL)) {
            icon = db.bu();
        } else if (string.equals(MODEL)) {
            IExObservable iExObservable = this.getExObservable();
            if (iExObservable instanceof IUPresentation) {
                String string3;
                icon = iExObservable instanceof IMMTopicPresentation ? db.br() : (iExObservable instanceof IObjectPresentation ? ((string3 = ((IObjectPresentation)iExObservable).getDiagram().getDiagramType()).equals("Collaboration Diagram") ? db.ak() : db.Q()) : db.a(((IUPresentation)iExObservable).getModel()));
            } else if (iExObservable instanceof UModelElement) {
                icon = db.a((UModelElement)iExObservable);
            } else if (iExObservable instanceof UTaggedValue) {
                icon = db.L();
            }
        }
        return icon;
    }

    public String getDisplayName() {
        if (!this.getComment().equals("")) {
            return this.getComment();
        }
        if (this.getType().equals(MODEL)) {
            IExObservable iExObservable = this.getExObservable();
            if (iExObservable == null) {
                return Hyperlink.getTitle("projectview.item.no_reference.label");
            }
            if (iExObservable instanceof IUPresentation) {
                UClassifier uClassifier;
                UClassifier uClassifier2;
                if (iExObservable instanceof IMMTopicPresentation) {
                    return ((IMMTopicPresentation)iExObservable).getLabel() + " " + Hyperlink.getTitle("projectview.item.diagram_element.label");
                }
                UModelElement uModelElement = ((IUPresentation)iExObservable).getModel();
                String string = uModelElement instanceof UClassifier && f.d((UClassifier)((IUPresentation)iExObservable).getModel()) ? JomtUtilities.getAnonymousBoundClassInfo((UClassifier)((IUPresentation)iExObservable).getModel()) : (uModelElement instanceof UObjectFlowState ? ((uClassifier2 = ((UObjectFlowState)uModelElement).getType()) instanceof UClassifierInState ? ((uClassifier = ((UClassifierInState)uClassifier2).getType()) != null ? uClassifier.getNameString() : ((IUPresentation)iExObservable).getName()) : ((IUPresentation)iExObservable).getName()) : ((IUPresentation)iExObservable).getName());
                return string + " " + Hyperlink.getTitle("projectview.item.diagram_element.label");
            }
            if (iExObservable instanceof UModelElement) {
                if (iExObservable instanceof UClassifier && f.d((UClassifier)iExObservable)) {
                    return JomtUtilities.getAnonymousBoundClassInfo((UClassifier)iExObservable);
                }
                return ((UModelElement)iExObservable).getNameString();
            }
            if (iExObservable instanceof UTaggedValue) {
                UTaggedValue uTaggedValue = (UTaggedValue)iExObservable;
                return Hyperlink.getTitle("uml.usecase_description.label") + " - " + uTaggedValue.getInvTaggedValue().getNameString();
            }
        }
        return this.getName();
    }

    public boolean equals(Object object) {
        Hyperlink hyperlink;
        return object instanceof Hyperlink && this.equals(this.type, (hyperlink = (Hyperlink)object).getType()) && this.equals(this.name, hyperlink.getName()) && this.equals(this.path, hyperlink.getPath()) && this.equals(this.comment, hyperlink.getComment());
    }

    private boolean equals(Object object, Object object2) {
        return object == null && object2 == null || object != null && object.equals(object2);
    }
}

