/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.geom2D.Rectangle2d;
import JP.co.esm.caddies.golf.geom2D.Vec2d;
import JP.co.esm.caddies.jomt.jmodel.BinaryRelationPresentation;
import JP.co.esm.caddies.jomt.jmodel.IDurationConstraintPresentation;
import JP.co.esm.caddies.jomt.jmodel.IMessagePresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.uml.BehavioralElements.Collaborations.UDurationConstraint;
import JP.co.esm.caddies.uml.Foundation.Core.IUPresentation;
import JP.co.esm.caddies.uml.Foundation.Core.UConstraint;
import java.util.Arrays;
import java.util.List;

public class DurationConstraintPresentation
extends BinaryRelationPresentation
implements IDurationConstraintPresentation {
    private static final long serialVersionUID = 3873033629197428262L;
    private static double WIDTH = 1.0;

    @Override
    protected String getIndicatoryName() {
        String string = "";
        if (this.model instanceof UDurationConstraint) {
            UDurationConstraint uDurationConstraint = (UDurationConstraint)this.model;
            string = uDurationConstraint.getBody().getBody().getBody();
        }
        return String.format("{%s}", string);
    }

    @Override
    public Pnt2d getDefaultNamePnt() {
        Pnt2d pnt2d = this.getMiddlePnt();
        if (pnt2d == null) {
            return null;
        }
        pnt2d.x += 9.0;
        return pnt2d;
    }

    @Override
    public void move(Vec2d vec2d) {
        this.setChanged();
        if (this.points != null) {
            for (int i2 = 0; i2 < this.points.length; ++i2) {
                this.points[i2].add(vec2d);
            }
            this.updatePoints();
        }
    }

    @Override
    public void updatePoints() {
        Rectangle2d rectangle2d = this.getSourceRect();
        Rectangle2d rectangle2d2 = this.getTargetRect();
        if (rectangle2d != null && rectangle2d2 != null && this.points != null && this.points.length == 2) {
            if (this.points[0].y != rectangle2d.y) {
                this.points[0].set(this.points[0].x, rectangle2d.y);
            }
            if (this.points[1].y != rectangle2d2.y) {
                this.points[1].set(this.points[1].x, rectangle2d2.y);
            }
            this.allPoints = Arrays.copyOf(this.points, 2);
            this.outerPoints = Arrays.copyOf(this.points, 2);
        }
        if (!suppressResize) {
            this.updateNamePresentation();
        }
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        if (string.equals("line.shape")) {
            return false;
        }
        return super.isSupportedStyleKey(string);
    }

    @Override
    public void validate(JomtEntityStore jomtEntityStore) {
        if (this.getServerNum() != 2) {
            this.sizeErrorMsg(this.getServers(), "servers should be two");
        } else if (!(this.getServer(0) instanceof IMessagePresentation) || !(this.getServer(1) instanceof IMessagePresentation)) {
            this.errorMsg(this, "servers should be Messages");
        } else {
            IMessagePresentation iMessagePresentation = (IMessagePresentation)this.getServer(0);
            IMessagePresentation iMessagePresentation2 = (IMessagePresentation)this.getServer(1);
            List list = ((UConstraint)this.getModel()).getConstrainedElements();
            if (list.size() != 2 || iMessagePresentation.getMessage() != list.get(0) || iMessagePresentation2.getMessage() != list.get(1)) {
                this.errorMsg(this, "server presentation's model is NG");
            }
        }
        super.validate(jomtEntityStore);
    }

    @Override
    public Rectangle2d getSourceRect() {
        IUPresentation iUPresentation = this.getSourcePresentation();
        if (iUPresentation != null) {
            if (iUPresentation instanceof IMessagePresentation) {
                return this.getRectangle((IMessagePresentation)iUPresentation);
            }
            return super.getSourceRect();
        }
        return null;
    }

    @Override
    public Rectangle2d getTargetRect() {
        IUPresentation iUPresentation = this.getTargetPresentation();
        if (iUPresentation != null) {
            if (iUPresentation instanceof IMessagePresentation) {
                return this.getRectangle((IMessagePresentation)iUPresentation);
            }
            return super.getSourceRect();
        }
        return null;
    }

    public Pnt2d getMiddlePnt(IMessagePresentation iMessagePresentation) {
        Pnt2d[] pnt2dArray = iMessagePresentation.getOuterPoints();
        if (pnt2dArray == null) {
            pnt2dArray = iMessagePresentation.getAllPoints();
        }
        if (pnt2dArray == null) {
            return null;
        }
        Pnt2d[] pnt2dArray2 = Arrays.copyOf(pnt2dArray, 2);
        return DurationConstraintPresentation.getMiddlePnt(pnt2dArray2);
    }

    private Rectangle2d getRectangle(IMessagePresentation iMessagePresentation) {
        Pnt2d pnt2d = this.getMiddlePnt(iMessagePresentation);
        if (pnt2d != null) {
            return new Rectangle2d(pnt2d.x - WIDTH / 2.0, pnt2d.y - WIDTH / 2.0, WIDTH, WIDTH);
        }
        return null;
    }
}

