/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.jomt.jmodel.AssociationPresentation;
import JP.co.esm.caddies.jomt.jmodel.IClassifierPresentation;
import JP.co.esm.caddies.jomt.jmodel.IConnectorPresentation;
import JP.co.esm.caddies.jomt.jmodel.IJomtPresentation;
import JP.co.esm.caddies.jomt.jmodel.ILabelPresentation;
import JP.co.esm.caddies.jomt.jmodel.IPartPresentation;
import JP.co.esm.caddies.jomt.jmodel.IPortPresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.q;
import JP.co.esm.caddies.uml.Foundation.Core.IUPresentation;
import JP.co.esm.caddies.uml.Foundation.Core.UAssociation;
import JP.co.esm.caddies.uml.Foundation.Core.UAssociationEnd;
import JP.co.esm.caddies.uml.Foundation.Core.UConnector;
import JP.co.esm.caddies.uml.Foundation.Core.UConnectorEnd;
import JP.co.esm.caddies.uml.Foundation.Core.UConstraint;
import JP.co.esm.caddies.uml.Foundation.ExtensionMechanisms.UStereotype;
import java.util.HashSet;
import java.util.List;

public class ConnectorPresentation
extends AssociationPresentation
implements IConnectorPresentation {
    private static final long serialVersionUID = -6491890739052897289L;

    @Override
    public void setDepth(int n2) {
        this.setChanged();
        if (this.getRolesMinDepth() == 0 && this.getServers().isEmpty()) {
            super.setDepth(n2);
        } else {
            super.setDepth(this.getRolesMinDepth() - 2);
        }
    }

    private int getRolesMinDepth() {
        if (!this.getServers().isEmpty()) {
            ILabelPresentation iLabelPresentation = (ILabelPresentation)this.getServer(0);
            ILabelPresentation iLabelPresentation2 = (ILabelPresentation)this.getServer(1);
            return Math.min(this.getDepth(), Math.min(iLabelPresentation.getDepth(), iLabelPresentation2.getDepth()));
        }
        return this.getDepth();
    }

    @Override
    public String getLabel() {
        UAssociation uAssociation;
        String string = this.getNamePresentation().getLabel();
        UConnector uConnector = (UConnector)this.getModel();
        if (uConnector != null && (uAssociation = uConnector.getBase()) != null && !"".equals(uAssociation.getNameString())) {
            string = string + ":" + uAssociation.getNameString();
        }
        return string;
    }

    @Override
    protected void validateServers(JomtEntityStore jomtEntityStore) {
        List list = this.getServers();
        if (list == null) {
            this.nullErrorMsg(this, "servers is null");
        }
        if (list.size() != 2) {
            this.sizeErrorMsg(list, "connector servers");
        }
        super.validateServers(jomtEntityStore);
        HashSet<IUPresentation> hashSet = new HashSet<IUPresentation>();
        for (IJomtPresentation iJomtPresentation : list) {
            if (iJomtPresentation instanceof IPartPresentation) {
                hashSet.add(iJomtPresentation.getContainer());
                continue;
            }
            if (iJomtPresentation instanceof IPortPresentation) {
                IUPresentation iUPresentation;
                if (iJomtPresentation.getServerNum() != 1) {
                    this.sizeErrorMsg(iJomtPresentation.getServers(), "connector's server-port's server");
                }
                if ((iUPresentation = iJomtPresentation.getServer(0)) instanceof IPartPresentation) {
                    hashSet.add(((IPartPresentation)iUPresentation).getContainer());
                    continue;
                }
                if (!(iUPresentation instanceof IClassifierPresentation)) continue;
                hashSet.add(iUPresentation);
                continue;
            }
            this.errorMsg(this, "connectorPresentation's server is invalid");
        }
        if (hashSet.size() != 1) {
            this.errorMsg(this, "ConnectorPresentation's servers not in same container");
        }
    }

    @Override
    public void setVisibility(boolean bl2) {
        this.setChanged();
        this.visibility = bl2;
    }

    @Override
    public UAssociationEnd getAssociationEndA() {
        return this.getAssociationEndFromConnectorEnd(0);
    }

    @Override
    public UAssociationEnd getAssociationEndB() {
        return this.getAssociationEndFromConnectorEnd(1);
    }

    private UAssociationEnd getAssociationEndFromConnectorEnd(int n2) {
        if (n2 != 0 && n2 != 1) {
            return null;
        }
        UAssociationEnd uAssociationEnd = null;
        UConnector uConnector = (UConnector)this.getModel();
        if (uConnector != null) {
            UConnectorEnd uConnectorEnd = (UConnectorEnd)uConnector.getConnection(n2);
            uAssociationEnd = q.a(uConnectorEnd);
        }
        return uAssociationEnd;
    }

    @Override
    public UConstraint getConstraintModel(int n2) {
        UConnector uConnector;
        if (this.model != null && (uConnector = (UConnector)this.model).getBase() != null && uConnector.getBase().getConstraints().size() > n2 && n2 >= 0) {
            return (UConstraint)uConnector.getBase().getConstraints().get(n2);
        }
        return super.getConstraintModel(n2);
    }

    @Override
    public List getConstraintModels() {
        UConnector uConnector;
        if (this.model != null && (uConnector = (UConnector)this.model).getBase() != null) {
            return uConnector.getBase().getConstraints();
        }
        return super.getConstraintModels();
    }

    @Override
    public UStereotype getStereotypeModel(int n2) {
        UConnector uConnector;
        if (this.model != null && (uConnector = (UConnector)this.model).getBase() != null && uConnector.getBase().getStereotypes().size() > n2 && n2 >= 0) {
            return (UStereotype)uConnector.getBase().getStereotypes().get(n2);
        }
        return super.getStereotypeModel(n2);
    }

    @Override
    public void setConnectorVisibility(boolean bl2) {
        if (this.getNamePresentation() != null) {
            this.getNamePresentation().setVisibility(bl2);
        }
        this.setVisibility(bl2);
        this.setMultiplicityVisibility(bl2);
        this.setRoleNameVisibility(bl2);
        this.setConstraintVisibility(bl2);
        this.setStereotypeVisibility(bl2);
    }

    @Override
    public List getVisibleStereotypes() {
        UConnector uConnector = (UConnector)this.model;
        List list = null;
        list = uConnector != null && uConnector.getBase() != null ? uConnector.getBase().getStereotypes() : super.getVisibleStereotypes();
        return list;
    }
}

