/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.jomt.jmodel;

import JP.co.esm.caddies.golf.geom2D.Pnt2d;
import JP.co.esm.caddies.golf.geom2D.Rectangle2d;
import JP.co.esm.caddies.jomt.jmodel.IActivationPresentation;
import JP.co.esm.caddies.jomt.jmodel.IBinaryRelationPresentation;
import JP.co.esm.caddies.jomt.jmodel.IClassifierPresentation;
import JP.co.esm.caddies.jomt.jmodel.ILabelPresentation;
import JP.co.esm.caddies.jomt.jmodel.IMessagePresentation;
import JP.co.esm.caddies.jomt.jmodel.IPartPresentation;
import JP.co.esm.caddies.jomt.jmodel.IPortPresentation;
import JP.co.esm.caddies.jomt.jmodel.IRectPresentation;
import JP.co.esm.caddies.jomt.jmodel.ITerminationPresentation;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.PathPresentation;
import JP.co.esm.caddies.jomt.jmodel.Z;
import JP.co.esm.caddies.jomt.jmodel.ad;
import JP.co.esm.caddies.jomt.jutil.JomtUtilities;
import JP.co.esm.caddies.uml.Foundation.Core.IUPresentation;
import JP.co.esm.caddies.uml.Foundation.Core.UPresentation;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryRelationPresentation
extends PathPresentation
implements IBinaryRelationPresentation {
    private static final Logger logger = LoggerFactory.getLogger(BinaryRelationPresentation.class);
    static final long serialVersionUID = -280041293397631763L;
    protected double sourceEndX = 0.5;
    protected double sourceEndY = 0.5;
    protected double targetEndX = 0.5;
    protected double targetEndY = 0.5;
    private boolean rightAngle = false;
    private static boolean suppressUpdate = false;
    private static final int SOURCE_SERVER = 0;
    private static final int TARGET_SERVER = 1;
    protected boolean visibility = true;

    @Override
    public void setSourcePresentation(IUPresentation iUPresentation) {
        this.setChanged();
        this.addServer(iUPresentation, 0);
        this.updatePoints();
    }

    @Override
    public IUPresentation getSourcePresentation() {
        return this.getServer(0);
    }

    @Override
    public void setTargetPresentation(IUPresentation iUPresentation) {
        this.setChanged();
        this.addServer(iUPresentation, 1);
        this.updatePoints();
    }

    @Override
    public IUPresentation getTargetPresentation() {
        return this.getServer(1);
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return this.isValidPReference();
    }

    @Override
    public boolean isValidPReference() {
        return this.getServerNum() >= 2 && this.getServer(0) != null && this.getServer(1) != null;
    }

    @Override
    public void setSourceEnd(double d2, double d3) {
        if (this.sourceEndX == d2 && this.sourceEndY == d3) {
            return;
        }
        this.setChanged();
        this.sourceEndX = d2 <= 0.01 ? 0.01 : (d2 >= 0.99 ? 0.99 : d2);
        this.sourceEndY = d3 <= 0.01 ? 0.01 : (d3 >= 0.99 ? 0.99 : d3);
        this.updatePoints();
    }

    @Override
    public void setSourceEnd(Pnt2d pnt2d) {
        this.setSourceEnd(pnt2d.x, pnt2d.y);
    }

    @Override
    public void setTargetEnd(double d2, double d3) {
        if (this.targetEndX == d2 && this.targetEndY == d3) {
            return;
        }
        this.targetEndX = d2 <= 0.01 ? 0.01 : (d2 >= 0.99 ? 0.99 : d2);
        this.targetEndY = d3 <= 0.01 ? 0.01 : (d3 >= 0.99 ? 0.99 : d3);
        this.updatePoints();
    }

    @Override
    public void setTargetEnd(Pnt2d pnt2d) {
        this.setTargetEnd(pnt2d.x, pnt2d.y);
    }

    @Override
    public double getSourceEndX() {
        return this.sourceEndX;
    }

    @Override
    public double getSourceEndY() {
        return this.sourceEndY;
    }

    @Override
    public double getTargetEndX() {
        return this.targetEndX;
    }

    @Override
    public double getTargetEndY() {
        return this.targetEndY;
    }

    @Override
    public void updatePoints() {
        if (!BinaryRelationPresentation.isSuppressUpdate()) {
            if (this.isSelfRelation() && !this.isRightAngleConstraint()) {
                Rectangle2d rectangle2d = this.getSourceRect();
                Pnt2d[] pnt2dArray = this.getPoints();
                boolean bl2 = true;
                for (int i2 = 0; i2 < pnt2dArray.length; ++i2) {
                    if (rectangle2d.contains(pnt2dArray[i2])) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    this.setRightAngleConstraint(true);
                    return;
                }
            }
            if (this.isRightAngleConstraint()) {
                this.updatePointsForRightAngle();
            } else if (this.isCurve()) {
                this.removeUnusedMiddlePoints();
            }
        }
        super.updatePoints();
    }

    private void removeUnusedMiddlePoints() {
        Pnt2d[] pnt2dArray = this.getPoints();
        if (pnt2dArray == null || pnt2dArray.length < 3) {
            return;
        }
        Pnt2d[] pnt2dArray2 = new Pnt2d[]{pnt2dArray[0], pnt2dArray[pnt2dArray.length - 1]};
        this.setPoints(pnt2dArray2);
    }

    @Override
    public boolean isSelfRelation() {
        return this.getSourcePresentation() != null && this.getSourcePresentation() == this.getTargetPresentation();
    }

    @Override
    public void updatePointsForRightAngle() {
        this.updateAllPoints();
        Pnt2d[] pnt2dArray = this.getAllPoints();
        if (pnt2dArray == null) {
            return;
        }
        if ((pnt2dArray = this.removeContainPnts(pnt2dArray)).length == 2) {
            if (pnt2dArray[0].x != pnt2dArray[1].x && pnt2dArray[0].y != pnt2dArray[1].y) {
                if (Z.a(this)) {
                    this.points = new Pnt2d[2];
                    Rectangle2d rectangle2d = this.getSourceRect();
                    Rectangle2d rectangle2d2 = this.getTargetRect();
                    this.points[0] = rectangle2d.getMaxY() < rectangle2d2.getMaxY() ? new Pnt2d(pnt2dArray[0].x, (rectangle2d.getMaxY() + rectangle2d2.getMinY()) / 2.0) : new Pnt2d(pnt2dArray[0].x, (rectangle2d2.getMaxY() + rectangle2d.getMinY()) / 2.0);
                    this.points[1] = new Pnt2d(pnt2dArray[1].x, this.points[0].y);
                } else if (Z.b(this)) {
                    this.points = new Pnt2d[2];
                    Rectangle2d rectangle2d = this.getSourceRect();
                    Rectangle2d rectangle2d3 = this.getTargetRect();
                    this.points[0] = rectangle2d.getMaxX() < rectangle2d3.getMaxX() ? new Pnt2d((rectangle2d.getMaxX() + rectangle2d3.getMinX()) / 2.0, pnt2dArray[0].y) : new Pnt2d((rectangle2d3.getMaxX() + rectangle2d.getMinX()) / 2.0, pnt2dArray[0].y);
                    this.points[1] = new Pnt2d(this.points[0].x, pnt2dArray[1].y);
                } else {
                    Pnt2d pnt2d = new Pnt2d(pnt2dArray[0].x, pnt2dArray[1].y);
                    this.points = new Pnt2d[1];
                    this.points[0] = pnt2d;
                }
            }
        } else {
            if (pnt2dArray[0].x != pnt2dArray[1].x && pnt2dArray[0].y != pnt2dArray[1].y) {
                if (Z.a(pnt2dArray[1], pnt2dArray[2])) {
                    this.points[0].x = pnt2dArray[0].x;
                    pnt2dArray[1].x = pnt2dArray[0].x;
                } else {
                    this.points[0].y = pnt2dArray[0].y;
                    pnt2dArray[1].y = pnt2dArray[0].y;
                }
            }
            if (pnt2dArray[pnt2dArray.length - 1].x != pnt2dArray[pnt2dArray.length - 2].x && pnt2dArray[pnt2dArray.length - 1].y != pnt2dArray[pnt2dArray.length - 2].y) {
                if (Z.a(pnt2dArray[pnt2dArray.length - 2], pnt2dArray[pnt2dArray.length - 3])) {
                    this.points[this.points.length - 1].x = pnt2dArray[pnt2dArray.length - 1].x;
                    pnt2dArray[pnt2dArray.length - 2].x = pnt2dArray[pnt2dArray.length - 1].x;
                } else {
                    this.points[this.points.length - 1].y = pnt2dArray[pnt2dArray.length - 1].y;
                    pnt2dArray[pnt2dArray.length - 2].y = pnt2dArray[pnt2dArray.length - 1].y;
                }
            }
        }
        this.optimizeThroughPnts();
        if (this.points.length == 0 && this.getSourcePresentation() == this.getTargetPresentation()) {
            this.createSelfReference();
        }
    }

    protected Pnt2d[] removeContainPnts(Pnt2d[] pnt2dArray) {
        IUPresentation iUPresentation;
        Cloneable cloneable;
        ArrayList<Pnt2d> arrayList = new ArrayList<Pnt2d>();
        arrayList.add(pnt2dArray[0]);
        int n2 = 1;
        Rectangle2d rectangle2d = this.getSourceRect();
        IUPresentation iUPresentation2 = this.getSourcePresentation();
        if (iUPresentation2 instanceof IPortPresentation && (cloneable = ((IPortPresentation)iUPresentation2).getServer(0)) instanceof IPartPresentation) {
            rectangle2d = ((IPartPresentation)cloneable).getRect();
        }
        while (n2 < pnt2dArray.length && rectangle2d.contains(pnt2dArray[n2])) {
            ++n2;
        }
        while (n2 < pnt2dArray.length) {
            arrayList.add(pnt2dArray[n2]);
            ++n2;
        }
        if (arrayList.size() == 1) {
            arrayList.add(pnt2dArray[pnt2dArray.length - 1]);
        }
        cloneable = this.getTargetRect();
        IUPresentation iUPresentation3 = this.getTargetPresentation();
        if (iUPresentation3 instanceof IPortPresentation && (iUPresentation = ((IPortPresentation)iUPresentation3).getServer(0)) instanceof IPartPresentation) {
            cloneable = ((IPartPresentation)iUPresentation).getRect();
        }
        while (arrayList.size() > 2 && ((RectangularShape)cloneable).contains((Pnt2d)arrayList.get(arrayList.size() - 2))) {
            arrayList.remove(arrayList.size() - 2);
        }
        return arrayList.toArray(new Pnt2d[arrayList.size()]);
    }

    protected void createSelfReference() {
        Rectangle2d rectangle2d = this.getSourceRect();
        this.points = new Pnt2d[2];
        this.points[0] = new Pnt2d(rectangle2d.getCenterX() - 10.0, rectangle2d.getMinY() - 20.0);
        this.points[1] = new Pnt2d(rectangle2d.getCenterX() + 10.0, rectangle2d.getMinY() - 20.0);
        this.sourceEndX = (rectangle2d.getWidth() / 2.0 - 10.0) / rectangle2d.getWidth();
        this.sourceEndY = 0.5;
        this.targetEndX = (rectangle2d.getWidth() / 2.0 + 10.0) / rectangle2d.getWidth();
        this.targetEndY = 0.5;
    }

    @Override
    public void updateAllPoints() {
        Pnt2d pnt2d = this.getSourceEndPnt();
        Pnt2d pnt2d2 = this.getTargetEndPnt();
        if (pnt2d == null || pnt2d2 == null) {
            this.allPoints = null;
            return;
        }
        Pnt2d[] pnt2dArray = this.getPoints();
        this.allPoints = pnt2dArray != null ? new Pnt2d[pnt2dArray.length + 2] : new Pnt2d[2];
        this.allPoints[0] = pnt2d;
        if (pnt2dArray != null) {
            for (int i2 = 0; i2 < pnt2dArray.length; ++i2) {
                this.allPoints[i2 + 1] = pnt2dArray[i2];
            }
        }
        this.allPoints[this.allPoints.length - 1] = pnt2d2;
    }

    @Override
    public void updateOuterPoints() {
        Rectangle2d rectangle2d = this.getSourceRect();
        Rectangle2d rectangle2d2 = this.getTargetRect();
        Pnt2d[] pnt2dArray = this.getAllPoints();
        this.outerPoints = JomtUtilities.getOuterPnts(rectangle2d, rectangle2d2, pnt2dArray);
        if (this.outerPoints == null) {
            logger.debug("updateOuterPoints : outerPoints = null");
        } else {
            Pnt2d pnt2d;
            IUPresentation iUPresentation = this.getServer(0);
            IUPresentation iUPresentation2 = this.getServer(1);
            if (iUPresentation instanceof IClassifierPresentation && ((IClassifierPresentation)iUPresentation).isTemplateParameterVisibility() && this.isNormalNotationType((IClassifierPresentation)iUPresentation) && (pnt2d = ((IClassifierPresentation)iUPresentation).getTemplateParameterRect().getCrossPointWithLine(this.outerPoints[1].x, this.outerPoints[1].y, this.outerPoints[0].x, this.outerPoints[0].y)) != null) {
                this.outerPoints[0] = pnt2d;
            }
            if (iUPresentation2 instanceof IClassifierPresentation && ((IClassifierPresentation)iUPresentation2).isTemplateParameterVisibility() && this.isNormalNotationType((IClassifierPresentation)iUPresentation2)) {
                int n2 = this.outerPoints.length - 1;
                Pnt2d pnt2d2 = ((IClassifierPresentation)iUPresentation2).getTemplateParameterRect().getCrossPointWithLine(this.outerPoints[n2 - 1].x, this.outerPoints[n2 - 1].y, this.outerPoints[n2].x, this.outerPoints[n2].y);
                if (pnt2d2 != null) {
                    this.outerPoints[n2] = pnt2d2;
                }
            }
        }
    }

    protected boolean isNormalNotationType(ILabelPresentation iLabelPresentation) {
        if ((iLabelPresentation.getNotationType() == 1 || iLabelPresentation.getNotationType() == 3) && ad.b(iLabelPresentation.getModel())) {
            return false;
        }
        return iLabelPresentation.getNotationType() != 2 || !this.isValidCustomIcon();
    }

    @Override
    public Pnt2d getSourceEndPnt() {
        return BinaryRelationPresentation.getPntOnRect(this.getSourceRect(), this.sourceEndX, this.sourceEndY);
    }

    @Override
    public Pnt2d getTargetEndPnt() {
        return BinaryRelationPresentation.getPntOnRect(this.getTargetRect(), this.targetEndX, this.targetEndY);
    }

    @Override
    public Rectangle2d getSourceRect() {
        IUPresentation iUPresentation = this.getSourcePresentation();
        if (iUPresentation != null) {
            Pnt2d pnt2d;
            if (iUPresentation instanceof ILabelPresentation) {
                return ((ILabelPresentation)iUPresentation).getRect();
            }
            if (iUPresentation instanceof IActivationPresentation) {
                return ((IActivationPresentation)iUPresentation).getRect();
            }
            if (iUPresentation instanceof IBinaryRelationPresentation && (pnt2d = ((IBinaryRelationPresentation)iUPresentation).getMiddlePnt()) != null) {
                return new Rectangle2d(pnt2d.x - 0.5, pnt2d.y - 0.5, 1.0, 1.0);
            }
        }
        return null;
    }

    @Override
    public Pnt2d getMiddlePnt() {
        if (this.isCurve()) {
            return this.getCurveMiddlePnt();
        }
        return super.getMiddlePnt();
    }

    private Pnt2d getCurveMiddlePnt() {
        Pnt2d[] pnt2dArray = this.getOuterPoints();
        if (pnt2dArray == null) {
            pnt2dArray = this.getAllPoints();
        }
        if (pnt2dArray == null) {
            return null;
        }
        double d2 = (pnt2dArray[0].x + 3.0 * (pnt2dArray[1].x + pnt2dArray[pnt2dArray.length - 2].x) + pnt2dArray[pnt2dArray.length - 1].x) / 8.0;
        double d3 = (pnt2dArray[0].y + 3.0 * (pnt2dArray[1].y + pnt2dArray[pnt2dArray.length - 2].y) + pnt2dArray[pnt2dArray.length - 1].y) / 8.0;
        return new Pnt2d(d2, d3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Rectangle2d getTargetRect() {
        IUPresentation iUPresentation = this.getTargetPresentation();
        if (iUPresentation == null) return null;
        if (iUPresentation instanceof ILabelPresentation) {
            return ((ILabelPresentation)iUPresentation).getRect();
        }
        if (iUPresentation instanceof IActivationPresentation) {
            IActivationPresentation iActivationPresentation = (IActivationPresentation)iUPresentation;
            if (!iActivationPresentation.isTargetApOfCreateMsg()) return iActivationPresentation.getRect();
            if (!(this instanceof IMessagePresentation)) return null;
            if (((IMessagePresentation)((Object)this)).isReturnMsgPresentation()) {
                return iActivationPresentation.getRect();
            }
            if (!((IMessagePresentation)((Object)this)).isCreateMsgPresentation()) return iActivationPresentation.getRect();
            return iActivationPresentation.getFather().getRect();
        }
        if (iUPresentation instanceof IBinaryRelationPresentation) {
            Pnt2d pnt2d = ((IBinaryRelationPresentation)iUPresentation).getMiddlePnt();
            if (pnt2d == null) return null;
            return new Rectangle2d(pnt2d.x - 0.5, pnt2d.y - 0.5, 1.0, 1.0);
        }
        if (!(iUPresentation instanceof ITerminationPresentation)) return null;
        return ((IRectPresentation)iUPresentation).getRect();
    }

    public static Pnt2d getPntOnRect(Rectangle2d rectangle2d, double d2, double d3) {
        if (rectangle2d == null) {
            return null;
        }
        double d4 = rectangle2d.x + rectangle2d.width * d2;
        double d5 = rectangle2d.y + rectangle2d.height * d3;
        return new Pnt2d(d4, d5);
    }

    @Override
    public void storeState(Hashtable hashtable) {
        hashtable.put("sourceEndX", new Double(this.sourceEndX));
        hashtable.put("sourceEndY", new Double(this.sourceEndY));
        hashtable.put("targetEndX", new Double(this.targetEndX));
        hashtable.put("targetEndY", new Double(this.targetEndY));
        hashtable.put("visibility", this.visibility);
        super.storeState(hashtable);
    }

    @Override
    public void restoreState(Hashtable hashtable) {
        this.setChanged();
        Object var2_2 = null;
        var2_2 = hashtable.get("sourceEndX");
        if (var2_2 != null) {
            this.sourceEndX = var2_2;
        }
        if ((var2_2 = hashtable.get("sourceEndY")) != null) {
            this.sourceEndY = var2_2;
        }
        if ((var2_2 = hashtable.get("targetEndX")) != null) {
            this.targetEndX = var2_2;
        }
        if ((var2_2 = hashtable.get("targetEndY")) != null) {
            this.targetEndY = var2_2;
        }
        if ((var2_2 = hashtable.get("visibility")) != null) {
            this.visibility = var2_2;
        }
        super.restoreState(hashtable);
    }

    @Override
    public Object clone() {
        BinaryRelationPresentation binaryRelationPresentation = (BinaryRelationPresentation)super.clone();
        return binaryRelationPresentation;
    }

    @Override
    public void setRightAngleConstraint(boolean bl2) {
        this.setChanged();
        if (this.isCurve()) {
            if (bl2) {
                this.addStyleMap("line.shape", "curve_right_angle");
            } else {
                this.addStyleMap("line.shape", "curve");
            }
        } else if (bl2) {
            this.addStyleMap("line.shape", "line_right_angle");
        } else {
            this.addStyleMap("line.shape", "line");
        }
        this.updatePoints();
    }

    @Override
    public boolean isRightAngleConstraint() {
        String string = this.getStyleMapFromKey("line.shape");
        return "line_right_angle".equals(string) || "curve_right_angle".equals(string);
    }

    @Override
    public boolean isCurve() {
        String string = this.getStyleMapFromKey("line.shape");
        return "curve".equals(string) || "curve_right_angle".equals(string);
    }

    public static boolean isSuppressUpdate() {
        return suppressUpdate;
    }

    public static void setSuppressUpdate(boolean bl2) {
        suppressUpdate = bl2;
    }

    @Override
    protected void validateServers(JomtEntityStore jomtEntityStore) {
        List list = this.getServers();
        if (list.size() < 2) {
            this.sizeErrorMsg(list, "servers");
        }
        super.validateServers(jomtEntityStore);
    }

    @Override
    public boolean attributesEqual(UPresentation uPresentation) {
        if (!(uPresentation instanceof BinaryRelationPresentation)) {
            return false;
        }
        BinaryRelationPresentation binaryRelationPresentation = (BinaryRelationPresentation)uPresentation;
        return super.attributesEqual(binaryRelationPresentation);
    }

    @Override
    public void attributesCopy(UPresentation uPresentation) {
        super.attributesCopy(uPresentation);
        if (!(uPresentation instanceof BinaryRelationPresentation)) {
            return;
        }
    }

    @Override
    public boolean isVisibility() {
        return this.visibility;
    }

    @Override
    public void setVisibility(boolean bl2) {
        this.setChanged();
        this.visibility = bl2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.visibility = true;
        objectInputStream.defaultReadObject();
        String string = "line.shape";
        if (this.isSupportedStyleKey(string) && this.getStyleMapFromKey(string) == null) {
            if (this.rightAngle) {
                this.addStyleMap(string, "line_right_angle");
            } else {
                this.addStyleMap(string, "line");
            }
        }
    }

    protected void optimizeThroughPnts() {
        this.points = Z.a((IBinaryRelationPresentation)this, this.points);
    }

    @Override
    public boolean isSupportedStyleKey(String string) {
        if (string.equals("line.color") || string.equals("line.shape")) {
            return true;
        }
        return super.isSupportedStyleKey(string);
    }

    @Override
    public String getDefaultStyleFromSystem(String string) {
        if (string.equals("line.color")) {
            return "#000000";
        }
        return super.getDefaultStyleFromSystem(string);
    }
}

