/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.golf.model;

import JP.co.esm.caddies.golf.model.BadEntityException;
import JP.co.esm.caddies.golf.model.EntityStore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.undo.StateEditable;

public class EntityRoot
implements Serializable {
    static final long serialVersionUID = -8923638540981700012L;
    protected HashSet store;
    protected HashMap entry = new HashMap(17);

    public EntityRoot() {
        this.store = new HashSet(101);
    }

    public void empty() {
        this.entry.clear();
        this.store.clear();
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public void addEntity(StateEditable stateEditable) {
        if (stateEditable != null) {
            this.store.add(stateEditable);
        }
    }

    public void removeEntity(StateEditable stateEditable) throws BadEntityException {
        if (stateEditable == null && !this.store.contains(null) || !this.contains(stateEditable)) {
            throw new BadEntityException("No entity found for removal");
        }
        this.store.remove(stateEditable);
        Collection collection = this.entry.values();
        collection.removeAll(Collections.singleton(stateEditable));
    }

    public boolean contains(StateEditable stateEditable) {
        if (stateEditable == null) {
            return false;
        }
        return this.store.contains(stateEditable);
    }

    public void setEntry(String string, StateEditable stateEditable) throws BadEntityException {
        if (!this.store.contains(stateEditable)) {
            throw new BadEntityException("No such entity for setting entry");
        }
        this.entry.put(string, stateEditable);
    }

    public StateEditable getEntry(String string) {
        StateEditable stateEditable = (StateEditable)this.entry.get(string);
        if (stateEditable == null) {
            throw new BadEntityException("no such entity for getting entity for entry");
        }
        return stateEditable;
    }

    public StateEditable getEntity(int n2) {
        for (StateEditable stateEditable : this.store) {
            if (stateEditable == null || System.identityHashCode(stateEditable) != n2) continue;
            return stateEditable;
        }
        return null;
    }

    public int getId(StateEditable stateEditable) {
        return System.identityHashCode(stateEditable);
    }

    public Iterator entityIterator() {
        return this.store.iterator();
    }

    public StateEditable[] getStoreArray() {
        return this.store.toArray(new StateEditable[this.store.size()]);
    }

    public Iterator entryIterator() {
        return this.entry.keySet().iterator();
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("********* entry names ************" + string);
        stringBuilder.append(this.entry.toString());
        stringBuilder.append(string);
        stringBuilder.append("********* entities ***************" + string);
        for (Object e2 : this.store) {
            stringBuilder.append(EntityStore.a(e2));
            stringBuilder.append("(" + e2 + ")");
            stringBuilder.append(string);
        }
        stringBuilder.append("**********************************");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }
}

