/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.er.util;

import JP.co.esm.caddies.er.ERAttribute;
import JP.co.esm.caddies.er.ERDataTypeProperty;
import JP.co.esm.caddies.er.EREntity;
import JP.co.esm.caddies.er.ERIndex;
import JP.co.esm.caddies.er.ERRelationship;
import JP.co.esm.caddies.er.ERRelationshipEnd;
import JP.co.esm.caddies.er.ERSubtypeRelationship;
import JP.co.esm.caddies.er.simpleER.SimpleERAttribute;
import JP.co.esm.caddies.er.simpleER.SimpleEREntity;
import JP.co.esm.caddies.golf.model.EntityStore;
import JP.co.esm.caddies.jomt.jmodel.JomtEntityStore;
import JP.co.esm.caddies.jomt.jmodel.ah;
import JP.co.esm.caddies.jomt.jmodel.q;
import JP.co.esm.caddies.jomt.jsystem.c;
import JP.co.esm.caddies.jomt.jsystem.i;
import JP.co.esm.caddies.uml.Foundation.Core.UAssociationEnd;
import JP.co.esm.caddies.uml.Foundation.Core.UClassifier;
import JP.co.esm.caddies.uml.Foundation.Core.UProperty;
import JP.co.esm.caddies.uml.Foundation.DataTypes.UMultiplicityRange;
import JP.co.esm.caddies.uml.ModelManagement.UModel;
import JP.co.esm.caddies.uml.ModelManagement.UPackage;
import JP.co.esm.caddies.uml.SimpleUML.SimpleClassifier;
import JP.co.esm.caddies.uml.SimpleUML.SimpleModel;
import JP.co.esm.caddies.uml.SimpleUML.SimpleUmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class ERUtilities {
    public static final String IS_ZERO_TO_ONE = i.i().a("diagramview.popupmenu.multiplicity01.label");
    public static final String IS_ZERO_TO_MULTI = i.i().a("diagramview.popupmenu.multiplicity_0x.label");
    public static final String IS_ONE_TO_MULTI = i.i().a("diagramview.popupmenu.multiplicity_1x.label");
    public static final String IS_CONSTANT = "isconstant";
    public static final String NONE = ERUtilities.getItem("er_datatype.table.combo.item.none");
    public static final String OPTIONAL = ERUtilities.getItem("er_datatype.table.combo.item.optional");
    public static final String REQUIRED = ERUtilities.getItem("er_datatype.table.combo.item.required");

    public static String getERRelationshipEndCardinality(UAssociationEnd uAssociationEnd) {
        UMultiplicityRange[] uMultiplicityRangeArray = ERUtilities.getMultiplicityRangeArray(uAssociationEnd);
        if (uMultiplicityRangeArray[0].getLower() == 0 && uMultiplicityRangeArray[0].getUpper() == 1) {
            return IS_ZERO_TO_ONE;
        }
        if (uMultiplicityRangeArray[0].getLower() == 1 && uMultiplicityRangeArray[0].getUpper() == -1) {
            return IS_ONE_TO_MULTI;
        }
        if (uMultiplicityRangeArray[0].getLower() == uMultiplicityRangeArray[0].getUpper()) {
            return IS_CONSTANT;
        }
        return "";
    }

    private static UMultiplicityRange[] getMultiplicityRangeArray(UAssociationEnd uAssociationEnd) {
        List list = uAssociationEnd.getMultiplicity().getMultiplicityRanges();
        UMultiplicityRange[] uMultiplicityRangeArray = new UMultiplicityRange[list.size()];
        list.toArray(uMultiplicityRangeArray);
        return uMultiplicityRangeArray;
    }

    public static int getERRelationshipEndConstantNum(UAssociationEnd uAssociationEnd) {
        UMultiplicityRange[] uMultiplicityRangeArray = ERUtilities.getMultiplicityRangeArray(uAssociationEnd);
        return uMultiplicityRangeArray[0].getLower();
    }

    public static boolean isBuiltInDataType(String string) {
        ERDataTypeProperty eRDataTypeProperty = ERDataTypeProperty.getInstance();
        String[] stringArray = eRDataTypeProperty.getDataTypeItems(eRDataTypeProperty.getTemplateName());
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = eRDataTypeProperty.getLabel(stringArray[i2]);
            if (!string2.equals(string)) continue;
            return eRDataTypeProperty.isBuiltIn(stringArray[i2]);
        }
        return false;
    }

    private static String getItem(String string) {
        String string2 = i.h().a(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static UClassifier getERDataType(String string) {
        List list = q.d().getAllOwnedElements();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            UClassifier uClassifier = (UClassifier)list.get(i2);
            if (!uClassifier.getNameString().equals(string)) continue;
            return uClassifier;
        }
        return null;
    }

    public static void changeToParentProperties(UClassifier uClassifier, UClassifier uClassifier2) {
        JomtEntityStore jomtEntityStore = c.g.p().doc;
        SimpleClassifier simpleClassifier = new SimpleClassifier((EntityStore)jomtEntityStore, uClassifier);
        SimpleClassifier simpleClassifier2 = new SimpleClassifier((EntityStore)jomtEntityStore, uClassifier2);
        if (ah.a(uClassifier2)) {
            simpleClassifier.setERDomainType(simpleClassifier2.getERDomainType());
            if (simpleClassifier2.getERDomainLengthAndPrecision() != null) {
                simpleClassifier.setERDomainLengthAndPrecision(simpleClassifier2.getERDomainLengthAndPrecision());
            } else {
                simpleClassifier.setERDomainLengthAndPrecision("");
            }
            if (uClassifier2.getConstraint("Not Null") != null) {
                if (uClassifier.getConstraint("Not Null") == null) {
                    simpleClassifier.addNotNullConstraint();
                }
            } else {
                simpleClassifier.removeNotNullConstraint();
            }
            if (simpleClassifier2.getERDefaultLength() != null) {
                simpleClassifier.setERDefaultLength(simpleClassifier2.getERDefaultLength());
            } else {
                simpleClassifier.setERDefaultLength("");
            }
            simpleClassifier.setDefinition(simpleClassifier2.getDefinition());
        }
    }

    public static boolean isValideLengthAndPrecision(String string, String string2, String string3) {
        return !(string.equals(REQUIRED) ? (string2.equals(REQUIRED) ? !ERUtilities.isLegalLettersForLengthAndPrecesion(string3) : (string2.equals(OPTIONAL) ? !ERUtilities.isLegalLettersForLengthAndPrecesion(string3) && !ERUtilities.isLegalLettersForLengthOrPrecesion(string3) : string2.equals(NONE) && !ERUtilities.isLegalLettersForLengthOrPrecesion(string3))) : (string.equals(OPTIONAL) ? (string2.equals(REQUIRED) ? !ERUtilities.isLegalLettersForLengthAndPrecesion(string3) && !ERUtilities.isLegalLettersForLengthOrPrecesion(string3) : (string2.equals(OPTIONAL) ? !string3.equals("") && !ERUtilities.isLegalLettersForLengthAndPrecesion(string3) && !ERUtilities.isLegalLettersForLengthOrPrecesion(string3) : string2.equals(NONE) && !string3.equals("") && !ERUtilities.isLegalLettersForLengthOrPrecesion(string3))) : string.equals(NONE) && (string2.equals(REQUIRED) ? !ERUtilities.isLegalLettersForLengthOrPrecesion(string3) : (string2.equals(OPTIONAL) ? !string3.equals("") && !ERUtilities.isLegalLettersForLengthOrPrecesion(string3) : string2.equals(NONE) && !string3.equals("")))));
    }

    public static boolean isLegalLettersForLengthAndPrecesion(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = "[a-z0-9A-Z]+,\\s*[a-z0-9A-Z]+";
        return Pattern.matches(string2, string);
    }

    public static boolean isLegalLettersForLengthOrPrecesion(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = "[a-z0-9A-Z]+";
        return Pattern.matches(string2, string);
    }

    public static EREntity getEREntityByLogicalName(String string) {
        for (EREntity eREntity : ERUtilities.getEREntityList()) {
            if (!ERUtilities.getEntityLogicalName(eREntity).equals(string)) continue;
            return eREntity;
        }
        return null;
    }

    public static EREntity getEREntityByPhysicalName(String string) {
        for (EREntity eREntity : ERUtilities.getEREntityList()) {
            if (!ERUtilities.getEntityPhysicalName(eREntity).equals(string)) continue;
            return eREntity;
        }
        return null;
    }

    public static ERAttribute getERAttributeByLogicalName(EREntity eREntity, String string) {
        for (ERAttribute eRAttribute : eREntity.getStructuralFeatures()) {
            if (!ERUtilities.getAttributeLogicalName(eRAttribute).equals(string)) continue;
            return eRAttribute;
        }
        return null;
    }

    public static ERAttribute getERAttributeByPhysicalName(EREntity eREntity, String string) {
        for (ERAttribute eRAttribute : eREntity.getStructuralFeatures()) {
            if (!ERUtilities.getAttributePhysicalName(eRAttribute).equals(string)) continue;
            return eRAttribute;
        }
        return null;
    }

    public static List getEREntityList() {
        ArrayList arrayList = new ArrayList();
        JomtEntityStore jomtEntityStore = c.g.p().doc;
        if (jomtEntityStore == null) {
            return arrayList;
        }
        Iterator iterator = jomtEntityStore.o();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof UModel) || !SimpleModel.isERModel((UModel)e2)) continue;
            UModel uModel = (UModel)e2;
            for (Object e3 : uModel.getAllOwnedElements()) {
                if (!(e3 instanceof UPackage) || e3 instanceof UModel) continue;
                UPackage uPackage = (UPackage)e3;
                ERUtilities.getAllEntityInSchema(arrayList, uPackage);
            }
        }
        return arrayList;
    }

    private static void getAllEntityInSchema(List list, UPackage uPackage) {
        for (Object e2 : uPackage.getAllOwnedElements()) {
            if (!(e2 instanceof EREntity)) continue;
            list.add(e2);
        }
    }

    public static String getERModelName() {
        JomtEntityStore jomtEntityStore = c.g.p().doc;
        if (jomtEntityStore == null) {
            return null;
        }
        Iterator iterator = jomtEntityStore.o();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof UModel) || !SimpleModel.isERModel((UModel)e2)) continue;
            UModel uModel = (UModel)e2;
            return uModel.getNameString();
        }
        return null;
    }

    public static String getERModelDefinition() {
        JomtEntityStore jomtEntityStore = c.g.p().doc;
        if (jomtEntityStore == null) {
            return null;
        }
        Iterator iterator = jomtEntityStore.o();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof UModel) || !SimpleModel.isERModel((UModel)e2)) continue;
            UModel uModel = (UModel)e2;
            return uModel.getDefinitionString();
        }
        return null;
    }

    public static String getEntityDefinition(EREntity eREntity) {
        SimpleEREntity simpleEREntity = new SimpleEREntity(null, eREntity);
        return simpleEREntity.getDefinition();
    }

    public static String getEntityLogicalName(EREntity eREntity) {
        SimpleEREntity simpleEREntity = new SimpleEREntity(null, eREntity);
        return simpleEREntity.getName();
    }

    public static String getEntityPhysicalName(EREntity eREntity) {
        return fa.d(eREntity);
    }

    public static String getEntityKindName(EREntity eREntity) {
        SimpleEREntity simpleEREntity = new SimpleEREntity(null, eREntity);
        return simpleEREntity.getType();
    }

    public static String getEntityAlias1(EREntity eREntity) {
        return fa.b(eREntity);
    }

    public static String getEntityAlias2(EREntity eREntity) {
        return fa.c(eREntity);
    }

    public static List getEntityAttributes(EREntity eREntity) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(eREntity.getPrimaryKeys());
        arrayList.addAll(eREntity.getNonPrimaryKeys());
        return arrayList;
    }

    public static List getEntityAttributesWithoutIdentifiedInv(EREntity eREntity) {
        ArrayList<ERAttribute> arrayList = new ArrayList<ERAttribute>();
        for (ERAttribute eRAttribute : ERUtilities.getEntityAttributes(eREntity)) {
            if (eRAttribute.getIdentifiedAttribute() != null) continue;
            arrayList.add(eRAttribute);
        }
        return arrayList;
    }

    public static String getAttributeLogicalName(ERAttribute eRAttribute) {
        SimpleERAttribute simpleERAttribute = new SimpleERAttribute(null, eRAttribute);
        return simpleERAttribute.getName();
    }

    public static String getAttributePhysicalName(ERAttribute eRAttribute) {
        return fa.d(eRAttribute);
    }

    public static String getAttributeAlias1(ERAttribute eRAttribute) {
        return fa.b(eRAttribute);
    }

    public static String getAttributeAlias2(ERAttribute eRAttribute) {
        return fa.c(eRAttribute);
    }

    public static String getAttributeDomain(ERAttribute eRAttribute) {
        UClassifier uClassifier = eRAttribute.getType();
        String string = "";
        if (ah.a(uClassifier)) {
            string = uClassifier.getNameString();
        }
        return string;
    }

    public static String getAttributePK(ERAttribute eRAttribute) {
        if (eRAttribute.isPrimaryKey()) {
            return i.aE();
        }
        return i.aF();
    }

    public static String getAttributeFK(ERAttribute eRAttribute) {
        if (eRAttribute.isForeignKey() || !SimpleERAttribute.getIdentifiedInv(eRAttribute).isEmpty()) {
            return i.aG();
        }
        return i.aH();
    }

    public static String getAttributeAK(ERAttribute eRAttribute) {
        if (eRAttribute.isAK() || !SimpleERAttribute.getIdentifiedInv(eRAttribute).isEmpty()) {
            return i.aI();
        }
        return i.aJ();
    }

    public static String getAttributeIE(ERAttribute eRAttribute) {
        if (eRAttribute.isIE() || !SimpleERAttribute.getIdentifiedInv(eRAttribute).isEmpty()) {
            return i.aK();
        }
        return i.aL();
    }

    public static String getAttributeNotNull(ERAttribute eRAttribute) {
        if (eRAttribute.isNotNull()) {
            return i.aM();
        }
        return i.aN();
    }

    public static String getAttributeReferEntity(ERAttribute eRAttribute) {
        ERAttribute eRAttribute2 = eRAttribute.getReferencedPrimaryKey();
        EREntity eREntity = (EREntity)eRAttribute.getOwner();
        if (eRAttribute2 != null) {
            EREntity eREntity2 = (EREntity)eRAttribute2.getOwner();
            return eREntity2.getNameString() + " (" + eRAttribute2.getNameString() + ")";
        }
        List list = eREntity.getAssociationEnds();
        for (UProperty uProperty : eREntity.getStructuralFeatures()) {
            if (!eRAttribute.equals(uProperty.getIdentifiedAttribute())) continue;
            return ERUtilities.getAttributeReferEntity((ERAttribute)uProperty);
        }
        for (UProperty uProperty : list) {
            ERRelationship eRRelationship = (ERRelationship)uProperty.getAssociation();
            ERIndex eRIndex = eRRelationship.getERIndex();
            EREntity eREntity3 = (EREntity)((ERRelationshipEnd)eRRelationship.getConnections().get(1)).getType();
            EREntity eREntity4 = (EREntity)((ERRelationshipEnd)eRRelationship.getConnections().get(0)).getType();
            if (eRIndex == null || !eREntity.equals(eREntity3)) continue;
            List list2 = eRIndex.getERAttributes();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                ERAttribute eRAttribute3 = (ERAttribute)list2.get(i2);
                stringBuilder.append(eREntity4.getNameString());
                stringBuilder.append(" (");
                stringBuilder.append(eRAttribute3.getNameString());
                stringBuilder.append(")");
                if (i2 == list2.size() - 1) continue;
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static String getAttributeType(ERAttribute eRAttribute) {
        SimpleERAttribute simpleERAttribute = (SimpleERAttribute)SimpleUmlUtil.getSimpleUml(eRAttribute);
        if (simpleERAttribute.getERDatatype() == null) {
            return "";
        }
        return simpleERAttribute.getERDatatype().getNameString();
    }

    public static String getAttributeLength(ERAttribute eRAttribute) {
        SimpleERAttribute simpleERAttribute = new SimpleERAttribute(null, eRAttribute);
        return simpleERAttribute.getLengthAndPrecision();
    }

    public static String getAttributeInitialValue(ERAttribute eRAttribute) {
        SimpleERAttribute simpleERAttribute = new SimpleERAttribute(null, eRAttribute);
        return simpleERAttribute.getDefault();
    }

    public static String getAttributeDefinition(ERAttribute eRAttribute) {
        SimpleERAttribute simpleERAttribute = new SimpleERAttribute(null, eRAttribute);
        return simpleERAttribute.getDefinition();
    }

    public static ERAttribute getReferenceFK(ERRelationship eRRelationship, ERAttribute eRAttribute) {
        for (ERAttribute eRAttribute2 : eRAttribute.getReferencedForeignKeys()) {
            if (eRAttribute2.getReferencedRelationship() != eRRelationship) continue;
            return eRAttribute2;
        }
        return null;
    }

    public static ERAttribute getReferenceFK(ERSubtypeRelationship eRSubtypeRelationship, ERAttribute eRAttribute) {
        for (ERAttribute eRAttribute2 : eRAttribute.getReferencedForeignKeys()) {
            if (eRAttribute2.getSubTypeForeignKeyInv() != eRSubtypeRelationship) continue;
            return eRAttribute2;
        }
        return null;
    }
}

