/*
 * Decompiled with CFR 0.152.
 */
package JP.co.esm.caddies.er.reverseApi.connection;

import JP.co.esm.caddies.er.reverseApi.connection.JxtConnection$DriverInfo;
import JP.co.esm.caddies.er.reverseApi.connection.JxtConnection$JxtConnectionParam;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class JxtConnection {
    public Connection connection;
    private Statement statement;
    private boolean visible = false;
    private boolean _DEBUG_ = false;
    private static ClassLoader driverClassLoader;
    private static final Logger logger;
    private static final Marker performance;

    public void setDebug(boolean bl2) {
        this._DEBUG_ = bl2;
    }

    public void close() throws SQLException {
        this.statement.close();
        this.connection.close();
        this.visible = false;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl2) {
        this.visible = bl2;
    }

    public void connect(JxtConnection$DriverInfo jxtConnection$DriverInfo, JxtConnection$JxtConnectionParam jxtConnection$JxtConnectionParam) throws SQLException, MalformedURLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        double d2 = System.currentTimeMillis();
        double d3 = System.currentTimeMillis();
        if (jxtConnection$DriverInfo.getPathfile().trim().length() > 0) {
            URL[] uRLArray;
            Object object;
            logger.debug("Dynamic load : {}", (Object)jxtConnection$DriverInfo.getPathfile().trim());
            if (driverClassLoader == null) {
                object = new URL("file:" + jxtConnection$DriverInfo.getPathfile().trim());
                uRLArray = new URL[]{object};
                driverClassLoader = new URLClassLoader(uRLArray, this.getClass().getClassLoader());
            }
            object = (Driver)Class.forName(jxtConnection$DriverInfo.getClassname(), true, driverClassLoader).newInstance();
            uRLArray = new Properties();
            uRLArray.put("user", jxtConnection$JxtConnectionParam.getLogin());
            uRLArray.put("password", jxtConnection$JxtConnectionParam.getPassword());
            this.connection = object.connect(jxtConnection$JxtConnectionParam.getJdbcurl(), (Properties)uRLArray);
        } else {
            Class.forName(jxtConnection$DriverInfo.getClassname());
            logger.debug("Classic load ");
            this.connection = DriverManager.getConnection(jxtConnection$JxtConnectionParam.getJdbcurl(), jxtConnection$JxtConnectionParam.getLogin(), jxtConnection$JxtConnectionParam.getPassword());
        }
        double d4 = (double)System.currentTimeMillis() - d2;
        if (this._DEBUG_) {
            logger.debug(performance, "--> Class.forName() :  {} : time : {}", (Object)jxtConnection$JxtConnectionParam.getName(), (Object)(d4 / 1000.0));
        }
        this.statement = this.connection.createStatement();
        jxtConnection$JxtConnectionParam.setConnected(true);
        this.visible = true;
        double d5 = (double)System.currentTimeMillis() - d2;
        if (this._DEBUG_) {
            logger.debug(performance, "--> connect() :  {} : time : {}", (Object)jxtConnection$JxtConnectionParam.getName(), (Object)(d5 / 1000.0));
        }
    }

    public ResultSet select(String string) throws SQLException {
        return this.statement.executeQuery(string);
    }

    public void update(String string) throws SQLException {
        this.statement.executeUpdate(string);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void finalize() {
        try {
            this.close();
            this.visible = false;
            this.connection = null;
            this.statement = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Properties getProperties() throws SQLException {
        Properties properties = new Properties();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        properties.put("Catalog separator", databaseMetaData.getCatalogSeparator());
        properties.put("Catalog Term", databaseMetaData.getCatalogTerm());
        properties.put("Database product name", databaseMetaData.getDatabaseProductName());
        properties.put("Product version", databaseMetaData.getDatabaseProductVersion());
        properties.put("Transaction isolation", "" + databaseMetaData.getDefaultTransactionIsolation());
        properties.put("Driver name", databaseMetaData.getDriverName());
        properties.put("Driver version", databaseMetaData.getDriverVersion());
        properties.put("Extra name character", databaseMetaData.getExtraNameCharacters());
        properties.put("Identifier quote string", databaseMetaData.getIdentifierQuoteString());
        properties.put("Max binary literal length", "" + databaseMetaData.getMaxBinaryLiteralLength());
        properties.put("Max catalog name lengh", "" + databaseMetaData.getMaxCatalogNameLength());
        properties.put("Max char literal lengh", "" + databaseMetaData.getMaxCharLiteralLength());
        properties.put("Max column name length", "" + databaseMetaData.getMaxColumnNameLength());
        properties.put("Max columns in group by", "" + databaseMetaData.getMaxColumnsInGroupBy());
        properties.put("Max columns in index", "" + databaseMetaData.getMaxColumnsInIndex());
        properties.put("Max columns in order by", "" + databaseMetaData.getMaxColumnsInOrderBy());
        properties.put("Max columns in select", "" + databaseMetaData.getMaxColumnsInSelect());
        properties.put("Max columns in table", "" + databaseMetaData.getMaxColumnsInTable());
        properties.put("Max connections", "" + databaseMetaData.getMaxConnections());
        properties.put("Max cursor name length", "" + databaseMetaData.getMaxCursorNameLength());
        properties.put("Max indexLength", "" + databaseMetaData.getMaxIndexLength());
        properties.put("Max procedure name length", "" + databaseMetaData.getMaxProcedureNameLength());
        properties.put("Max row size length", "" + databaseMetaData.getMaxRowSize());
        properties.put("Max schema name length", "" + databaseMetaData.getMaxSchemaNameLength());
        properties.put("Max statement length", "" + databaseMetaData.getMaxStatementLength());
        properties.put("Max statements", "" + databaseMetaData.getMaxStatements());
        properties.put("Max table name length", "" + databaseMetaData.getMaxTableNameLength());
        properties.put("Max table in select", "" + databaseMetaData.getMaxTablesInSelect());
        properties.put("Max user name length", "" + databaseMetaData.getMaxUserNameLength());
        properties.put("Numeric functions", "" + databaseMetaData.getNumericFunctions());
        properties.put("Procedure term", databaseMetaData.getProcedureTerm());
        properties.put("Schema term", databaseMetaData.getSchemaTerm());
        properties.put("Search string espace", databaseMetaData.getSearchStringEscape());
        properties.put("SQL Keywords", databaseMetaData.getSQLKeywords());
        properties.put("String functions", databaseMetaData.getStringFunctions());
        properties.put("System functions", databaseMetaData.getSystemFunctions());
        properties.put("Time-Date functions", databaseMetaData.getTimeDateFunctions());
        properties.put("Url", databaseMetaData.getURL());
        properties.put("UserName", databaseMetaData.getUserName());
        properties.put("Supports Catalogs in data manipulation ?", "" + databaseMetaData.supportsCatalogsInDataManipulation());
        properties.put("Supports Catalogs in index definitions ?", "" + databaseMetaData.supportsCatalogsInIndexDefinitions());
        properties.put("Supports Catalogs in table definitions ?", "" + databaseMetaData.supportsCatalogsInTableDefinitions());
        properties.put("Supports Schemas in data manipulation ?", "" + databaseMetaData.supportsSchemasInDataManipulation());
        properties.put("Supports Schemas in index definitions ?", "" + databaseMetaData.supportsSchemasInIndexDefinitions());
        properties.put("Supports Schemas in table definitions ?", "" + databaseMetaData.supportsSchemasInTableDefinitions());
        properties.put("Supports Group by ?", "" + databaseMetaData.supportsGroupBy());
        properties.put("Supports Select for update ?", "" + databaseMetaData.supportsSelectForUpdate());
        properties.put("Supports Stored procedures ?", "" + databaseMetaData.supportsStoredProcedures());
        properties.put("Supports Transactions ?", "" + databaseMetaData.supportsTransactions());
        properties.put("Supports Union ?", "" + databaseMetaData.supportsUnion());
        return properties;
    }

    public String[] getCatalogs() throws Exception {
        Object object;
        double d2 = System.currentTimeMillis();
        Vector<String> vector = new Vector<String>();
        if (this.connection.getMetaData().supportsCatalogsInDataManipulation()) {
            object = this.connection.getMetaData().getCatalogs();
            while (object.next()) {
                vector.add(object.getString(1));
            }
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        if (this._DEBUG_) {
            double d3 = (double)System.currentTimeMillis() - d2;
            logger.debug(performance, "--> getCatalogs() : {} : time : {}", (Object)Arrays.toString((Object[])object), (Object)(d3 / 1000.0));
        }
        return object;
    }

    public String[] getSchemas() throws Exception {
        Object object;
        double d2 = System.currentTimeMillis();
        Vector<String> vector = new Vector<String>();
        if (this.connection.getMetaData().supportsSchemasInDataManipulation()) {
            object = this.connection.getMetaData().getSchemas();
            while (object.next()) {
                vector.add(object.getString(1));
            }
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        if (this._DEBUG_) {
            double d3 = (double)System.currentTimeMillis() - d2;
            logger.debug(performance, "--> getSchema() : {} : time : {}", (Object)Arrays.toString((Object[])object), (Object)(d3 / 1000.0));
        }
        return object;
    }

    public DatabaseMetaData getMetaData() throws Exception {
        return this.connection.getMetaData();
    }

    public Vector getTables(String string, String string2) throws Exception {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        double d2 = System.currentTimeMillis();
        Vector<String> vector = new Vector<String>();
        ResultSet resultSet = databaseMetaData.getTables(string, string2, "%", null);
        while (resultSet.next()) {
            vector.add(resultSet.getString(3));
        }
        if (this._DEBUG_) {
            double d3 = (double)System.currentTimeMillis() - d2;
            logger.debug(performance, "--> getTables() :  {} : time : {}", (Object)Arrays.toString(vector.toArray()), (Object)(d3 / 1000.0));
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        logger.debug("input Diver File Location:");
        JxtConnection$DriverInfo jxtConnection$DriverInfo = new JxtConnection$DriverInfo();
        jxtConnection$DriverInfo.setClassname("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        jxtConnection$DriverInfo.setPathfile("D:\\files\\source\\sqljdbc.jar");
        logger.debug("input JDBC URL(example:jdbc:mysql://localhost:3306/ownSchema)");
        JxtConnection$JxtConnectionParam jxtConnection$JxtConnectionParam = new JxtConnection$JxtConnectionParam();
        jxtConnection$JxtConnectionParam.setLogin("sa");
        jxtConnection$JxtConnectionParam.setPassword("");
        jxtConnection$JxtConnectionParam.setJdbcurl("jdbc:sqlserver://192.168.0.155:1433;databaseName=pubs");
        JxtConnection jxtConnection = new JxtConnection();
        try {
            jxtConnection.connect(jxtConnection$DriverInfo, jxtConnection$JxtConnectionParam);
            String[] stringArray2 = jxtConnection.getCatalogs();
            String[] stringArray3 = jxtConnection.getSchemas();
            Vector vector = jxtConnection.getTables(stringArray2[4], stringArray3[0]);
            logger.debug("TableList:");
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                Object object;
                logger.debug(vector.get(i2) + ":");
                Vector<String> vector2 = new Vector<String>();
                Vector<String> vector3 = new Vector<String>();
                Vector<String> vector4 = new Vector<String>();
                Vector<String> vector5 = new Vector<String>();
                ResultSet resultSet = null;
                resultSet = jxtConnection.connection.getMetaData().getColumns(stringArray2[4], stringArray3[0], (String)vector.get(i2), "%");
                HashSet<Object> hashSet = new HashSet<Object>();
                ResultSet resultSet2 = jxtConnection.connection.getMetaData().supportsSchemasInTableDefinitions() ? jxtConnection.connection.getMetaData().getPrimaryKeys(stringArray2[4], stringArray3[0], vector.get(i2).toString()) : jxtConnection.connection.getMetaData().getPrimaryKeys(stringArray2[4], null, vector.get(i2).toString());
                while (resultSet2.next()) {
                    object = resultSet2.getString(4);
                    hashSet.add(object);
                }
                object = new HashMap();
                ResultSet resultSet3 = jxtConnection.connection.getMetaData().supportsSchemasInTableDefinitions() ? jxtConnection.connection.getMetaData().getImportedKeys(stringArray2[4], stringArray3[0], vector.get(i2).toString()) : jxtConnection.connection.getMetaData().getImportedKeys(stringArray2[4], null, vector.get(i2).toString());
                while (resultSet3.next()) {
                    resultSet3.getString(1);
                    resultSet3.getString(3);
                    resultSet3.getString(8);
                    ((HashMap)object).put(resultSet3.getString(8), " " + resultSet3.getString(1) + "-" + resultSet3.getString(3) + "-" + resultSet3.getString(4));
                }
                while (resultSet.next()) {
                    vector2.add(resultSet.getString(4));
                    logger.debug(resultSet.getString(4) + " ");
                    vector3.add(resultSet.getString(6));
                    logger.debug(resultSet.getString(6) + " ");
                    int n2 = resultSet.getInt(7);
                    int n3 = resultSet.getInt(9);
                    if (n3 > 0) {
                        vector4.add(n2 + "," + n3);
                    } else {
                        vector4.add("" + n2);
                    }
                    logger.debug(n2 + " ");
                    vector5.add(resultSet.getString(18));
                    logger.debug("{}{}{}", new Object[]{resultSet.getString(18), hashSet.contains(resultSet.getString(4)) ? " [PK]" : "", ((HashMap)object).get(resultSet.getString(4)) != null ? " [FK]" + ((HashMap)object).get(resultSet.getString(4)) : ""});
                }
                logger.debug("------------------------------------------------------------------------");
            }
        }
        catch (Exception exception) {
            logger.error("error has occurred.", (Throwable)exception);
        }
    }

    static {
        logger = LoggerFactory.getLogger(JxtConnection.class);
        performance = MarkerFactory.getMarker((String)"performance");
    }
}

