/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import com.change_vision.refrection.Refrections;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.slf4j.ILoggerFactory;
import org.slf4j.spi.LoggerFactoryBinder;

public class StaticLoggerBinder
implements LoggerFactoryBinder {
    private static final String METHOD_OF_AUTO_CONFIG = "autoConfig";
    private static final String CLASS_OF_LOGGER_CONTEXT = "ch.qos.logback.classic.LoggerContext";
    private static final String CLASS_OF_CONTEXT_INITIALIZER = "ch.qos.logback.classic.util.ContextInitializer";
    public static String REQUESTED_API_VERSION = "1.6";
    private static StaticLoggerBinder staticLoggerBinder;
    private static Object defaultLoggerContext;

    static {
        StaticLoggerBinder.init();
    }

    private static void init() {
        Class<?> defaultLoggerContextClass = Refrections.loadClass(CLASS_OF_LOGGER_CONTEXT);
        defaultLoggerContext = Refrections.newInstance(defaultLoggerContextClass);
        Class<?> contextInitializerClass = Refrections.loadClass(CLASS_OF_CONTEXT_INITIALIZER);
        Constructor<?> constructor = Refrections.getConstructor(contextInitializerClass, defaultLoggerContextClass);
        Object contextInitializer = Refrections.newInstanceByConstructor(constructor, defaultLoggerContext);
        Method autoConfigMethod = Refrections.getMethod(contextInitializerClass, METHOD_OF_AUTO_CONFIG, new Class[0]);
        Refrections.invoke(autoConfigMethod, contextInitializer, new Object[0]);
    }

    public static synchronized StaticLoggerBinder getSingleton() {
        if (staticLoggerBinder == null) {
            staticLoggerBinder = new StaticLoggerBinder();
        }
        return staticLoggerBinder;
    }

    public ILoggerFactory getLoggerFactory() {
        return (ILoggerFactory)defaultLoggerContext;
    }

    public String getLoggerFactoryClassStr() {
        return "ch.qos.logback.classic.util.ContextSelectorStaticBinder";
    }
}

