/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.refrection;

import com.change_vision.refrection.JarClassLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class Refrections {
    private static final String JAR_OF_CLASSIC = "/logback-classic-1.0.9.jar";
    private static final String JAR_OF_CORE = "/logback-core-1.0.9.jar";
    private static URLClassLoader loader;

    static {
        Refrections.init();
    }

    private static void init() {
        URL classic = Refrections.getResourceFromClassPath(JAR_OF_CLASSIC);
        URL core = Refrections.getResourceFromClassPath(JAR_OF_CORE);
        loader = Refrections.isInJar(classic) || Refrections.isInJar(core) ? new JarClassLoader(new URL[]{core, classic}, Refrections.class.getClassLoader()) : new URLClassLoader(new URL[]{core, classic}, Refrections.class.getClassLoader());
    }

    private static URL getResourceFromClassPath(String resourcePath) {
        return Refrections.class.getResource(resourcePath);
    }

    private static boolean isInJar(URL url) {
        return url.getProtocol().equals("jar");
    }

    public static Object invoke(Method method, Object invokedObject, Object ... args) {
        try {
            return method.invoke(invokedObject, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Method getMethod(Class<?> contextInitializerClass, String methodName, Class<?> ... parameterTypes) {
        try {
            return contextInitializerClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Constructor<?> getConstructor(Class<?> targetClass, Class<?> ... args) {
        try {
            return targetClass.getConstructor(args);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Class<?> loadClass(String className) {
        try {
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object newInstanceByConstructor(Constructor<?> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

