/*
 * Decompiled with CFR 0.152.
 */
package com.change_vision.refrection;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarClassLoader
extends URLClassLoader {
    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static boolean isJar(String fileName) {
        return fileName != null && fileName.toLowerCase().endsWith(".jar");
    }

    private static File jarEntryAsFile(JarFile jarFile, JarEntry jarEntry) throws IOException {
        File file;
        InputStream input = null;
        FileOutputStream output = null;
        try {
            int readCount;
            String name = jarEntry.getName().replace('/', '_');
            int i = name.lastIndexOf(".");
            String extension = i > -1 ? name.substring(i) : "";
            File file2 = File.createTempFile(String.valueOf(name.substring(0, name.length() - extension.length())) + ".", extension);
            file2.deleteOnExit();
            input = jarFile.getInputStream(jarEntry);
            output = new FileOutputStream(file2);
            byte[] buffer = new byte[4096];
            while ((readCount = input.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, readCount);
            }
            file = file2;
        }
        catch (Throwable throwable) {
            JarClassLoader.close(input);
            JarClassLoader.close(output);
            throw throwable;
        }
        JarClassLoader.close(input);
        JarClassLoader.close(output);
        return file;
    }

    public JarClassLoader(URL[] urls, ClassLoader parent) {
        block4: {
            super(urls, parent);
            try {
                ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
                CodeSource codeSource = protectionDomain.getCodeSource();
                URL rootJarUrl = codeSource.getLocation();
                String rootJarName = rootJarUrl.getFile();
                if (!JarClassLoader.isJar(rootJarName)) break block4;
                String path = rootJarUrl.getPath();
                try {
                    path = URLDecoder.decode(path, "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.addJarResource(new File(path));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public JarClassLoader(URL[] urls) {
        block4: {
            super(urls);
            try {
                ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
                CodeSource codeSource = protectionDomain.getCodeSource();
                URL rootJarUrl = codeSource.getLocation();
                String rootJarName = rootJarUrl.getFile();
                if (!JarClassLoader.isJar(rootJarName)) break block4;
                String path = rootJarUrl.getPath();
                try {
                    path = URLDecoder.decode(path, "utf-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                this.addJarResource(new File(path));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void addJarResource(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        URI uri = file.toURI();
        this.addURL(uri.toURL());
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory() || !JarClassLoader.isJar(jarEntry.getName())) continue;
            this.addJarResource(JarClassLoader.jarEntryAsFile(jarFile, jarEntry));
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                clazz = this.findClass(name);
                if (resolve) {
                    this.resolveClass(clazz);
                }
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return super.loadClass(name, resolve);
        }
    }
}

