//  -----------------------------------------------------------------------------------------
//    g x264 o(GUI) Ex  v1.xx/2.xx by rigaya
//  -----------------------------------------------------------------------------------------
//   \[XR[hɂ
//   Eۏ؂łB
//   E{\[XR[hgpƂɂ邢Ȃ鑹QEguɂrigaya͐ӔC𕉂܂B
//   ȏɗĒꍇA{\[XR[h̎gpAAρAĔЕzsĒč\܂B
//  -----------------------------------------------------------------------------------------

#include <windows.h>
#include <stdio.h>
#include <shlwapi.h>
#pragma comment(lib, "shlwapi.lib")
#include <mmsystem.h>
#pragma comment(lib, "winmm.lib") 

#include "output.h"
#include "auo.h"
#include "auo_frm.h"
#include "auo_util.h"
#include "auo_error.h"
#include "auo_version.h"
#include "auo_conf.h"
#include "auo_system.h"

#include "auo_video.h"
#include "auo_audio.h"
#include "auo_faw2aac.h"
#include "auo_mux.h"
#include "auo_encode.h"
#include "auo_runbat.h"

//---------------------------------------------------------------------
//		֐vg^Cv錾
//---------------------------------------------------------------------
static BOOL check_output(const OUTPUT_INFO *oip, const PRM_ENC *pe);
static void set_enc_prm(PRM_ENC *pe, const OUTPUT_INFO *oip);
static void auto_save_log(const OUTPUT_INFO *oip, const PRM_ENC *pe);

//---------------------------------------------------------------------
//		o̓vOCϐ
//---------------------------------------------------------------------

static CONF_GUIEX conf;
static SYSTEM_DATA sys_dat = { 0 };
static char auo_filefilter[1024] = { 0 };

//---------------------------------------------------------------------
//		o̓vOC\̒`
//---------------------------------------------------------------------
OUTPUT_PLUGIN_TABLE output_plugin_table = {
	NULL,                         // tO
	AUO_FULL_NAME,                // vOC̖O
	AUO_EXT_FILTER,               // o̓t@C̃tB^
	AUO_VERSION_INFO,             // vOC̏
	func_init,                    // DLLJnɌĂ΂֐ւ̃|C^ (NULLȂĂ΂܂)
	func_exit,                    // DLLIɌĂ΂֐ւ̃|C^ (NULLȂĂ΂܂)
	func_output,                  // o͎ɌĂ΂֐ւ̃|C^
	func_config,                  // o͐ݒ̃_CAOvꂽɌĂ΂֐ւ̃|C^ (NULLȂĂ΂܂)
	func_config_get,              // o͐ݒf[^擾鎞ɌĂ΂֐ւ̃|C^ (NULLȂĂ΂܂)
	func_config_set,              // o͐ݒf[^ݒ肷鎞ɌĂ΂֐ւ̃|C^ (NULLȂĂ΂܂)
};


//---------------------------------------------------------------------
//		o̓vOC\̂̃|C^n֐
//---------------------------------------------------------------------
EXTERN_C OUTPUT_PLUGIN_TABLE __declspec(dllexport) * __stdcall GetOutputPluginTable( void )
{
	init_SYSTEM_DATA(&sys_dat);
	make_file_filter(NULL, 0, sys_dat.exstg->s_local.default_output_ext);
	overwrite_aviutl_ini_file_filter(sys_dat.exstg->s_local.default_output_ext);
	output_plugin_table.filefilter = auo_filefilter;
	return &output_plugin_table;
}


//---------------------------------------------------------------------
//		o̓vOCo͊֐
//---------------------------------------------------------------------
//
	//int		flag;			//	tO
	//						//	OUTPUT_INFO_FLAG_VIDEO	: 摜f[^
	//						//	OUTPUT_INFO_FLAG_AUDIO	: f[^
	//						//	OUTPUT_INFO_FLAG_BATCH	: ob`o͒
	//int		w,h;			//	cTCY
	//int		rate,scale;		//	t[[g
	//int		n;				//	t[
	//int		size;			//	Pt[̃oCg
	//int		audio_rate;		//	TvO[g
	//int		audio_ch;		//	`l
	//int		audio_n;		//	TvO
	//int		audio_size;		//	PTṽoCg
	//LPSTR	savefile;		//	Z[ut@Cւ̃|C^
	//void	*(*func_get_video)( int frame );
	//						//	DIB`(RGB24bit)̉摜f[^ւ̃|C^擾܂B
	//						//	frame	: t[ԍ
	//						//	߂l	: f[^ւ̃|C^
	//						//			  摜f[^|C^̓e͎ɊO֐gCɏ߂܂ŗL
	//void	*(*func_get_audio)( int start,int length,int *readed );
	//						//	16bitPCM`̉f[^ւ̃|C^擾܂B
	//						//	start	: JnTvԍ
	//						//	length	: ǂݍރTv
	//						//	readed	: ǂݍ܂ꂽTv
	//						//	߂l	: f[^ւ̃|C^
	//						//			  f[^|C^̓e͎ɊO֐gCɏ߂܂ŗL
	//BOOL	(*func_is_abort)( void );
	//						//	f邩ׂ܂B
	//						//	߂l	: TRUEȂ璆f
	//BOOL	(*func_rest_time_disp)( int now,int total );
	//						//	c莞Ԃ\܂B
	//						//	now		: Ăt[ԍ
	//						//	total	: 鑍t[
	//						//	߂l	: TRUEȂ琬
	//int		(*func_get_flag)( int frame );
	//						//	tO擾܂B
	//						//	frame	: t[ԍ
	//						//	߂l	: tO
	//						//  OUTPUT_INFO_FRAME_FLAG_KEYFRAME		: L[t[
	//						//  OUTPUT_INFO_FRAME_FLAG_COPYFRAME	: Rs[t[
	//BOOL	(*func_update_preview)( void );
	//						//	vr[ʂXV܂B
	//						//	Ōfunc_get_videoœǂݍ܂ꂽt[\܂B
	//						//	߂l	: TRUEȂ琬
	//void	*(*func_get_video_ex)( int frame,DWORD format );
	//						//	DIB`̉摜f[^擾܂B
	//						//	frame	: t[ԍ
	//						//	format	: 摜tH[}bg( NULL = RGB24bit / 'Y''U''Y''2' = YUY2 / 'Y''C''4''8' = PIXEL_YC )
	//						//			  PIXEL_YC`  YUY2tB^[hł͎gpo܂B
	//						//	߂l	: f[^ւ̃|C^
	//						//			  摜f[^|C^̓e͎ɊO֐gCɏ߂܂ŗL

BOOL func_init() 
{
	return TRUE;
}

BOOL func_exit() 
{
	delete_SYSTEM_DATA(&sys_dat);
	return TRUE;
}

BOOL func_output( OUTPUT_INFO *oip ) 
{
	AUO_RESULT ret = AUO_RESULT_SUCCESS;
	static const encode_task task[3][2] = { { video_output, audio_output }, { audio_output, video_output }, { audio_output_parallel, video_output }  };
	PRM_ENC pe = { 0 };
	const DWORD tm_start_enc = timeGetTime();

	//f[^̏
	init_SYSTEM_DATA(&sys_dat);
	if (!sys_dat.exstg->get_init_success()) return FALSE;

	//OEBhEJ
	open_log_window(oip->savefile, 1, (conf.x264.use_auto_npass && conf.x264.rc_mode == X264_RC_BITRATE) ? conf.x264.auto_npass : 1);
	set_prevent_log_close(TRUE); //1 start

	//eݒs
	set_enc_prm(&pe, oip);
	pe.h_p_aviutl = OpenProcess(PROCESS_QUERY_INFORMATION, FALSE, GetCurrentProcessId()); //2 start

	//`FbNsAGR[h\ȂGR[hJn
	if (check_output(oip, &pe) && setup_afsvideo(oip, &conf, &pe, sys_dat.exstg->s_local.auto_afs_disable)) { //3 start

		ret |= run_bat_file(&conf, oip, &pe, &sys_dat, RUN_BAT_BEFORE);

		for (int i = 0; !ret && i < 2; i++)
			ret |= task[conf.aud.audio_encode_timing][i](&conf, oip, &pe, &sys_dat);

		int amp_result = 1;
		do {
			if (!ret) ret |= task[0][amp_result-1](&conf, oip, &pe, &sys_dat); //ăGRAIĂꍇAăGRȂ
			if (!ret) ret |= mux(&conf, oip, &pe, &sys_dat);
		} while (!ret && 0 < (amp_result = amp_check_file(&conf, &sys_dat, &pe, oip))); //ăGR[h̕Kv邩`FbN

		ret |= move_temporary_files(&conf, &pe, &sys_dat, oip, ret);

		write_log_auo_enc_time("GR[h  ", timeGetTime() - tm_start_enc);

		close_afsvideo(&pe); //3 end

	} else {
		ret |= AUO_RESULT_ERROR;
	}

	if (ret & AUO_RESULT_ABORT) info_encoding_aborted();

	CloseHandle(pe.h_p_aviutl); //2 end
	set_prevent_log_close(FALSE); //1 end
	auto_save_log(oip, &pe); //1 end ̂Ƃōs

	if (!(ret & (AUO_RESULT_ERROR | AUO_RESULT_ABORT)))
		ret |= run_bat_file(&conf, oip, &pe, &sys_dat, RUN_BAT_AFTER);

	return (ret & AUO_RESULT_ERROR) ? FALSE : TRUE;
}

//---------------------------------------------------------------------
//		o̓vOCݒ֐
//---------------------------------------------------------------------
//ȉIwarning C4100ق点
//C4100 : ͊֐̖{̕ 1 xQƂ܂B
#pragma warning( push )
#pragma warning( disable: 4100 )
BOOL func_config(HWND hwnd, HINSTANCE dll_hinst)
{
	init_SYSTEM_DATA(&sys_dat);
	if (sys_dat.exstg->get_init_success())
		ShowfrmConfig(&conf, &sys_dat);
	return TRUE;
}
#pragma warning( pop )

int func_config_get( void *data, int size )
{
	if (data && size == sizeof(CONF_GUIEX))
		memcpy(data, &conf, sizeof(conf));
	return sizeof(conf);
}

int func_config_set( void *data,int size )
{
	init_SYSTEM_DATA(&sys_dat);
	if (!sys_dat.exstg->get_init_success(TRUE))
		return NULL;
	init_CONF_GUIEX(&conf, FALSE);
	return (guiEx_config::adjust_conf_size(&conf, data, size)) ? size : NULL;
}


//---------------------------------------------------------------------
//		x264guiEx̂̑̊֐
//---------------------------------------------------------------------
void init_SYSTEM_DATA(SYSTEM_DATA *_sys_dat) {
	if (_sys_dat->init)
		return;
	get_auo_path(_sys_dat->auo_path, _countof(_sys_dat->auo_path));
	get_aviutl_dir(_sys_dat->aviutl_dir, _countof(_sys_dat->aviutl_dir));
	_sys_dat->exstg = new guiEx_settings();
	set_ex_stg_ptr(_sys_dat->exstg);
	_sys_dat->init = TRUE;
}
void delete_SYSTEM_DATA(SYSTEM_DATA *_sys_dat) {
	if (_sys_dat->init) {
		delete _sys_dat->exstg;
		_sys_dat->exstg = NULL;
		set_ex_stg_ptr(_sys_dat->exstg);
	}
	_sys_dat->init = FALSE;
}
void init_CONF_GUIEX(CONF_GUIEX *conf, BOOL use_highbit) {
	ZeroMemory(conf, sizeof(CONF_GUIEX));
	guiEx_config::write_conf_header(conf);
	get_default_conf_x264(&conf->x264, use_highbit);
	conf->size_all = CONF_INITIALIZED;
}
void write_log_auo_line_fmt(int log_type_index, const char *format, ... ) {
	va_list args;
	int len;
	char *buffer;
	va_start(args, format);
	len = _vscprintf(format, args) // _vscprintf doesn't count
		                      + 1; // terminating '\0'
	buffer = (char *)malloc(len * sizeof(buffer[0]));
	vsprintf_s(buffer, len, format, args);
	write_log_auo_line(log_type_index, buffer);
	free(buffer);
}
//GR[hԂ̕\
void write_log_auo_enc_time(const char *mes, DWORD time) {
	time = ((time + 50) / 100) * 100; //ľܓ
	write_log_auo_line_fmt(LOG_INFO, "%s : %d%2d%2d.%1db", 
		mes, 
		time / (60*60*1000),
		(time % (60*60*1000)) / (60*1000), 
		(time % (60*1000)) / 1000,
		((time % 1000)) / 100);
}

static BOOL check_muxer_exist(MUXER_SETTINGS *muxer_stg) {
	if (PathFileExists(muxer_stg->fullpath)) 
		return TRUE;
	error_no_exe_file(muxer_stg->filename, muxer_stg->fullpath);
	return FALSE;
}

static BOOL check_amp() {
	BOOL check = TRUE;
	if (!conf.x264.use_auto_npass)
		return check;
	if (conf.vid.amp_check & AMPLIMIT_BITRATE) {
		//if (conf.x264.bitrate > conf.vid.amp_limit_bitrate) {
		//	check = FALSE; error_amp_bitrate_confliction();
		//} else if (conf.vid.amp_limit_bitrate <= 0.0)
		//	conf.vid.amp_check &= ~AMPLIMIT_BITRATE; //tO܂
		if (conf.vid.amp_limit_bitrate <= 0.0)
			conf.vid.amp_check &= ~AMPLIMIT_BITRATE; //tO܂
	}
	if (conf.vid.amp_check & AMPLIMIT_FILE_SIZE) {
		if (conf.vid.amp_limit_file_size <= 0.0)
			conf.vid.amp_check &= ~AMPLIMIT_FILE_SIZE; //tO܂
	}
	return check;
}

static BOOL check_output(const OUTPUT_INFO *oip, const PRM_ENC *pe) {
	BOOL check = TRUE;
	//t@C
	if (strlen(oip->savefile) > (MAX_PATH_LEN - MAX_APPENDIX_LEN - 1)) {
		error_filename_too_long();
		check = FALSE;
	}

	//𑜓x
	int w_mul = 1, h_mul = 1;
	switch (conf.x264.output_csp) {
		case OUT_CSP_YUV444:
		case OUT_CSP_RGB:
			w_mul = 1, h_mul = 1; break;
		case OUT_CSP_NV16:
			w_mul = 2, h_mul = 1; break;
		case OUT_CSP_NV12:
		default:
			w_mul = 2; h_mul = 2; break;
	}
	if (conf.x264.interlaced) h_mul *= 2;
	if (oip->w % w_mul) {
		error_invalid_resolution(TRUE,  w_mul, oip->w, oip->h);
		check = FALSE;
	}
	if (oip->h % h_mul) {
		error_invalid_resolution(FALSE, h_mul, oip->w, oip->h);
		check = FALSE;
	}

	//o͂
	if (pe->video_out_type == VIDEO_OUTPUT_DISABLED && !(oip->flag & OUTPUT_INFO_FLAG_AUDIO)) {
		error_nothing_to_output();
		check = FALSE;
	}

	if (conf.oth.out_audio_only)
		write_log_auo_line(LOG_INFO, "̂ݏo͂s܂B");

	//KvȎst@C
	//x264
	if (!conf.oth.disable_guicmd) {
		char *x264fullpath = (conf.x264.use_highbit_depth) ? sys_dat.exstg->s_x264.fullpath_highbit : sys_dat.exstg->s_x264.fullpath;
		if (pe->video_out_type != VIDEO_OUTPUT_DISABLED && !PathFileExists(x264fullpath)) {
			error_no_exe_file("x264.exe", x264fullpath);
			check = FALSE;
		}
	}

	//GR[_
	if (oip->flag & OUTPUT_INFO_FLAG_AUDIO) {
		AUDIO_SETTINGS *aud_stg = &sys_dat.exstg->s_aud[conf.aud.encoder];
		if (str_has_char(aud_stg->filename) && !PathFileExists(aud_stg->fullpath)) {
			//faw̏ꍇfaw2aacOKAȂ΃G[
			if (!(conf.aud.encoder == sys_dat.exstg->s_aud_faw_index && check_if_faw2aac_exists())) {
				error_no_exe_file(aud_stg->filename, aud_stg->fullpath);
				check = FALSE;
			}
		}
	}

	//muxer
	switch (pe->muxer_to_be_used) {
		case MUXER_TC2MP4:
			check &= check_muxer_exist(&sys_dat.exstg->s_mux[MUXER_MP4]); //tc2mp4gp͒ǉmp4boxKv
			//փtH[X[
		case MUXER_MP4:
		case MUXER_MKV:
			check &= check_muxer_exist(&sys_dat.exstg->s_mux[pe->muxer_to_be_used]);
			break;
		default:
			break;
	}

	//}`pXݒ
	check &= check_amp();

	return check;
}

void open_log_window(const char *savefile, int current_pass, int total_pass) {
	char mes[MAX_PATH_LEN + 512];
	char *newLine = (get_current_log_len(current_pass)) ? "\r\n\r\n" : ""; //KvȂs
	static const char *SEPARATOR = "------------------------------------------------------------------------------------------------------------------------------";
	if (total_pass < 2 || current_pass > total_pass)
		sprintf_s(mes, sizeof(mes), "%s%s\r\n[%s]\r\n%s", newLine, SEPARATOR, savefile, SEPARATOR);
	else
		sprintf_s(mes, sizeof(mes), "%s%s\r\n[%s] (%d / %d pass)\r\n%s", newLine, SEPARATOR, savefile, current_pass, total_pass, SEPARATOR);
	
	show_log_window(sys_dat.aviutl_dir, sys_dat.exstg->s_local.disable_visual_styles);
	write_log_line(LOG_INFO, mes);
}

static void set_tmpdir(PRM_ENC *pe, int tmp_dir_index, const char *savefile) {
	if (tmp_dir_index < TMP_DIR_OUTPUT || TMP_DIR_CUSTOM < tmp_dir_index)
		tmp_dir_index = TMP_DIR_OUTPUT;

	if (tmp_dir_index == TMP_DIR_SYSTEM) {
		//VXëꎞtH_擾
		if (GetTempPath(_countof(pe->temp_filename), pe->temp_filename) != NULL) {
			PathRemoveBackslash(pe->temp_filename);
			write_log_auo_line_fmt(LOG_INFO, "ꎞtH_ : %s", pe->temp_filename);
		} else {
			warning_failed_getting_temp_path();
			tmp_dir_index = TMP_DIR_OUTPUT;
		}
	}
	if (tmp_dir_index == TMP_DIR_CUSTOM) {
		//w肳ꂽtH_
		if (DirectoryExistsOrCreate(sys_dat.exstg->s_local.custom_tmp_dir)) {
			strcpy_s(pe->temp_filename, _countof(pe->temp_filename), sys_dat.exstg->s_local.custom_tmp_dir);
			PathRemoveBackslash(pe->temp_filename);
			write_log_auo_line_fmt(LOG_INFO, "ꎞtH_ : %s", pe->temp_filename);
		} else {
			warning_no_temp_root(sys_dat.exstg->s_local.custom_tmp_dir);
			tmp_dir_index = TMP_DIR_OUTPUT;
		}
	}
	if (tmp_dir_index == TMP_DIR_OUTPUT) {
		//o̓tH_Ɠ("\"Ȃ)
		strcpy_s(pe->temp_filename, _countof(pe->temp_filename), savefile);
		PathRemoveFileSpecFixed(pe->temp_filename);
	}
}

static void set_enc_prm(PRM_ENC *pe, const OUTPUT_INFO *oip) {
	//
	ZeroMemory(pe, sizeof(PRM_ENC));
	//ݒXV
	sys_dat.exstg->load_encode_stg();
	sys_dat.exstg->load_append();
	sys_dat.exstg->load_fn_replace();
	
	pe->video_out_type = check_video_ouput(&conf, oip);
	pe->muxer_to_be_used = check_muxer_to_be_used(&conf, pe->video_out_type, (oip->flag & OUTPUT_INFO_FLAG_AUDIO) != 0);
	pe->total_x264_pass = (conf.x264.use_auto_npass && conf.x264.rc_mode == X264_RC_BITRATE && !conf.oth.disable_guicmd) ? conf.x264.auto_npass : 1;
	pe->amp_x264_pass_limit = pe->total_x264_pass + sys_dat.exstg->s_local.amp_retry_limit;
	pe->current_x264_pass = 1;
	pe->drop_count = 0;
	memcpy(&pe->append, &sys_dat.exstg->s_append, sizeof(FILE_APPENDIX));
	ZeroMemory(&pe->append.aud, sizeof(pe->append.aud));

	char filename_replace[MAX_PATH_LEN];

	//ꎞtH_̌
	set_tmpdir(pe, conf.oth.temp_dir, oip->savefile);

	//ꎞtH_̌
	char *cus_aud_tdir = pe->temp_filename;
	if (conf.aud.aud_temp_dir)
		if (DirectoryExistsOrCreate(sys_dat.exstg->s_local.custom_audio_tmp_dir)) {
			cus_aud_tdir = sys_dat.exstg->s_local.custom_audio_tmp_dir;
			write_log_auo_line_fmt(LOG_INFO, "ꎞtH_ : %s", cus_aud_tdir);
		} else
			warning_no_aud_temp_root(sys_dat.exstg->s_local.custom_audio_tmp_dir);
	strcpy_s(pe->aud_temp_dir, _countof(pe->aud_temp_dir), cus_aud_tdir);

	//t@CusAꎞt@C쐬
	strcpy_s(filename_replace, _countof(filename_replace), PathFindFileName(oip->savefile));
	sys_dat.exstg->apply_fn_replace(filename_replace, _countof(filename_replace));
	PathCombineLong(pe->temp_filename, _countof(pe->temp_filename), pe->temp_filename, filename_replace);
}

static void auto_save_log(const OUTPUT_INFO *oip, const PRM_ENC *pe) {
	guiEx_settings ex_stg(true);
	ex_stg.load_log_win();
	if (!ex_stg.s_log.auto_save_log)
		return;
	char log_file_path[MAX_PATH_LEN];
	if (AUO_RESULT_SUCCESS != getLogFilePath(log_file_path, _countof(log_file_path), pe, &sys_dat, &conf, oip))
		warning_no_auto_save_log_dir();
	auto_save_log_file(log_file_path);
	return;
}

void overwrite_aviutl_ini_file_filter(int idx) {
	char ini_file[1024];
	get_aviutl_dir(ini_file, _countof(ini_file));
	PathAddBackSlashLong(ini_file);
	strcat_s(ini_file, _countof(ini_file), "aviutl.ini");
	
	char filefilter_ini[1024] = { 0 };
	make_file_filter(filefilter_ini, _countof(filefilter_ini), idx);
	WritePrivateProfileString(AUO_NAME, "filefilter", filefilter_ini, ini_file);
}

void make_file_filter(char *filter, size_t nSize, int default_index) {
	static const char *const TOP = "All Support Formats (*.*)";
	const char separator = (filter) ? '\\' : '\0';
	if (filter == NULL) {
		filter = auo_filefilter;
		nSize = _countof(auo_filefilter);
	}
	char *ptr = filter;
	
#define ADD_FILTER(str, appendix) { \
	size_t len = strlen(str); \
	if (nSize - (ptr - filter) <= len + 1) return; \
	memcpy(ptr, (str), sizeof(ptr[0]) * len); \
	ptr += len; \
	*ptr = (appendix); \
	ptr++; \
}
#define ADD_DESC(idx) { \
	size_t len = sprintf_s(ptr, nSize - (ptr - filter), "%s (%s)", OUTPUT_FILE_EXT_DESC[idx], OUTPUT_FILE_EXT_FILTER[idx]); \
	ptr += len; \
	*ptr = separator; \
	ptr++; \
	len = strlen(OUTPUT_FILE_EXT_FILTER[idx]); \
	if (nSize - (ptr - filter) <= len + 1) return; \
	memcpy(ptr, OUTPUT_FILE_EXT_FILTER[idx], sizeof(ptr[0]) * len); \
	ptr += len; \
	*ptr = separator; \
	ptr++; \
}
	ADD_FILTER(TOP, separator);
	ADD_FILTER(OUTPUT_FILE_EXT_FILTER[default_index], ';');
	for (int idx = 0; idx < _countof(OUTPUT_FILE_EXT_FILTER); idx++)
		if (idx != default_index)
			ADD_FILTER(OUTPUT_FILE_EXT_FILTER[idx], ';');
	ADD_FILTER(OUTPUT_FILE_EXT_FILTER[default_index], separator);
	ADD_DESC(default_index);
	for (int idx = 0; idx < _countof(OUTPUT_FILE_EXT_FILTER); idx++)
		if (idx != default_index)
			ADD_DESC(idx);
	ptr[0] = '\0';
#undef ADD_FILTER
#undef ADD_DESC
}
